/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.server.resources;

import java.util.List;
import org.eclipse.californium.core.CoapResource;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.LinkFormat;
import org.eclipse.californium.core.server.resources.CoapExchange;
import org.eclipse.californium.core.server.resources.Resource;

public class DiscoveryResource
extends CoapResource {
    public static final String CORE = "core";
    private final Resource root;

    public DiscoveryResource(Resource root) {
        this(CORE, root);
    }

    public DiscoveryResource(String name, Resource root) {
        super(name);
        this.setVisible(false);
        this.root = root;
    }

    @Override
    public void handleGET(CoapExchange exchange) {
        if (exchange.getRequestOptions().hasAccept() && exchange.getRequestOptions().getAccept() != 40) {
            exchange.respond(CoAP.ResponseCode.NOT_ACCEPTABLE);
            return;
        }
        List<String> query = exchange.getRequestOptions().getUriQuery();
        if (query.size() > 1) {
            exchange.respond(CoAP.ResponseCode.BAD_OPTION, "only one search query is supported!", 0);
            return;
        }
        String tree = this.discoverTree(this.root, query);
        exchange.respond(CoAP.ResponseCode.CONTENT, tree, 40);
    }

    public String discoverTree(Resource root, List<String> queries) {
        StringBuilder buffer = new StringBuilder();
        for (Resource child : root.getChildren()) {
            LinkFormat.serializeTree(child, queries, buffer);
        }
        if (buffer.length() > 1) {
            buffer.setLength(buffer.length() - 1);
        }
        return buffer.toString();
    }
}

