/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.observe;

import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.config.CoapConfig;
import org.eclipse.californium.core.network.Exchange;
import org.eclipse.californium.core.observe.ObservingEndpoint;
import org.eclipse.californium.core.server.resources.Resource;
import org.eclipse.californium.elements.config.Configuration;
import org.eclipse.californium.elements.util.ClockUtil;
import org.eclipse.californium.elements.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObserveRelation {
    private static final Logger LOGGER = LoggerFactory.getLogger(ObserveRelation.class);
    private final long checkIntervalTime;
    private final int checkIntervalCount;
    private final ObservingEndpoint endpoint;
    private final Resource resource;
    private final Exchange exchange;
    private Response recentControlNotification;
    private Response nextControlNotification;
    private final String key;
    private volatile boolean established;
    private volatile boolean canceled;
    private long interestCheckTimer = ClockUtil.nanoRealtime();
    private int interestCheckCounter = 1;

    public ObserveRelation(ObservingEndpoint endpoint, Resource resource, Exchange exchange) {
        if (endpoint == null) {
            throw new NullPointerException();
        }
        if (resource == null) {
            throw new NullPointerException();
        }
        if (exchange == null) {
            throw new NullPointerException();
        }
        this.endpoint = endpoint;
        this.resource = resource;
        this.exchange = exchange;
        Configuration config = exchange.getEndpoint().getConfig();
        this.checkIntervalTime = config.get(CoapConfig.NOTIFICATION_CHECK_INTERVAL_TIME, TimeUnit.NANOSECONDS);
        this.checkIntervalCount = config.get(CoapConfig.NOTIFICATION_CHECK_INTERVAL_COUNT);
        this.key = StringUtil.toString(this.getSource()) + "#" + exchange.getRequest().getTokenString();
        LOGGER.debug("Observe-relation, checks every {}ns or {} notifications.", (Object)this.checkIntervalTime, (Object)this.checkIntervalCount);
    }

    public boolean isEstablished() {
        return this.established;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEstablished() {
        boolean fail;
        ObserveRelation observeRelation = this;
        synchronized (observeRelation) {
            fail = this.canceled;
            if (!fail) {
                this.established = true;
            }
        }
        if (fail) {
            throw new IllegalStateException(String.format("Could not establish observe relation %s with %s, already canceled (%s)!", this.getKey(), this.resource.getURI(), this.exchange));
        }
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public void cleanup() {
        if (this.isEstablished()) {
            this.cancel();
        }
    }

    public void cancel() {
        this.cancel(true);
    }

    public void cancelAll() {
        this.endpoint.cancelAll();
    }

    public void notifyObservers() {
        this.resource.handleRequest(this.exchange);
    }

    public Resource getResource() {
        return this.resource;
    }

    public Exchange getExchange() {
        return this.exchange;
    }

    public InetSocketAddress getSource() {
        return this.endpoint.getAddress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean check() {
        boolean check;
        long now = ClockUtil.nanoRealtime();
        ObserveRelation observeRelation = this;
        synchronized (observeRelation) {
            boolean bl = check = ++this.interestCheckCounter >= this.checkIntervalCount;
            if (check) {
                this.interestCheckTimer = now;
                this.interestCheckCounter = 0;
            }
        }
        if (check) {
            LOGGER.trace("Observe-relation check, {} notifications reached.", (Object)this.checkIntervalCount);
            return check;
        }
        observeRelation = this;
        synchronized (observeRelation) {
            boolean bl = check = now - this.interestCheckTimer - this.checkIntervalTime > 0L;
            if (check) {
                this.interestCheckTimer = now;
                this.interestCheckCounter = 0;
            }
        }
        if (check) {
            LOGGER.trace("Observe-relation check, {}s interval reached.", (Object)TimeUnit.NANOSECONDS.toSeconds(this.checkIntervalTime));
        }
        return check;
    }

    public boolean isPostponedNotification(Response response) {
        if (ObserveRelation.isInTransit(this.recentControlNotification)) {
            LOGGER.trace("in transit {}", (Object)this.recentControlNotification);
            if (this.nextControlNotification != null) {
                if (!this.nextControlNotification.isNotification()) {
                    return true;
                }
                this.nextControlNotification.onTransferComplete();
            }
            this.nextControlNotification = response;
            return true;
        }
        this.recentControlNotification = response;
        this.nextControlNotification = null;
        this.send(response);
        return false;
    }

    public Response getNextNotification(Response response, boolean acknowledged) {
        Response next = null;
        if (this.recentControlNotification == response) {
            next = this.nextControlNotification;
            if (next != null) {
                this.recentControlNotification = next;
                this.nextControlNotification = null;
                this.send(next);
            } else if (acknowledged) {
                this.recentControlNotification = null;
                this.nextControlNotification = null;
            }
        }
        return next;
    }

    public void send(Response response) {
        if (!response.isNotification()) {
            this.cancel(false);
        }
    }

    public String getKey() {
        return this.key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancel(boolean complete) {
        boolean fail = false;
        boolean cancel = false;
        ObserveRelation observeRelation = this;
        synchronized (observeRelation) {
            if (!this.canceled) {
                boolean bl = fail = !this.established;
                if (!fail) {
                    this.canceled = true;
                    this.established = false;
                    cancel = true;
                }
            }
        }
        if (fail) {
            throw new IllegalStateException(String.format("Observe relation %s with %s not established (%s)!", this.getKey(), this.resource.getURI(), this.exchange));
        }
        if (cancel) {
            LOGGER.debug("Canceling observe relation {} with {} ({})", this.getKey(), this.resource.getURI(), this.exchange);
            this.resource.removeObserveRelation(this);
            this.endpoint.removeObserveRelation(this);
            if (complete) {
                this.exchange.executeComplete();
            }
        }
    }

    private static boolean isInTransit(Response response) {
        if (response == null || !response.isConfirmable()) {
            return false;
        }
        return !response.isAcknowledged() && !response.isTimedOut() && !response.isRejected();
    }
}

