/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls.x509;

import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.X509KeyManager;
import javax.security.auth.x500.X500Principal;
import org.eclipse.californium.elements.util.Asn1DerDecoder;
import org.eclipse.californium.elements.util.CertPathUtil;
import org.eclipse.californium.scandium.dtls.CertificateIdentityResult;
import org.eclipse.californium.scandium.dtls.CertificateType;
import org.eclipse.californium.scandium.dtls.ConnectionId;
import org.eclipse.californium.scandium.dtls.HandshakeResultHandler;
import org.eclipse.californium.scandium.dtls.SignatureAndHashAlgorithm;
import org.eclipse.californium.scandium.dtls.cipher.CipherSuite;
import org.eclipse.californium.scandium.dtls.cipher.XECDHECryptography;
import org.eclipse.californium.scandium.dtls.x509.CertificateConfigurationHelper;
import org.eclipse.californium.scandium.dtls.x509.CertificateProvider;
import org.eclipse.californium.scandium.dtls.x509.ConfigurationHelperSetup;
import org.eclipse.californium.scandium.util.ListUtils;
import org.eclipse.californium.scandium.util.ServerName;
import org.eclipse.californium.scandium.util.ServerNames;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyManagerCertificateProvider
implements CertificateProvider,
ConfigurationHelperSetup {
    private static final Logger LOGGER = LoggerFactory.getLogger(KeyManagerCertificateProvider.class);
    private static final List<String> ALL_KEY_TYPES = Arrays.asList("EC", "RSA", "EdDSA", "Ed25519", "Ed448");
    private final String defaultAlias;
    private final X509KeyManager keyManager;
    private final List<CertificateType> supportedCertificateTypes;
    private final List<CipherSuite.CertificateKeyAlgorithm> supportedCertificateKeyAlgorithms;

    public KeyManagerCertificateProvider(X509KeyManager keyManager, CertificateType ... supportedCertificateTypes) {
        this(null, keyManager, KeyManagerCertificateProvider.asList(supportedCertificateTypes));
    }

    public KeyManagerCertificateProvider(X509KeyManager keyManager, List<CertificateType> supportedCertificateTypes) {
        this(null, keyManager, supportedCertificateTypes);
    }

    public KeyManagerCertificateProvider(String defaultAlias, X509KeyManager keyManager, CertificateType ... supportedCertificateTypes) {
        this(defaultAlias, keyManager, KeyManagerCertificateProvider.asList(supportedCertificateTypes));
    }

    public KeyManagerCertificateProvider(String defaultAlias, X509KeyManager keyManager, List<CertificateType> supportedCertificateTypes) {
        if (keyManager == null) {
            throw new NullPointerException("KeyManager must not be null!");
        }
        if (supportedCertificateTypes != null) {
            if (supportedCertificateTypes.isEmpty()) {
                throw new IllegalArgumentException("Certificate types must not be empty!");
            }
            for (CertificateType certificateType : supportedCertificateTypes) {
                if (certificateType.isSupported()) continue;
                throw new IllegalArgumentException("Certificate type " + (Object)((Object)certificateType) + " is not supported!");
            }
        }
        this.defaultAlias = defaultAlias;
        this.keyManager = keyManager;
        if (supportedCertificateTypes == null) {
            supportedCertificateTypes = new ArrayList<CertificateType>(1);
            supportedCertificateTypes.add(CertificateType.X_509);
        }
        this.supportedCertificateTypes = Collections.unmodifiableList(supportedCertificateTypes);
        ArrayList<CipherSuite.CertificateKeyAlgorithm> supportedCertificateKeyAlgorithms = new ArrayList<CipherSuite.CertificateKeyAlgorithm>();
        List<String> aliases = this.getAliases(false, ALL_KEY_TYPES, null);
        for (String alias : aliases) {
            this.setup(alias, supportedCertificateKeyAlgorithms);
        }
        aliases = this.getAliases(true, ALL_KEY_TYPES, null);
        for (String alias : aliases) {
            this.setup(alias, supportedCertificateKeyAlgorithms);
        }
        this.supportedCertificateKeyAlgorithms = Collections.unmodifiableList(supportedCertificateKeyAlgorithms);
    }

    private void setup(String alias, List<CipherSuite.CertificateKeyAlgorithm> supportedCertificateKeyAlgorithms) {
        X509Certificate[] certificateChain = this.keyManager.getCertificateChain(alias);
        if (certificateChain != null && certificateChain.length > 0) {
            PublicKey key = certificateChain[0].getPublicKey();
            CipherSuite.CertificateKeyAlgorithm keyAlgorithm = CipherSuite.CertificateKeyAlgorithm.getAlgorithm(key);
            ListUtils.addIfAbsent(supportedCertificateKeyAlgorithms, keyAlgorithm);
        }
    }

    @Override
    public void setupConfigurationHelper(CertificateConfigurationHelper helper) {
        if (helper == null) {
            throw new NullPointerException("Certificate configuration helper must not be null!");
        }
        List<String> aliases = this.getAliases(false, ALL_KEY_TYPES, null);
        for (String alias : aliases) {
            this.setupConfigurationHelperForAlias(helper, alias);
        }
        aliases = this.getAliases(true, ALL_KEY_TYPES, null);
        for (String alias : aliases) {
            this.setupConfigurationHelperForAlias(helper, alias);
        }
    }

    private void setupConfigurationHelperForAlias(CertificateConfigurationHelper helper, String alias) {
        X509Certificate[] certificateChain = this.keyManager.getCertificateChain(alias);
        if (certificateChain != null && certificateChain.length > 0) {
            if (this.supportedCertificateTypes.contains((Object)CertificateType.X_509)) {
                helper.addConfigurationDefaultsFor(Arrays.asList(certificateChain));
            } else if (this.supportedCertificateTypes.contains((Object)CertificateType.RAW_PUBLIC_KEY)) {
                helper.addConfigurationDefaultsFor(certificateChain[0].getPublicKey());
            }
        }
    }

    @Override
    public List<CipherSuite.CertificateKeyAlgorithm> getSupportedCertificateKeyAlgorithms() {
        return this.supportedCertificateKeyAlgorithms;
    }

    @Override
    public List<CertificateType> getSupportedCertificateTypes() {
        return this.supportedCertificateTypes;
    }

    @Override
    public CertificateIdentityResult requestCertificateIdentity(ConnectionId cid, boolean client, List<X500Principal> issuers, ServerNames serverNames, List<CipherSuite.CertificateKeyAlgorithm> certificateKeyAlgorithms, List<SignatureAndHashAlgorithm> signatureAndHashAlgorithms, List<XECDHECryptography.SupportedGroup> curves) {
        List<String> alias;
        String role = client ? "Client" : "Server";
        LOGGER.debug("{} certificate for {}", (Object)role, serverNames == null ? "<n.a.>" : serverNames);
        if (issuers != null && !issuers.isEmpty()) {
            LOGGER.debug("{} certificate issued by {}", (Object)role, (Object)issuers);
        }
        Principal[] principals = issuers == null ? null : issuers.toArray(new Principal[issuers.size()]);
        ArrayList<String> keyTypes = new ArrayList<String>();
        if (certificateKeyAlgorithms != null) {
            for (CipherSuite.CertificateKeyAlgorithm algorithm : certificateKeyAlgorithms) {
                if (algorithm == CipherSuite.CertificateKeyAlgorithm.NONE) continue;
                ListUtils.addIfAbsent(keyTypes, algorithm.name());
            }
        }
        if (signatureAndHashAlgorithms != null && !signatureAndHashAlgorithms.isEmpty()) {
            if (keyTypes.isEmpty()) {
                if (SignatureAndHashAlgorithm.isSupportedAlgorithm(signatureAndHashAlgorithms, "EC")) {
                    ListUtils.addIfAbsent(keyTypes, "EC");
                }
                if (SignatureAndHashAlgorithm.isSupportedAlgorithm(signatureAndHashAlgorithms, "RSA")) {
                    ListUtils.addIfAbsent(keyTypes, "RSA");
                }
                KeyManagerCertificateProvider.addEdDsaSupport(keyTypes, signatureAndHashAlgorithms);
            } else if (keyTypes.contains("EC")) {
                KeyManagerCertificateProvider.addEdDsaSupport(keyTypes, signatureAndHashAlgorithms);
            }
        } else if (keyTypes.isEmpty()) {
            keyTypes.add("EC");
        }
        LOGGER.debug("{} certificate public key types {}", (Object)role, (Object)keyTypes);
        if (signatureAndHashAlgorithms != null && !signatureAndHashAlgorithms.isEmpty()) {
            LOGGER.debug("{} certificate signed with {}", (Object)role, (Object)signatureAndHashAlgorithms);
        }
        if (curves != null && !curves.isEmpty()) {
            LOGGER.debug("{} certificate using {}", (Object)role, (Object)curves);
        }
        if (!(alias = this.getAliases(client, keyTypes, principals)).isEmpty()) {
            ArrayList<String> matchingServerNames = new ArrayList<String>();
            ArrayList<String> matchingSignatures = new ArrayList<String>();
            ArrayList<String> matchingCurves = new ArrayList<String>();
            int index = 1;
            for (String id : alias) {
                LOGGER.debug("Apply select {} - {} of {}", id, index, alias.size());
                X509Certificate[] certificateChain = this.keyManager.getCertificateChain(id);
                List<X509Certificate> chain = Arrays.asList(certificateChain);
                if (serverNames != null && this.matchServerNames(serverNames, certificateChain[0])) {
                    matchingServerNames.add(id);
                }
                if (signatureAndHashAlgorithms != null && this.matchSignatureAndHashAlgorithms(signatureAndHashAlgorithms, chain)) {
                    matchingSignatures.add(id);
                }
                if (curves != null && this.matchCurves(curves, chain)) {
                    matchingCurves.add(id);
                }
                ++index;
            }
            if (!matchingServerNames.isEmpty()) {
                LOGGER.debug("{} selected by {}", (Object)matchingServerNames.size(), (Object)serverNames);
                alias.retainAll(matchingServerNames);
            }
            if (signatureAndHashAlgorithms != null) {
                LOGGER.debug("{} selected by signature and hash algorithms", (Object)matchingSignatures.size());
                alias.retainAll(matchingSignatures);
            }
            if (curves != null) {
                LOGGER.debug("{} selected by curves", (Object)matchingCurves.size());
                alias.retainAll(matchingCurves);
            }
            if (alias.size() > 0) {
                String id = null;
                if (alias.size() > 1 && signatureAndHashAlgorithms != null && signatureAndHashAlgorithms.size() > 1) {
                    alias = this.selectPriorized(alias, signatureAndHashAlgorithms);
                }
                id = alias.size() > 1 && this.defaultAlias != null && alias.contains(this.defaultAlias) ? this.defaultAlias : alias.get(0);
                X509Certificate[] certificateChain = this.keyManager.getCertificateChain(id);
                List<X509Certificate> chain = Arrays.asList(certificateChain);
                PrivateKey privateKey = this.keyManager.getPrivateKey(id);
                return new CertificateIdentityResult(cid, privateKey, chain, (Object)id);
            }
        } else {
            LOGGER.debug("no matching credentials");
        }
        return new CertificateIdentityResult(cid, null);
    }

    @Override
    public void setResultHandler(HandshakeResultHandler resultHandler) {
    }

    private List<String> getAliases(boolean client, List<String> keyTypes, Principal[] issuers) {
        ArrayList<String> all = new ArrayList<String>();
        for (String keyType : keyTypes) {
            String[] alias = null;
            alias = client ? this.keyManager.getClientAliases(keyType, issuers) : this.keyManager.getServerAliases(keyType, issuers);
            if (alias == null) continue;
            LOGGER.debug("found {} {} keys for {}", alias.length, keyType, client ? "client" : "server");
            ListUtils.addIfAbsent(all, Arrays.asList(alias));
        }
        return all;
    }

    private boolean matchServerNames(ServerNames serverNames, X509Certificate node) {
        ServerName serverName = serverNames.getServerName(ServerName.NameType.HOST_NAME);
        if (serverName != null) {
            String name = serverName.getNameAsString();
            return CertPathUtil.matchDestination(node, name);
        }
        return false;
    }

    private boolean matchSignatureAndHashAlgorithms(List<SignatureAndHashAlgorithm> signatureAndHashAlgorithms, List<X509Certificate> chain) {
        if (SignatureAndHashAlgorithm.getSupportedSignatureAlgorithm(signatureAndHashAlgorithms, chain.get(0).getPublicKey()) == null) {
            return false;
        }
        return SignatureAndHashAlgorithm.isSignedWithSupportedAlgorithms(signatureAndHashAlgorithms, chain);
    }

    private boolean matchCurves(List<XECDHECryptography.SupportedGroup> curves, List<X509Certificate> chain) {
        for (X509Certificate certificate : chain) {
            PublicKey certPublicKey = certificate.getPublicKey();
            if (!Asn1DerDecoder.isEcBased(certPublicKey.getAlgorithm())) continue;
            XECDHECryptography.SupportedGroup group = XECDHECryptography.SupportedGroup.fromPublicKey(certPublicKey);
            if (group == null) {
                return false;
            }
            if (curves.contains((Object)group)) continue;
            return false;
        }
        return true;
    }

    private List<String> selectPriorized(List<String> alias, List<SignatureAndHashAlgorithm> signatureAndHashAlgorithms) {
        ArrayList<String> result = new ArrayList<String>();
        for (SignatureAndHashAlgorithm signatureAndHashAlgorithm : signatureAndHashAlgorithms) {
            for (String id : alias) {
                X509Certificate[] certificateChain = this.keyManager.getCertificateChain(id);
                if (certificateChain == null || certificateChain.length <= 0) continue;
                String algorithm = certificateChain[0].getPublicKey().getAlgorithm();
                if (signatureAndHashAlgorithm.isSupported(algorithm)) {
                    result.add(id);
                    LOGGER.debug("Select by signature {} - {} == {}", id, signatureAndHashAlgorithm.getJcaName(), algorithm);
                    continue;
                }
                LOGGER.debug("Signature doesn't match {} - {} != {}", id, signatureAndHashAlgorithm.getJcaName(), algorithm);
            }
            if (result.isEmpty()) continue;
            break;
        }
        return result;
    }

    private static void addEdDsaSupport(List<String> publicKeyTypes, List<SignatureAndHashAlgorithm> signatureAndHashAlgorithms) {
        if (signatureAndHashAlgorithms.contains(SignatureAndHashAlgorithm.INTRINSIC_WITH_ED25519)) {
            ListUtils.addIfAbsent(publicKeyTypes, "EdDSA");
            ListUtils.addIfAbsent(publicKeyTypes, "Ed25519");
        }
        if (signatureAndHashAlgorithms.contains(SignatureAndHashAlgorithm.INTRINSIC_WITH_ED448)) {
            ListUtils.addIfAbsent(publicKeyTypes, "EdDSA");
            ListUtils.addIfAbsent(publicKeyTypes, "Ed448");
        }
    }

    private static List<CertificateType> asList(CertificateType[] types) {
        if (types == null || types.length == 0) {
            return null;
        }
        return Arrays.asList(types);
    }
}

