/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.config;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.eclipse.californium.elements.config.BasicListDefinition;
import org.eclipse.californium.elements.config.BooleanDefinition;
import org.eclipse.californium.elements.config.CertificateAuthenticationMode;
import org.eclipse.californium.elements.config.Configuration;
import org.eclipse.californium.elements.config.EnumDefinition;
import org.eclipse.californium.elements.config.EnumListDefinition;
import org.eclipse.californium.elements.config.FloatDefinition;
import org.eclipse.californium.elements.config.IntegerDefinition;
import org.eclipse.californium.elements.config.StringSetDefinition;
import org.eclipse.californium.elements.config.SystemConfig;
import org.eclipse.californium.elements.config.TimeDefinition;
import org.eclipse.californium.elements.config.ValueException;
import org.eclipse.californium.scandium.dtls.ExtendedMasterSecretMode;
import org.eclipse.californium.scandium.dtls.MaxFragmentLengthExtension;
import org.eclipse.californium.scandium.dtls.SignatureAndHashAlgorithm;
import org.eclipse.californium.scandium.dtls.cipher.CipherSuite;
import org.eclipse.californium.scandium.dtls.cipher.XECDHECryptography;

public final class DtlsConfig {
    public static final String MODULE = "DTLS.";
    public static final int DEFAULT_RETRANSMISSION_TIMEOUT_IN_MILLISECONDS = 2000;
    public static final int RFC6347_RETRANSMISSION_TIMEOUT_IN_MILLISECONDS = 1000;
    public static final int RFC7925_RETRANSMISSION_TIMEOUT_IN_MILLISECONDS = 9000;
    public static final int DEFAULT_MAX_RETRANSMISSION_TIMEOUT_IN_MILLISECONDS = 60000;
    public static final int DEFAULT_ADDITIONAL_TIMEOUT_FOR_ECC_IN_MILLISECONDS = 0;
    public static final int DEFAULT_MAX_RETRANSMISSIONS = 4;
    public static final int DEFAULT_MAX_FRAGMENTED_HANDSHAKE_MESSAGE_LENGTH = 8192;
    public static final int DEFAULT_MAX_TRANSMISSION_UNIT_LIMIT = 1500;
    public static final int DEFAULT_MAX_CONNECTIONS = 150000;
    public static final long DEFAULT_STALE_CONNECTION_TRESHOLD_SECONDS = 1800L;
    public static final int DEFAULT_MAX_PENDING_OUTBOUND_MESSAGES = 100000;
    public static final int DEFAULT_MAX_DEFERRED_OUTBOUND_APPLICATION_MESSAGES = 10;
    public static final int DEFAULT_MAX_DEFERRED_PROCESSED_INCOMING_RECORDS_SIZE = 8192;
    public static final int DEFAULT_VERIFY_PEERS_ON_RESUMPTION_THRESHOLD_IN_PERCENT = 30;
    public static final TimeDefinition DTLS_SESSION_TIMEOUT = new TimeDefinition("DTLS.SESSION_TIMEOUT", "DTLS session timeout. Currently not supported.", 1L, TimeUnit.HOURS);
    public static final TimeDefinition DTLS_AUTO_HANDSHAKE_TIMEOUT = new TimeDefinition("DTLS.AUTO_HANDSHAKE_TIMEOUT", "DTLS auto-handshake timeout. <blank>, disabled.");
    public static final IntegerDefinition DTLS_CONNECTION_ID_LENGTH = new IntegerDefinition("DTLS.CONNECTION_ID_LENGTH", "DTLS connection ID length. <blank> disabled, 0 enables support without active use of CID.", null, 0);
    public static final IntegerDefinition DTLS_CONNECTION_ID_NODE_ID = new IntegerDefinition("DTLS.CONNECTION_ID_NODE_ID", "DTLS cluster-node ID used for connection ID. <blank> not used.", null, 0);
    public static final TimeDefinition DTLS_RETRANSMISSION_TIMEOUT = new TimeDefinition("DTLS.RETRANSMISSION_TIMEOUT", "DTLS initial retransmission timeout.", 2000L, TimeUnit.MILLISECONDS);
    public static final TimeDefinition DTLS_MAX_RETRANSMISSION_TIMEOUT = new TimeDefinition("DTLS.MAX_RETRANSMISSION_TIMEOUT", "DTLS maximum retransmission timeout.", 60000L, TimeUnit.MILLISECONDS);
    public static final FloatDefinition DTLS_RETRANSMISSION_INIT_RANDOM = new FloatDefinition("DTLS.RETRANSMISSION_INIT_RANDOM", "DTLS random factor for initial retransmission timeout.", Float.valueOf(1.0f), Float.valueOf(1.0f));
    public static final FloatDefinition DTLS_RETRANSMISSION_TIMEOUT_SCALE = new FloatDefinition("DTLS.RETRANSMISSION_TIMEOUT_SCALE", "DTLS scale factor for retransmission backoff-timeout.", Float.valueOf(2.0f), Float.valueOf(1.0f));
    public static final TimeDefinition DTLS_ADDITIONAL_ECC_TIMEOUT = new TimeDefinition("DTLS.ADDITIONAL_ECC_TIMEOUT", "DTLS additional initial timeout for ECC related flights.", 0L, TimeUnit.MILLISECONDS);
    public static final IntegerDefinition DTLS_MAX_RETRANSMISSIONS = new IntegerDefinition("DTLS.MAX_RETRANSMISSIONS", "DTLS maximum number of flight retransmissions.", 4, 0);
    public static final IntegerDefinition DTLS_RETRANSMISSION_BACKOFF = new IntegerDefinition("DTLS.RETRANSMISSION_BACKOFF", "Number of flight-retransmissions before switching to backoff mode using single handshake messages in single record datagrams.", null, 0);
    public static final BooleanDefinition DTLS_SERVER_USE_SESSION_ID = new BooleanDefinition("DTLS.SERVER_USE_SESSION_ID", "Enable server to use a session ID in order to support session resumption.", true);
    public static final BooleanDefinition DTLS_USE_EARLY_STOP_RETRANSMISSION = new BooleanDefinition("DTLS.USE_EARLY_STOP_RETRANSMISSION", "Stop retransmission on receiving the first message of the next flight, not waiting for the last message.", true);
    public static final IntegerDefinition DTLS_RECORD_SIZE_LIMIT = new IntegerDefinition("DTLS.RECORD_SIZE_LIMIT", "DTLS record size limit (RFC 8449). Between 64 and 65535.", null, 64);
    public static final EnumDefinition<MaxFragmentLengthExtension.Length> DTLS_MAX_FRAGMENT_LENGTH = new EnumDefinition("DTLS.MAX_FRAGMENT_SIZE", "DTLS maximum fragment length (RFC 6066).", (Enum[])MaxFragmentLengthExtension.Length.values());
    public static final IntegerDefinition DTLS_MAX_FRAGMENTED_HANDSHAKE_MESSAGE_LENGTH = new IntegerDefinition("DTLS.MAX_FRAGMENTED_HANDSHAKE_MESSAGE_LENGTH", "DTLS maximum length of reassembled fragmented handshake message.\nMust be large enough for used certificates.", 8192, 64);
    public static final BooleanDefinition DTLS_USE_MULTI_RECORD_MESSAGES = new BooleanDefinition("DTLS.USE_MULTI_RECORD_MESSAGES", "Use multiple DTLS records in UDP messages.");
    public static final BooleanDefinition DTLS_USE_MULTI_HANDSHAKE_MESSAGE_RECORDS = new BooleanDefinition("DTLS.USE_MULTI_HANDSHAKE_MESSAGE_RECORDS", "Use multiple handshake messages in DTLS records.\nNot all libraries may have implemented this!");
    public static final EnumDefinition<CertificateAuthenticationMode> DTLS_CLIENT_AUTHENTICATION_MODE = new EnumDefinition("DTLS.CLIENT_AUTHENTICATION_MODE", "DTLS client authentication mode for certificate based cipher suites.", (Enum)CertificateAuthenticationMode.NEEDED, (Enum[])CertificateAuthenticationMode.values());
    public static final BooleanDefinition DTLS_VERIFY_SERVER_CERTIFICATES_SUBJECT = new BooleanDefinition("DTLS.VERIFY_SERVER_CERTIFICATES_SUBJECT", "DTLS verifies the server certificate's subjects.", true);
    public static final EnumDefinition<DtlsRole> DTLS_ROLE = new EnumDefinition("DTLS.ROLE", "DTLS role.", (Enum)DtlsRole.BOTH, (Enum[])DtlsRole.values());
    public static final IntegerDefinition DTLS_MAX_TRANSMISSION_UNIT = new IntegerDefinition("DTLS.MAX_TRANSMISSION_UNIT", "DTLS MTU (Maximum Transmission Unit).", null, 64);
    public static final IntegerDefinition DTLS_MAX_TRANSMISSION_UNIT_LIMIT = new IntegerDefinition("DTLS.MAX_TRANSMISSION_UNIT_LIMIT", "DTLS MTU (Maximum Transmission Unit) limit for local auto detection.", null, 64);
    public static final StringSetDefinition DTLS_DEFAULT_HANDSHAKE_MODE = new StringSetDefinition("DTLS.DEFAULT_HANDSHAKE_MODE", "DTLS default handshake mode.", "auto", "none", "auto");
    public static final IntegerDefinition DTLS_MAX_CONNECTIONS = new IntegerDefinition("DTLS.MAX_CONNECTIONS", "DTLS maximum connections.", 150000, 1);
    public static final TimeDefinition DTLS_STALE_CONNECTION_THRESHOLD = new TimeDefinition("DTLS.STALE_CONNECTION_THRESHOLD", "DTLS threshold for state connections. Connections will only get removed for new ones, if at least for that threshold no messages are exchanged using that connection.", 1800L, TimeUnit.SECONDS);
    public static final IntegerDefinition DTLS_OUTBOUND_MESSAGE_BUFFER_SIZE = new IntegerDefinition("DTLS.OUTBOUND_MESSAGE_BUFFER_SIZE", "DTLS buffer size for outbound messages.", 100000, 64);
    public static final IntegerDefinition DTLS_MAX_DEFERRED_OUTBOUND_APPLICATION_MESSAGES = new IntegerDefinition("DTLS.MAX_DEFERRED_OUTBOUND_APPLICATION_MESSAGES", "DTLS maximum deferred outbound application messages.", 10, 0);
    public static final IntegerDefinition DTLS_MAX_DEFERRED_INBOUND_RECORDS_SIZE = new IntegerDefinition("DTLS.MAX_DEFERRED_INBOUND_RECORDS", "DTLS maximum size of all deferred inbound messages.", 8192, 0);
    public static final IntegerDefinition DTLS_RECEIVER_THREAD_COUNT = new IntegerDefinition("DTLS.RECEIVER_THREAD_COUNT", "Number of DTLS receiver threads.", 1, 0);
    public static final IntegerDefinition DTLS_CONNECTOR_THREAD_COUNT = new IntegerDefinition("DTLS.CONNECTOR_THREAD_COUNT", "Number of DTLS connector threads.", 1, 0);
    public static final IntegerDefinition DTLS_RECEIVE_BUFFER_SIZE = new IntegerDefinition("DTLS.RECEIVE_BUFFER_SIZE", "DTLS receive-buffer size.", null, 64);
    public static final IntegerDefinition DTLS_SEND_BUFFER_SIZE = new IntegerDefinition("DTLS.SEND_BUFFER_SIZE", "DTLS send-buffer size.", null, 64);
    public static final BooleanDefinition DTLS_USE_SERVER_NAME_INDICATION = new BooleanDefinition("DTLS.USE_SERVER_NAME_INDICATION", "DTLS use server name indication.", false);
    public static final EnumDefinition<ExtendedMasterSecretMode> DTLS_EXTENDED_MASTER_SECRET_MODE = new EnumDefinition("DTLS.EXTENDED_MASTER_SECRET_MODE", "DTLS extended master secret mode.", (Enum)ExtendedMasterSecretMode.ENABLED, (Enum[])ExtendedMasterSecretMode.values());
    public static final IntegerDefinition DTLS_VERIFY_PEERS_ON_RESUMPTION_THRESHOLD = new IntegerDefinition("DTLS.VERIFY_PEERS_ON_RESUMPTION_THRESHOLD", "DTLS verify peers on resumption threshold in percent.", 30, 0);
    public static final BooleanDefinition DTLS_USE_HELLO_VERIFY_REQUEST_FOR_PSK = new BooleanDefinition("DTLS.USE_HELLO_VERIFY_REQUEST_FOR_PSK", "DTLS use a HELLO_VERIFY_REQUEST for PSK cipher suites to protect against spoofing.", true);
    public static final BooleanDefinition DTLS_USE_HELLO_VERIFY_REQUEST = new BooleanDefinition("DTLS.USE_HELLO_VERIFY_REQUEST", "DTLS use a HELLO_VERIFY_REQUESt to protect against spoofing.", true);
    public static final BooleanDefinition DTLS_USE_ANTI_REPLAY_FILTER = new BooleanDefinition("DTLS.USE_USE_ANTI_REPLAY_FILTER", "DTLS use the anti-replay-filter.", true);
    public static final IntegerDefinition DTLS_USE_DISABLED_WINDOW_FOR_ANTI_REPLAY_FILTER = new IntegerDefinition("DTLS.USE_DISABLED_WINDOW_FOR_ANTI_REPLAY_FILTER", "DTLS use a disabled window for the anti-replay-filter. -1 := extend the disabled window to start of session, 0 := normal window, <n> := disabled window of size <n>.", 0, -1);
    public static final BooleanDefinition DTLS_UPDATE_ADDRESS_USING_CID_ON_NEWER_RECORDS = new BooleanDefinition("DTLS.UPDATE_ADDRESS_USING_CID_ON_NEWER_RECORDS", "DTLS update address using CID on newer records.", true);
    public static final BooleanDefinition DTLS_TRUNCATE_CLIENT_CERTIFICATE_PATH = new BooleanDefinition("DTLS.TRUNCATE_CLIENT_CERTIFICATE_PATH", "DTLS truncate client certificate path.", true);
    public static final BooleanDefinition DTLS_TRUNCATE_CERTIFICATE_PATH_FOR_VALIDATION = new BooleanDefinition("DTLS.TRUNCATE_CERTIFICATE_PATH_FOR_VALIDATION", "DTLS certificate path for validation.", true);
    public static final BooleanDefinition DTLS_RECOMMENDED_CIPHER_SUITES_ONLY = new BooleanDefinition("DTLS.RECOMMENDED_CIPHER_SUITES_ONLY", "DTLS recommended cipher-suites only.", true);
    public static final BooleanDefinition DTLS_RECOMMENDED_CURVES_ONLY = new BooleanDefinition("DTLS.RECOMMENDED_CURVES_ONLY", "DTLS recommended ECC curves/groups only.", true);
    public static final BooleanDefinition DTLS_RECOMMENDED_SIGNATURE_AND_HASH_ALGORITHMS_ONLY = new BooleanDefinition("DTLS.RECOMMENDED_SIGNATURE_AND_HASH_ALGORITHMS_ONLY", "DTLS recommended signature- and hash-algorithms only.", true);
    public static final EnumListDefinition<CipherSuite> DTLS_PRESELECTED_CIPHER_SUITES = new EnumListDefinition("DTLS.PRESELECTED_CIPHER_SUITES", "List of preselected DTLS cipher-suites.\nIf not recommended cipher suites are intended to be used, switch off DTLS_RECOMMENDED_CIPHER_SUITES_ONLY.\nThe supported cipher suites are evaluated at runtime and may differ from the ones when creating this properties file.", (Enum[])CipherSuite.getCipherSuites(false, false));
    public static final EnumListDefinition<CipherSuite> DTLS_CIPHER_SUITES = new EnumListDefinition("DTLS.CIPHER_SUITES", "List of DTLS cipher-suites.\nIf not recommended cipher suites are intended to be used, switch off DTLS_RECOMMENDED_CIPHER_SUITES_ONLY.\nThe supported cipher suites are evaluated at runtime and may differ from the ones when creating this properties file.", null, 1, (Enum[])CipherSuite.getCipherSuites(false, true));
    public static final EnumListDefinition<XECDHECryptography.SupportedGroup> DTLS_CURVES = new EnumListDefinition("DTLS.CURVES", "List of DTLS curves (supported groups).\nDefaults to all supported curves of the JCE at runtime.", (Enum[])XECDHECryptography.SupportedGroup.getUsableGroupsArray());
    public static final SignatureAndHashAlgorithmsDefinition DTLS_SIGNATURE_AND_HASH_ALGORITHMS = new SignatureAndHashAlgorithmsDefinition("DTLS.SIGNATURE_AND_HASH_ALGORITHMS", "List of DTLS signature- and hash-algorithms.\nValues e.g SHA256withECDSA or ED25519.");
    public static final EnumListDefinition<CipherSuite.CertificateKeyAlgorithm> DTLS_CERTIFICATE_KEY_ALGORITHMS = new EnumListDefinition("DTLS.CERTIFICATE_KEY_ALGORITHMS", "List of DTLS certificate key algorithms.\nOn the client side used to select the default cipher-suites, on the server side to negotiate the client's certificate.", (Enum[])new CipherSuite.CertificateKeyAlgorithm[]{CipherSuite.CertificateKeyAlgorithm.EC, CipherSuite.CertificateKeyAlgorithm.RSA});
    public static final IntegerDefinition DTLS_USE_DEPRECATED_CID = new IntegerDefinition("DTLS.USE_DEPRECATED_CID", "DTLS use deprecated CID extension code point for client (before version 09 of RFC-CID).", null, 53);
    public static final BooleanDefinition DTLS_SUPPORT_DEPRECATED_CID = new BooleanDefinition("DTLS.SUPPORT_DEPRECATED_CID", "DTLS support deprecated CID for server (before version 9).", false);
    public static final Configuration.ModuleDefinitionsProvider DEFINITIONS = new Configuration.ModuleDefinitionsProvider(){

        @Override
        public String getModule() {
            return DtlsConfig.MODULE;
        }

        @Override
        public void applyDefinitions(Configuration config) {
            int CORES = Runtime.getRuntime().availableProcessors();
            config.set(DTLS_SESSION_TIMEOUT, 24, TimeUnit.HOURS);
            config.set(DTLS_AUTO_HANDSHAKE_TIMEOUT, null, TimeUnit.SECONDS);
            config.set(DTLS_RETRANSMISSION_TIMEOUT, 2000, TimeUnit.MILLISECONDS);
            config.set(DTLS_MAX_RETRANSMISSION_TIMEOUT, 60000, TimeUnit.MILLISECONDS);
            config.set(DTLS_ADDITIONAL_ECC_TIMEOUT, 0, TimeUnit.MILLISECONDS);
            config.set(DTLS_MAX_RETRANSMISSIONS, 4);
            config.set(DTLS_RETRANSMISSION_INIT_RANDOM, Float.valueOf(1.0f));
            config.set(DTLS_RETRANSMISSION_TIMEOUT_SCALE, Float.valueOf(2.0f));
            config.set(DTLS_RETRANSMISSION_BACKOFF, null);
            config.set(DTLS_CONNECTION_ID_LENGTH, null);
            config.set(DTLS_CONNECTION_ID_NODE_ID, null);
            config.set(DTLS_SERVER_USE_SESSION_ID, true);
            config.set(DTLS_USE_EARLY_STOP_RETRANSMISSION, true);
            config.set(DTLS_RECORD_SIZE_LIMIT, null);
            config.set(DTLS_MAX_FRAGMENT_LENGTH, null);
            config.set(DTLS_MAX_FRAGMENTED_HANDSHAKE_MESSAGE_LENGTH, 8192);
            config.set(DTLS_USE_MULTI_RECORD_MESSAGES, null);
            config.set(DTLS_USE_MULTI_HANDSHAKE_MESSAGE_RECORDS, null);
            config.set(DTLS_CLIENT_AUTHENTICATION_MODE, CertificateAuthenticationMode.NEEDED);
            config.set(DTLS_VERIFY_SERVER_CERTIFICATES_SUBJECT, true);
            config.set(DTLS_ROLE, DtlsRole.BOTH);
            config.set(DTLS_MAX_TRANSMISSION_UNIT, null);
            config.set(DTLS_MAX_TRANSMISSION_UNIT_LIMIT, 1500);
            config.set(DTLS_DEFAULT_HANDSHAKE_MODE, null);
            config.set(DTLS_MAX_CONNECTIONS, 150000);
            config.set(DTLS_STALE_CONNECTION_THRESHOLD, 1800L, TimeUnit.SECONDS);
            config.set(DTLS_OUTBOUND_MESSAGE_BUFFER_SIZE, 100000);
            config.set(DTLS_MAX_DEFERRED_OUTBOUND_APPLICATION_MESSAGES, 10);
            config.set(DTLS_MAX_DEFERRED_INBOUND_RECORDS_SIZE, 8192);
            config.set(DTLS_RECEIVER_THREAD_COUNT, CORES > 3 ? 2 : 1);
            config.set(DTLS_CONNECTOR_THREAD_COUNT, CORES);
            config.set(DTLS_RECEIVE_BUFFER_SIZE, null);
            config.set(DTLS_SEND_BUFFER_SIZE, null);
            config.set(DTLS_USE_SERVER_NAME_INDICATION, false);
            config.set(DTLS_EXTENDED_MASTER_SECRET_MODE, ExtendedMasterSecretMode.ENABLED);
            config.set(DTLS_VERIFY_PEERS_ON_RESUMPTION_THRESHOLD, 30);
            config.set(DTLS_USE_HELLO_VERIFY_REQUEST, true);
            config.set(DTLS_USE_HELLO_VERIFY_REQUEST_FOR_PSK, true);
            config.set(DTLS_USE_ANTI_REPLAY_FILTER, true);
            config.set(DTLS_USE_DISABLED_WINDOW_FOR_ANTI_REPLAY_FILTER, 0);
            config.set(DTLS_UPDATE_ADDRESS_USING_CID_ON_NEWER_RECORDS, true);
            config.set(DTLS_TRUNCATE_CLIENT_CERTIFICATE_PATH, true);
            config.set(DTLS_TRUNCATE_CERTIFICATE_PATH_FOR_VALIDATION, true);
            config.set(DTLS_RECOMMENDED_CIPHER_SUITES_ONLY, true);
            config.set(DTLS_RECOMMENDED_CURVES_ONLY, true);
            config.set(DTLS_RECOMMENDED_SIGNATURE_AND_HASH_ALGORITHMS_ONLY, true);
            config.set(DTLS_PRESELECTED_CIPHER_SUITES, null);
            config.set(DTLS_CIPHER_SUITES, null);
            config.set(DTLS_CURVES, null);
            config.set(DTLS_SIGNATURE_AND_HASH_ALGORITHMS, null);
            config.set(DTLS_CERTIFICATE_KEY_ALGORITHMS, null);
            config.set(DTLS_USE_DEPRECATED_CID, null);
            config.set(DTLS_SUPPORT_DEPRECATED_CID, false);
        }
    };

    public static void register() {
        SystemConfig.register();
    }

    static {
        Configuration.addDefaultModule(DEFINITIONS);
    }

    public static class SignatureAndHashAlgorithmsDefinition
    extends BasicListDefinition<SignatureAndHashAlgorithm> {
        public SignatureAndHashAlgorithmsDefinition(String key, String documentation) {
            super(key, documentation, null);
        }

        @Override
        public String getTypeName() {
            return "List<SignatureAndHashAlgorithm>";
        }

        @Override
        public String writeValue(List<SignatureAndHashAlgorithm> value) {
            StringBuilder message = new StringBuilder();
            for (SignatureAndHashAlgorithm in : value) {
                message.append(in.getJcaName()).append(", ");
            }
            message.setLength(message.length() - 2);
            return message.toString();
        }

        @Override
        public List<SignatureAndHashAlgorithm> checkValue(List<SignatureAndHashAlgorithm> value) throws ValueException {
            if (value != null) {
                for (SignatureAndHashAlgorithm algorithm : value) {
                    if (algorithm.isSupported()) continue;
                    throw new IllegalArgumentException(algorithm + " is not supported by the JCE!");
                }
            }
            return super.checkValue(value);
        }

        @Override
        protected boolean isAssignableFrom(Object value) {
            if (value instanceof List) {
                for (Object item : (List)value) {
                    if (item instanceof SignatureAndHashAlgorithm) continue;
                    throw new IllegalArgumentException(item + " is no SignatureAndHashAlgorithm");
                }
                return true;
            }
            return false;
        }

        @Override
        protected List<SignatureAndHashAlgorithm> parseValue(String value) {
            String[] list = value.split(",");
            ArrayList<SignatureAndHashAlgorithm> result = new ArrayList<SignatureAndHashAlgorithm>(list.length);
            for (String in : list) {
                in = in.trim();
                SignatureAndHashAlgorithm item = SignatureAndHashAlgorithm.valueOf(in);
                result.add(item);
            }
            return result;
        }
    }

    public static enum DtlsRole {
        CLIENT_ONLY,
        SERVER_ONLY,
        BOTH;

    }
}

