/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.PortUnreachableException;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.californium.elements.Connector;
import org.eclipse.californium.elements.DtlsEndpointContext;
import org.eclipse.californium.elements.EndpointContext;
import org.eclipse.californium.elements.EndpointContextMatcher;
import org.eclipse.californium.elements.MapBasedEndpointContext;
import org.eclipse.californium.elements.PersistentConnector;
import org.eclipse.californium.elements.RawData;
import org.eclipse.californium.elements.RawDataChannel;
import org.eclipse.californium.elements.exception.EndpointMismatchException;
import org.eclipse.californium.elements.exception.EndpointUnconnectedException;
import org.eclipse.californium.elements.exception.MulticastNotSupportedException;
import org.eclipse.californium.elements.util.Bytes;
import org.eclipse.californium.elements.util.ClockUtil;
import org.eclipse.californium.elements.util.DaemonThreadFactory;
import org.eclipse.californium.elements.util.DatagramReader;
import org.eclipse.californium.elements.util.ExecutorsUtil;
import org.eclipse.californium.elements.util.LeastRecentlyUsedCache;
import org.eclipse.californium.elements.util.NamedThreadFactory;
import org.eclipse.californium.elements.util.NetworkInterfacesUtil;
import org.eclipse.californium.elements.util.NoPublicAPI;
import org.eclipse.californium.elements.util.SerialExecutor;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.scandium.AlertHandler;
import org.eclipse.californium.scandium.ConnectionListener;
import org.eclipse.californium.scandium.CookieGenerator;
import org.eclipse.californium.scandium.DtlsHealth;
import org.eclipse.californium.scandium.DtlsHealthLogger;
import org.eclipse.californium.scandium.config.DtlsConfig;
import org.eclipse.californium.scandium.config.DtlsConnectorConfig;
import org.eclipse.californium.scandium.dtls.AlertMessage;
import org.eclipse.californium.scandium.dtls.ApplicationMessage;
import org.eclipse.californium.scandium.dtls.ClientHandshaker;
import org.eclipse.californium.scandium.dtls.ClientHello;
import org.eclipse.californium.scandium.dtls.Connection;
import org.eclipse.californium.scandium.dtls.ConnectionEvictedException;
import org.eclipse.californium.scandium.dtls.ConnectionId;
import org.eclipse.californium.scandium.dtls.ConnectionIdGenerator;
import org.eclipse.californium.scandium.dtls.ContentType;
import org.eclipse.californium.scandium.dtls.DTLSConnectionState;
import org.eclipse.californium.scandium.dtls.DTLSContext;
import org.eclipse.californium.scandium.dtls.DTLSMessage;
import org.eclipse.californium.scandium.dtls.DTLSSession;
import org.eclipse.californium.scandium.dtls.DtlsException;
import org.eclipse.californium.scandium.dtls.ExtendedMasterSecretMode;
import org.eclipse.californium.scandium.dtls.FragmentedHandshakeMessage;
import org.eclipse.californium.scandium.dtls.HandshakeException;
import org.eclipse.californium.scandium.dtls.HandshakeMessage;
import org.eclipse.californium.scandium.dtls.HandshakeResult;
import org.eclipse.californium.scandium.dtls.HandshakeResultHandler;
import org.eclipse.californium.scandium.dtls.Handshaker;
import org.eclipse.californium.scandium.dtls.HelloVerifyRequest;
import org.eclipse.californium.scandium.dtls.InMemoryConnectionStore;
import org.eclipse.californium.scandium.dtls.MaxFragmentLengthExtension;
import org.eclipse.californium.scandium.dtls.ProtocolVersion;
import org.eclipse.californium.scandium.dtls.Record;
import org.eclipse.californium.scandium.dtls.RecordLayer;
import org.eclipse.californium.scandium.dtls.ResumingClientHandshaker;
import org.eclipse.californium.scandium.dtls.ResumingServerHandshaker;
import org.eclipse.californium.scandium.dtls.ResumptionSupportingConnectionStore;
import org.eclipse.californium.scandium.dtls.ServerHandshaker;
import org.eclipse.californium.scandium.dtls.SessionAdapter;
import org.eclipse.californium.scandium.dtls.SessionId;
import org.eclipse.californium.scandium.dtls.SessionListener;
import org.eclipse.californium.scandium.dtls.cipher.CipherSuite;
import org.eclipse.californium.scandium.dtls.pskstore.AdvancedPskStore;
import org.eclipse.californium.scandium.dtls.resumption.ConnectionStoreResumptionVerifier;
import org.eclipse.californium.scandium.dtls.resumption.ResumptionVerifier;
import org.eclipse.californium.scandium.dtls.x509.CertificateProvider;
import org.eclipse.californium.scandium.dtls.x509.NewAdvancedCertificateVerifier;
import org.eclipse.californium.scandium.util.ServerNames;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class DTLSConnector
implements Connector,
PersistentConnector,
RecordLayer {
    public static final String KEY_TLS_SERVER_HOST_NAME = "TLS_SERVER_HOST_NAME";
    private static final Logger LOGGER = LoggerFactory.getLogger(DTLSConnector.class);
    private static final Logger DROP_LOGGER = LoggerFactory.getLogger(LOGGER.getName() + ".drops");
    private static final int MAX_PLAINTEXT_FRAGMENT_LENGTH = 16384;
    private static final int MAX_CIPHERTEXT_EXPANSION = CipherSuite.getOverallMaxCiphertextExpansion();
    private static final int MAX_DATAGRAM_BUFFER_SIZE = 16409 + MAX_CIPHERTEXT_EXPANSION;
    private static final int TLS12_CID_PADDING = 0;
    private static final long CLIENT_HELLO_TIMEOUT_NANOS = CookieGenerator.COOKIE_LIFETIME_NANOS * 2L + TimeUnit.SECONDS.toNanos(15L);
    public static final boolean MDC_SUPPORT;
    protected final DtlsConnectorConfig config;
    private final ResumptionSupportingConnectionStore connectionStore;
    private final ResumptionVerifier resumptionVerifier;
    private final Queue<Connection> recentHandshakes = new ConcurrentLinkedQueue<Connection>();
    private final Long autoResumptionTimeoutMillis;
    private final boolean useHelloVerifyRequestForPsk;
    private final boolean useHelloVerifyRequest;
    private final int thresholdHandshakesWithoutVerifiedPeer;
    private final AtomicInteger pendingHandshakesWithoutVerifiedPeer = new AtomicInteger();
    private final SessionListener pendingHandshakesListener = new SessionAdapter(){

        @Override
        public void contextEstablished(Handshaker currentHandshaker, DTLSContext establishedContext) throws HandshakeException {
            DTLSConnector.this.pendingHandshakesWithoutVerifiedPeer.decrementAndGet();
        }

        @Override
        public void handshakeFailed(Handshaker handshaker, Throwable error) {
            DTLSConnector.this.pendingHandshakesWithoutVerifiedPeer.decrementAndGet();
        }
    };
    protected final DtlsHealth health;
    private final DtlsConfig.DtlsRole dtlsRole;
    private final String defaultHandshakeMode;
    private final int useExtendedWindowFilter;
    private final boolean useFilter;
    private final boolean useCidUpdateAddressOnNewerRecordFilter;
    private final int outboundMessageBufferSize;
    private final AtomicInteger pendingOutboundMessagesCountdown = new AtomicInteger();
    private final List<Thread> receiverThreads = new LinkedList<Thread>();
    protected final ConnectionIdGenerator connectionIdGenerator;
    private final ProtocolVersion protocolVersionForHelloVerifyRequests;
    private ScheduledFuture<?> recentHandshakeCleaner;
    private ScheduledFuture<?> statusLogger;
    private InetSocketAddress lastBindAddress;
    private Integer maximumTransmissionUnit;
    private int ipv4Mtu = 576;
    private int ipv6Mtu = 1280;
    protected int inboundDatagramBufferSize = MAX_DATAGRAM_BUFFER_SIZE;
    private final CookieGenerator cookieGenerator = new CookieGenerator();
    private volatile DatagramSocket socket;
    protected ScheduledExecutorService timer;
    private AtomicBoolean running = new AtomicBoolean(false);
    private volatile EndpointContextMatcher endpointContextMatcher;
    private volatile RawDataChannel messageHandler;
    private volatile AlertHandler alertHandler;
    private final SessionListener sessionListener;
    private final ConnectionListener connectionListener;
    private volatile ExecutorService executorService;
    private boolean hasInternalExecutor;

    public DTLSConnector(DtlsConnectorConfig configuration) {
        this(configuration, DTLSConnector.createConnectionStore(configuration));
    }

    protected static ResumptionSupportingConnectionStore createConnectionStore(DtlsConnectorConfig configuration) {
        return new InMemoryConnectionStore(configuration.getMaxConnections(), configuration.getStaleConnectionThresholdSeconds(), configuration.getSessionStore()).setTag(configuration.getLoggingTag());
    }

    protected DTLSConnector(DtlsConnectorConfig configuration, final ResumptionSupportingConnectionStore connectionStore) {
        long thresholdInPercent;
        DtlsHealth healthHandler;
        NewAdvancedCertificateVerifier certificateVerifier;
        CertificateProvider certificateIdentityProvider;
        if (configuration == null) {
            throw new NullPointerException("Configuration must not be null");
        }
        if (connectionStore == null) {
            throw new NullPointerException("Connection store must not be null");
        }
        this.config = configuration;
        this.connectionIdGenerator = this.config.getConnectionIdGenerator();
        this.protocolVersionForHelloVerifyRequests = this.config.getProtocolVersionForHelloVerifyRequests();
        this.outboundMessageBufferSize = this.config.getOutboundMessageBufferSize();
        this.pendingOutboundMessagesCountdown.set(this.outboundMessageBufferSize);
        this.autoResumptionTimeoutMillis = this.config.getAutoHandshakeTimeoutMillis();
        this.dtlsRole = this.config.getDtlsRole();
        this.defaultHandshakeMode = this.config.getDefaultHandshakeMode();
        this.useExtendedWindowFilter = this.config.useDisabledWindowFilter();
        this.useFilter = this.config.useAntiReplayFilter();
        this.useCidUpdateAddressOnNewerRecordFilter = this.config.useUpdateAddressUsingCidOnNewerRecords();
        this.connectionStore = connectionStore;
        this.connectionStore.attach(this.connectionIdGenerator);
        this.connectionStore.setConnectionListener(this.config.getConnectionListener());
        this.connectionListener = this.config.getConnectionListener();
        HandshakeResultHandler handler = new HandshakeResultHandler(){

            @Override
            public void apply(HandshakeResult connectionResult) {
                DTLSConnector.this.processAsynchronousHandshakeResult(connectionResult);
            }
        };
        AdvancedPskStore advancedPskStore = this.config.getAdvancedPskStore();
        if (advancedPskStore != null) {
            advancedPskStore.setResultHandler(handler);
        }
        if ((certificateIdentityProvider = this.config.getCertificateIdentityProvider()) != null) {
            certificateIdentityProvider.setResultHandler(handler);
        }
        if ((certificateVerifier = this.config.getAdvancedCertificateVerifier()) != null) {
            certificateVerifier.setResultHandler(handler);
        }
        ResumptionVerifier resumptionVerifier = this.resumptionVerifier = this.config.useServerSessionId() != false ? this.config.getResumptionVerifier() : null;
        if (this.resumptionVerifier != null) {
            ConnectionStoreResumptionVerifier connectionStoreResumptionVerifier;
            this.resumptionVerifier.setResultHandler(handler);
            if (this.resumptionVerifier instanceof ConnectionStoreResumptionVerifier && !(connectionStoreResumptionVerifier = (ConnectionStoreResumptionVerifier)this.resumptionVerifier).hasConnectionStore()) {
                connectionStoreResumptionVerifier.setConnectionStore(connectionStore);
            }
        }
        if ((healthHandler = this.config.getHealthHandler()) == null && this.config.getHealthStatusIntervalMilliseconds() > 0 && !(healthHandler = this.createDefaultHealthHandler(this.config)).isEnabled()) {
            healthHandler = null;
        }
        this.health = healthHandler;
        this.sessionListener = new SessionAdapter(){

            @Override
            public void contextEstablished(Handshaker handshaker, DTLSContext establishedContext) {
                DTLSConnector.this.contextEstablished(handshaker);
            }

            @Override
            public void handshakeCompleted(Handshaker handshaker) {
                Connection connection;
                if (DTLSConnector.this.health != null) {
                    DTLSConnector.this.health.endHandshake(true);
                }
                if ((connection = handshaker.getConnection()).getStartNanos() != null) {
                    DTLSConnector.this.recentHandshakes.add(connection);
                }
            }

            @Override
            public void handshakeFailed(Handshaker handshaker, Throwable error) {
                List<RawData> listOut;
                if (DTLSConnector.this.health != null) {
                    DTLSConnector.this.health.endHandshake(false);
                }
                if (!(listOut = handshaker.takeDeferredApplicationData()).isEmpty()) {
                    LOGGER.debug("Handshake with [{}] failed, report error to deferred {} messages", (Object)handshaker.getPeerAddress(), (Object)listOut.size());
                    for (RawData message : listOut) {
                        message.onError(error);
                    }
                }
                Connection connection = handshaker.getConnection();
                if (handshaker.isRemovingConnection()) {
                    connectionStore.remove(connection, false);
                } else if (handshaker.isProbing()) {
                    LOGGER.debug("Handshake with [{}] failed within probe!", (Object)handshaker.getPeerAddress());
                } else if (connection.getEstablishedDtlsContext() == handshaker.getDtlsContext()) {
                    if (error instanceof HandshakeException) {
                        AlertMessage alert = ((HandshakeException)error).getAlert();
                        if (alert != null && alert.getDescription() == AlertMessage.AlertDescription.CLOSE_NOTIFY) {
                            LOGGER.debug("Handshake with [{}] closed after session was established!", (Object)handshaker.getPeerAddress());
                        } else {
                            LOGGER.warn("Handshake with [{}] failed after session was established! {}", (Object)handshaker.getPeerAddress(), (Object)alert);
                        }
                    } else if (error instanceof ConnectionEvictedException) {
                        LOGGER.debug("Handshake with [{}] never get APPLICATION_DATA", (Object)handshaker.getPeerAddress(), (Object)error);
                    } else {
                        LOGGER.warn("Handshake with [{}] failed after session was established!", (Object)handshaker.getPeerAddress(), (Object)error);
                    }
                } else if (connection.hasEstablishedDtlsContext()) {
                    LOGGER.warn("Handshake with [{}] failed, but has an established session!", (Object)handshaker.getPeerAddress());
                } else {
                    LOGGER.debug("Handshake with [{}] aborted, connection preserved!", (Object)handshaker.getPeerAddress());
                }
            }
        };
        int maxConnections = this.config.getMaxConnections();
        long threshold = ((long)maxConnections * (thresholdInPercent = (long)this.config.getVerifyPeersOnResumptionThreshold().intValue()) + 50L) / 100L;
        if (threshold == 0L && thresholdInPercent > 0L) {
            threshold = 1L;
        }
        this.thresholdHandshakesWithoutVerifiedPeer = (int)threshold;
        this.useHelloVerifyRequest = this.config.useHelloVerifyRequest();
        this.useHelloVerifyRequestForPsk = this.useHelloVerifyRequest && this.config.useHelloVerifyRequestForPsk() != false;
    }

    protected DtlsHealth createDefaultHealthHandler(DtlsConnectorConfig configuration) {
        return new DtlsHealthLogger(configuration.getLoggingTag());
    }

    private final void initializeHandshaker(Handshaker handshaker) {
        handshaker.addSessionListener(this.sessionListener);
        if (this.health != null) {
            this.health.startHandshake();
        }
        this.onInitializeHandshaker(handshaker);
    }

    protected void onInitializeHandshaker(Handshaker handshaker) {
    }

    private final void contextEstablished(Handshaker handshaker) {
        try {
            List<Record> listIn;
            final Connection connection = handshaker.getConnection();
            this.connectionStore.putEstablishedSession(connection);
            SerialExecutor serialExecutor = connection.getExecutor();
            List<RawData> listOut = handshaker.takeDeferredApplicationData();
            if (!listOut.isEmpty()) {
                LOGGER.trace("DTLS context with [{}] established, now process deferred {} outgoing messages", (Object)handshaker.getPeerAddress(), (Object)listOut.size());
                Iterator<RawData> i$ = listOut.iterator();
                while (i$.hasNext()) {
                    RawData message;
                    final RawData rawData = message = i$.next();
                    serialExecutor.execute(new Runnable(){

                        @Override
                        public void run() {
                            DTLSConnector.this.sendMessage(rawData, connection);
                        }
                    });
                }
            }
            if (!(listIn = handshaker.takeDeferredRecordsOfNextEpoch()).isEmpty()) {
                LOGGER.trace("DTLS context with [{}] established, now process deferred {} incoming messages", (Object)handshaker.getPeerAddress(), (Object)listIn.size());
                Iterator<Record> i$ = listIn.iterator();
                while (i$.hasNext()) {
                    Record message;
                    final Record record = message = i$.next();
                    serialExecutor.execute(new Runnable(){

                        @Override
                        public void run() {
                            DTLSConnector.this.processRecord(record, connection);
                        }
                    });
                }
            }
        }
        catch (RejectedExecutionException ex) {
            LOGGER.debug("stopping.");
        }
    }

    private long calculateRecentHandshakeExpires() {
        return ClockUtil.nanoRealtime() - CLIENT_HELLO_TIMEOUT_NANOS;
    }

    private void cleanupRecentHandshakes() {
        int count = 0;
        int size = 0;
        long expires = this.calculateRecentHandshakeExpires();
        while (true) {
            Long startNanos;
            size = this.recentHandshakes.size();
            Connection connection = this.recentHandshakes.peek();
            if (connection == null || (startNanos = connection.getStartNanos()) != null && expires - startNanos < 0L) break;
            connection.startByClientHello(null);
            this.recentHandshakes.poll();
            ++count;
        }
        if (count > 0 || size > 0) {
            LOGGER.debug("Cleanup {} recent handshakes, left {}!", (Object)count, (Object)size);
        }
    }

    public final synchronized void setExecutor(ExecutorService executor) {
        if (this.executorService != executor) {
            if (this.running.get()) {
                throw new IllegalStateException("cannot set new executor while connector is running");
            }
            this.executorService = executor;
        }
    }

    public final void close(InetSocketAddress peerAddress) {
        final Connection connection = this.getConnection(peerAddress, null, false);
        if (connection != null && connection.hasEstablishedDtlsContext()) {
            SerialExecutor serialExecutor = connection.getExecutor();
            serialExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    DTLSConnector.this.closeConnection(connection);
                }
            });
        }
    }

    @Override
    public final synchronized void start() throws IOException {
        this.start(this.config.getAddress());
    }

    final synchronized void restart() throws IOException {
        if (this.lastBindAddress == null) {
            throw new IllegalStateException("Connector has never been started before");
        }
        this.start(this.lastBindAddress);
    }

    private ExecutorService getExecutorService() {
        return this.executorService;
    }

    protected void start(InetSocketAddress bindAddress) throws IOException {
        if (this.running.get()) {
            return;
        }
        this.init(bindAddress, new DatagramSocket(null), this.config.getMaxTransmissionUnit());
    }

    protected void init(InetSocketAddress bindAddress, DatagramSocket socket, Integer mtu) throws IOException {
        int healthStatusInterval;
        Integer size;
        this.socket = socket;
        this.pendingOutboundMessagesCountdown.set(this.outboundMessageBufferSize);
        if (bindAddress.getPort() != 0 && this.config.useReuseAddress().booleanValue()) {
            LOGGER.info("Enable address reuse for socket!");
            socket.setReuseAddress(true);
            if (!socket.getReuseAddress()) {
                LOGGER.warn("Enable address reuse for socket failed!");
            }
        }
        if ((size = this.config.getSocketReceiveBufferSize()) != null && size > 0) {
            try {
                socket.setReceiveBufferSize(size);
            }
            catch (IllegalArgumentException ex) {
                LOGGER.error("failed to apply receive buffer size {}", (Object)size, (Object)ex);
            }
        }
        if ((size = this.config.getSocketSendBufferSize()) != null && size > 0) {
            try {
                socket.setSendBufferSize(size);
            }
            catch (IllegalArgumentException ex) {
                LOGGER.error("failed to apply send buffer size {}", (Object)size, (Object)ex);
            }
        }
        int recvBuffer = socket.getReceiveBufferSize();
        int sendBuffer = socket.getSendBufferSize();
        if (!socket.isBound()) {
            socket.bind(bindAddress);
        }
        InetSocketAddress actualBindAddress = new InetSocketAddress(socket.getLocalAddress(), socket.getLocalPort());
        if (this.lastBindAddress != null && !actualBindAddress.equals(this.lastBindAddress)) {
            this.connectionStore.markAllAsResumptionRequired();
        }
        if (this.config.getMaxFragmentLength() != null) {
            MaxFragmentLengthExtension.Length lengthCode = this.config.getMaxFragmentLength();
            this.inboundDatagramBufferSize = lengthCode.length() + MAX_CIPHERTEXT_EXPANSION + 25;
        }
        if (this.config.getMaxTransmissionUnit() != null) {
            this.maximumTransmissionUnit = this.config.getMaxTransmissionUnit();
            LOGGER.info("Configured MTU [{}]", (Object)this.maximumTransmissionUnit);
        } else if (mtu != null) {
            this.maximumTransmissionUnit = mtu;
            LOGGER.info("Forced MTU [{}]", (Object)this.maximumTransmissionUnit);
        } else {
            InetAddress localInterfaceAddress = bindAddress.getAddress();
            if (localInterfaceAddress.isAnyLocalAddress()) {
                this.ipv4Mtu = NetworkInterfacesUtil.getIPv4Mtu();
                this.ipv6Mtu = NetworkInterfacesUtil.getIPv6Mtu();
                LOGGER.info("multiple network interfaces, using smallest MTU [IPv4 {}, IPv6 {}]", (Object)this.ipv4Mtu, (Object)this.ipv6Mtu);
            } else {
                NetworkInterface ni = NetworkInterface.getByInetAddress(localInterfaceAddress);
                boolean ipv6 = localInterfaceAddress instanceof Inet6Address;
                if (ni != null && ni.getMTU() > 0) {
                    if (ipv6) {
                        this.ipv6Mtu = ni.getMTU();
                    } else {
                        this.ipv4Mtu = ni.getMTU();
                    }
                } else if (ipv6) {
                    this.ipv6Mtu = NetworkInterfacesUtil.getIPv6Mtu();
                    LOGGER.info("Cannot determine MTU of network interface, using minimum MTU [{}] of IPv6 instead", (Object)this.ipv6Mtu);
                } else {
                    this.ipv4Mtu = NetworkInterfacesUtil.getIPv4Mtu();
                    LOGGER.info("Cannot determine MTU of network interface, using minimum MTU [{}] of IPv4 instead", (Object)this.ipv4Mtu);
                }
            }
            Integer limit = this.config.getMaxTransmissionUnitLimit();
            if (limit != null && limit < this.inboundDatagramBufferSize) {
                if (this.ipv4Mtu > limit) {
                    this.ipv4Mtu = limit;
                    LOGGER.info("Limit MTU IPv4[{}]", (Object)this.ipv4Mtu);
                }
                if (this.ipv6Mtu > limit) {
                    this.ipv6Mtu = limit;
                    LOGGER.info("Limit MTU IPv6[{}]", (Object)this.ipv6Mtu);
                }
            } else {
                if (this.ipv4Mtu > this.inboundDatagramBufferSize) {
                    this.ipv4Mtu = this.inboundDatagramBufferSize;
                    LOGGER.info("Buffersize MTU IPv4[{}]", (Object)this.ipv4Mtu);
                }
                if (this.ipv6Mtu > this.inboundDatagramBufferSize) {
                    this.ipv6Mtu = this.inboundDatagramBufferSize;
                    LOGGER.info("Buffersize MTU IPv6[{}]", (Object)this.ipv6Mtu);
                }
            }
        }
        this.lastBindAddress = actualBindAddress;
        this.timer = this.executorService instanceof ScheduledExecutorService ? (ScheduledExecutorService)this.executorService : ExecutorsUtil.newSingleThreadScheduledExecutor(new DaemonThreadFactory("DTLS-Timer-" + this.lastBindAddress + "#", NamedThreadFactory.SCANDIUM_THREAD_GROUP));
        if (this.executorService == null) {
            int threadCount = this.config.getConnectorThreadCount();
            this.executorService = threadCount > 1 ? ExecutorsUtil.newFixedThreadPool(threadCount - 1, new DaemonThreadFactory("DTLS-Worker-" + this.lastBindAddress + "#", NamedThreadFactory.SCANDIUM_THREAD_GROUP)) : this.timer;
            this.hasInternalExecutor = true;
        }
        long expires = this.calculateRecentHandshakeExpires();
        int recentCounter = 0;
        ArrayList<Connection> recent = new ArrayList<Connection>();
        Iterator<Connection> iterator = this.connectionStore.iterator();
        while (iterator.hasNext()) {
            Long start;
            Connection connection = iterator.next();
            if (!connection.hasEstablishedDtlsContext()) continue;
            if (!connection.isExecuting()) {
                connection.setConnectorContext(this.executorService, this.connectionListener);
            }
            if ((start = connection.getStartNanos()) == null) continue;
            ++recentCounter;
            if (expires - start < 0L) {
                recent.add(connection);
                continue;
            }
            connection.startByClientHello(null);
        }
        if (recentCounter > 0) {
            LOGGER.info("Restore {} recent handshakes!", (Object)recent.size());
            if (!recent.isEmpty()) {
                Collections.sort(recent, new Comparator<Connection>(){

                    @Override
                    public int compare(Connection o1, Connection o2) {
                        Long time1 = o1.getStartNanos();
                        Long time2 = o2.getStartNanos();
                        if (time1 != null && time2 != null) {
                            long diff = time1 - time2;
                            if (diff > 0L) {
                                return 1;
                            }
                            if (diff < 0L) {
                                return -1;
                            }
                        } else {
                            if (time1 == null) {
                                return -1;
                            }
                            if (time2 == null) {
                                return 1;
                            }
                        }
                        return 0;
                    }
                });
                this.recentHandshakes.addAll(recent);
                this.cleanupRecentHandshakes();
            }
        }
        this.running.set(true);
        int receiverThreadCount = this.config.getReceiverThreadCount();
        for (int i = 0; i < receiverThreadCount; ++i) {
            Worker receiver = new Worker("DTLS-Receiver-" + i + "-" + this.lastBindAddress){
                private final byte[] receiverBuffer;
                private final DatagramPacket packet;
                {
                    this.receiverBuffer = new byte[DTLSConnector.this.inboundDatagramBufferSize];
                    this.packet = new DatagramPacket(this.receiverBuffer, DTLSConnector.this.inboundDatagramBufferSize);
                }

                @Override
                public void doWork() throws Exception {
                    if (MDC_SUPPORT) {
                        MDC.clear();
                    }
                    this.packet.setData(this.receiverBuffer);
                    DTLSConnector.this.receiveNextDatagramFromNetwork(this.packet);
                }
            };
            receiver.setDaemon(true);
            receiver.start();
            this.receiverThreads.add(receiver);
        }
        String mtuDescription = this.maximumTransmissionUnit != null ? this.maximumTransmissionUnit.toString() : "IPv4 " + this.ipv4Mtu + " / IPv6 " + this.ipv6Mtu;
        LOGGER.info("DTLSConnector listening on {}, recv buf = {}, send buf = {}, recv packet size = {}, MTU = {}", this.lastBindAddress, recvBuffer, sendBuffer, this.inboundDatagramBufferSize, mtuDescription);
        if (this.health != null && this.health.isEnabled() && (healthStatusInterval = this.config.getHealthStatusIntervalMilliseconds()) > 0) {
            this.statusLogger = this.timer.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    DTLSConnector.this.health.dump(DTLSConnector.this.config.getLoggingTag(), DTLSConnector.this.config.getMaxConnections(), DTLSConnector.this.connectionStore.remainingCapacity(), DTLSConnector.this.pendingHandshakesWithoutVerifiedPeer.get());
                }
            }, healthStatusInterval, healthStatusInterval, TimeUnit.MILLISECONDS);
        }
        this.recentHandshakeCleaner = this.timer.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                try {
                    DTLSConnector.this.cleanupRecentHandshakes();
                }
                catch (Throwable t) {
                    LOGGER.warn("Cleanup recent handshakes failed!", t);
                }
            }
        }, 5000L, 5000L, TimeUnit.MILLISECONDS);
    }

    public final void forceResumeSessionFor(InetSocketAddress peer) {
        Connection peerConnection = this.connectionStore.get(peer);
        if (peerConnection != null && peerConnection.hasEstablishedDtlsContext()) {
            peerConnection.setResumptionRequired(true);
        }
    }

    public final void forceResumeAllSessions() {
        this.connectionStore.markAllAsResumptionRequired();
    }

    public final void clearConnectionState() {
        this.connectionStore.clear();
    }

    private final DatagramSocket getSocket() {
        return this.socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        boolean stop;
        ExecutorService shutdownTimer = null;
        ExecutorService shutdown = null;
        ArrayList<Runnable> pending = new ArrayList<Runnable>();
        DTLSConnector dTLSConnector = this;
        synchronized (dTLSConnector) {
            stop = this.running.compareAndSet(true, false);
            if (stop) {
                LOGGER.debug("DTLS connector on [{}] stopping ...", (Object)this.lastBindAddress);
                if (this.statusLogger != null) {
                    this.statusLogger.cancel(false);
                    this.statusLogger = null;
                }
                if (this.recentHandshakeCleaner != null) {
                    this.recentHandshakeCleaner.cancel(false);
                    this.recentHandshakeCleaner = null;
                }
                this.recentHandshakes.clear();
                for (Thread t : this.receiverThreads) {
                    t.interrupt();
                }
                if (this.socket != null) {
                    this.socket.close();
                    this.socket = null;
                }
                this.maximumTransmissionUnit = null;
                this.ipv4Mtu = 576;
                this.ipv6Mtu = 1280;
                this.connectionStore.stop(pending);
                if (this.executorService != this.timer) {
                    pending.addAll(this.timer.shutdownNow());
                    shutdownTimer = this.timer;
                    this.timer = null;
                }
                if (this.hasInternalExecutor) {
                    pending.addAll(this.executorService.shutdownNow());
                    shutdown = this.executorService;
                    this.executorService = null;
                    this.hasInternalExecutor = false;
                }
                for (Thread t : this.receiverThreads) {
                    t.interrupt();
                    try {
                        t.join(500L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                this.receiverThreads.clear();
            }
        }
        if (shutdownTimer != null) {
            try {
                if (!shutdownTimer.awaitTermination(500L, TimeUnit.MILLISECONDS)) {
                    LOGGER.warn("Shutdown DTLS connector on [{}] timer not terminated in time!", (Object)this.lastBindAddress);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (shutdown != null) {
            try {
                if (!shutdown.awaitTermination(500L, TimeUnit.MILLISECONDS)) {
                    LOGGER.warn("Shutdown DTLS connector on [{}] executor not terminated in time!", (Object)this.lastBindAddress);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        for (Runnable job : pending) {
            try {
                job.run();
            }
            catch (Exception e) {
                LOGGER.warn("Shutdown DTLS connector:", e);
            }
        }
        if (stop) {
            LOGGER.debug("DTLS connector on [{}] stopped.", (Object)this.lastBindAddress);
        }
    }

    @Override
    public void destroy() {
        this.stop();
        this.connectionStore.clear();
        this.messageHandler = null;
    }

    @Override
    public int saveConnections(OutputStream out, long maxQuietPeriodInSeconds) throws IOException {
        if (this.isRunning()) {
            throw new IllegalStateException("Connector is running, save not possible!");
        }
        return this.connectionStore.saveConnections(out, maxQuietPeriodInSeconds);
    }

    @Override
    public int loadConnections(InputStream in, long delta) throws IOException {
        return this.connectionStore.loadConnections(in, delta);
    }

    public boolean restoreConnection(Connection connection) {
        return this.connectionStore.restore(connection);
    }

    public Future<Void> startDropConnectionsForPrincipal(final Principal principal) {
        if (principal == null) {
            throw new NullPointerException("principal must not be null!");
        }
        LeastRecentlyUsedCache.Predicate<Principal> handler = new LeastRecentlyUsedCache.Predicate<Principal>(){

            @Override
            public boolean accept(Principal connectionPrincipal) {
                return principal.equals(connectionPrincipal);
            }
        };
        return this.startTerminateConnectionsForPrincipal(handler);
    }

    public Future<Void> startTerminateConnectionsForPrincipal(LeastRecentlyUsedCache.Predicate<Principal> principalHandler) {
        return this.startTerminateConnectionsForPrincipal(principalHandler, true);
    }

    public Future<Void> startTerminateConnectionsForPrincipal(final LeastRecentlyUsedCache.Predicate<Principal> principalHandler, final boolean removeFromSessionCache) {
        if (principalHandler == null) {
            throw new NullPointerException("principal handler must not be null!");
        }
        LeastRecentlyUsedCache.Predicate<Connection> connectionHandler = new LeastRecentlyUsedCache.Predicate<Connection>(){

            @Override
            public boolean accept(Connection connection) {
                Principal peer = null;
                DTLSSession session = connection.getSession();
                if (session != null && (peer = session.getPeerIdentity()) != null && principalHandler.accept(peer)) {
                    DTLSConnector.this.connectionStore.remove(connection, removeFromSessionCache);
                }
                return false;
            }
        };
        return this.startForEach(connectionHandler);
    }

    public Future<Void> startForEach(LeastRecentlyUsedCache.Predicate<Connection> handler) {
        if (handler == null) {
            throw new NullPointerException("handler must not be null!");
        }
        ForEachFuture result = new ForEachFuture();
        this.nextForEach(this.connectionStore.iterator(), handler, result);
        return result;
    }

    private void nextForEach(final Iterator<Connection> iterator, final LeastRecentlyUsedCache.Predicate<Connection> handler, final ForEachFuture result) {
        block4: {
            if (!result.isStopped() && iterator.hasNext()) {
                final Connection next = iterator.next();
                try {
                    next.getExecutor().execute(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            boolean done = true;
                            try {
                                if (!result.isStopped() && !handler.accept(next)) {
                                    done = false;
                                    DTLSConnector.this.nextForEach(iterator, handler, result);
                                }
                            }
                            catch (Exception exception) {
                                result.failed(exception);
                            }
                            finally {
                                if (done) {
                                    result.done();
                                }
                            }
                        }
                    });
                    return;
                }
                catch (RejectedExecutionException ex) {
                    if (handler.accept(next)) break block4;
                    while (iterator.hasNext() && !handler.accept(iterator.next()) && !result.isStopped()) {
                    }
                }
            }
        }
        result.done();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Connection getConnection(InetSocketAddress peerAddress, ConnectionId cid, boolean create) {
        ExecutorService executor = this.getExecutorService();
        ResumptionSupportingConnectionStore resumptionSupportingConnectionStore = this.connectionStore;
        synchronized (resumptionSupportingConnectionStore) {
            Connection connection;
            if (cid != null) {
                connection = this.connectionStore.get(cid);
            } else {
                connection = this.connectionStore.get(peerAddress);
                if (connection == null && create) {
                    LOGGER.trace("create new connection for {}", (Object)peerAddress);
                    Connection newConnection = new Connection(peerAddress);
                    newConnection.setConnectorContext(executor, this.connectionListener);
                    if (this.running.get() && !this.connectionStore.put(newConnection)) {
                        return null;
                    }
                    return newConnection;
                }
            }
            if (connection == null) {
                LOGGER.trace("no connection available for {},{}", (Object)peerAddress, (Object)cid);
            } else if (!connection.isExecuting() && this.running.get()) {
                LOGGER.trace("revive connection for {},{}", (Object)peerAddress, (Object)cid);
                connection.setConnectorContext(executor, this.connectionListener);
            } else {
                LOGGER.trace("connection available for {},{}", (Object)peerAddress, (Object)cid);
            }
            return connection;
        }
    }

    protected void receiveNextDatagramFromNetwork(DatagramPacket packet) throws IOException {
        DatagramSocket currentSocket = this.getSocket();
        if (currentSocket == null) {
            return;
        }
        currentSocket.receive(packet);
        if (packet.getLength() == 0) {
            return;
        }
        this.processDatagram(packet, null);
    }

    @Override
    public void processDatagram(DatagramPacket datagram) {
        this.processDatagram(datagram, null);
    }

    protected void processDatagram(DatagramPacket packet, InetSocketAddress router) {
        InetSocketAddress peerAddress = (InetSocketAddress)packet.getSocketAddress();
        if (MDC_SUPPORT) {
            MDC.put("PEER", StringUtil.toString(peerAddress));
        }
        if (this.health != null) {
            this.health.receivingRecord(false);
        }
        long timestamp = ClockUtil.nanoRealtime();
        DatagramReader reader = new DatagramReader(packet.getData(), packet.getOffset(), packet.getLength());
        List<Record> records = Record.fromReader(reader, this.connectionIdGenerator, timestamp);
        LOGGER.trace("Received {} DTLS records from {} using a {} byte datagram buffer", records.size(), StringUtil.toLog(peerAddress), this.inboundDatagramBufferSize);
        if (records.isEmpty()) {
            DROP_LOGGER.trace("Discarding malicious record with {} bytes from [{}]", (Object)packet.getLength(), StringUtil.toLog(peerAddress));
            if (this.health != null) {
                this.health.receivingRecord(true);
            }
            return;
        }
        if (!this.running.get()) {
            DROP_LOGGER.trace("Discarding {} records, startting with {} from [{}] on shutdown", new Object[]{records.size(), records.get(0).getType(), StringUtil.toLog(peerAddress)});
            LOGGER.debug("Execution shutdown while processing incoming records from peer: {}", StringUtil.toLog(peerAddress));
            if (this.health != null) {
                this.health.receivingRecord(true);
            }
            return;
        }
        final Record firstRecord = records.get(0);
        if (records.size() == 1 && firstRecord.isNewClientHello()) {
            firstRecord.setAddress(peerAddress, router);
            if (this.dtlsRole == DtlsConfig.DtlsRole.CLIENT_ONLY) {
                DROP_LOGGER.trace("client-only, discarding {} CLIENT_HELLO from [{}]!", (Object)records.size(), StringUtil.toLog(peerAddress));
                if (this.health != null) {
                    this.health.sendingRecord(true);
                }
                return;
            }
            this.getExecutorService().execute(new Runnable(){

                @Override
                public void run() {
                    if (MDC_SUPPORT) {
                        MDC.put("PEER", StringUtil.toString(firstRecord.getPeerAddress()));
                    }
                    DTLSConnector.this.processNewClientHello(firstRecord);
                    if (MDC_SUPPORT) {
                        MDC.clear();
                    }
                }
            });
            return;
        }
        ConnectionId connectionId = firstRecord.getConnectionId();
        final Connection connection = this.getConnection(peerAddress, connectionId, false);
        if (connection == null) {
            if (this.health != null) {
                this.health.receivingRecord(true);
            }
            if (connectionId == null) {
                DROP_LOGGER.trace("Discarding {} records from [{}] received without existing connection", (Object)records.size(), StringUtil.toLog(peerAddress));
            } else {
                DROP_LOGGER.trace("Discarding {} records from [{},{}] received without existing connection", records.size(), StringUtil.toLog(peerAddress), connectionId);
            }
            return;
        }
        SerialExecutor serialExecutor = connection.getExecutor();
        for (final Record record : records) {
            try {
                record.setAddress(peerAddress, router);
                serialExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        if (DTLSConnector.this.running.get()) {
                            DTLSConnector.this.processRecord(record, connection);
                        }
                    }
                });
            }
            catch (RejectedExecutionException e) {
                LOGGER.debug("Execution rejected while processing record [type: {}, peer: {}]", new Object[]{record.getType(), StringUtil.toLog(peerAddress), e});
                break;
            }
            catch (RuntimeException e) {
                LOGGER.warn("Unexpected error occurred while processing record [type: {}, peer: {}]", new Object[]{record.getType(), StringUtil.toLog(peerAddress), e});
                this.terminateConnectionWithInternalError(connection);
                break;
            }
        }
    }

    @Override
    public void processRecord(Record record, Connection connection) {
        try {
            boolean discard;
            DTLSContext context;
            if (record.getConnectionId() == null && !connection.equalsPeerAddress(record.getPeerAddress())) {
                long delay = TimeUnit.NANOSECONDS.toMillis(ClockUtil.nanoRealtime() - record.getReceiveNanos());
                DROP_LOGGER.debug("Drop received record {}, connection changed address {} => {}! (shift {}ms)", new Object[]{record.getType(), StringUtil.toLog(record.getPeerAddress()), StringUtil.toLog(connection.getPeerAddress()), delay});
                if (this.health != null) {
                    this.health.receivingRecord(true);
                }
                return;
            }
            int epoch = record.getEpoch();
            LOGGER.trace("Received DTLS record of type [{}], length: {}, [epoche:{},rseqn:{}]", new Object[]{record.getType(), record.getFragmentLength(), epoch, record.getSequenceNumber()});
            Handshaker handshaker = connection.getOngoingHandshake();
            if (handshaker != null && handshaker.isExpired()) {
                handshaker.handshakeFailed(new Exception("handshake already expired!"));
                if (this.connectionStore.get(connection.getConnectionId()) != connection) {
                    DROP_LOGGER.debug("Discarding {} record [epoch {}, rseqn {}] received from peer [{}], handshake expired!", new Object[]{record.getType(), epoch, record.getSequenceNumber(), StringUtil.toLog(record.getPeerAddress())});
                    if (this.health != null) {
                        this.health.receivingRecord(true);
                    }
                    return;
                }
                handshaker = null;
            }
            if ((context = connection.getDtlsContext(epoch)) == null) {
                if (handshaker != null && handshaker.getDtlsContext().getReadEpoch() == 0 && epoch == 1) {
                    handshaker.addRecordsOfNextEpochForDeferredProcessing(record);
                } else {
                    DROP_LOGGER.debug("Discarding {} record [epoch {}, rseqn {}] received from peer [{}] without an active dtls context", new Object[]{record.getType(), epoch, record.getSequenceNumber(), StringUtil.toLog(record.getPeerAddress())});
                    if (this.health != null) {
                        this.health.receivingRecord(true);
                    }
                }
                return;
            }
            boolean closed = connection.isClosed();
            boolean bl = discard = (this.useFilter || closed) && !context.isRecordProcessable(epoch, record.getSequenceNumber(), this.useExtendedWindowFilter);
            if (discard) {
                if (closed) {
                    DROP_LOGGER.debug("Discarding {} record [epoch {}, rseqn {}] received from closed peer [{}]", new Object[]{record.getType(), epoch, record.getSequenceNumber(), StringUtil.toLog(record.getPeerAddress())});
                } else {
                    DROP_LOGGER.debug("Discarding duplicate {} record [epoch {}, rseqn {}] received from peer [{}]", new Object[]{record.getType(), epoch, record.getSequenceNumber(), StringUtil.toLog(record.getPeerAddress())});
                }
                if (this.health != null) {
                    this.health.receivingRecord(true);
                }
                return;
            }
            if (record.getType() == ContentType.TLS12_CID) {
                if (epoch == 0) {
                    DROP_LOGGER.debug("Discarding TLS_CID record received from peer [{}] during handshake", StringUtil.toLog(record.getPeerAddress()));
                    if (this.health != null) {
                        this.health.receivingRecord(true);
                    }
                    return;
                }
            } else if (epoch > 0 && connection.expectCid()) {
                DROP_LOGGER.debug("Discarding record received from peer [{}], CID required!", StringUtil.toLog(record.getPeerAddress()));
                if (this.health != null) {
                    this.health.receivingRecord(true);
                }
                return;
            }
            if (!record.isDecoded()) {
                record.setDeprecatedMac(context.useDeprecatedCid());
                record.decodeFragment(context.getReadState());
            }
            if (handshaker != null && handshaker.isProbing()) {
                this.connectionStore.removeFromEstablishedSessions(connection);
                connection.resetContext();
                handshaker.resetProbing();
                LOGGER.trace("handshake probe successful {}", StringUtil.toLog(connection.getPeerAddress()));
            }
            switch (record.getType()) {
                case APPLICATION_DATA: {
                    this.processApplicationDataRecord(record, connection);
                    break;
                }
                case ALERT: {
                    this.processAlertRecord(record, connection, context);
                    break;
                }
                case CHANGE_CIPHER_SPEC: {
                    this.processChangeCipherSpecRecord(record, connection);
                    break;
                }
                case HANDSHAKE: {
                    this.processHandshakeRecord(record, connection, context);
                    break;
                }
                default: {
                    DROP_LOGGER.debug("Discarding record of unsupported type [{}] from peer [{}]", (Object)record.getType(), StringUtil.toLog(record.getPeerAddress()));
                    break;
                }
            }
        }
        catch (RuntimeException e) {
            if (this.health != null) {
                this.health.receivingRecord(true);
            }
            LOGGER.warn("Unexpected error occurred while processing record from peer [{}]", StringUtil.toLog(record.getPeerAddress()), (Object)e);
            this.terminateConnectionWithInternalError(connection);
        }
        catch (GeneralSecurityException e) {
            DTLSContext dtlsContext = connection.getEstablishedDtlsContext();
            if (dtlsContext != null) {
                dtlsContext.incrementMacErrors();
                if (this.connectionListener != null && this.connectionListener.onConnectionMacError(connection)) {
                    this.closeConnection(connection);
                }
            }
            DROP_LOGGER.debug("Discarding {} received from peer [{}] caused by {}", new Object[]{record.getType(), StringUtil.toLog(record.getPeerAddress()), e.getMessage()});
            if (this.health != null) {
                this.health.receivingRecord(true);
            }
            LOGGER.debug("error occurred while processing record from peer [{}]", StringUtil.toLog(record.getPeerAddress()), (Object)e);
        }
        catch (HandshakeException e) {
            LOGGER.debug("error occurred while processing record from peer [{}]", StringUtil.toLog(record.getPeerAddress()), (Object)e);
        }
    }

    private void closeConnection(Connection connection) {
        DTLSContext context = connection.getEstablishedDtlsContext();
        if (context != null) {
            LOGGER.trace("Closing connection with peer [{}]", (Object)connection.getPeerAddress());
            this.sendAlert(connection, context, new AlertMessage(AlertMessage.AlertLevel.WARNING, AlertMessage.AlertDescription.CLOSE_NOTIFY));
            connection.setResumptionRequired(true);
        }
    }

    private void terminateConnectionWithInternalError(Connection connection) {
        DTLSContext context = connection.getDtlsContext();
        if (context != null) {
            LOGGER.trace("Terminating connection with peer [{}], Internal Error", StringUtil.toLog(connection.getPeerAddress()));
            this.sendAlert(connection, context, new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.INTERNAL_ERROR));
        }
        this.connectionStore.remove(connection, true);
    }

    private void processApplicationDataRecord(Record record, Connection connection) {
        Handshaker ongoingHandshake = connection.getOngoingHandshake();
        DTLSContext dtlsContext = connection.getEstablishedDtlsContext();
        if (dtlsContext != null && !connection.isResumptionRequired()) {
            ApplicationMessage message = (ApplicationMessage)record.getFragment();
            InetSocketAddress previousAddress = connection.getPeerAddress();
            boolean newest = this.updateConnectionAddress(record, connection);
            RawDataChannel channel = this.messageHandler;
            if (channel != null) {
                MapBasedEndpointContext.Attributes attributes = new MapBasedEndpointContext.Attributes();
                if (newest) {
                    attributes.add(DtlsEndpointContext.KEY_NEWEST_RECORD, Boolean.TRUE);
                }
                if (previousAddress != null && !connection.equalsPeerAddress(previousAddress)) {
                    attributes.add(DtlsEndpointContext.KEY_PREVIOUS_ADDRESS, previousAddress);
                }
                DtlsEndpointContext endpointContext = connection.getReadContext(attributes, record.getPeerAddress());
                LOGGER.trace("Received APPLICATION_DATA for {}", (Object)endpointContext);
                RawData receivedApplicationMessage = RawData.inbound(message.getData(), endpointContext, false, record.getReceiveNanos(), this.lastBindAddress);
                channel.receiveData(receivedApplicationMessage);
            }
        } else if (ongoingHandshake != null) {
            ongoingHandshake.addRecordsOfNextEpochForDeferredProcessing(record);
        } else {
            DROP_LOGGER.debug("Discarding APPLICATION_DATA record received from peer [{}]", StringUtil.toLog(record.getPeerAddress()));
        }
    }

    private void processAlertRecord(Record record, Connection connection, DTLSContext epochContext) {
        AlertMessage alert = (AlertMessage)record.getFragment();
        Handshaker handshaker = connection.getOngoingHandshake();
        HandshakeException error = null;
        LOGGER.trace("Processing {} ALERT from [{}]: {}", new Object[]{alert.getLevel(), StringUtil.toLog(connection.getPeerAddress()), alert.getDescription()});
        if (AlertMessage.AlertDescription.CLOSE_NOTIFY.equals((Object)alert.getDescription())) {
            if (connection.hasEstablishedDtlsContext()) {
                this.updateConnectionAddress(record, connection);
            } else {
                error = new HandshakeException("Received 'close notify'", alert);
                if (handshaker != null) {
                    handshaker.setFailureCause(error);
                }
            }
            if (!connection.isResumptionRequired()) {
                if (connection.getPeerAddress() != null) {
                    this.sendAlert(connection, epochContext, new AlertMessage(AlertMessage.AlertLevel.WARNING, AlertMessage.AlertDescription.CLOSE_NOTIFY));
                }
                if (connection.hasEstablishedDtlsContext()) {
                    connection.close(record);
                } else {
                    this.connectionStore.remove(connection, false);
                }
            }
        } else if (AlertMessage.AlertLevel.FATAL.equals((Object)alert.getLevel())) {
            error = new HandshakeException("Received 'fatal alert/" + (Object)((Object)alert.getDescription()) + "'", alert);
            if (handshaker != null) {
                handshaker.setFailureCause(error);
            }
            this.connectionStore.remove(connection, true);
        }
        this.reportAlertInternal(connection, alert);
        if (null != error && null != handshaker) {
            handshaker.handshakeFailed(error);
        }
    }

    private boolean updateConnectionAddress(Record record, Connection connection) {
        InetSocketAddress newAddress = null;
        boolean newest = connection.markRecordAsRead(record);
        if (newest || !this.useCidUpdateAddressOnNewerRecordFilter) {
            connection.setRouter(record.getRouter());
            newAddress = record.getPeerAddress();
        }
        this.connectionStore.update(connection, newAddress);
        Handshaker ongoingHandshake = connection.getOngoingHandshake();
        if (ongoingHandshake != null) {
            ongoingHandshake.handshakeCompleted();
        }
        if (this.connectionListener != null && this.connectionListener.onConnectionUpdatesSequenceNumbers(connection, false)) {
            this.closeConnection(connection);
        }
        return newest;
    }

    private void processChangeCipherSpecRecord(Record record, Connection connection) {
        Handshaker ongoingHandshaker = connection.getOngoingHandshake();
        if (ongoingHandshaker != null) {
            try {
                ongoingHandshaker.processMessage(record);
            }
            catch (HandshakeException e) {
                this.processExceptionDuringHandshake(record, connection, e);
            }
        } else {
            DROP_LOGGER.debug("Received CHANGE_CIPHER_SPEC record from peer [{}] with no handshake going on", StringUtil.toLog(record.getPeerAddress()));
        }
    }

    private void processHandshakeRecord(Record record, Connection connection, DTLSContext dtlsContext) {
        LOGGER.trace("Received {} record from peer [{}]", (Object)record.getType(), StringUtil.toLog(record.getPeerAddress()));
        if (record.isNewClientHello()) {
            throw new IllegalArgumentException("new CLIENT_HELLO must be processed by processClientHello!");
        }
        try {
            Handshaker handshaker = connection.getOngoingHandshake();
            HandshakeMessage handshakeMessage = (HandshakeMessage)record.getFragment();
            switch (handshakeMessage.getMessageType()) {
                case CLIENT_HELLO: {
                    DROP_LOGGER.debug("Reject re-negotiation from peer [{}]", StringUtil.toLog(record.getPeerAddress()));
                    this.sendAlert(connection, dtlsContext, new AlertMessage(AlertMessage.AlertLevel.WARNING, AlertMessage.AlertDescription.NO_RENEGOTIATION));
                    break;
                }
                case HELLO_REQUEST: {
                    if (handshaker != null) {
                        DROP_LOGGER.debug("Ignore HELLO_REQUEST received from peer [{}] during ongoing handshake", StringUtil.toLog(connection.getPeerAddress()));
                        break;
                    }
                    DROP_LOGGER.debug("Reject HELLO_REQUEST received from peer [{}]", StringUtil.toLog(connection.getPeerAddress()));
                    this.sendAlert(connection, dtlsContext, new AlertMessage(AlertMessage.AlertLevel.WARNING, AlertMessage.AlertDescription.NO_RENEGOTIATION));
                    break;
                }
                default: {
                    if (handshaker != null) {
                        handshaker.processMessage(record);
                        break;
                    }
                    DROP_LOGGER.debug("Discarding HANDSHAKE message [epoch={}] from peer [{}], no ongoing handshake!", (Object)record.getEpoch(), StringUtil.toLog(record.getPeerAddress()));
                    break;
                }
            }
        }
        catch (HandshakeException e) {
            this.processExceptionDuringHandshake(record, connection, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processNewClientHello(final Record record) {
        InetSocketAddress peerAddress = record.getPeerAddress();
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Processing new CLIENT_HELLO from peer [{}]:{}{}", StringUtil.toLog(peerAddress), StringUtil.lineSeparator(), record);
        }
        try {
            record.decodeFragment(DTLSConnectionState.NULL);
            DTLSMessage message = record.getFragment();
            if (message instanceof FragmentedHandshakeMessage) {
                LOGGER.debug("Received unsupported fragmented CLIENT_HELLO from peer {}.", StringUtil.toLog(peerAddress));
                this.discardRecord(record, new DtlsException("Fragmented CLIENT_HELLO is not supported!"));
                return;
            }
            ClientHello clientHello = (ClientHello)message;
            byte[] expectedCookie = this.cookieGenerator.generateCookie(peerAddress, clientHello);
            boolean addressVerified = this.isClientInControlOfSourceIpAddress(peerAddress, clientHello, expectedCookie);
            if (addressVerified) {
                Connection connection;
                ExecutorService executor = this.getExecutorService();
                ResumptionSupportingConnectionStore resumptionSupportingConnectionStore = this.connectionStore;
                synchronized (resumptionSupportingConnectionStore) {
                    connection = this.connectionStore.get(peerAddress);
                    if (connection != null && !connection.isStartedByClientHello(clientHello)) {
                        SessionId establishedSessionId;
                        boolean sameSession;
                        if (this.useHelloVerifyRequest && !clientHello.hasCookie() && clientHello.hasSessionId() && !(sameSession = Bytes.equals(establishedSessionId = connection.getEstablishedSessionIdentifier(), clientHello.getSessionId()))) {
                            addressVerified = false;
                        }
                        if (addressVerified) {
                            DTLSContext dtlsContext;
                            final Handshaker handshaker = connection.getOngoingHandshake();
                            if (handshaker != null && ((dtlsContext = connection.getEstablishedDtlsContext()) == null || dtlsContext != handshaker.getDtlsContext())) {
                                final DtlsException cause = new DtlsException("Received new CLIENT_HELLO from " + StringUtil.toDisplayString(peerAddress));
                                try {
                                    connection.getExecutor().execute(new Runnable(){

                                        @Override
                                        public void run() {
                                            if (DTLSConnector.this.running.get()) {
                                                handshaker.handshakeFailed(cause);
                                            }
                                        }
                                    });
                                }
                                catch (RejectedExecutionException ex) {
                                    LOGGER.trace("Execution rejected, connection already shutdown [peer: {}]", StringUtil.toLog(peerAddress));
                                }
                            }
                            connection = null;
                        }
                    }
                    if (connection == null) {
                        connection = new Connection(peerAddress);
                        connection.setConnectorContext(executor, this.connectionListener);
                        connection.startByClientHello(clientHello);
                        if (!this.connectionStore.put(connection)) {
                            return;
                        }
                    }
                }
                if (addressVerified) {
                    try {
                        final Connection clientConnection = connection;
                        connection.getExecutor().execute(new Runnable(){

                            @Override
                            public void run() {
                                if (DTLSConnector.this.running.get()) {
                                    DTLSConnector.this.processClientHello(record, clientConnection);
                                }
                            }
                        });
                    }
                    catch (RejectedExecutionException e) {
                        LOGGER.debug("Execution rejected while processing record [type: {}, peer: {}]", new Object[]{record.getType(), StringUtil.toLog(peerAddress), e});
                    }
                    catch (RuntimeException e) {
                        LOGGER.warn("Unexpected error occurred while processing record [type: {}, peer: {}]", new Object[]{record.getType(), StringUtil.toLog(peerAddress), e});
                        this.terminateConnectionWithInternalError(connection);
                    }
                    return;
                }
            }
            this.sendHelloVerify(clientHello, record, expectedCookie);
        }
        catch (HandshakeException e) {
            LOGGER.debug("Processing new CLIENT_HELLO from peer [{}] failed!", StringUtil.toLog(record.getPeerAddress()), (Object)e);
        }
        catch (GeneralSecurityException e) {
            DROP_LOGGER.debug("Processing new CLIENT_HELLO from peer [{}] failed!", StringUtil.toLog(record.getPeerAddress()), (Object)e);
        }
        catch (RuntimeException e) {
            LOGGER.warn("Processing new CLIENT_HELLO from peer [{}] failed!", StringUtil.toLog(record.getPeerAddress()), (Object)e);
        }
    }

    private void processClientHello(Record record, Connection connection) {
        if (connection == null) {
            throw new NullPointerException("connection must not be null!");
        }
        if (!connection.equalsPeerAddress(record.getPeerAddress())) {
            DROP_LOGGER.debug("Drop received CLIENT_HELLO, changed address {} => {}!", StringUtil.toLog(record.getPeerAddress()), StringUtil.toLog(connection.getPeerAddress()));
            return;
        }
        if (connection.hasEstablishedDtlsContext() || connection.hasOngoingHandshake()) {
            DROP_LOGGER.debug("Discarding received duplicate CLIENT_HELLO message [epoch={}] from peer [{}]!", (Object)record.getEpoch(), StringUtil.toLog(record.getPeerAddress()));
            return;
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Processing CLIENT_HELLO from peer [{}]:{}{}", StringUtil.toLog(record.getPeerAddress()), StringUtil.lineSeparator(), record);
        }
        try {
            ServerHandshaker handshaker;
            ClientHello clientHello = (ClientHello)record.getFragment();
            if (this.resumptionVerifier != null && clientHello.hasSessionId()) {
                handshaker = new ResumingServerHandshaker(record.getSequenceNumber(), clientHello.getMessageSeq(), this, this.timer, connection, this.config);
                if (!clientHello.hasCookie()) {
                    this.pendingHandshakesWithoutVerifiedPeer.incrementAndGet();
                    handshaker.addSessionListener(this.pendingHandshakesListener);
                }
            } else {
                handshaker = new ServerHandshaker(record.getSequenceNumber(), clientHello.getMessageSeq(), this, this.timer, connection, this.config);
            }
            this.initializeHandshaker(handshaker);
            handshaker.processMessage(record);
        }
        catch (HandshakeException e) {
            this.processExceptionDuringHandshake(record, connection, e);
        }
    }

    private boolean isClientInControlOfSourceIpAddress(InetSocketAddress peer, ClientHello clientHello, byte[] expectedCookie) {
        List<CipherSuite> common;
        byte[] providedCookie = clientHello.getCookie();
        if (providedCookie.length > 0) {
            boolean cookie = MessageDigest.isEqual(expectedCookie, providedCookie);
            if (!cookie) {
                try {
                    byte[] pastCookie = this.cookieGenerator.generatePastCookie(peer, clientHello);
                    if (pastCookie != null && MessageDigest.isEqual(pastCookie, providedCookie)) {
                        cookie = true;
                    }
                }
                catch (GeneralSecurityException ex) {
                    LOGGER.debug("failed to generate past cookie.", ex);
                }
            }
            if (!cookie && LOGGER.isDebugEnabled()) {
                LOGGER.debug("provided cookie must {} match {}. Send verify request to {}", StringUtil.byteArray2HexString(providedCookie, '\u0000', 6), StringUtil.byteArray2HexString(expectedCookie, '\u0000', 6), StringUtil.toLog(peer));
            }
            return cookie;
        }
        if (!this.useHelloVerifyRequest) {
            return true;
        }
        if (!this.useHelloVerifyRequestForPsk && CipherSuite.containsPskBasedCipherSuite(common = clientHello.getCommonCipherSuites(this.config.getSupportedCipherSuites()))) {
            return true;
        }
        if (this.resumptionVerifier != null && clientHello.hasSessionId() && 0 < this.thresholdHandshakesWithoutVerifiedPeer) {
            int pending = this.pendingHandshakesWithoutVerifiedPeer.get();
            LOGGER.trace("pending fast resumptions [{}], threshold [{}]", (Object)pending, (Object)this.thresholdHandshakesWithoutVerifiedPeer);
            if (pending < this.thresholdHandshakesWithoutVerifiedPeer) {
                return this.resumptionVerifier.skipRequestHelloVerify(clientHello.getSessionId());
            }
        }
        return false;
    }

    private void sendHelloVerify(ClientHello clientHello, Record record, byte[] expectedCookie) throws GeneralSecurityException {
        if (expectedCookie == null) {
            throw new NullPointerException("Cookie must not be null!");
        }
        LOGGER.trace("Verifying client IP address [{}] using HELLO_VERIFY_REQUEST", StringUtil.toLog(record.getPeerAddress()));
        ProtocolVersion version = this.protocolVersionForHelloVerifyRequests;
        if (version == null) {
            version = clientHello.getProtocolVersion();
            if (version.compareTo(ProtocolVersion.VERSION_DTLS_1_0) < 0) {
                version = ProtocolVersion.VERSION_DTLS_1_0;
            } else if (version.compareTo(ProtocolVersion.VERSION_DTLS_1_2) > 0) {
                version = ProtocolVersion.VERSION_DTLS_1_2;
            }
        }
        HelloVerifyRequest msg = new HelloVerifyRequest(version, expectedCookie);
        msg.setMessageSeq(clientHello.getMessageSeq());
        Record helloVerify = new Record(ContentType.HANDSHAKE, version, record.getSequenceNumber(), msg);
        helloVerify.setAddress(record.getPeerAddress(), null);
        try {
            this.sendRecord(helloVerify);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void processExceptionDuringHandshake(Record record, Connection connection, HandshakeException cause) {
        AlertMessage alert = cause.getAlert();
        if (!AlertMessage.AlertLevel.FATAL.equals((Object)alert.getLevel())) {
            if (record != null) {
                this.discardRecord(record, cause);
            }
            this.reportAlertInternal(connection, alert);
            return;
        }
        if (AlertMessage.AlertDescription.UNKNOWN_PSK_IDENTITY.equals((Object)alert.getDescription())) {
            if (record != null) {
                this.discardRecord(record, cause);
            }
            this.reportAlertInternal(connection, alert);
            return;
        }
        Handshaker handshaker = connection.getOngoingHandshake();
        if (handshaker != null) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Aborting handshake with peer [{}]:", StringUtil.toLog(connection.getPeerAddress()), (Object)cause);
            } else if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Aborting handshake with peer [{}]: {}", StringUtil.toLog(connection.getPeerAddress()), (Object)cause.getMessage());
            }
            handshaker.setFailureCause(cause);
            DTLSContext handshakeContext = handshaker.getDtlsContext();
            DTLSContext connectionContext = connection.getEstablishedDtlsContext();
            if (connectionContext == handshakeContext) {
                if (alert.getDescription() == AlertMessage.AlertDescription.CLOSE_NOTIFY) {
                    LOGGER.debug("Handshake with [{}] closed after session was established!", StringUtil.toLog(handshaker.getPeerAddress()));
                } else {
                    LOGGER.warn("Handshake with [{}] failed after session was established! {}", StringUtil.toLog(handshaker.getPeerAddress()), (Object)alert);
                }
            } else if (connectionContext != null) {
                LOGGER.warn("Handshake with [{}] failed, but has an established session!", StringUtil.toLog(handshaker.getPeerAddress()));
            }
            this.sendAlert(connection, handshakeContext, alert);
            handshaker.handshakeFailed(cause);
            this.reportAlertInternal(connection, alert);
        }
    }

    private void reportAlertInternal(Connection connection, AlertMessage alert) {
        AlertHandler handler;
        if (connection.setRootCause(alert) && (handler = this.alertHandler) != null) {
            handler.onAlert(connection.getPeerAddress(), alert);
        }
    }

    void sendAlert(Connection connection, DTLSContext context, AlertMessage alert) {
        if (connection == null) {
            throw new NullPointerException("Connection must not be null");
        }
        if (context == null) {
            throw new NullPointerException("DTLS Context must not be null");
        }
        if (alert == null) {
            throw new NullPointerException("Alert must not be null");
        }
        if (connection.isResumptionRequired()) {
            return;
        }
        try {
            LOGGER.trace("send ALERT {} for peer {}.", (Object)alert, StringUtil.toLog(connection.getPeerAddress()));
            boolean useCid = context.getWriteEpoch() > 0;
            Record record = useCid || alert.getProtocolVersion() == null ? new Record(ContentType.ALERT, context.getWriteEpoch(), alert, context, useCid, 0) : new Record(ContentType.ALERT, alert.getProtocolVersion(), context.getNextSequenceNumber(), alert);
            record.setAddress(connection.getPeerAddress(), connection.getRouter());
            this.sendRecord(record);
            if (this.connectionListener != null) {
                this.connectionListener.onConnectionUpdatesSequenceNumbers(connection, true);
            }
        }
        catch (IOException record) {
        }
        catch (GeneralSecurityException e) {
            DROP_LOGGER.warn("Cannot create ALERT message for peer [{}]", StringUtil.toLog(connection.getPeerAddress()), (Object)e);
        }
    }

    @Override
    public void send(final RawData message) {
        Connection connection;
        if (message == null) {
            throw new NullPointerException("Message must not be null");
        }
        if (this.health != null) {
            this.health.sendingRecord(false);
        }
        if (message.isMulticast()) {
            DROP_LOGGER.warn("DTLSConnector drops {} outgoing bytes to multicast {}", (Object)message.getSize(), StringUtil.toLog(message.getInetSocketAddress()));
            message.onError(new MulticastNotSupportedException("DTLS doesn't support multicast!"));
            if (this.health != null) {
                this.health.sendingRecord(true);
            }
            return;
        }
        RuntimeException error = null;
        if (!this.running.get()) {
            connection = null;
            error = new IllegalStateException("connector must be started before sending messages is possible");
        } else if (message.getSize() > 16384) {
            connection = null;
            error = new IllegalArgumentException("Message data must not exceed 16384 bytes");
        } else {
            boolean create;
            boolean bl = create = this.dtlsRole != DtlsConfig.DtlsRole.SERVER_ONLY;
            if (create) {
                boolean bl2 = create = !this.getEffectiveHandshakeMode(message).equals("none");
            }
            if ((connection = this.getConnection(message.getInetSocketAddress(), null, create)) == null) {
                if (create) {
                    error = new IllegalStateException("connection store is exhausted!");
                } else {
                    if (this.dtlsRole == DtlsConfig.DtlsRole.SERVER_ONLY) {
                        message.onError(new EndpointUnconnectedException("server only, connection missing!"));
                    } else {
                        message.onError(new EndpointUnconnectedException("connection missing!"));
                    }
                    DROP_LOGGER.debug("DTLSConnector drops {} outgoing bytes to {}, connection missing!", (Object)message.getSize(), StringUtil.toLog(message.getInetSocketAddress()));
                    if (this.health != null) {
                        this.health.sendingRecord(true);
                    }
                    return;
                }
            }
        }
        if (error != null) {
            DROP_LOGGER.debug("DTLSConnector drops {} outgoing bytes to {}, {}!", message.getSize(), StringUtil.toLog(message.getInetSocketAddress()), error.getMessage());
            message.onError(error);
            if (this.health != null) {
                this.health.sendingRecord(true);
            }
            throw error;
        }
        final long now = ClockUtil.nanoRealtime();
        if (this.pendingOutboundMessagesCountdown.decrementAndGet() >= 0) {
            try {
                SerialExecutor executor = connection.getExecutor();
                if (executor == null) {
                    throw new NullPointerException("missing executor for connection! " + connection.getPeerAddress());
                }
                executor.execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            if (DTLSConnector.this.running.get()) {
                                DTLSConnector.this.sendMessage(now, message, connection);
                            } else {
                                DROP_LOGGER.trace("DTLSConnector drops {} outgoing bytes to {}, connector not running!", (Object)message.getSize(), StringUtil.toLog(message.getInetSocketAddress()));
                                message.onError(new InterruptedIOException("Connector is not running."));
                                if (DTLSConnector.this.health != null) {
                                    DTLSConnector.this.health.sendingRecord(true);
                                }
                            }
                        }
                        catch (Exception e) {
                            if (DTLSConnector.this.running.get()) {
                                LOGGER.warn("Exception thrown by executor thread [{}]", (Object)Thread.currentThread().getName(), (Object)e);
                            }
                            DROP_LOGGER.trace("DTLSConnector drops {} outgoing bytes to {} {}", message.getSize(), StringUtil.toLog(message.getInetSocketAddress()), e.getMessage());
                            if (DTLSConnector.this.health != null) {
                                DTLSConnector.this.health.sendingRecord(true);
                            }
                            message.onError(e);
                        }
                        finally {
                            DTLSConnector.this.pendingOutboundMessagesCountdown.incrementAndGet();
                        }
                    }
                });
            }
            catch (RejectedExecutionException e) {
                LOGGER.debug("Execution rejected while sending application record [peer: {}]", StringUtil.toLog(message.getInetSocketAddress()), (Object)e);
                DROP_LOGGER.trace("DTLSConnector drops {} outgoing bytes to {}, {}", message.getSize(), StringUtil.toLog(message.getInetSocketAddress()), e.getMessage());
                message.onError(new InterruptedIOException("Connector is not running."));
                if (this.health != null) {
                    this.health.sendingRecord(true);
                }
            }
        } else {
            this.pendingOutboundMessagesCountdown.incrementAndGet();
            DROP_LOGGER.warn("Outbound message overflow! Dropping outbound message to peer [{}]", StringUtil.toLog(message.getInetSocketAddress()));
            message.onError(new IllegalStateException("Outbound message overflow!"));
            if (this.health != null) {
                this.health.sendingRecord(true);
            }
        }
    }

    private void sendMessage(long nanos, RawData message, Connection connection) throws HandshakeException {
        if (connection.getPeerAddress() == null) {
            long delay = TimeUnit.NANOSECONDS.toMillis(ClockUtil.nanoRealtime() - nanos);
            DROP_LOGGER.info("Drop outgoing record with {} bytes, connection lost address {}! (shift {}ms)", message.getSize(), StringUtil.toLog(message.getInetSocketAddress()), delay);
            message.onError(new EndpointUnconnectedException("connection not longer assigned to address!"));
            if (this.health != null) {
                this.health.sendingRecord(true);
            }
            return;
        }
        LOGGER.trace("Sending application layer message to [{}]", (Object)message.getEndpointContext());
        Handshaker handshaker = connection.getOngoingHandshake();
        if (handshaker != null && !handshaker.hasContextEstablished()) {
            if (handshaker.isExpired()) {
                handshaker.handshakeAborted(new Exception("handshake already expired!"));
            } else if (handshaker.isProbing()) {
                if (this.checkOutboundEndpointContext(message, null)) {
                    message.onConnecting();
                    handshaker.addApplicationDataForDeferredProcessing(message);
                }
                return;
            }
        }
        if (connection.isActive()) {
            this.sendMessageWithSession(message, connection);
        } else {
            this.sendMessageWithoutSession(message, connection);
        }
    }

    private void sendMessageWithoutSession(RawData message, Connection connection) throws HandshakeException {
        if (!this.checkOutboundEndpointContext(message, null)) {
            return;
        }
        Handshaker handshaker = connection.getOngoingHandshake();
        if (handshaker == null) {
            if (this.dtlsRole == DtlsConfig.DtlsRole.SERVER_ONLY) {
                DROP_LOGGER.trace("DTLSConnector drops {} outgoing bytes to {}, server only, connection missing!", (Object)message.getSize(), StringUtil.toLog(message.getInetSocketAddress()));
                message.onError(new EndpointUnconnectedException("server only, connection missing!"));
                if (this.health != null) {
                    this.health.sendingRecord(true);
                }
                return;
            }
            boolean none = this.getEffectiveHandshakeMode(message).contentEquals("none");
            if (none) {
                DROP_LOGGER.trace("DTLSConnector drops {} outgoing bytes to {}, connection missing!", (Object)message.getSize(), StringUtil.toLog(message.getInetSocketAddress()));
                message.onError(new EndpointUnconnectedException("connection missing!"));
                if (this.health != null) {
                    this.health.sendingRecord(true);
                }
                return;
            }
            String hostname = message.getEndpointContext().getVirtualHost();
            ClientHandshaker clientHandshaker = new ClientHandshaker(hostname, this, this.timer, connection, this.config, false);
            this.initializeHandshaker(clientHandshaker);
            message.onConnecting();
            clientHandshaker.addApplicationDataForDeferredProcessing(message);
            clientHandshaker.startHandshake();
        } else {
            message.onConnecting();
            handshaker.addApplicationDataForDeferredProcessing(message);
        }
    }

    private void sendMessageWithSession(RawData message, Connection connection) throws HandshakeException {
        DTLSContext context = connection.getEstablishedDtlsContext();
        String handshakeMode = this.getEffectiveHandshakeMode(message);
        boolean markedAsClosed = context.isMarkedAsClosed();
        boolean none = "none".equals(handshakeMode);
        if (none) {
            if (markedAsClosed || connection.isResumptionRequired()) {
                DROP_LOGGER.trace("DTLSConnector drops {} outgoing bytes to {}, resumption required!", (Object)message.getSize(), StringUtil.toLog(message.getInetSocketAddress()));
                message.onError(new EndpointUnconnectedException("resumption required!"));
                if (this.health != null) {
                    this.health.sendingRecord(true);
                }
                return;
            }
        } else {
            boolean force;
            boolean full = "full".equals(handshakeMode);
            boolean probing = "probe".equals(handshakeMode);
            boolean bl = force = probing || full || "force".equals(handshakeMode);
            if (force || markedAsClosed || connection.isAutoResumptionRequired(this.getAutoHandshakeTimeout(message))) {
                if (this.dtlsRole == DtlsConfig.DtlsRole.SERVER_ONLY) {
                    DROP_LOGGER.trace("DTLSConnector drops {} outgoing bytes to {}, server only, resumption requested failed!", (Object)message.getSize(), StringUtil.toLog(message.getInetSocketAddress()));
                    message.onError(new EndpointUnconnectedException("server only, resumption requested failed!"));
                    if (this.health != null) {
                        this.health.sendingRecord(true);
                    }
                    return;
                }
                message.onConnecting();
                String hostname = message.getEndpointContext().getVirtualHost();
                Handshaker previousHandshaker = connection.getOngoingHandshake();
                DTLSSession resume = null;
                if (!full) {
                    resume = context.getSession();
                    full = resume.getSessionIdentifier().isEmpty();
                    if (!full && this.config.getExtendedMasterSecretMode().is(ExtendedMasterSecretMode.ENABLED)) {
                        boolean bl2 = full = !resume.useExtendedMasterSecret();
                        if (full) {
                            LOGGER.debug("Extended Master Secrets not supported by server {}, fallback to full handshake!", StringUtil.toLog(message.getInetSocketAddress()));
                        }
                    }
                    if (!full) {
                        boolean bl3 = full = !ServerNames.equalsIgnoreCase(hostname, resume.getHostName());
                        if (full) {
                            LOGGER.debug("Server Name Indication changed for server {}, fallback to full handshake!", StringUtil.toLog(message.getInetSocketAddress()));
                        }
                    }
                }
                ClientHandshaker newHandshaker = full ? new ClientHandshaker(hostname, this, this.timer, connection, this.config, probing) : new ResumingClientHandshaker(resume, (RecordLayer)this, this.timer, connection, this.config, probing);
                if (probing) {
                    connection.setResumptionRequired(false);
                } else {
                    this.connectionStore.removeFromEstablishedSessions(connection);
                    connection.resetContext();
                }
                this.initializeHandshaker(newHandshaker);
                if (previousHandshaker != null) {
                    newHandshaker.takeDeferredApplicationData(previousHandshaker);
                    previousHandshaker.handshakeAborted(new Exception("handshake replaced!"));
                }
                newHandshaker.addApplicationDataForDeferredProcessing(message);
                newHandshaker.startHandshake();
                return;
            }
        }
        this.sendMessage(message, connection);
    }

    private void sendMessage(RawData message, Connection connection) {
        try {
            DTLSContext dltsContext = connection.getEstablishedDtlsContext();
            LOGGER.trace("send {}-{} using {}", connection.getConnectionId(), StringUtil.toLog(connection.getPeerAddress()), dltsContext.getSession().getSessionIdentifier());
            MapBasedEndpointContext.Attributes attributes = new MapBasedEndpointContext.Attributes();
            DtlsEndpointContext context = connection.getWriteContext(attributes);
            if (!this.checkOutboundEndpointContext(message, context)) {
                return;
            }
            message.onContextEstablished(context);
            Record record = new Record(ContentType.APPLICATION_DATA, dltsContext.getWriteEpoch(), new ApplicationMessage(message.getBytes()), dltsContext, true, 0);
            record.setAddress(connection.getPeerAddress(), connection.getRouter());
            this.sendRecord(record);
            message.onSent();
            this.connectionStore.update(connection, null);
            if (this.connectionListener != null && this.connectionListener.onConnectionUpdatesSequenceNumbers(connection, true)) {
                this.closeConnection(connection);
            }
        }
        catch (IOException e) {
            message.onError(e);
        }
        catch (GeneralSecurityException e) {
            DROP_LOGGER.warn("Cannot send APPLICATION record to peer [{}]", StringUtil.toLog(message.getInetSocketAddress()), (Object)e);
            message.onError(e);
        }
    }

    private boolean checkOutboundEndpointContext(RawData message, EndpointContext connectionContext) {
        EndpointContextMatcher endpointMatcher = this.getEndpointContextMatcher();
        if (null != endpointMatcher && !endpointMatcher.isToBeSent(message.getEndpointContext(), connectionContext)) {
            if (DROP_LOGGER.isInfoEnabled()) {
                DROP_LOGGER.info("DTLSConnector ({}) drops {} bytes outgoing, {} != {}", this, message.getSize(), endpointMatcher.toRelevantState(message.getEndpointContext()), endpointMatcher.toRelevantState(connectionContext));
            }
            message.onError(new EndpointMismatchException("DTLS sending"));
            if (this.health != null) {
                this.health.sendingRecord(true);
            }
            return false;
        }
        return true;
    }

    public final DTLSSession getSessionByAddress(InetSocketAddress address) {
        DTLSContext context = this.getDtlsContextByAddress(address);
        if (context != null) {
            return context.getSession();
        }
        return null;
    }

    public final DTLSContext getDtlsContextByAddress(InetSocketAddress address) {
        if (address == null) {
            return null;
        }
        Connection connection = this.connectionStore.get(address);
        if (connection != null) {
            return connection.getEstablishedDtlsContext();
        }
        return null;
    }

    @Override
    public void dropReceivedRecord(Record record) {
        DROP_LOGGER.debug("Discarding {} record [epoch {}, rseqn {}] dropped by handshaker for peer [{}]", new Object[]{record.getType(), record.getEpoch(), record.getSequenceNumber(), StringUtil.toLog(record.getPeerAddress())});
        if (this.health != null) {
            this.health.receivingRecord(true);
        }
    }

    @Override
    public int getMaxDatagramSize(boolean ipv6) {
        int headerSize;
        int n = headerSize = ipv6 ? 128 : 64;
        int mtu = this.maximumTransmissionUnit != null ? this.maximumTransmissionUnit : (ipv6 ? this.ipv6Mtu : this.ipv4Mtu);
        int size = mtu - headerSize;
        if (size < 64) {
            throw new IllegalStateException(String.format("%s, datagram size %d, mtu %d", ipv6 ? "IPV6" : "IPv4", size, mtu));
        }
        return size;
    }

    @Override
    @NoPublicAPI
    public void sendFlight(List<DatagramPacket> datagrams) throws IOException {
        for (DatagramPacket datagramPacket : datagrams) {
            if (this.health != null) {
                this.health.sendingRecord(false);
            }
            this.sendNextDatagramOverNetwork(datagramPacket);
        }
    }

    @Override
    public void processHandshakeException(Connection connection, HandshakeException error) {
        this.processExceptionDuringHandshake(null, connection, error);
    }

    protected void sendRecord(Record record) throws IOException {
        if (this.health != null && record.getType() != ContentType.APPLICATION_DATA) {
            this.health.sendingRecord(false);
        }
        byte[] recordBytes = record.toByteArray();
        DatagramPacket datagram = new DatagramPacket(recordBytes, recordBytes.length, record.getPeerAddress());
        this.sendNextDatagramOverNetwork(datagram);
    }

    protected void sendNextDatagramOverNetwork(DatagramPacket datagramPacket) throws IOException {
        InetSocketAddress address;
        block6: {
            DatagramSocket socket = this.getSocket();
            if (socket != null && !socket.isClosed()) {
                try {
                    socket.send(datagramPacket);
                    return;
                }
                catch (PortUnreachableException e) {
                    if (!socket.isClosed()) {
                        LOGGER.warn("Could not send record, destination {} unreachable!", StringUtil.toLog(datagramPacket.getSocketAddress()));
                    }
                }
                catch (IOException e) {
                    if (socket.isClosed()) break block6;
                    LOGGER.warn("Could not send record", e);
                    throw e;
                }
            }
        }
        if ((address = this.lastBindAddress) == null) {
            address = this.config.getAddress();
        }
        DROP_LOGGER.debug("Socket [{}] is closed, discarding packet ...", (Object)address);
        throw new IOException("Socket closed.");
    }

    private void processAsynchronousHandshakeResult(final HandshakeResult handshakeResult) {
        final Connection connection = this.connectionStore.get(handshakeResult.getConnectionId());
        if (connection != null) {
            if (connection.hasOngoingHandshake()) {
                SerialExecutor serialExecutor = connection.getExecutor();
                try {
                    serialExecutor.execute(new Runnable(){

                        @Override
                        public void run() {
                            if (DTLSConnector.this.running.get()) {
                                Handshaker handshaker = connection.getOngoingHandshake();
                                if (handshaker != null) {
                                    try {
                                        handshaker.processAsyncHandshakeResult(handshakeResult);
                                    }
                                    catch (HandshakeException e) {
                                        DTLSConnector.this.processExceptionDuringHandshake(null, connection, e);
                                    }
                                    catch (IllegalStateException e) {
                                        LOGGER.warn("Exception while processing handshake result [{}]", (Object)connection, (Object)e);
                                    }
                                } else {
                                    LOGGER.debug("No ongoing handshake for result [{}]", (Object)connection);
                                }
                            } else {
                                LOGGER.debug("Execution stopped while processing handshake result [{}]", (Object)connection);
                            }
                        }
                    });
                }
                catch (RejectedExecutionException e) {
                    LOGGER.debug("Execution rejected while processing handshake result [{}]", (Object)connection, (Object)e);
                }
                catch (RuntimeException e) {
                    LOGGER.warn("Unexpected error occurred while processing handshake result [{}]", (Object)connection, (Object)e);
                }
            } else {
                LOGGER.debug("No ongoing handshake for handshake result [{}]", (Object)connection);
            }
        } else {
            LOGGER.debug("No connection  for handshake result [{}]", (Object)connection);
        }
    }

    private Long getAutoHandshakeTimeout(RawData message) {
        Long timeout = this.autoResumptionTimeoutMillis;
        Number contextTimeout = message.getEndpointContext().get(DtlsEndpointContext.KEY_AUTO_HANDSHAKE_TIMEOUT);
        if (contextTimeout != null) {
            timeout = contextTimeout.longValue() >= 0L ? Long.valueOf(contextTimeout.longValue()) : null;
        }
        return timeout;
    }

    public final int getMaximumFragmentLength(InetSocketAddress peer) {
        DTLSContext dtlsContext = this.getDtlsContextByAddress(peer);
        if (dtlsContext != null) {
            return dtlsContext.getSession().getMaxFragmentLength();
        }
        return this.getMaxDatagramSize(peer.getAddress() instanceof Inet6Address) - 25;
    }

    @Override
    public final InetSocketAddress getAddress() {
        int localPort;
        DatagramSocket socket = this.getSocket();
        int n = localPort = socket == null ? -1 : socket.getLocalPort();
        if (localPort < 0) {
            return this.config.getAddress();
        }
        return new InetSocketAddress(socket.getLocalAddress(), localPort);
    }

    @Override
    public final boolean isRunning() {
        return this.running.get();
    }

    @Override
    public void setRawDataReceiver(RawDataChannel messageHandler) {
        if (this.isRunning()) {
            throw new IllegalStateException("message handler cannot be set on running connector");
        }
        this.messageHandler = messageHandler;
    }

    @Override
    public void setEndpointContextMatcher(EndpointContextMatcher endpointContextMatcher) {
        this.endpointContextMatcher = endpointContextMatcher;
    }

    private EndpointContextMatcher getEndpointContextMatcher() {
        return this.endpointContextMatcher;
    }

    private String getEffectiveHandshakeMode(RawData message) {
        String mode = message.getEndpointContext().getString(DtlsEndpointContext.KEY_HANDSHAKE_MODE);
        if (mode == null) {
            mode = this.defaultHandshakeMode;
        }
        return mode;
    }

    public final void setAlertHandler(AlertHandler handler) {
        this.alertHandler = handler;
    }

    private void discardRecord(Record record, Throwable cause) {
        if (this.health != null) {
            this.health.receivingRecord(true);
        }
        byte[] bytes = record.getFragmentBytes();
        if (DROP_LOGGER.isTraceEnabled()) {
            String hexString = StringUtil.byteArray2HexString(bytes, '\u0000', 64);
            DROP_LOGGER.trace("Discarding received {} record (epoch {}, payload: {}) from peer [{}]: ", new Object[]{record.getType(), record.getEpoch(), hexString, StringUtil.toLog(record.getPeerAddress()), cause});
        } else if (DROP_LOGGER.isDebugEnabled()) {
            String hexString = StringUtil.byteArray2HexString(bytes, '\u0000', 16);
            DROP_LOGGER.debug("Discarding received {} record (epoch {}, payload: {}) from peer [{}]: {}", new Object[]{record.getType(), record.getEpoch(), hexString, StringUtil.toLog(record.getPeerAddress()), cause.getMessage()});
        }
    }

    @Override
    public String getProtocol() {
        return "DTLS";
    }

    public String toString() {
        return this.getProtocol() + "-" + StringUtil.toString(this.getAddress());
    }

    static {
        boolean mdc = false;
        try {
            MDC.clear();
            mdc = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        MDC_SUPPORT = mdc;
    }

    private static class ForEachFuture
    implements Future<Void> {
        private final Lock lock = new ReentrantLock();
        private final Condition waitDone = this.lock.newCondition();
        private volatile boolean cancel;
        private volatile boolean done;
        private volatile Exception exception;

        private ForEachFuture() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            boolean cancelled = false;
            this.lock.lock();
            try {
                if (!this.done && !this.cancel) {
                    cancelled = true;
                    this.cancel = true;
                }
            }
            finally {
                this.lock.unlock();
            }
            return cancelled;
        }

        @Override
        public boolean isCancelled() {
            return this.cancel;
        }

        @Override
        public boolean isDone() {
            return this.done;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void get() throws InterruptedException, ExecutionException {
            this.lock.lock();
            try {
                if (!this.done) {
                    this.waitDone.await();
                }
                if (this.exception != null) {
                    throw new ExecutionException(this.exception);
                }
            }
            finally {
                this.lock.unlock();
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            this.lock.lock();
            try {
                if (!this.done) {
                    this.waitDone.await(timeout, unit);
                }
                if (this.exception != null) {
                    throw new ExecutionException(this.exception);
                }
            }
            finally {
                this.lock.unlock();
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void done() {
            this.lock.lock();
            try {
                this.done = true;
                this.waitDone.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void failed(Exception exception) {
            this.lock.lock();
            try {
                this.exception = exception;
                this.done = true;
                this.waitDone.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }

        public boolean isStopped() {
            return this.done || this.cancel;
        }
    }

    protected abstract class Worker
    extends Thread {
        protected Worker(String name) {
            super(NamedThreadFactory.SCANDIUM_THREAD_GROUP, name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                LOGGER.info("Starting worker thread [{}]", (Object)this.getName());
                while (DTLSConnector.this.running.get()) {
                    try {
                        this.doWork();
                    }
                    catch (InterruptedIOException e) {
                        if (DTLSConnector.this.running.get()) {
                            LOGGER.info("Worker thread [{}] IO has been interrupted", (Object)this.getName());
                            continue;
                        }
                        LOGGER.debug("Worker thread [{}] IO has been interrupted", (Object)this.getName());
                    }
                    catch (InterruptedException e) {
                        if (DTLSConnector.this.running.get()) {
                            LOGGER.info("Worker thread [{}] has been interrupted", (Object)this.getName());
                            continue;
                        }
                        LOGGER.debug("Worker thread [{}] has been interrupted", (Object)this.getName());
                    }
                    catch (Exception e) {
                        if (DTLSConnector.this.running.get()) {
                            LOGGER.debug("Exception thrown by worker thread [{}]", (Object)this.getName(), (Object)e);
                            continue;
                        }
                        LOGGER.trace("Exception thrown by worker thread [{}]", (Object)this.getName(), (Object)e);
                    }
                }
            }
            finally {
                if (DTLSConnector.this.running.get()) {
                    LOGGER.info("Worker thread [{}] has terminated", (Object)this.getName());
                } else {
                    LOGGER.debug("Worker thread [{}] has terminated", (Object)this.getName());
                }
            }
        }

        protected abstract void doWork() throws Exception;
    }
}

