/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements.util;

import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import javax.crypto.Cipher;
import org.eclipse.californium.elements.util.Asn1DerDecoder;
import org.eclipse.californium.elements.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JceProviderUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(JceProviderUtil.class);
    private static volatile JceProviderUtil features;
    private static final String NET_I2P_CRYPTO_EDDSA = "net.i2p.crypto.eddsa";
    private static final String NET_I2P_CRYPTO_EDDSA_PROVIDER = "net.i2p.crypto.eddsa.EdDSASecurityProvider";
    private static final String BOUNCY_CASTLE_PROVIDER = "org.bouncycastle.jce.provider.BouncyCastleProvider";
    private static final String CALIFORNIUM_JCE_PROVIDER = "CALIFORNIUM_JCE_PROVIDER";
    private static final String SYSTEM_JCE_PROVIDER = "SYSTEM";
    private static final String BOUNCY_CASTLE_JCE_PROVIDER = "BC";
    private static final String NET_I2P_CRYPTO_JCE_PROVIDER = "I2P";
    private static final String AES = "AES";
    private final boolean useBc;
    private final boolean rsa;
    private final boolean ec;
    private final boolean ed25519;
    private final boolean ed448;
    private final boolean strongEncryption;

    private static boolean isBouncyCastle(Provider provider) {
        return provider != null && provider.getName().equals(BOUNCY_CASTLE_JCE_PROVIDER);
    }

    private static void configureBouncyCastle(Provider provider) {
        if (JceProviderUtil.isBouncyCastle(provider)) {
            JceProviderUtil.configure(provider, "Alg.Alias.KeyFactory.OID.1.3.101.112", "Ed25519");
            JceProviderUtil.configure(provider, "Alg.Alias.KeyFactory.OID.1.3.101.113", "Ed448");
        }
    }

    private static void configure(Provider provider, String key, String value) {
        String current = provider.getProperty(key);
        if (!value.equals(current)) {
            provider.setProperty(key, value);
        }
    }

    private static Provider loadProvider(String clzName) {
        try {
            Class<?> clz = Class.forName(clzName);
            Provider provider = (Provider)clz.getConstructor(new Class[0]).newInstance(new Object[0]);
            LOGGER.info("Loaded {}", (Object)clzName);
            return provider;
        }
        catch (Throwable e) {
            LOGGER.trace("Loading {} failed!", (Object)clzName, (Object)e);
            return null;
        }
    }

    private static void setupJce() {
        Provider newProvider;
        boolean tryJce = true;
        boolean tryBc = false;
        boolean tryEd25519Java = true;
        String jce = StringUtil.getConfiguration(CALIFORNIUM_JCE_PROVIDER);
        if (jce != null && !jce.isEmpty()) {
            LOGGER.info("JCE setup: {}", (Object)jce);
            if (SYSTEM_JCE_PROVIDER.equalsIgnoreCase(jce)) {
                tryBc = false;
                tryEd25519Java = false;
            } else if (BOUNCY_CASTLE_JCE_PROVIDER.equalsIgnoreCase(jce)) {
                tryBc = true;
                tryJce = false;
                tryEd25519Java = false;
            } else if (NET_I2P_CRYPTO_JCE_PROVIDER.equalsIgnoreCase(jce)) {
                tryJce = false;
                tryBc = false;
            }
        }
        boolean found = false;
        Provider provider = null;
        try {
            KeyFactory factory = KeyFactory.getInstance("EdDSA");
            provider = factory.getProvider();
            if (tryJce) {
                found = true;
                LOGGER.trace("EdDSA from default jce {}", (Object)provider.getName());
            }
        }
        catch (NoSuchAlgorithmException factory) {
            // empty catch block
        }
        if (!found && tryBc) {
            if (JceProviderUtil.isBouncyCastle(provider)) {
                found = true;
                LOGGER.trace("EdDSA from BC");
            } else {
                newProvider = JceProviderUtil.loadProvider(BOUNCY_CASTLE_PROVIDER);
                if (newProvider != null) {
                    try {
                        KeyFactory.getInstance("EdDSA", newProvider);
                        Security.removeProvider(newProvider.getName());
                        Security.insertProviderAt(newProvider, 1);
                        provider = newProvider;
                        found = true;
                        LOGGER.trace("EdDSA from BC");
                    }
                    catch (SecurityException securityException) {
                    }
                    catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                        // empty catch block
                    }
                }
            }
        }
        if (!found && tryEd25519Java) {
            if (provider != null && provider.getClass().getName().equals(NET_I2P_CRYPTO_EDDSA_PROVIDER)) {
                found = true;
                LOGGER.trace("EdDSA from {}", (Object)NET_I2P_CRYPTO_EDDSA);
            } else {
                newProvider = JceProviderUtil.loadProvider(NET_I2P_CRYPTO_EDDSA_PROVIDER);
                if (newProvider != null) {
                    try {
                        KeyFactory.getInstance("Ed25519", newProvider);
                        Security.removeProvider(newProvider.getName());
                        Security.addProvider(newProvider);
                        provider = newProvider;
                        found = true;
                        LOGGER.trace("EdDSA from {}", (Object)NET_I2P_CRYPTO_EDDSA);
                    }
                    catch (SecurityException securityException) {
                    }
                    catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                        // empty catch block
                    }
                }
            }
        }
        boolean strongEncryption = false;
        try {
            strongEncryption = Cipher.getMaxAllowedKeyLength(AES) >= 256;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        boolean ec = false;
        boolean rsa = false;
        try {
            KeyFactory.getInstance("RSA");
            rsa = true;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        try {
            KeyFactory.getInstance("EC");
            ec = true;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        LOGGER.debug("RSA: {}, EC: {}, strong encryption: {}", rsa, ec, strongEncryption);
        boolean ed25519 = false;
        boolean ed448 = false;
        if (found && provider != null) {
            JceProviderUtil.configureBouncyCastle(provider);
            try {
                KeyFactory.getInstance("Ed25519");
                ed25519 = true;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
            try {
                KeyFactory.getInstance("Ed448");
                ed448 = true;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
            LOGGER.debug("EdDSA supported by {}, Ed25519: {}, Ed448: {}", provider.getName(), ed25519, ed448);
        } else {
            provider = null;
            LOGGER.debug("EdDSA not supported!");
        }
        JceProviderUtil newSupport = new JceProviderUtil(JceProviderUtil.isBouncyCastle(provider), rsa, ec, ed25519, ed448, strongEncryption);
        if (!newSupport.equals(features)) {
            features = newSupport;
        }
    }

    public static void init() {
    }

    public static boolean usesBouncyCastle() {
        return JceProviderUtil.features.useBc;
    }

    public static boolean hasStrongEncryption() {
        return JceProviderUtil.features.strongEncryption;
    }

    public static boolean isSupported(String algorithm) {
        if ("EC".equalsIgnoreCase(algorithm)) {
            return JceProviderUtil.features.ec;
        }
        if ("RSA".equalsIgnoreCase(algorithm)) {
            return JceProviderUtil.features.rsa;
        }
        String oid = Asn1DerDecoder.getEdDsaStandardAlgorithmName(algorithm, null);
        if ("OID.1.3.101.112".equals(oid)) {
            return JceProviderUtil.features.ed25519;
        }
        if ("OID.1.3.101.113".equals(oid)) {
            return JceProviderUtil.features.ed448;
        }
        if ("EdDSA".equalsIgnoreCase(algorithm)) {
            return JceProviderUtil.features.ed25519 || JceProviderUtil.features.ed448;
        }
        return false;
    }

    private JceProviderUtil(boolean useBc, boolean rsa, boolean ec, boolean ed25519, boolean ed448, boolean strongEncryption) {
        this.useBc = useBc;
        this.rsa = rsa;
        this.ec = ec;
        this.ed25519 = ed25519;
        this.ed448 = ed448;
        this.strongEncryption = strongEncryption;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.ed25519 ? 41 : 37);
        result = 31 * result + (this.ed448 ? 41 : 37);
        result = 31 * result + (this.strongEncryption ? 41 : 37);
        result = 31 * result + (this.ec ? 41 : 37);
        result = 31 * result + (this.rsa ? 41 : 37);
        result = 31 * result + (this.useBc ? 41 : 37);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JceProviderUtil other = (JceProviderUtil)obj;
        if (this.ed25519 != other.ed25519) {
            return false;
        }
        if (this.ed448 != other.ed448) {
            return false;
        }
        if (this.strongEncryption != other.strongEncryption) {
            return false;
        }
        if (this.ec != other.ec) {
            return false;
        }
        if (this.rsa != other.rsa) {
            return false;
        }
        return this.useBc == other.useBc;
    }

    static {
        JceProviderUtil.setupJce();
    }
}

