/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.californium.elements.config.BasicDefinition;
import org.eclipse.californium.elements.config.DefinitionUtils;
import org.eclipse.californium.elements.config.ValueException;

public class EnumListDefinition<E extends Enum<?>>
extends BasicDefinition<List<E>> {
    private final String typeName;
    private final List<E> values;
    private final String valuesDocumentation;

    public EnumListDefinition(String key, String documentation, E[] values) {
        this(key, documentation, null, (Enum[])values);
    }

    public EnumListDefinition(String key, String documentation, List<E> defaultValue, E[] values) {
        super(key, documentation, new ArrayList(), defaultValue);
        if (values == null) {
            throw new NullPointerException("Enum set must not be null!");
        }
        if (values.length == 0) {
            throw new IllegalArgumentException("Enum set must not be empty!");
        }
        for (E in : values) {
            if (in != null) continue;
            throw new IllegalArgumentException("Enum set must not contain null!");
        }
        this.typeName = "List<" + values[0].getClass().getSimpleName() + ">";
        this.values = Arrays.asList(Arrays.copyOf(values, values.length));
        this.valuesDocumentation = DefinitionUtils.toNames(this.values, true);
        if (defaultValue != null) {
            this.isAssignableFrom(defaultValue);
        }
    }

    @Override
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    public String writeValue(List<E> value) {
        return DefinitionUtils.toNames(value, false);
    }

    @Override
    public String getDocumentation() {
        return super.getDocumentation() + "\nList of " + this.valuesDocumentation + ".";
    }

    @Override
    protected boolean isAssignableFrom(Object value) {
        if (value instanceof List) {
            for (Object item : (List)value) {
                if (this.values.contains(item)) continue;
                if (super.isAssignableFrom(item)) {
                    throw new IllegalArgumentException(item + " is not in " + this.valuesDocumentation);
                }
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    protected List<E> parseValue(String value) throws ValueException {
        String[] list = value.split(",");
        ArrayList<E> result = new ArrayList<E>(list.length);
        for (String valueItem : list) {
            E elementitem = DefinitionUtils.toValue(valueItem = valueItem.trim(), this.values);
            if (elementitem == null) {
                throw new ValueException(valueItem + " is not in " + this.valuesDocumentation);
            }
            result.add(elementitem);
        }
        return result;
    }
}

