/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.cbor;

import com.upokecenter.cbor.CBORDataUtilities;
import com.upokecenter.cbor.CBORObject;
import com.upokecenter.cbor.CBORUtilities;
import com.upokecenter.cbor.JSONOptions;
import com.upokecenter.numbers.EContext;
import com.upokecenter.numbers.EDecimal;
import com.upokecenter.numbers.EFloat;
import com.upokecenter.numbers.EInteger;

final class CBORDataUtilitiesByteArrayString {
    private static final long DoubleNegInfinity = -4503599627370496L;
    private static final long DoublePosInfinity = 0x7FF0000000000000L;

    private CBORDataUtilitiesByteArrayString() {
    }

    static CBORObject ParseJSONNumber(byte[] chars, int offset, int count, JSONOptions options, int[] endOfNumber) {
        if (chars == null || chars.length == 0 || count <= 0) {
            return null;
        }
        if (offset < 0 || offset > chars.length) {
            return null;
        }
        if (count > chars.length || chars.length - offset < count) {
            return null;
        }
        JSONOptions opt = options == null ? CBORDataUtilities.DefaultOptions : options;
        boolean preserveNegativeZero = options.getPreserveNegativeZero();
        JSONOptions.ConversionMode kind = options.getNumberConversion();
        int endPos = offset + count;
        int initialOffset = offset++;
        boolean negative = false;
        if (chars[initialOffset] == 45) {
            negative = true;
        }
        int numOffset = offset;
        boolean haveDecimalPoint = false;
        boolean haveDigits = false;
        boolean haveDigitsAfterDecimal = false;
        boolean haveExponent = false;
        int i = offset;
        int decimalPointPos = -1;
        int k = i;
        if (endPos - 1 > k && chars[k] == 48 && chars[k + 1] >= 48 && chars[k + 1] <= 57) {
            if (endOfNumber != null) {
                endOfNumber[0] = k + 2;
            }
            return null;
        }
        while (k < endPos) {
            byte c = chars[k];
            if (c >= 48 && c <= 57) {
                haveDigits = true;
                haveDigitsAfterDecimal |= haveDecimalPoint;
            } else if (c == 46) {
                if (!haveDigits || haveDecimalPoint) {
                    if (endOfNumber != null) {
                        endOfNumber[0] = k;
                    }
                    return null;
                }
                haveDecimalPoint = true;
                decimalPointPos = k;
            } else {
                if (c == 69 || c == 101) {
                    ++k;
                    haveExponent = true;
                    break;
                }
                if (endOfNumber != null) {
                    endOfNumber[0] = k;
                    if (c != 44 && c != 93 && c != 125 && c != 32 && c != 10 && c != 13 && c != 9) {
                        return null;
                    }
                    endPos = k;
                    break;
                }
                return null;
            }
            ++k;
        }
        if (!haveDigits || haveDecimalPoint && !haveDigitsAfterDecimal) {
            if (endOfNumber != null) {
                endOfNumber[0] = k;
            }
            return null;
        }
        int exponentPos = -1;
        boolean negativeExp = false;
        if (haveExponent) {
            haveDigits = false;
            if (k == endPos) {
                if (endOfNumber != null) {
                    endOfNumber[0] = k;
                }
                return null;
            }
            byte c = chars[k];
            if (c == 43) {
                ++k;
            } else if (c == 45) {
                negativeExp = true;
                ++k;
            }
            while (k < endPos) {
                c = chars[k];
                if (c >= 48 && c <= 57) {
                    if (exponentPos < 0 && c != 48) {
                        exponentPos = k;
                    }
                } else {
                    if (endOfNumber != null) {
                        endOfNumber[0] = k;
                        if (c != 44 && c != 93 && c != 125 && c != 32 && c != 10 && c != 13 && c != 9) {
                            return null;
                        }
                        endPos = k;
                        break;
                    }
                    return null;
                }
                haveDigits = true;
                ++k;
            }
            if (!haveDigits) {
                if (endOfNumber != null) {
                    endOfNumber[0] = k;
                }
                return null;
            }
        }
        if (endOfNumber != null) {
            endOfNumber[0] = endPos;
        }
        if (exponentPos >= 0 && endPos - exponentPos > 20) {
            if (negativeExp) {
                if (kind == JSONOptions.ConversionMode.Double || kind == JSONOptions.ConversionMode.IntOrFloat) {
                    if (!negative) {
                        return CBORObject.FromFloatingPointBits(0L, 2);
                    }
                    return CBORObject.FromFloatingPointBits(32768L, 2);
                }
                if (kind == JSONOptions.ConversionMode.IntOrFloatFromDouble) {
                    return CBORObject.FromObject(0);
                }
            } else {
                if (kind == JSONOptions.ConversionMode.Double || kind == JSONOptions.ConversionMode.IntOrFloatFromDouble || kind == JSONOptions.ConversionMode.IntOrFloat) {
                    return CBORObject.FromFloatingPointBits(negative ? -4503599627370496L : 0x7FF0000000000000L, 8);
                }
                if (kind == JSONOptions.ConversionMode.Decimal128) {
                    return CBORObject.FromObject(negative ? EDecimal.NegativeInfinity : EDecimal.PositiveInfinity);
                }
            }
        }
        if (!haveExponent && !haveDecimalPoint && endPos - numOffset <= 16) {
            long v = 0L;
            for (int vi = numOffset; vi < endPos; ++vi) {
                v = v * 10L + (long)(chars[vi] - 48);
            }
            if (!(v == 0L && negative || v >= 0x1FFFFFFFFFFFFFL)) {
                if (negative) {
                    v = -v;
                }
                if (kind == JSONOptions.ConversionMode.Double) {
                    return CBORObject.FromFloatingPointBits(EFloat.FromInt64(v).ToDoubleBits(), 8);
                }
                if (kind == JSONOptions.ConversionMode.Decimal128) {
                    return CBORObject.FromObject(EDecimal.FromInt64(v));
                }
                return CBORObject.FromObject(v);
            }
        }
        if (kind == JSONOptions.ConversionMode.Full) {
            EDecimal ed;
            if (!haveDecimalPoint && !haveExponent) {
                EInteger ei = EInteger.FromSubstring(chars, initialOffset, endPos);
                if (preserveNegativeZero && ei.isZero() && negative) {
                    return CBORObject.FromFloatingPointBits(32768L, 2);
                }
                return CBORObject.FromObject(ei);
            }
            if (!haveExponent && haveDecimalPoint) {
                int vi;
                long lv = 0L;
                int expo = -(endPos - (decimalPointPos + 1));
                int digitCount = 0;
                for (vi = numOffset; vi < decimalPointPos; ++vi) {
                    if (digitCount < 0 || digitCount >= 18) {
                        digitCount = -1;
                        break;
                    }
                    if (digitCount > 0 || chars[vi] != 48) {
                        ++digitCount;
                    }
                    lv = lv * 10L + (long)(chars[vi] - 48);
                }
                for (vi = decimalPointPos + 1; vi < endPos; ++vi) {
                    if (digitCount < 0 || digitCount >= 18) {
                        digitCount = -1;
                        break;
                    }
                    if (digitCount > 0 || chars[vi] != 48) {
                        ++digitCount;
                    }
                    lv = lv * 10L + (long)(chars[vi] - 48);
                }
                if (negative) {
                    lv = -lv;
                }
                if (!(digitCount < 0 || negative && lv == 0L)) {
                    if (expo == 0) {
                        return CBORObject.FromObject(lv);
                    }
                    CBORObject cbor = CBORObject.FromArrayBackedObject(new CBORObject[]{CBORObject.FromObject(expo), CBORObject.FromObject(lv)});
                    return cbor.WithTag(4);
                }
            }
            if ((ed = EDecimal.FromString(chars, initialOffset, endPos - initialOffset)).isZero() && negative) {
                if (ed.getExponent().isZero()) {
                    return preserveNegativeZero ? CBORObject.FromFloatingPointBits(32768L, 2) : CBORObject.FromObject(0);
                }
                if (!preserveNegativeZero) {
                    return CBORObject.FromObject(ed.Negate());
                }
                return CBORObject.FromObject(ed);
            }
            return ed.getExponent().isZero() ? CBORObject.FromObject(ed.getMantissa()) : CBORObject.FromObject(ed);
        }
        if (kind == JSONOptions.ConversionMode.Double) {
            EFloat ef = EFloat.FromString(chars, initialOffset, endPos - initialOffset, EContext.Binary64);
            long lb = ef.ToDoubleBits();
            if (!(preserveNegativeZero || lb != Long.MIN_VALUE && lb != 0L)) {
                lb = 0L;
            }
            return CBORObject.FromFloatingPointBits(lb, 8);
        }
        if (kind == JSONOptions.ConversionMode.Decimal128) {
            EDecimal ed = EDecimal.FromString(chars, initialOffset, endPos - initialOffset, EContext.Decimal128);
            if (!preserveNegativeZero && ed.isNegative() && ed.isZero()) {
                ed = ed.Negate();
            }
            return CBORObject.FromObject(ed);
        }
        if (kind == JSONOptions.ConversionMode.IntOrFloatFromDouble) {
            EFloat ef = EFloat.FromString(chars, initialOffset, endPos - initialOffset, EContext.Binary64);
            long lb = ef.ToDoubleBits();
            return !CBORUtilities.IsBeyondSafeRange(lb) && CBORUtilities.IsIntegerValue(lb) ? CBORObject.FromObject(CBORUtilities.GetIntegerValue(lb)) : CBORObject.FromFloatingPointBits(lb, 8);
        }
        if (kind == JSONOptions.ConversionMode.IntOrFloat) {
            EContext ctx = EContext.Binary64.WithBlankFlags();
            EFloat ef = EFloat.FromString(chars, initialOffset, endPos - initialOffset, ctx);
            long lb = ef.ToDoubleBits();
            if ((ctx.getFlags() & 1) != 0) {
                if (!(preserveNegativeZero || lb != Long.MIN_VALUE && lb != 0L)) {
                    lb = 0L;
                }
                return CBORObject.FromFloatingPointBits(lb, 8);
            }
            return !CBORUtilities.IsBeyondSafeRange(lb) && CBORUtilities.IsIntegerValue(lb) ? CBORObject.FromObject(CBORUtilities.GetIntegerValue(lb)) : CBORObject.FromFloatingPointBits(lb, 8);
        }
        throw new IllegalArgumentException("Unsupported conversion kind.");
    }
}

