/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.config;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.scandium.ConnectionListener;
import org.eclipse.californium.scandium.DtlsHealth;
import org.eclipse.californium.scandium.auth.ApplicationLevelInfoSupplier;
import org.eclipse.californium.scandium.dtls.CertificateType;
import org.eclipse.californium.scandium.dtls.ConnectionIdGenerator;
import org.eclipse.californium.scandium.dtls.ExtendedMasterSecretMode;
import org.eclipse.californium.scandium.dtls.ProtocolVersion;
import org.eclipse.californium.scandium.dtls.SessionStore;
import org.eclipse.californium.scandium.dtls.SignatureAndHashAlgorithm;
import org.eclipse.californium.scandium.dtls.cipher.CipherSuite;
import org.eclipse.californium.scandium.dtls.cipher.CipherSuiteSelector;
import org.eclipse.californium.scandium.dtls.cipher.DefaultCipherSuiteSelector;
import org.eclipse.californium.scandium.dtls.cipher.XECDHECryptography;
import org.eclipse.californium.scandium.dtls.pskstore.AdvancedPskStore;
import org.eclipse.californium.scandium.dtls.resumption.ConnectionStoreResumptionVerifier;
import org.eclipse.californium.scandium.dtls.resumption.ResumptionVerifier;
import org.eclipse.californium.scandium.dtls.x509.CertificateConfigurationHelper;
import org.eclipse.californium.scandium.dtls.x509.CertificateProvider;
import org.eclipse.californium.scandium.dtls.x509.ConfigurationHelperSetup;
import org.eclipse.californium.scandium.dtls.x509.NewAdvancedCertificateVerifier;
import org.eclipse.californium.scandium.util.ListUtils;

public final class DtlsConnectorConfig {
    public static final int DEFAULT_MAX_DEFERRED_PROCESSED_APPLICATION_DATA_MESSAGES = 10;
    public static final int DEFAULT_MAX_CONNECTIONS = 150000;
    public static final int DEFAULT_MAX_FRAGMENTED_HANDSHAKE_MESSAGE_LENGTH = 8192;
    public static final int DEFAULT_MAX_DEFERRED_PROCESSED_INCOMING_RECORDS_SIZE = 8192;
    public static final long DEFAULT_STALE_CONNECTION_TRESHOLD = 1800L;
    public static final int DEFAULT_RETRANSMISSION_TIMEOUT_MS = 2000;
    public static final int RFC6347_RETRANSMISSION_TIMEOUT_MS = 1000;
    public static final int RFC7925_RETRANSMISSION_TIMEOUT_MS = 9000;
    public static final int DEFAULT_MAX_RETRANSMISSION_TIMEOUT_MS = 60000;
    public static final int DEFAULT_ADDITIONAL_TIMEOUT_FOR_ECC_MS = 0;
    public static final int DEFAULT_MAX_RETRANSMISSIONS = 4;
    public static final int DEFAULT_VERIFY_PEERS_ON_RESUMPTION_THRESHOLD_IN_PERCENT = 30;
    public static final int DEFAULT_MAX_TRANSMISSION_UNIT_LIMIT = 1500;
    private static final int DEFAULT_EXECUTOR_THREAD_POOL_SIZE = 6 * Runtime.getRuntime().availableProcessors();
    private static final int DEFAULT_RECEIVER_THREADS = (Runtime.getRuntime().availableProcessors() + 1) / 2;
    private InetSocketAddress address;
    private NewAdvancedCertificateVerifier advancedCertificateVerifier;
    private Boolean earlyStopRetransmission;
    private Boolean enableReuseAddress;
    private Integer recordSizeLimit;
    private Integer maxFragmentLengthCode;
    private Integer maxFragmentedHandshakeMessageLength;
    private Boolean enableMultiRecordMessages;
    private Boolean enableMultiHandshakeMessageRecords;
    private ProtocolVersion protocolVersionForHelloVerifyRequests;
    private Integer retransmissionTimeout;
    private Integer additionalTimeoutForEcc;
    private Integer maxRetransmissionTimeout;
    private Integer backOffRetransmission;
    private Integer maxRetransmissions;
    private Integer maxTransmissionUnit;
    private Integer maxTransmissionUnitLimit;
    private Boolean clientAuthenticationWanted;
    private Boolean clientAuthenticationRequired;
    private Boolean serverOnly;
    private String defaultHandshakeMode;
    private AdvancedPskStore advancedPskStore;
    private CertificateProvider certificateIdentityProvider;
    private CertificateConfigurationHelper certificateConfigurationHelper;
    private CipherSuiteSelector cipherSuiteSelector;
    private List<CipherSuite> preselectedCipherSuites;
    private List<CipherSuite> supportedCipherSuites;
    private List<SignatureAndHashAlgorithm> supportedSignatureAlgorithms;
    private List<XECDHECryptography.SupportedGroup> supportedGroups;
    private Integer outboundMessageBufferSize;
    private Integer maxDeferredProcessedOutgoingApplicationDataMessages;
    private Integer maxDeferredProcessedIncomingRecordsSize;
    private Integer maxConnections;
    private Long staleConnectionThreshold;
    private Integer connectionThreadCount;
    private Integer receiverThreadCount;
    private Integer socketReceiveBufferSize;
    private Integer socketSendBufferSize;
    private Integer healthStatusInterval;
    private Long autoResumptionTimeoutMillis;
    private Boolean sniEnabled;
    private ExtendedMasterSecretMode extendedMasterSecretMode;
    private Integer verifyPeersOnResumptionThreshold;
    private Boolean useHelloVerifyRequestForPsk;
    private Boolean useHelloVerifyRequest;
    private Boolean useServerSessionId;
    private Boolean useAntiReplayFilter;
    private Integer useExtendedWindowFilter;
    private Boolean useCidUpdateAddressOnNewerRecordFilter;
    private String loggingTag;
    private ConnectionIdGenerator connectionIdGenerator;
    private ApplicationLevelInfoSupplier applicationLevelInfoSupplier;
    private Boolean useTruncatedCertificatePathForClientsCertificateMessage;
    private Boolean useTruncatedCertificatePathForValidation;
    private ConnectionListener connectionListener;
    private SessionStore sessionStore;
    private ResumptionVerifier resumptionVerifier;
    private DtlsHealth healthHandler;
    private Boolean clientOnly;
    private Boolean recommendedCipherSuitesOnly;
    private Boolean recommendedSupportedGroupsOnly;
    private Boolean recommendedSignatureAndHashAlgorithmsOnly;

    private DtlsConnectorConfig() {
    }

    public Integer getRecordSizeLimit() {
        return this.recordSizeLimit;
    }

    public Integer getMaxFragmentLengthCode() {
        return this.maxFragmentLengthCode;
    }

    public Integer getMaxFragmentedHandshakeMessageLength() {
        return this.maxFragmentedHandshakeMessageLength;
    }

    public Boolean useMultiRecordMessages() {
        return this.enableMultiRecordMessages;
    }

    public Boolean useMultiHandshakeMessageRecords() {
        return this.enableMultiHandshakeMessageRecords;
    }

    public ProtocolVersion getProtocolVersionForHelloVerifyRequests() {
        return this.protocolVersionForHelloVerifyRequests;
    }

    public Integer getRetransmissionTimeout() {
        return this.retransmissionTimeout;
    }

    public Integer getAdditionalTimeoutForEcc() {
        return this.additionalTimeoutForEcc;
    }

    public Integer getMaxRetransmissionTimeout() {
        return this.maxRetransmissionTimeout;
    }

    public Integer getMaxDeferredProcessedOutgoingApplicationDataMessages() {
        return this.maxDeferredProcessedOutgoingApplicationDataMessages;
    }

    public Integer getMaxDeferredProcessedIncomingRecordsSize() {
        return this.maxDeferredProcessedIncomingRecordsSize;
    }

    public Integer getBackOffRetransmission() {
        return this.backOffRetransmission;
    }

    public Integer getMaxRetransmissions() {
        return this.maxRetransmissions;
    }

    public Integer getMaxTransmissionUnit() {
        return this.maxTransmissionUnit;
    }

    public Integer getMaxTransmissionUnitLimit() {
        return this.maxTransmissionUnitLimit;
    }

    public Boolean isEarlyStopRetransmission() {
        return this.earlyStopRetransmission;
    }

    public Boolean isAddressReuseEnabled() {
        return this.enableReuseAddress;
    }

    public Boolean isSniEnabled() {
        return this.sniEnabled;
    }

    public ExtendedMasterSecretMode getExtendedMasterSecretMode() {
        return this.extendedMasterSecretMode;
    }

    public Integer getVerifyPeersOnResumptionThreshold() {
        return this.verifyPeersOnResumptionThreshold;
    }

    public Boolean useHelloVerifyRequestForPsk() {
        return this.useHelloVerifyRequestForPsk;
    }

    public Boolean useHelloVerifyRequest() {
        return this.useHelloVerifyRequest;
    }

    public ConnectionIdGenerator getConnectionIdGenerator() {
        return this.connectionIdGenerator;
    }

    public Integer getOutboundMessageBufferSize() {
        return this.outboundMessageBufferSize;
    }

    public InetSocketAddress getAddress() {
        return this.address;
    }

    public CertificateProvider getCertificateIdentityProvider() {
        return this.certificateIdentityProvider;
    }

    public CipherSuiteSelector getCipherSuiteSelector() {
        return this.cipherSuiteSelector;
    }

    public List<CipherSuite> getPreselectedCipherSuites() {
        return this.preselectedCipherSuites;
    }

    public List<CipherSuite> getSupportedCipherSuites() {
        return this.supportedCipherSuites;
    }

    public List<SignatureAndHashAlgorithm> getSupportedSignatureAlgorithms() {
        return this.supportedSignatureAlgorithms;
    }

    public List<XECDHECryptography.SupportedGroup> getSupportedGroups() {
        return this.supportedGroups;
    }

    public AdvancedPskStore getAdvancedPskStore() {
        return this.advancedPskStore;
    }

    public NewAdvancedCertificateVerifier getAdvancedCertificateVerifier() {
        return this.advancedCertificateVerifier;
    }

    public ApplicationLevelInfoSupplier getApplicationLevelInfoSupplier() {
        return this.applicationLevelInfoSupplier;
    }

    public Boolean isClientAuthenticationWanted() {
        return this.clientAuthenticationWanted;
    }

    public Boolean isClientAuthenticationRequired() {
        return this.clientAuthenticationRequired;
    }

    public Boolean isServerOnly() {
        return this.serverOnly;
    }

    public String getDefaultHandshakeMode() {
        return this.defaultHandshakeMode;
    }

    public List<CertificateType> getIdentityCertificateTypes() {
        if (this.certificateIdentityProvider == null) {
            return null;
        }
        return this.certificateIdentityProvider.getSupportedCertificateTypes();
    }

    public List<CertificateType> getTrustCertificateTypes() {
        if (this.advancedCertificateVerifier == null) {
            return null;
        }
        return this.advancedCertificateVerifier.getSupportedCertificateTypes();
    }

    public Integer getMaxConnections() {
        return this.maxConnections;
    }

    public Long getStaleConnectionThreshold() {
        return this.staleConnectionThreshold;
    }

    public Integer getConnectionThreadCount() {
        return this.connectionThreadCount;
    }

    public Integer getReceiverThreadCount() {
        return this.receiverThreadCount;
    }

    public Integer getSocketReceiveBufferSize() {
        return this.socketReceiveBufferSize;
    }

    public Integer getSocketSendBufferSize() {
        return this.socketSendBufferSize;
    }

    public Long getAutoResumptionTimeoutMillis() {
        return this.autoResumptionTimeoutMillis;
    }

    public Boolean useServerSessionId() {
        return this.useServerSessionId;
    }

    public Boolean useAntiReplayFilter() {
        return this.useAntiReplayFilter;
    }

    public Integer useExtendedWindowFilter() {
        return this.useExtendedWindowFilter;
    }

    public Boolean useCidUpdateAddressOnNewerRecordFilter() {
        return this.useCidUpdateAddressOnNewerRecordFilter;
    }

    public Boolean useTruncatedCertificatePathForClientsCertificateMessage() {
        return this.useTruncatedCertificatePathForClientsCertificateMessage;
    }

    public Boolean useTruncatedCertificatePathForValidation() {
        return this.useTruncatedCertificatePathForValidation;
    }

    public ConnectionListener getConnectionListener() {
        return this.connectionListener;
    }

    public SessionStore getSessionStore() {
        return this.sessionStore;
    }

    public ResumptionVerifier getResumptionVerifier() {
        return this.resumptionVerifier;
    }

    public String getLoggingTag() {
        return this.loggingTag;
    }

    public Integer getHealthStatusInterval() {
        return this.healthStatusInterval;
    }

    public DtlsHealth getHealthHandler() {
        return this.healthHandler;
    }

    public Boolean isClientOnly() {
        return this.clientOnly;
    }

    public Boolean isRecommendedCipherSuitesOnly() {
        return this.recommendedCipherSuitesOnly;
    }

    public Boolean isRecommendedSupportedGroupsOnly() {
        return this.recommendedSupportedGroupsOnly;
    }

    public Boolean isRecommendedSignatureAndHashAlgorithmsOnly() {
        return this.recommendedSignatureAndHashAlgorithmsOnly;
    }

    protected Object clone() {
        DtlsConnectorConfig cloned = new DtlsConnectorConfig();
        cloned.address = this.address;
        cloned.advancedCertificateVerifier = this.advancedCertificateVerifier;
        cloned.earlyStopRetransmission = this.earlyStopRetransmission;
        cloned.enableReuseAddress = this.enableReuseAddress;
        cloned.recordSizeLimit = this.recordSizeLimit;
        cloned.maxFragmentLengthCode = this.maxFragmentLengthCode;
        cloned.maxFragmentedHandshakeMessageLength = this.maxFragmentedHandshakeMessageLength;
        cloned.enableMultiRecordMessages = this.enableMultiRecordMessages;
        cloned.enableMultiHandshakeMessageRecords = this.enableMultiHandshakeMessageRecords;
        cloned.protocolVersionForHelloVerifyRequests = this.protocolVersionForHelloVerifyRequests;
        cloned.retransmissionTimeout = this.retransmissionTimeout;
        cloned.additionalTimeoutForEcc = this.additionalTimeoutForEcc;
        cloned.maxRetransmissionTimeout = this.maxRetransmissionTimeout;
        cloned.maxRetransmissions = this.maxRetransmissions;
        cloned.maxTransmissionUnit = this.maxTransmissionUnit;
        cloned.maxTransmissionUnitLimit = this.maxTransmissionUnitLimit;
        cloned.clientAuthenticationRequired = this.clientAuthenticationRequired;
        cloned.clientAuthenticationWanted = this.clientAuthenticationWanted;
        cloned.serverOnly = this.serverOnly;
        cloned.defaultHandshakeMode = this.defaultHandshakeMode;
        cloned.advancedPskStore = this.advancedPskStore;
        cloned.certificateIdentityProvider = this.certificateIdentityProvider;
        cloned.certificateConfigurationHelper = this.certificateConfigurationHelper;
        cloned.cipherSuiteSelector = this.cipherSuiteSelector;
        cloned.preselectedCipherSuites = this.preselectedCipherSuites;
        cloned.supportedCipherSuites = this.supportedCipherSuites;
        cloned.supportedSignatureAlgorithms = this.supportedSignatureAlgorithms;
        cloned.supportedGroups = this.supportedGroups;
        cloned.outboundMessageBufferSize = this.outboundMessageBufferSize;
        cloned.maxDeferredProcessedOutgoingApplicationDataMessages = this.maxDeferredProcessedOutgoingApplicationDataMessages;
        cloned.maxDeferredProcessedIncomingRecordsSize = this.maxDeferredProcessedIncomingRecordsSize;
        cloned.maxConnections = this.maxConnections;
        cloned.staleConnectionThreshold = this.staleConnectionThreshold;
        cloned.connectionThreadCount = this.connectionThreadCount;
        cloned.receiverThreadCount = this.receiverThreadCount;
        cloned.socketReceiveBufferSize = this.socketReceiveBufferSize;
        cloned.socketSendBufferSize = this.socketSendBufferSize;
        cloned.healthStatusInterval = this.healthStatusInterval;
        cloned.autoResumptionTimeoutMillis = this.autoResumptionTimeoutMillis;
        cloned.sniEnabled = this.sniEnabled;
        cloned.extendedMasterSecretMode = this.extendedMasterSecretMode;
        cloned.verifyPeersOnResumptionThreshold = this.verifyPeersOnResumptionThreshold;
        cloned.useHelloVerifyRequestForPsk = this.useHelloVerifyRequestForPsk;
        cloned.useHelloVerifyRequest = this.useHelloVerifyRequest;
        cloned.useServerSessionId = this.useServerSessionId;
        cloned.loggingTag = this.loggingTag;
        cloned.useAntiReplayFilter = this.useAntiReplayFilter;
        cloned.useExtendedWindowFilter = this.useExtendedWindowFilter;
        cloned.useCidUpdateAddressOnNewerRecordFilter = this.useCidUpdateAddressOnNewerRecordFilter;
        cloned.connectionIdGenerator = this.connectionIdGenerator;
        cloned.applicationLevelInfoSupplier = this.applicationLevelInfoSupplier;
        cloned.useTruncatedCertificatePathForClientsCertificateMessage = this.useTruncatedCertificatePathForClientsCertificateMessage;
        cloned.useTruncatedCertificatePathForValidation = this.useTruncatedCertificatePathForValidation;
        cloned.connectionListener = this.connectionListener;
        cloned.sessionStore = this.sessionStore;
        cloned.resumptionVerifier = this.resumptionVerifier;
        cloned.healthHandler = this.healthHandler;
        cloned.clientOnly = this.clientOnly;
        cloned.recommendedCipherSuitesOnly = this.recommendedCipherSuitesOnly;
        cloned.recommendedSupportedGroupsOnly = this.recommendedSupportedGroupsOnly;
        return cloned;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(DtlsConnectorConfig config) {
        return new Builder(config);
    }

    public static final class Builder {
        private DtlsConnectorConfig config;

        public Builder() {
            this.config = new DtlsConnectorConfig();
        }

        public Builder(DtlsConnectorConfig initialConfiguration) {
            this.config = (DtlsConnectorConfig)initialConfiguration.clone();
        }

        public Builder setAddress(InetSocketAddress address) {
            if (address.isUnresolved()) {
                throw new IllegalArgumentException("Bind address must not be unresolved");
            }
            this.config.address = address;
            return this;
        }

        public Builder setEnableAddressReuse(boolean enable) {
            this.config.enableReuseAddress = enable;
            return this;
        }

        public Builder setRecommendedCipherSuitesOnly(boolean recommendedCipherSuitesOnly) {
            this.config.recommendedCipherSuitesOnly = recommendedCipherSuitesOnly;
            if (recommendedCipherSuitesOnly && this.config.supportedCipherSuites != null) {
                this.verifyRecommendedCipherSuitesOnly(this.config.supportedCipherSuites);
            }
            return this;
        }

        public Builder setRecommendedSupportedGroupsOnly(boolean recommendedSupportedGroupsOnly) {
            this.config.recommendedSupportedGroupsOnly = recommendedSupportedGroupsOnly;
            if (recommendedSupportedGroupsOnly && this.config.supportedGroups != null) {
                this.verifyRecommendedSupportedGroupsOnly(this.config.supportedGroups);
            }
            return this;
        }

        public Builder setRecommendedSignatureAndHashAlgorithmsOnly(boolean recommendedSignatureAndHashAlgorithmsOnly) {
            this.config.recommendedSignatureAndHashAlgorithmsOnly = recommendedSignatureAndHashAlgorithmsOnly;
            if (recommendedSignatureAndHashAlgorithmsOnly && this.config.supportedSignatureAlgorithms != null) {
                this.verifyRecommendedSignatureAndHashAlgorithmsOnly(this.config.supportedSignatureAlgorithms);
            }
            return this;
        }

        public Builder setClientOnly() {
            if (Boolean.TRUE.equals(this.config.serverOnly)) {
                throw new IllegalStateException("client only is in contradiction to server only!");
            }
            if (this.config.clientAuthenticationRequired != null || this.config.clientAuthenticationWanted != null) {
                throw new IllegalStateException("client only is in contradiction to server side client authentication!");
            }
            if (Boolean.FALSE.equals(this.config.useServerSessionId)) {
                throw new IllegalStateException("client only is in contradiction to server side 'server session id'!");
            }
            if (Boolean.FALSE.equals(this.config.useHelloVerifyRequestForPsk)) {
                throw new IllegalStateException("client only is in contradiction to server side HELLO_VERIFY_REQUEST for PSK configuration!");
            }
            if (Boolean.FALSE.equals(this.config.useHelloVerifyRequest)) {
                throw new IllegalStateException("client only is in contradiction to server side HELLO_VERIFY_REQUEST configuration!");
            }
            this.config.clientOnly = true;
            return this;
        }

        public Builder setServerOnly(boolean enable) {
            if (enable) {
                if (Boolean.TRUE.equals(this.config.clientOnly)) {
                    throw new IllegalStateException("server only is in contradiction to client only!");
                }
                if (this.config.defaultHandshakeMode != null && !this.config.defaultHandshakeMode.equals("none")) {
                    throw new IllegalStateException("server only is in contradiction to default handshake mode '" + this.config.defaultHandshakeMode + "!");
                }
            }
            this.config.serverOnly = enable;
            return this;
        }

        public Builder setDefaultHandshakeMode(String defaultHandshakeMode) {
            if (defaultHandshakeMode != null && !defaultHandshakeMode.equals("auto") && !defaultHandshakeMode.equals("none")) {
                throw new IllegalArgumentException("default handshake mode must be either \"auto\" or \"none\"!");
            }
            if (this.config.serverOnly != null && this.config.serverOnly.booleanValue() && defaultHandshakeMode != null && !defaultHandshakeMode.equals("none")) {
                throw new IllegalStateException("default handshake modes are not supported for server only!");
            }
            this.config.defaultHandshakeMode = defaultHandshakeMode;
            return this;
        }

        public Builder setRecordSizeLimit(Integer recordSizeLimit) {
            if (recordSizeLimit != null && (recordSizeLimit < 64 || recordSizeLimit > 65535)) {
                throw new IllegalArgumentException("Record size limit must be within [64...65535], not " + recordSizeLimit + "!");
            }
            this.config.recordSizeLimit = recordSizeLimit;
            return this;
        }

        public Builder setMaxFragmentLengthCode(Integer lengthCode) {
            if (lengthCode != null && (lengthCode < 1 || lengthCode > 4)) {
                throw new IllegalArgumentException("Maximum fragment length code must be one of {1, 2, 3, 4}");
            }
            this.config.maxFragmentLengthCode = lengthCode;
            return this;
        }

        public Builder setMaxFragmentedHandshakeMessageLength(Integer length) {
            this.config.maxFragmentedHandshakeMessageLength = length;
            return this;
        }

        public Builder setEnableMultiRecordMessages(boolean enable) {
            this.config.enableMultiRecordMessages = enable;
            return this;
        }

        public Builder setEnableMultiHandshakeMessageRecords(boolean enable) {
            this.config.enableMultiHandshakeMessageRecords = enable;
            return this;
        }

        public Builder setProtocolVersionForHelloVerifyRequests(ProtocolVersion protocolVersion) {
            this.config.protocolVersionForHelloVerifyRequests = protocolVersion;
            return this;
        }

        public Builder setSocketReceiveBufferSize(Integer size) {
            this.config.socketReceiveBufferSize = size;
            return this;
        }

        public Builder setSocketSendBufferSize(Integer size) {
            this.config.socketSendBufferSize = size;
            return this;
        }

        public Builder setHealthStatusInterval(Integer healthStatusIntervalSeconds) {
            this.config.healthStatusInterval = healthStatusIntervalSeconds;
            return this;
        }

        public Builder setHealthHandler(DtlsHealth healthHandler) {
            this.config.healthHandler = healthHandler;
            return this;
        }

        public Builder setOutboundMessageBufferSize(int capacity) {
            if (capacity < 1) {
                throw new IllegalArgumentException("Outbound message buffer size must be at least 1");
            }
            this.config.outboundMessageBufferSize = capacity;
            return this;
        }

        public Builder setBackOffRetransmission(Integer count) {
            if (count != null && count < 0) {
                throw new IllegalArgumentException("number of retransmissions to back-off must not be negative");
            }
            this.config.backOffRetransmission = count;
            return this;
        }

        public Builder setMaxRetransmissions(int count) {
            if (count < 1) {
                throw new IllegalArgumentException("Maximum number of retransmissions must be greater than zero");
            }
            this.config.maxRetransmissions = count;
            return this;
        }

        public Builder setMaxTransmissionUnit(int mtu) {
            if (this.config.maxTransmissionUnitLimit != null) {
                throw new IllegalArgumentException("MTU limit already set!");
            }
            this.config.maxTransmissionUnit = mtu;
            return this;
        }

        public Builder setMaxTransmissionUnitLimit(int limit) {
            if (this.config.maxTransmissionUnit != null) {
                throw new IllegalArgumentException("MTU already set!");
            }
            this.config.maxTransmissionUnitLimit = limit;
            return this;
        }

        public Builder setClientAuthenticationWanted(boolean authWanted) {
            if (Boolean.TRUE.equals(this.config.clientOnly)) {
                throw new IllegalStateException("client authentication is not supported for client only!");
            }
            if (authWanted && Boolean.TRUE.equals(this.config.clientAuthenticationRequired)) {
                throw new IllegalArgumentException("client authentication is already required!");
            }
            this.config.clientAuthenticationWanted = authWanted;
            return this;
        }

        public Builder setClientAuthenticationRequired(boolean authRequired) {
            if (Boolean.TRUE.equals(this.config.clientOnly)) {
                throw new IllegalStateException("client authentication is not supported for client only!");
            }
            if (authRequired && Boolean.TRUE.equals(this.config.clientAuthenticationWanted)) {
                throw new IllegalArgumentException("client authentication is already wanted!");
            }
            this.config.clientAuthenticationRequired = authRequired;
            return this;
        }

        public Builder setCipherSuiteSelector(CipherSuiteSelector cipherSuiteSelector) {
            this.config.cipherSuiteSelector = cipherSuiteSelector;
            return this;
        }

        public Builder setPreselectedCipherSuites(CipherSuite ... cipherSuites) {
            if (cipherSuites == null) {
                this.config.preselectedCipherSuites = null;
                return this;
            }
            return this.setPreselectedCipherSuites(Arrays.asList(cipherSuites));
        }

        public Builder setPreselectedCipherSuites(List<CipherSuite> cipherSuites) {
            if (cipherSuites == null) {
                this.config.preselectedCipherSuites = null;
            } else {
                if (cipherSuites.isEmpty()) {
                    throw new IllegalArgumentException("Connector must preselect at least one cipher suite");
                }
                if (cipherSuites.contains((Object)CipherSuite.TLS_NULL_WITH_NULL_NULL)) {
                    throw new IllegalArgumentException("NULL Cipher Suite is not supported by connector");
                }
                if (Boolean.FALSE.equals(this.config.useHelloVerifyRequestForPsk) && !CipherSuite.containsPskBasedCipherSuite(cipherSuites)) {
                    throw new IllegalArgumentException("HELLO_VERIFY_REQUEST disabled, requires at least on PSK cipher suite!");
                }
            }
            this.config.preselectedCipherSuites = cipherSuites;
            return this;
        }

        public Builder setPreselectedCipherSuites(String ... cipherSuites) {
            if (cipherSuites == null) {
                this.config.preselectedCipherSuites = null;
                return this;
            }
            List<CipherSuite> suites = CipherSuite.getTypesByNames(cipherSuites);
            return this.setPreselectedCipherSuites(suites);
        }

        public Builder setSupportedCipherSuites(CipherSuite ... cipherSuites) {
            if (cipherSuites == null) {
                throw new NullPointerException("Connector must support at least one cipher suite");
            }
            return this.setSupportedCipherSuites(Arrays.asList(cipherSuites));
        }

        public Builder setSupportedCipherSuites(List<CipherSuite> cipherSuites) {
            if (cipherSuites == null) {
                throw new NullPointerException("Connector must support at least one cipher suite");
            }
            if (cipherSuites.isEmpty()) {
                throw new IllegalArgumentException("Connector must support at least one cipher suite");
            }
            if (cipherSuites.contains((Object)CipherSuite.TLS_NULL_WITH_NULL_NULL)) {
                throw new IllegalArgumentException("NULL Cipher Suite is not supported by connector");
            }
            if (Boolean.FALSE.equals(this.config.useHelloVerifyRequestForPsk) && !CipherSuite.containsPskBasedCipherSuite(cipherSuites)) {
                throw new IllegalArgumentException("HELLO_VERIFY_REQUEST disabled, requires at least on PSK cipher suite!");
            }
            if (this.config.recommendedCipherSuitesOnly == null || this.config.recommendedCipherSuitesOnly.booleanValue()) {
                this.verifyRecommendedCipherSuitesOnly(cipherSuites);
            }
            for (CipherSuite cipherSuite : cipherSuites) {
                if (cipherSuite.isSupported()) continue;
                throw new IllegalArgumentException("cipher-suites " + (Object)((Object)cipherSuite) + " is not supported by JVM!");
            }
            this.config.supportedCipherSuites = cipherSuites;
            return this;
        }

        public Builder setSupportedCipherSuites(String ... cipherSuites) {
            if (cipherSuites == null) {
                throw new NullPointerException("Connector must support at least one cipher suite");
            }
            List<CipherSuite> suites = CipherSuite.getTypesByNames(cipherSuites);
            return this.setSupportedCipherSuites(suites);
        }

        public Builder setSupportedSignatureAlgorithms(SignatureAndHashAlgorithm ... supportedSignatureAlgorithms) {
            if (supportedSignatureAlgorithms == null) {
                this.config.supportedSignatureAlgorithms = null;
                return this;
            }
            return this.setSupportedSignatureAlgorithms(Arrays.asList(supportedSignatureAlgorithms));
        }

        public Builder setSupportedSignatureAlgorithms(List<SignatureAndHashAlgorithm> supportedSignatureAlgorithms) {
            if (supportedSignatureAlgorithms != null && (this.config.recommendedSignatureAndHashAlgorithmsOnly == null || this.config.recommendedSignatureAndHashAlgorithmsOnly.booleanValue())) {
                this.verifyRecommendedSignatureAndHashAlgorithmsOnly(supportedSignatureAlgorithms);
            }
            this.config.supportedSignatureAlgorithms = supportedSignatureAlgorithms;
            return this;
        }

        public Builder setSupportedSignatureAlgorithms(String ... supportedSignatureAlgorithms) {
            ArrayList<SignatureAndHashAlgorithm> list = null;
            if (supportedSignatureAlgorithms != null) {
                list = new ArrayList<SignatureAndHashAlgorithm>(supportedSignatureAlgorithms.length);
                for (int i = 0; i < supportedSignatureAlgorithms.length; ++i) {
                    SignatureAndHashAlgorithm signatureAndHashAlgorithm = SignatureAndHashAlgorithm.valueOf(supportedSignatureAlgorithms[i]);
                    if (signatureAndHashAlgorithm == null) {
                        throw new IllegalArgumentException(String.format("Signature and hash algorithm [%s] is not (yet) supported", supportedSignatureAlgorithms[i]));
                    }
                    list.add(signatureAndHashAlgorithm);
                }
            }
            return this.setSupportedSignatureAlgorithms(list);
        }

        public Builder setSupportedGroups(XECDHECryptography.SupportedGroup ... supportedGroups) {
            if (supportedGroups == null) {
                throw new NullPointerException("Connector must support at least one group (curve)");
            }
            return this.setSupportedGroups(Arrays.asList(supportedGroups));
        }

        public Builder setSupportedGroups(List<XECDHECryptography.SupportedGroup> supportedGroups) {
            if (supportedGroups == null) {
                throw new NullPointerException("Connector must support at least one group (curve)");
            }
            if (supportedGroups.isEmpty()) {
                throw new IllegalArgumentException("Connector must support at least one group (curve)");
            }
            if (this.config.recommendedSupportedGroupsOnly == null || this.config.recommendedSupportedGroupsOnly.booleanValue()) {
                this.verifyRecommendedSupportedGroupsOnly(supportedGroups);
            }
            for (XECDHECryptography.SupportedGroup group : supportedGroups) {
                if (group.isUsable()) continue;
                throw new IllegalArgumentException("curve " + group.name() + " is not supported by JVM!");
            }
            this.config.supportedGroups = supportedGroups;
            return this;
        }

        public Builder setSupportedGroups(String ... supportedGroups) {
            if (supportedGroups == null) {
                throw new NullPointerException("Connector must support at least one supported group (curve)");
            }
            ArrayList<XECDHECryptography.SupportedGroup> groups = new ArrayList<XECDHECryptography.SupportedGroup>(supportedGroups.length);
            for (int i = 0; i < supportedGroups.length; ++i) {
                XECDHECryptography.SupportedGroup knownGroup = XECDHECryptography.SupportedGroup.valueOf(supportedGroups[i]);
                if (knownGroup == null) {
                    throw new IllegalArgumentException(String.format("Group (curve) [%s] is not (yet) supported", supportedGroups[i]));
                }
                groups.add(knownGroup);
            }
            return this.setSupportedGroups(groups);
        }

        public Builder setEarlyStopRetransmission(boolean activate) {
            this.config.earlyStopRetransmission = activate;
            return this;
        }

        public Builder setRetransmissionTimeout(int timeout) {
            if (timeout < 0) {
                throw new IllegalArgumentException("Retransmission timeout must not be negative");
            }
            if (this.config.maxRetransmissionTimeout != null && this.config.maxRetransmissionTimeout < timeout) {
                throw new IllegalArgumentException("Retransmission timeout must not be more than the provided maximum of " + this.config.maxRetransmissionTimeout);
            }
            this.config.retransmissionTimeout = timeout;
            return this;
        }

        public Builder setMaxRetransmissionTimeout(int maxTimeout) {
            if (maxTimeout < 0) {
                throw new IllegalArgumentException("Maximum retransmission timeout must not be negative");
            }
            if (this.config.retransmissionTimeout != null && this.config.retransmissionTimeout > maxTimeout) {
                throw new IllegalArgumentException("Maximum retransmission timeout must not be less than the provided initial value of " + this.config.retransmissionTimeout);
            }
            this.config.maxRetransmissionTimeout = maxTimeout;
            return this;
        }

        public Builder setAdditionalTimeoutForEcc(int timeout) {
            if (timeout < 0) {
                throw new IllegalArgumentException("Additional timeout for ECC must not be negative");
            }
            this.config.additionalTimeoutForEcc = timeout;
            return this;
        }

        public Builder setAdvancedPskStore(AdvancedPskStore advancedPskStore) {
            this.config.advancedPskStore = advancedPskStore;
            return this;
        }

        public Builder setCertificateIdentityProvider(CertificateProvider certificateIdentityProvider) {
            this.config.certificateIdentityProvider = certificateIdentityProvider;
            return this;
        }

        public Builder setAdvancedCertificateVerifier(NewAdvancedCertificateVerifier verifier) {
            if (verifier == null) {
                throw new NullPointerException("CertificateVerifier must not be null");
            }
            this.config.advancedCertificateVerifier = verifier;
            return this;
        }

        public Builder setApplicationLevelInfoSupplier(ApplicationLevelInfoSupplier supplier) {
            if (supplier == null) {
                throw new NullPointerException("Supplier must not be null");
            }
            this.config.applicationLevelInfoSupplier = supplier;
            return this;
        }

        public Builder setMaxDeferredProcessedOutgoingApplicationDataMessages(int maxDeferredProcessedOutgoingApplicationDataMessages) {
            if (maxDeferredProcessedOutgoingApplicationDataMessages < 0) {
                throw new IllegalArgumentException("Max deferred processed outging application data messages must not be negative!");
            }
            this.config.maxDeferredProcessedOutgoingApplicationDataMessages = maxDeferredProcessedOutgoingApplicationDataMessages;
            return this;
        }

        public Builder setMaxDeferredProcessedIncomingRecordsSize(int maxDeferredProcessedIncomingRecordsSize) {
            if (maxDeferredProcessedIncomingRecordsSize < 0) {
                throw new IllegalArgumentException("Max deferred processed incoming records size must not be negative!");
            }
            this.config.maxDeferredProcessedIncomingRecordsSize = maxDeferredProcessedIncomingRecordsSize;
            return this;
        }

        public Builder setMaxConnections(int maxConnections) {
            if (maxConnections < 1) {
                throw new IllegalArgumentException("Max connections must be at least 1");
            }
            this.config.maxConnections = maxConnections;
            return this;
        }

        public Builder setStaleConnectionThreshold(long threshold) {
            if (threshold < 1L) {
                throw new IllegalArgumentException("Threshold must be at least 1 second");
            }
            this.config.staleConnectionThreshold = threshold;
            return this;
        }

        public Builder setConnectionIdGenerator(ConnectionIdGenerator connectionIdGenerator) {
            this.config.connectionIdGenerator = connectionIdGenerator;
            return this;
        }

        public Builder setConnectionThreadCount(int threadCount) {
            this.config.connectionThreadCount = threadCount;
            return this;
        }

        public Builder setReceiverThreadCount(int threadCount) {
            this.config.receiverThreadCount = threadCount;
            return this;
        }

        public Builder setAutoResumptionTimeoutMillis(Long timeoutInMillis) {
            if (timeoutInMillis != null && timeoutInMillis < 1L) {
                throw new IllegalArgumentException("auto resumption timeout must not below 1!");
            }
            this.config.autoResumptionTimeoutMillis = timeoutInMillis;
            return this;
        }

        public Builder setSniEnabled(boolean flag) {
            this.config.sniEnabled = flag;
            return this;
        }

        public Builder setExtendedMasterSecretMode(ExtendedMasterSecretMode mode) {
            this.config.extendedMasterSecretMode = mode;
            return this;
        }

        public Builder setVerifyPeersOnResumptionThreshold(int threshold) {
            if (Boolean.FALSE.equals(this.config.useHelloVerifyRequest)) {
                throw new IllegalStateException("HELLO_VERIFY_REQUEST is already disabled!");
            }
            if (threshold < 0 || threshold > 100) {
                throw new IllegalArgumentException("threshold must be between 0 and 100, but is " + threshold + "!");
            }
            this.config.verifyPeersOnResumptionThreshold = threshold;
            return this;
        }

        public Builder setUseHelloVerifyRequestForPsk(boolean enable) {
            if (Boolean.TRUE.equals(this.config.clientOnly)) {
                throw new IllegalStateException("HELLO_VERIFY_REQUEST usage is not supported for client only!");
            }
            if (Boolean.FALSE.equals(this.config.useHelloVerifyRequest) && enable) {
                throw new IllegalStateException("HELLO_VERIFY_REQUEST is generally disabled!");
            }
            if (!enable && this.config.supportedCipherSuites != null && !CipherSuite.containsPskBasedCipherSuite(this.config.supportedCipherSuites)) {
                throw new IllegalArgumentException("No PSK cipher suite selected, HELLO_VERIFY_REQUEST can not be disabled!");
            }
            this.config.useHelloVerifyRequestForPsk = enable;
            return this;
        }

        public Builder setUseHelloVerifyRequest(boolean enable) {
            if (Boolean.TRUE.equals(this.config.clientOnly)) {
                throw new IllegalStateException("HELLO_VERIFY_REQUEST usage is not supported for client only!");
            }
            if (!enable) {
                if (Boolean.TRUE.equals(this.config.useHelloVerifyRequestForPsk)) {
                    throw new IllegalStateException("HELLO_VERIFY_REQUEST is enabled for PSK!");
                }
                if (this.config.verifyPeersOnResumptionThreshold != null) {
                    throw new IllegalArgumentException("Verify peers on resumption threshold is already set!");
                }
            }
            this.config.useHelloVerifyRequest = enable;
            return this;
        }

        public Builder setUseServerSessionId(boolean flag) {
            if (Boolean.TRUE.equals(this.config.clientOnly) && !flag) {
                throw new IllegalArgumentException("not applicable for client only!");
            }
            this.config.useServerSessionId = flag;
            return this;
        }

        public Builder setUseAntiReplayFilter(boolean enable) {
            if (enable && this.config.useExtendedWindowFilter != null && this.config.useExtendedWindowFilter != 0) {
                throw new IllegalArgumentException("Window filter is active!");
            }
            this.config.useAntiReplayFilter = enable;
            return this;
        }

        public Builder setUseExtendedWindowFilter(int level) {
            if (level != 0 && Boolean.TRUE.equals(this.config.useAntiReplayFilter)) {
                throw new IllegalArgumentException("Anti replay filter is active!");
            }
            this.config.useExtendedWindowFilter = level;
            return this;
        }

        public Builder setCidUpdateAddressOnNewerRecordFilter(boolean enable) {
            this.config.useCidUpdateAddressOnNewerRecordFilter = enable;
            return this;
        }

        public Builder setUseTruncatedCertificatePathForClientsCertificateMessage(boolean enable) {
            this.config.useTruncatedCertificatePathForClientsCertificateMessage = enable;
            return this;
        }

        public Builder setUseTruncatedCertificatePathForValidation(boolean enable) {
            this.config.useTruncatedCertificatePathForValidation = enable;
            return this;
        }

        public Builder setLoggingTag(String tag) {
            this.config.loggingTag = tag;
            return this;
        }

        public Builder setConnectionListener(ConnectionListener connectionListener) {
            this.config.connectionListener = connectionListener;
            return this;
        }

        public Builder setSessionStore(SessionStore sessionStore) {
            this.config.sessionStore = sessionStore;
            return this;
        }

        public Builder setResumptionVerifier(ResumptionVerifier resumptionVerifier) {
            this.config.resumptionVerifier = resumptionVerifier;
            return this;
        }

        public Builder setCertificateHelper(CertificateConfigurationHelper helper) {
            this.config.certificateConfigurationHelper = helper;
            return this;
        }

        public DtlsConnectorConfig getIncompleteConfig() {
            return this.config;
        }

        public DtlsConnectorConfig build() {
            this.config.loggingTag = StringUtil.normalizeLoggingTag(this.config.loggingTag);
            if (this.config.address == null) {
                this.config.address = new InetSocketAddress(0);
            }
            if (this.config.enableReuseAddress == null) {
                this.config.enableReuseAddress = Boolean.FALSE;
            }
            if (this.config.useTruncatedCertificatePathForClientsCertificateMessage == null) {
                this.config.useTruncatedCertificatePathForClientsCertificateMessage = Boolean.TRUE;
            }
            if (this.config.useTruncatedCertificatePathForValidation == null) {
                this.config.useTruncatedCertificatePathForValidation = Boolean.TRUE;
            }
            if (this.config.earlyStopRetransmission == null) {
                this.config.earlyStopRetransmission = Boolean.TRUE;
            }
            if (this.config.maxRetransmissionTimeout == null) {
                if (this.config.retransmissionTimeout != null && this.config.retransmissionTimeout > 60000) {
                    this.config.maxRetransmissionTimeout = this.config.retransmissionTimeout;
                } else {
                    this.config.maxRetransmissionTimeout = 60000;
                }
            }
            if (this.config.retransmissionTimeout == null) {
                if (this.config.maxRetransmissionTimeout < 2000) {
                    this.config.retransmissionTimeout = this.config.maxRetransmissionTimeout;
                } else {
                    this.config.retransmissionTimeout = 2000;
                }
            } else if (this.config.retransmissionTimeout > this.config.maxRetransmissionTimeout) {
                throw new IllegalStateException("Retransmission timeout " + this.config.retransmissionTimeout + " is more than the maximum " + this.config.maxRetransmissionTimeout + "!");
            }
            if (this.config.additionalTimeoutForEcc == null) {
                this.config.additionalTimeoutForEcc = 0;
            }
            if (this.config.maxRetransmissions == null) {
                this.config.maxRetransmissions = 4;
            }
            if (this.config.backOffRetransmission == null) {
                this.config.backOffRetransmission = this.config.maxRetransmissions / 2;
            }
            if (this.config.maxFragmentedHandshakeMessageLength == null) {
                this.config.maxFragmentedHandshakeMessageLength = 8192;
            }
            if (this.config.clientAuthenticationWanted == null) {
                this.config.clientAuthenticationWanted = Boolean.FALSE;
            }
            if (this.config.clientOnly == null) {
                this.config.clientOnly = Boolean.FALSE;
            }
            if (this.config.recommendedCipherSuitesOnly == null) {
                this.config.recommendedCipherSuitesOnly = Boolean.TRUE;
            }
            if (this.config.recommendedSupportedGroupsOnly == null) {
                this.config.recommendedSupportedGroupsOnly = Boolean.TRUE;
            }
            if (this.config.clientAuthenticationRequired == null) {
                if (this.config.clientOnly.booleanValue()) {
                    this.config.clientAuthenticationRequired = Boolean.FALSE;
                } else {
                    this.config.clientAuthenticationRequired = this.config.clientAuthenticationWanted == false;
                }
            }
            if (this.config.serverOnly == null) {
                this.config.serverOnly = Boolean.FALSE;
            }
            if (this.config.defaultHandshakeMode == null) {
                if (this.config.serverOnly.booleanValue()) {
                    this.config.defaultHandshakeMode = "none";
                } else {
                    this.config.defaultHandshakeMode = "auto";
                }
            }
            if (this.config.useServerSessionId == null) {
                this.config.useServerSessionId = Boolean.TRUE;
            }
            if (this.config.outboundMessageBufferSize == null) {
                this.config.outboundMessageBufferSize = 100000;
            }
            if (this.config.maxDeferredProcessedOutgoingApplicationDataMessages == null) {
                this.config.maxDeferredProcessedOutgoingApplicationDataMessages = 10;
            }
            if (this.config.maxDeferredProcessedIncomingRecordsSize == null) {
                this.config.maxDeferredProcessedIncomingRecordsSize = 8192;
            }
            if (this.config.maxConnections == null) {
                this.config.maxConnections = 150000;
            }
            if (this.config.connectionThreadCount == null) {
                this.config.connectionThreadCount = DEFAULT_EXECUTOR_THREAD_POOL_SIZE;
            }
            if (this.config.receiverThreadCount == null) {
                this.config.receiverThreadCount = DEFAULT_RECEIVER_THREADS;
            }
            if (this.config.staleConnectionThreshold == null) {
                this.config.staleConnectionThreshold = 1800L;
            }
            if (this.config.maxTransmissionUnitLimit == null) {
                this.config.maxTransmissionUnitLimit = 1500;
            }
            if (this.config.sniEnabled == null) {
                this.config.sniEnabled = Boolean.FALSE;
            }
            if (this.config.extendedMasterSecretMode == null) {
                this.config.extendedMasterSecretMode = ExtendedMasterSecretMode.ENABLED;
            }
            if (this.config.useExtendedWindowFilter == null) {
                this.config.useExtendedWindowFilter = 0;
            }
            if (this.config.useAntiReplayFilter == null) {
                this.config.useAntiReplayFilter = this.config.useExtendedWindowFilter == 0;
            }
            if (this.config.useCidUpdateAddressOnNewerRecordFilter == null) {
                this.config.useCidUpdateAddressOnNewerRecordFilter = Boolean.TRUE;
            }
            if (this.config.verifyPeersOnResumptionThreshold == null) {
                this.config.verifyPeersOnResumptionThreshold = 30;
            }
            if (this.config.useHelloVerifyRequest == null) {
                this.config.useHelloVerifyRequest = Boolean.TRUE;
            }
            if (this.config.useHelloVerifyRequestForPsk == null) {
                this.config.useHelloVerifyRequestForPsk = this.config.useHelloVerifyRequest;
            }
            if (this.config.serverOnly.booleanValue() && !this.config.clientAuthenticationRequired.booleanValue() && !this.config.clientAuthenticationWanted.booleanValue() && this.config.advancedCertificateVerifier != null) {
                throw new IllegalStateException("configured certificate verifier is not used for disabled client authentication!");
            }
            if (this.config.supportedGroups == null) {
                this.config.supportedGroups = Collections.emptyList();
            }
            if (this.config.supportedSignatureAlgorithms == null) {
                this.config.supportedSignatureAlgorithms = Collections.emptyList();
            }
            if (this.config.cipherSuiteSelector == null && !this.config.clientOnly.booleanValue()) {
                this.config.cipherSuiteSelector = new DefaultCipherSuiteSelector();
            }
            if (this.config.resumptionVerifier == null && this.config.useServerSessionId.booleanValue() && !this.config.clientOnly.booleanValue()) {
                this.config.resumptionVerifier = new ConnectionStoreResumptionVerifier();
            }
            if (this.config.supportedCipherSuites == null || this.config.supportedCipherSuites.isEmpty()) {
                this.determineCipherSuitesFromConfig();
            }
            if (this.config.supportedCipherSuites == null || this.config.supportedCipherSuites.isEmpty()) {
                throw new IllegalStateException("Supported cipher suites must be set either explicitly or implicitly by means of setting the identity or PSK store");
            }
            for (CipherSuite cipherSuite : this.config.supportedCipherSuites) {
                if (cipherSuite.isSupported()) continue;
                throw new IllegalStateException("cipher-suites " + (Object)((Object)cipherSuite) + " is not supported by JVM!");
            }
            boolean certifacte = false;
            boolean ecc = false;
            boolean psk = false;
            for (CipherSuite suite : this.config.supportedCipherSuites) {
                if (suite.isPskBased()) {
                    this.verifyPskBasedCipherConfig(suite);
                    psk = true;
                } else if (suite.requiresServerCertificateMessage()) {
                    this.verifyCertificateBasedCipherConfig(suite);
                    certifacte = true;
                }
                if (!suite.isEccBased()) continue;
                ecc = true;
            }
            if (!psk && this.config.advancedPskStore != null) {
                throw new IllegalStateException("Advanced PSK store set, but no PSK cipher suite!");
            }
            CertificateProvider provider = this.config.certificateIdentityProvider;
            NewAdvancedCertificateVerifier verifier = this.config.advancedCertificateVerifier;
            if (this.config.certificateConfigurationHelper == null) {
                CertificateConfigurationHelper helper = new CertificateConfigurationHelper();
                if (provider instanceof ConfigurationHelperSetup) {
                    ((ConfigurationHelperSetup)((Object)provider)).setupConfigurationHelper(helper);
                    this.config.certificateConfigurationHelper = helper;
                }
                if (verifier instanceof ConfigurationHelperSetup) {
                    ((ConfigurationHelperSetup)((Object)verifier)).setupConfigurationHelper(helper);
                    this.config.certificateConfigurationHelper = helper;
                }
            }
            if (ecc) {
                if (this.config.supportedSignatureAlgorithms.isEmpty()) {
                    ArrayList<SignatureAndHashAlgorithm> algorithms = new ArrayList<SignatureAndHashAlgorithm>(SignatureAndHashAlgorithm.DEFAULT);
                    if (this.config.certificateConfigurationHelper != null) {
                        ListUtils.addIfAbsent(algorithms, this.config.certificateConfigurationHelper.getDefaultSignatureAndHashAlgorithms());
                    }
                    this.config.supportedSignatureAlgorithms = algorithms;
                }
                if (this.config.supportedGroups.isEmpty()) {
                    ArrayList<XECDHECryptography.SupportedGroup> defaultGroups = new ArrayList<XECDHECryptography.SupportedGroup>(XECDHECryptography.SupportedGroup.getPreferredGroups());
                    if (this.config.certificateConfigurationHelper != null) {
                        ListUtils.addIfAbsent(defaultGroups, this.config.certificateConfigurationHelper.getDefaultSupportedGroups());
                    }
                    this.config.supportedGroups = defaultGroups;
                }
            } else {
                if (!this.config.supportedSignatureAlgorithms.isEmpty()) {
                    throw new IllegalStateException("supported signature and hash algorithms set, but no ecdhe based cipher suite!");
                }
                if (!this.config.supportedGroups.isEmpty()) {
                    throw new IllegalStateException("supported groups set, but no ecdhe based cipher suite!");
                }
            }
            if (!certifacte) {
                if (provider != null) {
                    throw new IllegalStateException("certificate identity set, but no certificate based cipher suite!");
                }
                if (this.config.advancedCertificateVerifier != null) {
                    throw new IllegalStateException("certificate trust set, but no certificate based cipher suite!");
                }
            }
            if (this.config.recommendedSupportedGroupsOnly.booleanValue()) {
                this.verifyRecommendedSupportedGroupsOnly(this.config.supportedGroups);
            }
            if (this.config.certificateConfigurationHelper != null) {
                this.config.certificateConfigurationHelper.verifySignatureAndHashAlgorithmsConfiguration(this.config.supportedSignatureAlgorithms);
                this.config.certificateConfigurationHelper.verifySupportedGroupsConfiguration(this.config.supportedGroups);
                if (provider != null && provider.getSupportedCertificateTypes().contains((Object)CertificateType.X_509)) {
                    if (this.config.clientOnly.booleanValue()) {
                        if (!this.config.certificateConfigurationHelper.canBeUsedForAuthentication(true)) {
                            throw new IllegalStateException("certificate has no proper key usage for clients!");
                        }
                    } else if (this.config.serverOnly.booleanValue()) {
                        if (!this.config.certificateConfigurationHelper.canBeUsedForAuthentication(false)) {
                            throw new IllegalStateException("certificate has no proper key usage for servers!");
                        }
                    } else {
                        if (!this.config.certificateConfigurationHelper.canBeUsedForAuthentication(true)) {
                            throw new IllegalStateException("certificate has no proper key usage as clients!");
                        }
                        if (!this.config.certificateConfigurationHelper.canBeUsedForAuthentication(false)) {
                            throw new IllegalStateException("certificate has no proper key usage as servers!");
                        }
                    }
                }
            }
            if (this.config.useHelloVerifyRequest.booleanValue() && !this.config.useHelloVerifyRequestForPsk.booleanValue() && !CipherSuite.containsPskBasedCipherSuite(this.config.supportedCipherSuites)) {
                throw new IllegalArgumentException("HELLO_VERIFY_REQUEST disabled for PSK, requires at least one PSK cipher suite!");
            }
            this.config.supportedCipherSuites = ListUtils.init(this.config.supportedCipherSuites);
            this.config.supportedGroups = ListUtils.init(this.config.supportedGroups);
            this.config.supportedSignatureAlgorithms = ListUtils.init(this.config.supportedSignatureAlgorithms);
            return this.config;
        }

        private void verifyPskBasedCipherConfig(CipherSuite suite) {
            if (this.config.advancedPskStore == null) {
                throw new IllegalStateException("PSK store must be set for configured " + suite.name());
            }
            if (!this.config.advancedPskStore.hasEcdhePskSupported() && suite.isEccBased()) {
                throw new IllegalStateException("PSK store doesn't support ECDHE! " + suite.name());
            }
        }

        private void verifyCertificateBasedCipherConfig(CipherSuite suite) {
            String algorithm;
            List<String> keyAlgorithms;
            if (this.config.certificateIdentityProvider == null) {
                if (!this.config.clientOnly.booleanValue()) {
                    throw new IllegalStateException("Identity must be set for configured " + suite.name());
                }
            } else if (this.config.certificateConfigurationHelper != null && !(keyAlgorithms = this.config.certificateConfigurationHelper.getSupportedKeyAlgorithms()).contains(algorithm = suite.getCertificateKeyAlgorithm().name())) {
                throw new IllegalStateException("Keys must be " + algorithm + " capable for configured " + suite.name());
            }
            if ((this.config.clientOnly.booleanValue() || this.config.clientAuthenticationRequired.booleanValue() || this.config.clientAuthenticationWanted.booleanValue()) && this.config.advancedCertificateVerifier == null) {
                throw new IllegalStateException("certificate verifier must be set for configured " + suite.name());
            }
        }

        private void verifyRecommendedCipherSuitesOnly(List<CipherSuite> suites) {
            StringBuilder message = new StringBuilder();
            for (CipherSuite cipherSuite : suites) {
                if (cipherSuite.isRecommended()) continue;
                if (message.length() > 0) {
                    message.append(", ");
                }
                message.append(cipherSuite.name());
            }
            if (message.length() > 0) {
                throw new IllegalArgumentException("Not recommended cipher suites " + message + " used! (Requires to set recommendedCipherSuitesOnly to false.)");
            }
        }

        private void verifyRecommendedSupportedGroupsOnly(List<XECDHECryptography.SupportedGroup> supportedGroups) {
            StringBuilder message = new StringBuilder();
            for (XECDHECryptography.SupportedGroup group : supportedGroups) {
                if (group.isRecommended()) continue;
                if (message.length() > 0) {
                    message.append(", ");
                }
                message.append(group.name());
            }
            if (message.length() > 0) {
                throw new IllegalArgumentException("Not recommended supported groups (curves) " + message + " used! (Requires to set recommendedSupportedGroupsOnly to false.)");
            }
        }

        private void verifyRecommendedSignatureAndHashAlgorithmsOnly(List<SignatureAndHashAlgorithm> signatureAndHashAlgorithms) {
            StringBuilder message = new StringBuilder();
            for (SignatureAndHashAlgorithm signature : signatureAndHashAlgorithms) {
                if (signature.isRecommended()) continue;
                if (message.length() > 0) {
                    message.append(", ");
                }
                message.append(signature.getJcaName());
            }
            if (message.length() > 0) {
                throw new IllegalArgumentException("Not recommended signature and hash algorithms " + message + " used! (Requires to set recommendedSignatureAndHashAlgorithmsOnly to false.)");
            }
        }

        private void determineCipherSuitesFromConfig() {
            boolean certificates;
            ArrayList<CipherSuite> ciphers = new ArrayList<CipherSuite>();
            boolean bl = certificates = this.config.certificateIdentityProvider != null || this.config.advancedCertificateVerifier != null;
            if (certificates) {
                ciphers.addAll(CipherSuite.getEcdsaCipherSuites(this.config.recommendedCipherSuitesOnly));
            }
            if (this.config.advancedPskStore != null) {
                if (this.config.advancedPskStore.hasEcdhePskSupported()) {
                    ciphers.addAll(CipherSuite.getCipherSuitesByKeyExchangeAlgorithm((boolean)this.config.recommendedCipherSuitesOnly, CipherSuite.KeyExchangeAlgorithm.ECDHE_PSK));
                }
                ciphers.addAll(CipherSuite.getCipherSuitesByKeyExchangeAlgorithm((boolean)this.config.recommendedCipherSuitesOnly, CipherSuite.KeyExchangeAlgorithm.PSK));
            }
            if (this.config.preselectedCipherSuites != null) {
                ArrayList<CipherSuite> preselect = new ArrayList<CipherSuite>();
                for (CipherSuite cipherSuite : this.config.preselectedCipherSuites) {
                    if (!ciphers.contains((Object)cipherSuite)) continue;
                    preselect.add(cipherSuite);
                }
                ciphers = preselect;
            }
            this.config.supportedCipherSuites = ciphers;
        }
    }
}

