/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.security.MessageDigest;
import java.util.concurrent.ScheduledExecutorService;
import org.eclipse.californium.elements.util.NoPublicAPI;
import org.eclipse.californium.scandium.config.DtlsConnectorConfig;
import org.eclipse.californium.scandium.dtls.AlertMessage;
import org.eclipse.californium.scandium.dtls.ChangeCipherSpecMessage;
import org.eclipse.californium.scandium.dtls.ClientHello;
import org.eclipse.californium.scandium.dtls.CompressionMethod;
import org.eclipse.californium.scandium.dtls.Connection;
import org.eclipse.californium.scandium.dtls.DTLSFlight;
import org.eclipse.californium.scandium.dtls.DTLSSession;
import org.eclipse.californium.scandium.dtls.ExtendedMasterSecretMode;
import org.eclipse.californium.scandium.dtls.Finished;
import org.eclipse.californium.scandium.dtls.HandshakeException;
import org.eclipse.californium.scandium.dtls.HandshakeMessage;
import org.eclipse.californium.scandium.dtls.HelloExtensions;
import org.eclipse.californium.scandium.dtls.Random;
import org.eclipse.californium.scandium.dtls.RecordLayer;
import org.eclipse.californium.scandium.dtls.ServerHandshaker;
import org.eclipse.californium.scandium.dtls.ServerHello;
import org.eclipse.californium.scandium.dtls.SessionId;
import org.eclipse.californium.scandium.dtls.cipher.CipherSuite;

@NoPublicAPI
public class ResumingServerHandshaker
extends ServerHandshaker {
    private byte[] handshakeHash;

    public ResumingServerHandshaker(long initialRecordSequenceNo, int sequenceNumber, DTLSSession session, RecordLayer recordLayer, ScheduledExecutorService timer, Connection connection, DtlsConnectorConfig config) {
        super(initialRecordSequenceNo, sequenceNumber, session, recordLayer, timer, connection, config);
        SessionId sessionId = session.getSessionIdentifier();
        if (sessionId == null || sessionId.isEmpty()) {
            throw new IllegalArgumentException("Session must contain the ID of the session to resume");
        }
    }

    @Override
    protected void doProcessMessage(HandshakeMessage message) throws HandshakeException {
        switch (message.getMessageType()) {
            case CLIENT_HELLO: {
                this.receivedClientHello((ClientHello)message);
                this.expectChangeCipherSpecMessage();
                break;
            }
            case FINISHED: {
                this.receivedClientFinished((Finished)message);
                break;
            }
            default: {
                throw new HandshakeException(String.format("Received unexpected handshake message [%s] from peer %s", new Object[]{message.getMessageType(), this.peerToLog}), new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.UNEXPECTED_MESSAGE));
            }
        }
    }

    private void receivedClientHello(ClientHello clientHello) throws HandshakeException {
        MessageDigest mdWithServerFinished;
        this.handshakeStarted();
        DTLSSession session = this.getSession();
        CipherSuite cipherSuite = session.getCipherSuite();
        CompressionMethod compressionMethod = session.getCompressionMethod();
        if (!clientHello.getCipherSuites().contains((Object)cipherSuite)) {
            throw new HandshakeException("Client wants to change cipher suite in resumed session", new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.ILLEGAL_PARAMETER));
        }
        if (!session.getProtocolVersion().equals(clientHello.getClientVersion())) {
            throw new HandshakeException("Client wants to change protocol version in resumed session", new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.ILLEGAL_PARAMETER));
        }
        if (!clientHello.getCompressionMethods().contains((Object)compressionMethod)) {
            throw new HandshakeException("Client wants to change compression method in resumed session", new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.ILLEGAL_PARAMETER));
        }
        if (this.extendedMasterSecretMode.is(ExtendedMasterSecretMode.ENABLED) && !clientHello.hasExtendedMasterSecret()) {
            throw new HandshakeException("Client wants to resume without extended master secret", new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.ILLEGAL_PARAMETER));
        }
        if (this.extendedMasterSecretMode == ExtendedMasterSecretMode.OPTIONAL && session.useExtendedMasterSecret() && !clientHello.hasExtendedMasterSecret()) {
            throw new HandshakeException("Client wants to resume without extended master secret", new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.ILLEGAL_PARAMETER));
        }
        this.clientRandom = clientHello.getRandom();
        this.serverRandom = new Random();
        HelloExtensions serverHelloExtensions = new HelloExtensions();
        this.negotiateCipherSuite(clientHello, serverHelloExtensions);
        this.processHelloExtensions(clientHello, serverHelloExtensions);
        this.flightNumber += 2;
        DTLSFlight flight = this.createFlight();
        ServerHello serverHello = new ServerHello(clientHello.getClientVersion(), this.serverRandom, session.getSessionIdentifier(), cipherSuite, compressionMethod, serverHelloExtensions);
        this.wrapMessage(flight, serverHello);
        ChangeCipherSpecMessage changeCipherSpecMessage = new ChangeCipherSpecMessage();
        this.wrapMessage(flight, changeCipherSpecMessage);
        MessageDigest md = this.getHandshakeMessageDigest();
        try {
            mdWithServerFinished = (MessageDigest)md.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new HandshakeException("Cannot create FINISHED message hash", new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.INTERNAL_ERROR));
        }
        this.masterSecret = session.getMasterSecret();
        this.calculateKeys(this.masterSecret);
        this.setCurrentWriteState();
        Finished finished = new Finished(cipherSuite.getThreadLocalPseudoRandomFunctionMac(), this.masterSecret, false, md.digest());
        this.wrapMessage(flight, finished);
        mdWithServerFinished.update(finished.toByteArray());
        this.handshakeHash = mdWithServerFinished.digest();
        this.sendFlight(flight);
        this.states = NO_CLIENT_CERTIFICATE;
        this.statesIndex = 0;
    }

    private void receivedClientFinished(Finished message) throws HandshakeException {
        message.verifyData(this.getSession().getCipherSuite().getThreadLocalPseudoRandomFunctionMac(), this.masterSecret, true, this.handshakeHash);
        this.contextEstablished();
        this.handshakeCompleted();
    }
}

