/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.security.MessageDigest;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import javax.crypto.Mac;
import org.eclipse.californium.elements.util.NoPublicAPI;
import org.eclipse.californium.scandium.config.DtlsConnectorConfig;
import org.eclipse.californium.scandium.dtls.AlertMessage;
import org.eclipse.californium.scandium.dtls.CertificateType;
import org.eclipse.californium.scandium.dtls.ChangeCipherSpecMessage;
import org.eclipse.californium.scandium.dtls.ClientHandshaker;
import org.eclipse.californium.scandium.dtls.ClientHello;
import org.eclipse.californium.scandium.dtls.Connection;
import org.eclipse.californium.scandium.dtls.ConnectionId;
import org.eclipse.californium.scandium.dtls.ConnectionIdExtension;
import org.eclipse.californium.scandium.dtls.ContentType;
import org.eclipse.californium.scandium.dtls.DTLSFlight;
import org.eclipse.californium.scandium.dtls.DTLSSession;
import org.eclipse.californium.scandium.dtls.ExtendedMasterSecretExtension;
import org.eclipse.californium.scandium.dtls.Finished;
import org.eclipse.californium.scandium.dtls.HandshakeException;
import org.eclipse.californium.scandium.dtls.HandshakeMessage;
import org.eclipse.californium.scandium.dtls.HandshakeState;
import org.eclipse.californium.scandium.dtls.HandshakeType;
import org.eclipse.californium.scandium.dtls.HelloVerifyRequest;
import org.eclipse.californium.scandium.dtls.ProtocolVersion;
import org.eclipse.californium.scandium.dtls.RecordLayer;
import org.eclipse.californium.scandium.dtls.ServerHello;
import org.eclipse.californium.scandium.dtls.SessionId;
import org.eclipse.californium.scandium.dtls.SignatureAndHashAlgorithm;
import org.eclipse.californium.scandium.dtls.cipher.CipherSuite;
import org.eclipse.californium.scandium.dtls.cipher.XECDHECryptography;
import org.eclipse.californium.scandium.util.SecretUtil;

@NoPublicAPI
public class ResumingClientHandshaker
extends ClientHandshaker {
    private static HandshakeState[] RESUME = new HandshakeState[]{new HandshakeState(HandshakeType.HELLO_VERIFY_REQUEST, true), new HandshakeState(HandshakeType.SERVER_HELLO), new HandshakeState(ContentType.CHANGE_CIPHER_SPEC), new HandshakeState(HandshakeType.FINISHED)};
    private boolean fullHandshake = false;

    public ResumingClientHandshaker(DTLSSession session, RecordLayer recordLayer, ScheduledExecutorService timer, Connection connection, DtlsConnectorConfig config, boolean probe) {
        super(probe, session, recordLayer, timer, connection, config);
        SessionId sessionId = session.getSessionIdentifier();
        if (sessionId == null || sessionId.isEmpty()) {
            throw new IllegalArgumentException("Session must contain the ID of the session to resume");
        }
    }

    @Override
    protected void doProcessMessage(HandshakeMessage message) throws HandshakeException {
        if (this.fullHandshake) {
            super.doProcessMessage(message);
            return;
        }
        switch (message.getMessageType()) {
            case HELLO_VERIFY_REQUEST: {
                this.receivedHelloVerifyRequest((HelloVerifyRequest)message);
                break;
            }
            case SERVER_HELLO: {
                this.receivedServerHello((ServerHello)message);
                break;
            }
            case FINISHED: {
                this.receivedServerFinished((Finished)message);
                break;
            }
            default: {
                throw new HandshakeException(String.format("Received unexpected handshake message [%s] from peer %s", new Object[]{message.getMessageType(), this.peerToLog}), new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.UNEXPECTED_MESSAGE));
            }
        }
    }

    @Override
    protected void receivedServerHello(ServerHello message) throws HandshakeException {
        DTLSSession session = this.getSession();
        if (!session.getSessionIdentifier().equals(message.getSessionId())) {
            this.LOGGER.debug("Server [{}] refuses to resume session [{}], performing full handshake instead...", this.peerToLog, (Object)session.getSessionIdentifier());
            this.fullHandshake = true;
            this.states = SEVER_CERTIFICATE;
            SecretUtil.destroy(this.context);
            super.receivedServerHello(message);
        } else {
            ConnectionIdExtension extension;
            if (!message.getCompressionMethod().equals((Object)session.getCompressionMethod())) {
                throw new HandshakeException("Server wants to change compression method in resumed session", new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.ILLEGAL_PARAMETER));
            }
            if (!message.getCipherSuite().equals((Object)session.getCipherSuite())) {
                throw new HandshakeException("Server wants to change cipher suite in resumed session", new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.ILLEGAL_PARAMETER));
            }
            if (session.useExtendedMasterSecret() && !message.hasExtendedMasterSecret()) {
                throw new HandshakeException("Server wants to change extended master secret in resumed session", new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.ILLEGAL_PARAMETER));
            }
            if (!session.getProtocolVersion().equals(message.getServerVersion())) {
                throw new HandshakeException("Server wants to change protocol version in resumed session", new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.ILLEGAL_PARAMETER));
            }
            this.verifyServerHelloExtensions(message);
            this.serverRandom = message.getRandom();
            if (this.supportsConnectionId() && (extension = message.getConnectionIdExtension()) != null) {
                ConnectionId connectionId = extension.getConnectionId();
                this.context.setWriteConnectionId(connectionId);
                this.context.setReadConnectionId(this.getReadConnectionId());
            }
            this.expectChangeCipherSpecMessage();
            this.masterSecret = session.getMasterSecret();
            this.calculateKeys(this.masterSecret);
        }
    }

    private void receivedServerFinished(Finished message) throws HandshakeException {
        MessageDigest mdWithServerFinish;
        this.flightNumber += 2;
        DTLSFlight flight = this.createFlight();
        MessageDigest md = this.getHandshakeMessageDigest();
        try {
            mdWithServerFinish = (MessageDigest)md.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new HandshakeException("Cannot create FINISHED message hash", new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.INTERNAL_ERROR));
        }
        Mac mac = this.getSession().getCipherSuite().getThreadLocalPseudoRandomFunctionMac();
        message.verifyData(mac, this.masterSecret, false, md.digest());
        ChangeCipherSpecMessage changeCipherSpecMessage = new ChangeCipherSpecMessage();
        this.wrapMessage(flight, changeCipherSpecMessage);
        this.setCurrentWriteState();
        mdWithServerFinish.update(message.getRawMessage());
        Finished finished = new Finished(mac, this.masterSecret, true, mdWithServerFinish.digest());
        this.wrapMessage(flight, finished);
        this.sendLastFlight(flight);
        this.contextEstablished();
    }

    @Override
    public void startHandshake() throws HandshakeException {
        this.handshakeStarted();
        DTLSSession session = this.getSession();
        ClientHello message = new ClientHello(ProtocolVersion.VERSION_DTLS_1_2, session, (List<SignatureAndHashAlgorithm>)this.supportedSignatureAlgorithms, (List<CertificateType>)this.supportedClientCertificateTypes, (List<CertificateType>)this.supportedServerCertificateTypes, (List<XECDHECryptography.SupportedGroup>)this.supportedGroups);
        if (CipherSuite.containsEccBasedCipherSuite(message.getCipherSuites())) {
            this.expectEcc();
        }
        this.clientRandom = message.getRandom();
        if (session.useExtendedMasterSecret()) {
            message.addExtension(ExtendedMasterSecretExtension.INSTANCE);
        }
        this.addConnectionId(message);
        this.addRecordSizeLimit(message);
        this.addMaxFragmentLength(message);
        this.addServerNameIndication(message);
        this.clientHello = message;
        this.flightNumber = 1;
        DTLSFlight flight = this.createFlight();
        this.wrapMessage(flight, message);
        this.sendFlight(flight);
        this.states = RESUME;
        this.statesIndex = 0;
    }
}

