/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.plugtests;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.SocketException;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import org.eclipse.californium.core.CoapServer;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.network.Endpoint;
import org.eclipse.californium.core.network.EndpointObserver;
import org.eclipse.californium.core.network.config.NetworkConfig;
import org.eclipse.californium.core.network.config.NetworkConfigDefaultHandler;
import org.eclipse.californium.core.network.interceptors.AnonymizedOriginTracer;
import org.eclipse.californium.core.network.interceptors.HealthStatisticLogger;
import org.eclipse.californium.core.network.interceptors.MessageTracer;
import org.eclipse.californium.core.server.ServersSerializationUtil;
import org.eclipse.californium.elements.tcp.netty.TlsServerConnector;
import org.eclipse.californium.elements.util.Bytes;
import org.eclipse.californium.elements.util.DataStreamReader;
import org.eclipse.californium.elements.util.DatagramWriter;
import org.eclipse.californium.elements.util.ExecutorsUtil;
import org.eclipse.californium.elements.util.NamedThreadFactory;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.plugtests.AbstractTestServer;
import org.eclipse.californium.plugtests.resources.Context;
import org.eclipse.californium.plugtests.resources.Create;
import org.eclipse.californium.plugtests.resources.DefaultTest;
import org.eclipse.californium.plugtests.resources.Hono;
import org.eclipse.californium.plugtests.resources.Large;
import org.eclipse.californium.plugtests.resources.LargeCreate;
import org.eclipse.californium.plugtests.resources.LargePost;
import org.eclipse.californium.plugtests.resources.LargeSeparate;
import org.eclipse.californium.plugtests.resources.LargeUpdate;
import org.eclipse.californium.plugtests.resources.Link1;
import org.eclipse.californium.plugtests.resources.Link2;
import org.eclipse.californium.plugtests.resources.Link3;
import org.eclipse.californium.plugtests.resources.LocationQuery;
import org.eclipse.californium.plugtests.resources.LongPath;
import org.eclipse.californium.plugtests.resources.MultiFormat;
import org.eclipse.californium.plugtests.resources.MyIp;
import org.eclipse.californium.plugtests.resources.Observe;
import org.eclipse.californium.plugtests.resources.ObserveLarge;
import org.eclipse.californium.plugtests.resources.ObserveNon;
import org.eclipse.californium.plugtests.resources.ObservePumping;
import org.eclipse.californium.plugtests.resources.ObserveReset;
import org.eclipse.californium.plugtests.resources.Path;
import org.eclipse.californium.plugtests.resources.Query;
import org.eclipse.californium.plugtests.resources.Separate;
import org.eclipse.californium.plugtests.resources.Shutdown;
import org.eclipse.californium.plugtests.resources.Validate;
import org.eclipse.californium.scandium.dtls.cipher.CipherSuite;
import org.eclipse.californium.scandium.dtls.cipher.PseudoRandomFunction;
import org.eclipse.californium.scandium.dtls.cipher.RandomManager;
import org.eclipse.californium.scandium.util.SecretUtil;
import picocli.CommandLine;

public class PlugtestServer
extends AbstractTestServer {
    private static final File CONFIG_FILE = new File("CaliforniumPlugtest.properties");
    private static final String CONFIG_HEADER = "Californium CoAP Properties file for Plugtest Server";
    private static final int DEFAULT_MAX_RESOURCE_SIZE = 8192;
    private static final int DEFAULT_BLOCK_SIZE = 64;
    public static final int ERR_INIT_FAILED = 1;
    private static NetworkConfigDefaultHandler DEFAULTS = new NetworkConfigDefaultHandler(){

        @Override
        public void applyDefaults(NetworkConfig config) {
            config.setInt("DTLS_AUTO_RESUME_TIMEOUT", 0);
            config.setInt("DTLS_CONNECTION_ID_LENGTH", 6);
            config.setInt("MAX_RESOURCE_BODY_SIZE", 8192);
            config.setInt("MAX_MESSAGE_SIZE", 64);
            config.setInt("PREFERRED_BLOCK_SIZE", 64);
            config.setInt("NOTIFICATION_CHECK_INTERVAL_COUNT", 4);
            config.setInt("NOTIFICATION_CHECK_INTERVAL", 30000);
            config.setInt("HEALTH_STATUS_INTERVAL", 300);
            config.setInt("UDP_CONNECTOR_RECEIVE_BUFFER", 0);
            config.setInt("UDP_CONNECTOR_SEND_BUFFER", 0);
        }
    };
    private static final Config config = new Config();
    private static PlugtestServer server;
    private static List<CoapServer> servers;
    private static BaseConfig.Store storeConfig;
    private static File store;
    private static byte[] state;

    public static void main(String[] args) {
        CommandLine cmd = new CommandLine(config);
        try {
            CommandLine.ParseResult result = cmd.parseArgs(args);
            if (result.isVersionHelpRequested()) {
                String version = StringUtil.CALIFORNIUM_VERSION == null ? "" : StringUtil.CALIFORNIUM_VERSION;
                System.out.println("\nCalifornium (Cf) " + cmd.getCommandName() + " " + version);
                cmd.printVersionHelp(System.out);
                System.out.println();
            }
            if (result.isUsageHelpRequested()) {
                cmd.usage(System.out);
                return;
            }
        }
        catch (CommandLine.ParameterException ex) {
            System.err.println(ex.getMessage());
            System.err.println();
            cmd.usage(System.err);
            System.exit(-1);
        }
        PlugtestServer.init(config);
        PlugtestServer.load(config);
        NetworkConfig netConfig = NetworkConfig.createWithFile(CONFIG_FILE, CONFIG_HEADER, DEFAULTS);
        ScheduledExecutorService executor = ExecutorsUtil.newScheduledThreadPool(netConfig.getInt("PROTOCOL_STAGE_THREAD_COUNT"), new NamedThreadFactory("CoapServer(main)#"));
        ScheduledThreadPoolExecutor secondaryExecutor = ExecutorsUtil.newDefaultSecondaryScheduler("CoapServer(secondary)#");
        PlugtestServer.start(executor, secondaryExecutor, config, new ActiveInputReader());
        LOGGER.info("Executor shutdown ...");
        ExecutorsUtil.shutdownExecutorGracefully(500L, executor, secondaryExecutor);
        PlugtestServer.exit();
        LOGGER.info("Exit ...");
    }

    public static void exit() {
        int count = Thread.activeCount();
        while (count > 0) {
            int size = Thread.activeCount();
            Thread[] all = new Thread[size];
            int available = Thread.enumerate(all);
            if (available < size) {
                size = available;
            }
            count = 0;
            for (int index = 0; index < size; ++index) {
                Thread thread = all[index];
                if (thread.isDaemon() || !thread.isAlive()) continue;
                ++count;
                LOGGER.info("Thread [{}] {}", (Object)thread.getId(), (Object)thread.getName());
            }
            if (count == 1) break;
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                break;
            }
        }
    }

    public static void init(BaseConfig config) {
        NetworkConfig netconfig = NetworkConfig.createWithFile(CONFIG_FILE, CONFIG_HEADER, DEFAULTS);
        try {
            List<AbstractTestServer.Protocol> protocols = config.getProtocols();
            List<AbstractTestServer.InterfaceType> types = config.getInterfaceTypes();
            server = new PlugtestServer(netconfig);
            server.setTag("PLUG-TEST");
            PlugtestServer.add(server);
            server.addEndpoints(config.interfacePatterns, types, protocols, config);
            if (server.getEndpoints().isEmpty()) {
                System.err.println("no endpoint available!");
                System.exit(1);
            }
        }
        catch (Exception e) {
            System.err.printf("Failed to create " + PlugtestServer.class.getSimpleName() + ": %s\n", e.getMessage());
            e.printStackTrace(System.err);
            System.err.println("Exiting");
            System.exit(1);
        }
    }

    public static void add(CoapServer server) {
        servers.add(server);
    }

    private static Cipher init(int mode, SecretKey password, byte[] seed) {
        try {
            CipherSuite cipherSuite = CipherSuite.TLS_PSK_WITH_AES_128_CBC_SHA256;
            byte[] data = PseudoRandomFunction.doPRF(cipherSuite.getThreadLocalPseudoRandomFunctionMac(), password, PseudoRandomFunction.Label.KEY_EXPANSION_LABEL, seed, 32);
            SecretKey key = SecretUtil.create(data, 0, 16, "AES");
            IvParameterSpec parameterSpec = new IvParameterSpec(data, 16, 16);
            Bytes.clear(data);
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(mode, (Key)key, parameterSpec);
            SecretUtil.destroy(key);
            return cipher;
        }
        catch (GeneralSecurityException ex) {
            LOGGER.warn("encryption error:", ex);
            return null;
        }
    }

    public static void loadServers(InputStream in, SecretKey key) {
        DataStreamReader reader = new DataStreamReader(in);
        byte[] seed = reader.readVarBytes(8);
        if (seed != null && seed.length > 0) {
            if (key == null) {
                LOGGER.warn("missing key!");
                return;
            }
            Cipher cipher = PlugtestServer.init(2, key, seed);
            if (cipher == null) {
                LOGGER.warn("crypto error!");
                return;
            }
            in = new CipherInputStream(in, cipher);
        }
        ServersSerializationUtil.loadServers(in, servers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void load(BaseConfig config) {
        if (config.store != null) {
            storeConfig = config.store;
            store = new File(config.store.file);
            if (store.exists()) {
                SecretKey key = null;
                if (config.store.password64 != null) {
                    byte[] secret = StringUtil.base64ToByteArray(config.store.password64);
                    key = SecretUtil.create(secret, "PW");
                    Bytes.clear(secret);
                }
                try {
                    try (FileInputStream in = new FileInputStream(store);){
                        PlugtestServer.loadServers(in, key);
                    }
                    LOGGER.info("Server state read.");
                    store.delete();
                }
                catch (IOException ex) {
                    LOGGER.warn("Reading server state failed!", ex);
                    SecretUtil.destroy(key);
                }
                catch (IllegalArgumentException ex2) {
                    LOGGER.warn("Reading server state failed!", ex2);
                    {
                        catch (Throwable throwable) {
                            SecretUtil.destroy(key);
                            throw throwable;
                        }
                    }
                    SecretUtil.destroy(key);
                }
                SecretUtil.destroy(key);
            }
        }
    }

    public static void load(String password) {
        if (state != null) {
            SecretKey key = PlugtestServer.toKey(password);
            ByteArrayInputStream in = new ByteArrayInputStream(state);
            PlugtestServer.loadServers(in, key);
            LOGGER.info("Loaded: {} Bytes ({})", (Object)state.length, (Object)password);
            state = null;
            for (CoapServer server : servers) {
                server.start();
            }
            SecretUtil.destroy(key);
            try {
                in.close();
            }
            catch (IOException iOException) {}
        } else {
            LOGGER.info("no data to load!");
        }
    }

    public static void start(ScheduledExecutorService mainExecutor, ScheduledExecutorService secondaryExecutor, BaseConfig config, ActiveInputReader inputReader) {
        PlugtestServer.registerShutdown();
        if (server != null) {
            server.setExecutors(mainExecutor, secondaryExecutor, true);
            server.start();
            for (Endpoint ep : server.getEndpoints()) {
                URI uri = ep.getUri();
                ep.addInterceptor(new MessageTracer());
                ep.addInterceptor(new AnonymizedOriginTracer(uri.getPort() + "-" + uri.getScheme()));
                int interval = ep.getConfig().getInt("HEALTH_STATUS_INTERVAL");
                final HealthStatisticLogger healthLogger = new HealthStatisticLogger(uri.toASCIIString(), !CoAP.isTcpScheme(uri.getScheme()), interval, secondaryExecutor);
                if (!healthLogger.isEnabled()) continue;
                ep.addPostProcessInterceptor(healthLogger);
                ep.addObserver(new EndpointObserver(){

                    @Override
                    public void stopped(Endpoint endpoint) {
                        healthLogger.stop();
                    }

                    @Override
                    public void started(Endpoint endpoint) {
                        healthLogger.start();
                    }

                    @Override
                    public void destroyed(Endpoint endpoint) {
                        healthLogger.stop();
                    }
                });
                healthLogger.start();
            }
            LOGGER.info("{} started ...", (Object)PlugtestServer.class.getSimpleName());
            if (inputReader != null) {
                while (!PlugtestServer.console(inputReader, 15000L)) {
                }
                LOGGER.info("{} stopping ...", (Object)PlugtestServer.class.getSimpleName());
                PlugtestServer.shutdown();
            }
        }
    }

    public static void shutdown() {
        if (server != null) {
            server.stop();
        }
    }

    public static void saveServers(OutputStream out, SecretKey key, long maxAgeInSeconds) throws IOException {
        DatagramWriter writer = new DatagramWriter();
        if (key != null) {
            byte[] seed = new byte[16];
            RandomManager.currentSecureRandom().nextBytes(seed);
            Cipher cipher = PlugtestServer.init(1, key, seed);
            if (cipher != null) {
                writer.writeVarBytes(seed, 8);
                writer.writeTo(out);
                out = new CipherOutputStream(out, cipher);
            } else {
                LOGGER.warn("crypto error!");
                writer.reset();
                key = null;
            }
        }
        if (key == null) {
            writer.writeVarBytes(Bytes.EMPTY, 8);
            writer.writeTo(out);
        }
        ServersSerializationUtil.saveServers(out, maxAgeInSeconds, servers);
        out.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save(String password) {
        SecretKey key = PlugtestServer.toKey(password);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        if (state != null) {
            Bytes.clear(state);
        }
        try {
            PlugtestServer.saveServers(out, key, 600L);
            state = out.toByteArray();
            out.close();
            LOGGER.info("Saved: {} Bytes ({})", (Object)state.length, (Object)password);
        }
        catch (IOException ex) {
            LOGGER.warn("saving failed:", ex);
        }
        finally {
            SecretUtil.destroy(key);
        }
    }

    public static SecretKey toKey(String password) {
        SecretKey key = null;
        if (password != null && !password.isEmpty()) {
            key = SecretUtil.create(password.getBytes(), "PW");
        }
        return key;
    }

    public static boolean console(ActiveInputReader reader, long timeout) {
        try {
            String line = reader.getLine(timeout);
            if (line != null) {
                System.out.println("> " + line);
                if (line.startsWith("save")) {
                    PlugtestServer.save(line.substring(4));
                } else if (line.startsWith("load")) {
                    PlugtestServer.load(line.substring(4));
                } else if (line.equals("exit")) {
                    return true;
                }
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            return true;
        }
        return false;
    }

    private static void registerShutdown() {
        LOGGER.info("register shutdown hook.");
        Runtime.getRuntime().addShutdownHook(new Thread("SHUTDOWN"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                LOGGER.info("Shutdown ...");
                if (store != null) {
                    store.delete();
                    SecretKey key = null;
                    if (storeConfig.password64 != null) {
                        byte[] secret = StringUtil.base64ToByteArray(storeConfig.password64);
                        key = SecretUtil.create(secret, "PW");
                        Bytes.clear(secret);
                    }
                    try (FileOutputStream out = new FileOutputStream(store);){
                        PlugtestServer.saveServers(out, key, TimeUnit.HOURS.toSeconds(storeConfig.maxAge.intValue()));
                    }
                    catch (IOException ex) {
                        try {
                            LOGGER.warn("Saving server state failed!", ex);
                            store.delete();
                        }
                        catch (Throwable throwable) {
                            SecretUtil.destroy(key);
                            throw throwable;
                        }
                        SecretUtil.destroy(key);
                    }
                    SecretUtil.destroy(key);
                }
                LOGGER.info("Shutdown.");
            }
        });
    }

    public PlugtestServer(NetworkConfig config) throws SocketException {
        super(config, null);
        this.add(new DefaultTest());
        this.add(new LongPath());
        this.add(new Query());
        this.add(new Separate());
        this.add(new Large());
        this.add(new LargeUpdate());
        this.add(new LargeCreate());
        this.add(new LargePost());
        this.add(new LargeSeparate());
        this.add(new Observe());
        this.add(new ObserveNon());
        this.add(new ObserveReset());
        this.add(new ObserveLarge());
        this.add(new ObservePumping());
        this.add(new ObservePumping(CoAP.Type.NON));
        this.add(new LocationQuery());
        this.add(new MultiFormat());
        this.add(new Link1());
        this.add(new Link2());
        this.add(new Link3());
        this.add(new Path());
        this.add(new Validate());
        this.add(new Create());
        this.add(new Shutdown());
        this.add(new Hono("telemetry"));
        this.add(new Hono("event"));
        this.add(new MyIp("myip", false));
        this.add(new Context("context", false));
    }

    static {
        servers = new CopyOnWriteArrayList<CoapServer>();
    }

    public static class ActiveInputReader {
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        Queue<String> buffer = new ConcurrentLinkedQueue<String>();
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                ActiveInputReader.this.read();
            }
        }, "INPUT");

        public ActiveInputReader() {
            this.thread.setDaemon(true);
            this.thread.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void read() {
            String line = null;
            try {
                while ((line = this.in.readLine()) != null) {
                    this.buffer.add(line);
                    Queue<String> queue = this.buffer;
                    synchronized (queue) {
                        this.buffer.notify();
                    }
                }
                return;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getLine(long timeout) throws InterruptedException {
            if (timeout >= 0L) {
                Queue<String> queue = this.buffer;
                synchronized (queue) {
                    this.buffer.wait(timeout);
                }
            }
            return this.buffer.poll();
        }
    }

    @CommandLine.Command(name="PlugtestServer", version={"(c) 2014, Institute for Pervasive Computing, ETH Zurich."})
    public static class Config
    extends BaseConfig {
    }

    public static class BaseConfig {
        @CommandLine.Option(names={"-h", "--help"}, usageHelp=true, description={"display a help message"})
        public boolean helpRequested;
        @CommandLine.Option(names={"--no-loopback"}, negatable=true, description={"enable endpoints on loopback network."})
        public boolean loopback = true;
        @CommandLine.Option(names={"--no-external"}, negatable=true, description={"enable endpoints on external network."})
        public boolean external = true;
        @CommandLine.Option(names={"--no-ipv4"}, negatable=true, description={"enable endpoints for ipv4."})
        public boolean ipv4 = true;
        @CommandLine.Option(names={"--no-ipv6"}, negatable=true, description={"enable endpoints for ipv6."})
        public boolean ipv6 = true;
        @CommandLine.Option(names={"--no-tcp"}, negatable=true, description={"enable endpoints for tcp."})
        public boolean tcp = true;
        @CommandLine.Option(names={"--dtls-only"}, description={"only dtls endpoints."})
        public boolean onlyDtls;
        @CommandLine.Option(names={"--trust-all"}, description={"trust all valid certificates."})
        public boolean trustall;
        @CommandLine.Option(names={"--client-auth"}, defaultValue="NEEDED", description={"client authentication. Values ${COMPLETION-CANDIDATES}, default ${DEFAULT-VALUE}."})
        public TlsServerConnector.ClientAuthMode clientAuth;
        @CommandLine.ArgGroup(exclusive=false)
        public Store store;
        @CommandLine.Option(names={"--interfaces-pattern"}, split=",", description={"interface regex patterns for endpoints."})
        public List<String> interfacePatterns;

        public List<AbstractTestServer.Protocol> getProtocols() {
            ArrayList<AbstractTestServer.Protocol> protocols = new ArrayList<AbstractTestServer.Protocol>();
            if (!this.onlyDtls) {
                protocols.add(AbstractTestServer.Protocol.UDP);
            } else {
                this.tcp = false;
            }
            protocols.add(AbstractTestServer.Protocol.DTLS);
            if (this.tcp) {
                protocols.add(AbstractTestServer.Protocol.TCP);
                protocols.add(AbstractTestServer.Protocol.TLS);
            }
            return protocols;
        }

        public List<AbstractTestServer.InterfaceType> getInterfaceTypes() {
            int s;
            ArrayList<AbstractTestServer.InterfaceType> types = new ArrayList<AbstractTestServer.InterfaceType>();
            if (this.external) {
                types.add(AbstractTestServer.InterfaceType.EXTERNAL);
            }
            if (this.loopback) {
                types.add(AbstractTestServer.InterfaceType.LOCAL);
            }
            if ((s = types.size()) == 0) {
                System.err.println("Either --loopback or --external must be enabled!");
                System.exit(1);
            }
            if (this.ipv6) {
                types.add(AbstractTestServer.InterfaceType.IPV6);
            }
            if (this.ipv4) {
                types.add(AbstractTestServer.InterfaceType.IPV4);
            }
            if (s == types.size()) {
                System.err.println("Either --ipv4 or --ipv6 must be enabled!");
            }
            return types;
        }

        public static class Store {
            @CommandLine.Option(names={"--store-file"}, required=true, description={"file store dtls state."})
            public String file;
            @CommandLine.Option(names={"--store-password64"}, required=false, description={"password to store dtls state. base 64 encoded."})
            public String password64;
            @CommandLine.Option(names={"--store-max-age"}, required=true, description={"maximum age of connections in hours."})
            public Integer maxAge;
        }
    }
}

