/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.plugtests;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.security.GeneralSecurityException;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.SecretKey;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.TrustManager;
import org.eclipse.californium.core.CoapServer;
import org.eclipse.californium.core.network.CoapEndpoint;
import org.eclipse.californium.core.network.EndpointContextMatcherFactory;
import org.eclipse.californium.core.network.config.NetworkConfig;
import org.eclipse.californium.elements.PrincipalEndpointContextMatcher;
import org.eclipse.californium.elements.tcp.netty.TcpServerConnector;
import org.eclipse.californium.elements.tcp.netty.TlsServerConnector;
import org.eclipse.californium.elements.util.NetworkInterfacesUtil;
import org.eclipse.californium.elements.util.SslContextUtil;
import org.eclipse.californium.plugtests.PlugtestServer;
import org.eclipse.californium.scandium.DTLSConnector;
import org.eclipse.californium.scandium.MdcConnectionListener;
import org.eclipse.californium.scandium.config.DtlsConnectorConfig;
import org.eclipse.californium.scandium.dtls.CertificateType;
import org.eclipse.californium.scandium.dtls.ConnectionId;
import org.eclipse.californium.scandium.dtls.HandshakeResultHandler;
import org.eclipse.californium.scandium.dtls.MultiNodeConnectionIdGenerator;
import org.eclipse.californium.scandium.dtls.PskPublicInformation;
import org.eclipse.californium.scandium.dtls.PskSecretResult;
import org.eclipse.californium.scandium.dtls.SingleNodeConnectionIdGenerator;
import org.eclipse.californium.scandium.dtls.cipher.CipherSuite;
import org.eclipse.californium.scandium.dtls.pskstore.AdvancedPskStore;
import org.eclipse.californium.scandium.dtls.pskstore.AsyncAdvancedPskStore;
import org.eclipse.californium.scandium.dtls.x509.AsyncNewAdvancedCertificateVerifier;
import org.eclipse.californium.scandium.util.SecretUtil;
import org.eclipse.californium.scandium.util.ServerNames;

public abstract class AbstractTestServer
extends CoapServer {
    private static final char[] KEY_STORE_PASSWORD = "endPass".toCharArray();
    private static final String KEY_STORE_LOCATION = "certs/keyStore.jks";
    private static final char[] TRUST_STORE_PASSWORD = "rootPass".toCharArray();
    private static final String TRUST_STORE_LOCATION = "certs/trustStore.jks";
    private static final String SERVER_NAME = "server";
    private static final String PSK_IDENTITY_PREFIX = "cali.";
    private static final SecretKey PSK_SECRET = SecretUtil.create(".fornium".getBytes(), "PSK");
    public static final String ETSI_PSK_IDENTITY = "password";
    public static final SecretKey ETSI_PSK_SECRET = SecretUtil.create("sesame".getBytes(), "PSK");
    public static final String OPENSSL_PSK_IDENTITY = "Client_identity";
    public static final SecretKey OPENSSL_PSK_SECRET = SecretUtil.create("secretPSK".getBytes(), "PSK");
    public static final String KEY_DTLS_HANDSHAKE_RESULT_DELAY = "DTLS_HANDSHAKE_RESULT_DELAY";
    public static final Pattern HONO_IDENTITY_PATTERN = Pattern.compile("^[^@]{8,}@.{8,}$");
    public static final SecretKey HONO_PSK_SECRET = SecretUtil.create("secret".getBytes(), "PSK");
    public static final Pattern IPV6_SCOPE = Pattern.compile("^([0-9a-fA-F:]+)(%\\w+)?$");
    private final NetworkConfig config;
    private final Map<Select, NetworkConfig> selectConfig;
    protected SslContextUtil.Credentials serverCredentials = null;
    protected Certificate[] trustedCertificates = null;
    protected SSLContext serverSslContext = null;

    protected AbstractTestServer(NetworkConfig config, Map<Select, NetworkConfig> selectConfig) {
        super(config, new int[0]);
        this.config = config;
        this.selectConfig = selectConfig;
    }

    public NetworkConfig getConfig(Select select) {
        NetworkConfig udpConfig;
        if (this.selectConfig != null && (udpConfig = this.selectConfig.get(select)) != null) {
            return udpConfig;
        }
        return this.config;
    }

    public NetworkConfig getConfig(Protocol protocol, InterfaceType interfaceType) {
        if (this.selectConfig != null) {
            Select select = new Select(protocol, interfaceType);
            NetworkConfig udpConfig = this.selectConfig.get(select);
            if (udpConfig != null) {
                return udpConfig;
            }
            select = new Select(protocol);
            udpConfig = this.selectConfig.get(select);
            if (udpConfig != null) {
                return udpConfig;
            }
            select = new Select(interfaceType);
            udpConfig = this.selectConfig.get(select);
            if (udpConfig != null) {
                return udpConfig;
            }
        }
        return this.config;
    }

    protected void initCredentials() {
        if (this.serverCredentials == null) {
            try {
                this.serverCredentials = SslContextUtil.loadCredentials("classpath://certs/keyStore.jks", SERVER_NAME, KEY_STORE_PASSWORD, KEY_STORE_PASSWORD);
                this.trustedCertificates = SslContextUtil.loadTrustedCertificates("classpath://certs/trustStore.jks", null, TRUST_STORE_PASSWORD);
                return;
            }
            catch (GeneralSecurityException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.serverCredentials = new SslContextUtil.Credentials(null);
        }
    }

    protected SSLContext getServerSslContext(boolean trustAll, String protocol) {
        this.initCredentials();
        try {
            if (this.serverCredentials.getPrivateKey() != null) {
                KeyManager[] keyManager = SslContextUtil.createKeyManager(SERVER_NAME, this.serverCredentials.getPrivateKey(), this.serverCredentials.getCertificateChain());
                TrustManager[] trustManager = trustAll ? SslContextUtil.createTrustAllManager() : SslContextUtil.createTrustManager(SERVER_NAME, this.trustedCertificates);
                SSLContext sslContext = SSLContext.getInstance(protocol);
                sslContext.init(keyManager, trustManager, null);
                return sslContext;
            }
        }
        catch (GeneralSecurityException e) {
            e.printStackTrace();
        }
        return null;
    }

    public void addEndpoints(List<String> selectAddress, List<InterfaceType> interfaceTypes, List<Protocol> protocols, PlugtestServer.BaseConfig cliConfig) {
        int coapPort = this.config.getInt("COAP_PORT");
        int coapsPort = this.config.getInt("COAP_SECURE_PORT");
        if (protocols.contains((Object)Protocol.DTLS) || protocols.contains((Object)Protocol.TLS)) {
            this.initCredentials();
            this.serverSslContext = this.getServerSslContext(cliConfig.trustall, "TLSv1.2");
            if (this.serverSslContext == null && protocols.contains((Object)Protocol.TLS)) {
                throw new IllegalArgumentException("TLS not supported, credentials missing!");
            }
        }
        ArrayList<InetAddress> used = new ArrayList<InetAddress>();
        for (InetAddress addr : NetworkInterfacesUtil.getNetworkInterfaces()) {
            InetSocketAddress bindToAddress;
            InterfaceType interfaceType;
            if (used.contains(addr) || interfaceTypes != null && !interfaceTypes.isEmpty() && ((!addr.isLoopbackAddress() ? !interfaceTypes.contains((Object)InterfaceType.EXTERNAL) : !interfaceTypes.contains((Object)InterfaceType.LOCAL)) || (!(addr instanceof Inet4Address) ? addr instanceof Inet6Address && !interfaceTypes.contains((Object)InterfaceType.IPV6) : !interfaceTypes.contains((Object)InterfaceType.IPV4)))) continue;
            if (selectAddress != null && !selectAddress.isEmpty()) {
                Matcher matcher;
                boolean found = false;
                String name = addr.getHostAddress();
                for (String filter : selectAddress) {
                    if (!name.matches(filter)) continue;
                    found = true;
                    break;
                }
                if (!found && addr instanceof Inet6Address && (matcher = IPV6_SCOPE.matcher(name)).matches()) {
                    name = matcher.group(1) + "%" + ((Inet6Address)addr).getScopedInterface().getName();
                    for (String filter : selectAddress) {
                        if (!name.matches(filter)) continue;
                        found = true;
                        break;
                    }
                }
                if (!found) continue;
            }
            used.add(addr);
            InterfaceType interfaceType2 = interfaceType = addr.isLoopbackAddress() ? InterfaceType.LOCAL : InterfaceType.EXTERNAL;
            if (protocols.contains((Object)Protocol.UDP) || protocols.contains((Object)Protocol.TCP)) {
                bindToAddress = new InetSocketAddress(addr, coapPort);
                if (protocols.contains((Object)Protocol.UDP)) {
                    NetworkConfig udpConfig = this.getConfig(Protocol.UDP, interfaceType);
                    CoapEndpoint.Builder builder = new CoapEndpoint.Builder();
                    builder.setInetSocketAddress(bindToAddress);
                    builder.setNetworkConfig(udpConfig);
                    CoapEndpoint endpoint = builder.build();
                    this.addEndpoint(endpoint);
                    this.print(endpoint, interfaceType);
                }
                if (protocols.contains((Object)Protocol.TCP)) {
                    NetworkConfig tcpConfig = this.getConfig(Protocol.TCP, interfaceType);
                    int tcpThreads = tcpConfig.getInt("TCP_WORKER_THREADS");
                    int tcpIdleTimeout = tcpConfig.getInt("TCP_CONNECTION_IDLE_TIMEOUT");
                    TcpServerConnector connector = new TcpServerConnector(bindToAddress, tcpThreads, tcpIdleTimeout);
                    CoapEndpoint.Builder builder = new CoapEndpoint.Builder();
                    builder.setConnector(connector);
                    builder.setNetworkConfig(tcpConfig);
                    CoapEndpoint endpoint = builder.build();
                    this.addEndpoint(endpoint);
                    this.print(endpoint, interfaceType);
                }
            }
            if (!protocols.contains((Object)Protocol.DTLS) && !protocols.contains((Object)Protocol.TLS)) continue;
            bindToAddress = new InetSocketAddress(addr, coapsPort);
            if (protocols.contains((Object)Protocol.DTLS)) {
                NetworkConfig dtlsConfig = this.getConfig(Protocol.DTLS, interfaceType);
                int retransmissionTimeout = dtlsConfig.getInt("ACK_TIMEOUT");
                int staleTimeout = dtlsConfig.getInt("MAX_PEER_INACTIVITY_PERIOD");
                int dtlsThreads = dtlsConfig.getInt("NETWORK_STAGE_SENDER_THREAD_COUNT");
                int dtlsReceiverThreads = dtlsConfig.getInt("NETWORK_STAGE_RECEIVER_THREAD_COUNT");
                int maxPeers = dtlsConfig.getInt("MAX_ACTIVE_PEERS");
                int handshakeResultDelay = dtlsConfig.getInt(KEY_DTLS_HANDSHAKE_RESULT_DELAY, 0);
                Integer cidLength = dtlsConfig.getOptInteger("DTLS_CONNECTION_ID_LENGTH");
                Integer cidNode = dtlsConfig.getOptInteger("DTLS_CONNECTION_ID_NODE_ID");
                Integer healthStatusInterval = this.config.getInt("HEALTH_STATUS_INTERVAL");
                Integer recvBufferSize = this.config.getOptInteger("UDP_CONNECTOR_RECEIVE_BUFFER");
                Integer sendBufferSize = this.config.getOptInteger("UDP_CONNECTOR_SEND_BUFFER");
                DtlsConnectorConfig.Builder dtlsConfigBuilder = new DtlsConnectorConfig.Builder();
                if (cidLength != null) {
                    if (cidLength > 4 && cidNode != null) {
                        dtlsConfigBuilder.setConnectionIdGenerator(new MultiNodeConnectionIdGenerator(cidNode, cidLength));
                    } else {
                        dtlsConfigBuilder.setConnectionIdGenerator(new SingleNodeConnectionIdGenerator(cidLength));
                    }
                }
                AsyncAdvancedPskStore asyncPskStore = new AsyncAdvancedPskStore(new PlugPskStore());
                asyncPskStore.setDelay(handshakeResultDelay);
                dtlsConfigBuilder.setAdvancedPskStore(asyncPskStore);
                dtlsConfigBuilder.setAddress(bindToAddress);
                dtlsConfigBuilder.setRecommendedCipherSuitesOnly(false);
                dtlsConfigBuilder.setSupportedCipherSuites(CipherSuite.TLS_PSK_WITH_AES_128_CCM_8, CipherSuite.TLS_ECDHE_PSK_WITH_AES_128_CCM_8_SHA256, CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_128_CCM_8, CipherSuite.TLS_PSK_WITH_AES_128_CBC_SHA256, CipherSuite.TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA256, CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256);
                dtlsConfigBuilder.setIdentity(this.serverCredentials.getPrivateKey(), (Certificate[])this.serverCredentials.getCertificateChain(), CertificateType.RAW_PUBLIC_KEY, CertificateType.X_509);
                AsyncNewAdvancedCertificateVerifier.Builder verifierBuilder = AsyncNewAdvancedCertificateVerifier.builder();
                if (cliConfig.trustall) {
                    verifierBuilder.setTrustAllCertificates();
                } else {
                    verifierBuilder.setTrustedCertificates(this.trustedCertificates);
                }
                verifierBuilder.setTrustAllRPKs();
                AsyncNewAdvancedCertificateVerifier verifier = verifierBuilder.build();
                verifier.setDelay(handshakeResultDelay);
                dtlsConfigBuilder.setAdvancedCertificateVerifier(verifier);
                dtlsConfigBuilder.setMaxConnections(maxPeers);
                dtlsConfigBuilder.setStaleConnectionThreshold(staleTimeout);
                dtlsConfigBuilder.setConnectionThreadCount(dtlsThreads);
                dtlsConfigBuilder.setReceiverThreadCount(dtlsReceiverThreads);
                dtlsConfigBuilder.setHealthStatusInterval(healthStatusInterval);
                dtlsConfigBuilder.setSocketReceiveBufferSize(recvBufferSize);
                dtlsConfigBuilder.setSocketSendBufferSize(sendBufferSize);
                dtlsConfigBuilder.setRetransmissionTimeout(retransmissionTimeout);
                switch (cliConfig.clientAuth) {
                    case NONE: {
                        dtlsConfigBuilder.setClientAuthenticationRequired(false);
                        break;
                    }
                    case WANTED: {
                        dtlsConfigBuilder.setClientAuthenticationWanted(true);
                        break;
                    }
                    case NEEDED: {
                        dtlsConfigBuilder.setClientAuthenticationRequired(true);
                    }
                }
                dtlsConfigBuilder.setConnectionListener(new MdcConnectionListener());
                DTLSConnector connector = new DTLSConnector(dtlsConfigBuilder.build());
                CoapEndpoint.Builder builder = new CoapEndpoint.Builder();
                builder.setConnector(connector);
                if (EndpointContextMatcherFactory.MatcherMode.PRINCIPAL.name().equals(dtlsConfig.getString("RESPONSE_MATCHING"))) {
                    builder.setEndpointContextMatcher(new PrincipalEndpointContextMatcher(true));
                }
                builder.setNetworkConfig(dtlsConfig);
                CoapEndpoint endpoint = builder.build();
                this.addEndpoint(endpoint);
                this.print(endpoint, interfaceType);
            }
            if (!protocols.contains((Object)Protocol.TLS)) continue;
            NetworkConfig tlsConfig = this.getConfig(Protocol.TLS, interfaceType);
            int tcpThreads = tlsConfig.getInt("TCP_WORKER_THREADS");
            int tcpIdleTimeout = tlsConfig.getInt("TCP_CONNECTION_IDLE_TIMEOUT");
            int tlsHandshakeTimeout = tlsConfig.getInt("TLS_HANDSHAKE_TIMEOUT");
            int maxPeers = tlsConfig.getInt("MAX_ACTIVE_PEERS");
            int sessionTimeout = tlsConfig.getInt("SECURE_SESSION_TIMEOUT");
            SSLSessionContext serverSessionContext = this.serverSslContext.getServerSessionContext();
            if (serverSessionContext != null) {
                serverSessionContext.setSessionTimeout(sessionTimeout);
                serverSessionContext.setSessionCacheSize(maxPeers);
            }
            TlsServerConnector connector = new TlsServerConnector(this.serverSslContext, cliConfig.clientAuth, bindToAddress, tcpThreads, tlsHandshakeTimeout, tcpIdleTimeout);
            CoapEndpoint.Builder builder = new CoapEndpoint.Builder();
            builder.setConnector(connector);
            builder.setNetworkConfig(tlsConfig);
            CoapEndpoint endpoint = builder.build();
            this.addEndpoint(endpoint);
            this.print(endpoint, interfaceType);
        }
    }

    protected void print(CoapEndpoint endpoint, InterfaceType interfaceType) {
        LOGGER.info("{}listen on {} ({}) max msg size: {}, block size: {}", new Object[]{this.getTag(), endpoint.getUri(), interfaceType, endpoint.getConfig().getInt("MAX_MESSAGE_SIZE"), endpoint.getConfig().getInt("PREFERRED_BLOCK_SIZE")});
    }

    public static class PlugPskStore
    implements AdvancedPskStore {
        private final PskPublicInformation identity = new PskPublicInformation("cali.sandbox");

        private SecretKey getKey(String identity) {
            if (identity.startsWith(AbstractTestServer.PSK_IDENTITY_PREFIX)) {
                return SecretUtil.create(PSK_SECRET);
            }
            if (identity.equals(AbstractTestServer.ETSI_PSK_IDENTITY)) {
                return SecretUtil.create(ETSI_PSK_SECRET);
            }
            if (identity.equals(AbstractTestServer.OPENSSL_PSK_IDENTITY)) {
                return SecretUtil.create(OPENSSL_PSK_SECRET);
            }
            if (HONO_IDENTITY_PATTERN.matcher(identity).matches()) {
                return SecretUtil.create(HONO_PSK_SECRET);
            }
            return null;
        }

        @Override
        public boolean hasEcdhePskSupported() {
            return true;
        }

        @Override
        public PskSecretResult requestPskSecretResult(ConnectionId cid, ServerNames serverName, PskPublicInformation identity, String hmacAlgorithm, SecretKey otherSecret, byte[] seed, boolean useExtendedMasterSecret) {
            SecretKey key = this.getKey(identity.getPublicInfoAsString());
            return new PskSecretResult(cid, identity, key);
        }

        @Override
        public PskPublicInformation getIdentity(InetSocketAddress peerAddress, ServerNames virtualHost) {
            return this.identity;
        }

        @Override
        public void setResultHandler(HandshakeResultHandler resultHandler) {
        }
    }

    public static class Select {
        public final Protocol protocol;
        public final InterfaceType interfaceType;

        public Select(Protocol protocol) {
            this.protocol = protocol;
            this.interfaceType = null;
        }

        public Select(InterfaceType interfaceType) {
            this.protocol = null;
            this.interfaceType = interfaceType;
        }

        public Select(Protocol protocol, InterfaceType interfaceType) {
            this.protocol = protocol;
            this.interfaceType = interfaceType;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.interfaceType == null ? 0 : this.interfaceType.hashCode());
            result = 31 * result + (this.protocol == null ? 0 : this.protocol.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Select other = (Select)obj;
            if (this.interfaceType != other.interfaceType) {
                return false;
            }
            return this.protocol == other.protocol;
        }
    }

    public static enum InterfaceType {
        LOCAL,
        EXTERNAL,
        IPV4,
        IPV6;

    }

    public static enum Protocol {
        UDP,
        DTLS,
        TCP,
        TLS;

    }
}

