/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.cbor;

import com.upokecenter.numbers.EContext;
import com.upokecenter.numbers.EDecimal;
import com.upokecenter.numbers.EFloat;
import com.upokecenter.numbers.EInteger;
import com.upokecenter.numbers.ERounding;
import com.upokecenter.util.DataUtilities;

final class CBORUtilities {
    private static final long DoublePosInfinity = 0x7FF0000000000000L;
    private static final String HexAlphabet = "0123456789ABCDEF";
    private static final int[] ValueNormalDays = new int[]{0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final int[] ValueLeapDays = new int[]{0, 31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final int[] ValueNormalToMonth = new int[]{0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334, 365};
    private static final int[] ValueLeapToMonth = new int[]{0, 31, 60, 91, 121, 152, 182, 213, 244, 274, 305, 335, 366};

    private CBORUtilities() {
    }

    public static int CompareStringsAsUtf8LengthFirst(String strA, String strB) {
        if (strA == null) {
            return strB == null ? 0 : -1;
        }
        if (strB == null) {
            return 1;
        }
        if (strA.length() == 0) {
            return strB.length() == 0 ? 0 : -1;
        }
        if (strB.length() == 0) {
            return strA.length() == 0 ? 0 : 1;
        }
        int cmp = 0;
        if (strA.length() < 128 && strB.length() < 128) {
            int i;
            int istrAUpperBound = strA.length() * 3;
            if (istrAUpperBound < strB.length()) {
                return -1;
            }
            int istrBUpperBound = strB.length() * 3;
            if (istrBUpperBound < strA.length()) {
                return 1;
            }
            cmp = 0;
            if (strA.length() == strB.length()) {
                boolean equalStrings = true;
                for (i = 0; i < strA.length(); ++i) {
                    if (strA.charAt(i) == strB.charAt(i)) continue;
                    equalStrings = false;
                    cmp = strA.charAt(i) < strB.charAt(i) ? -1 : 1;
                    break;
                }
                if (equalStrings) {
                    return 0;
                }
            }
            boolean nonAscii = false;
            for (i = 0; i < strA.length(); ++i) {
                if (strA.charAt(i) < '\u0080') continue;
                nonAscii = true;
                break;
            }
            for (i = 0; i < strB.length(); ++i) {
                if (strB.charAt(i) < '\u0080') continue;
                nonAscii = true;
                break;
            }
            if (!nonAscii) {
                if (strA.length() != strB.length()) {
                    return strA.length() < strB.length() ? -1 : 1;
                }
                if (strA.length() == strB.length()) {
                    return cmp;
                }
            }
        } else {
            long strAUpperBound = strA.length() * 3;
            if (strAUpperBound < (long)strB.length()) {
                return -1;
            }
            long strBUpperBound = strB.length() * 3;
            if (strBUpperBound < (long)strA.length()) {
                return 1;
            }
        }
        int sapos = 0;
        int sbpos = 0;
        long sautf8 = 0L;
        long sbutf8 = 0L;
        cmp = 0;
        boolean haveboth = true;
        while (true) {
            int sa = 0;
            int sb = 0;
            if (sapos == strA.length()) {
                haveboth = false;
                if (sbutf8 > sautf8) {
                    return -1;
                }
                if (sbpos == strB.length()) break;
                if (cmp == 0) {
                    cmp = -1;
                }
            } else {
                sa = DataUtilities.CodePointAt(strA, sapos, 1);
                if (sa < 0) {
                    throw new IllegalArgumentException("strA has unpaired surrogate");
                }
                if (sa >= 65536) {
                    sautf8 += 4L;
                    sapos += 2;
                } else if (sa >= 2048) {
                    sautf8 += 3L;
                    ++sapos;
                } else if (sa >= 128) {
                    sautf8 += 2L;
                    ++sapos;
                } else {
                    ++sautf8;
                    ++sapos;
                }
            }
            if (sbpos == strB.length()) {
                haveboth = false;
                if (sautf8 > sbutf8) {
                    return 1;
                }
                if (sapos == strA.length()) break;
                if (cmp == 0) {
                    cmp = 1;
                }
            } else {
                sb = DataUtilities.CodePointAt(strB, sbpos, 1);
                if (sb < 0) {
                    throw new IllegalArgumentException("strB has unpaired surrogate");
                }
                if (sb >= 65536) {
                    sbutf8 += 4L;
                    sbpos += 2;
                } else if (sb >= 2048) {
                    sbutf8 += 3L;
                    ++sbpos;
                } else if (sb >= 128) {
                    ++sbpos;
                    sbutf8 += 2L;
                } else {
                    ++sbpos;
                    ++sbutf8;
                }
            }
            if (!haveboth || cmp != 0 || sa == sb) continue;
            cmp = sa < sb ? -1 : 1;
        }
        return sautf8 != sbutf8 ? (sautf8 < sbutf8 ? -1 : 1) : cmp;
    }

    public static int CompareUtf16Utf8LengthFirst(String utf16, byte[] utf8) {
        if (utf16 == null) {
            return utf8 == null ? 0 : -1;
        }
        if (utf8 == null) {
            return 1;
        }
        if (utf16.length() == 0) {
            return utf8.length == 0 ? 0 : -1;
        }
        if (utf16.length() == 0) {
            return utf8.length == 0 ? 0 : 1;
        }
        long strAUpperBound = utf16.length() * 3;
        if (strAUpperBound < (long)utf8.length) {
            return -1;
        }
        long strBUpperBound = utf16.length() * 3;
        if (strBUpperBound < (long)utf8.length) {
            return 1;
        }
        int u16pos = 0;
        int u8pos = 0;
        long u16u8length = 0L;
        int cmp = 0;
        boolean haveboth = true;
        while (true) {
            int u16 = 0;
            int u8 = 0;
            if (u16pos == utf16.length()) {
                haveboth = false;
                if ((long)u8pos > u16u8length) {
                    return -1;
                }
                if (u8pos == utf8.length) break;
                if (cmp == 0) {
                    cmp = -1;
                }
            } else {
                u16 = DataUtilities.CodePointAt(utf16, u16pos, 1);
                if (u16 < 0) {
                    throw new IllegalArgumentException("utf16 has unpaired surrogate");
                }
                if (u16 >= 65536) {
                    u16u8length += 4L;
                    u16pos += 2;
                } else if (u16 >= 2048) {
                    u16u8length += 3L;
                    ++u16pos;
                } else if (u16 >= 128) {
                    u16u8length += 2L;
                    ++u16pos;
                } else {
                    ++u16u8length;
                    ++u16pos;
                }
            }
            if (u8pos == utf8.length) {
                haveboth = false;
                if (cmp == 0) {
                    return 1;
                }
                if (u16pos == utf16.length()) break;
                if (cmp == 0) {
                    cmp = 1;
                }
            } else {
                u8 = CBORUtilities.Utf8CodePointAt(utf8, u8pos);
                if (u8 < 0) {
                    throw new IllegalArgumentException("utf8 has invalid encoding");
                }
                u8pos = u8 >= 65536 ? (u8pos += 4) : (u8 >= 2048 ? (u8pos += 3) : (u8 >= 128 ? (u8pos += 2) : ++u8pos));
            }
            if (!haveboth || cmp != 0 || u16 == u8) continue;
            cmp = u16 < u8 ? -1 : 1;
        }
        return u16u8length != (long)u8pos ? (u16u8length < (long)u8pos ? -1 : 1) : cmp;
    }

    public static int Utf8CodePointAt(byte[] utf8, int offset) {
        int endPos = utf8.length;
        if (offset < 0 || offset >= endPos) {
            return -1;
        }
        int c = utf8[offset] & 0xFF;
        if (c <= 127) {
            return c;
        }
        if (c >= 194 && c <= 223) {
            int c1 = ++offset < endPos ? utf8[offset] & 0xFF : -1;
            return c1 < 128 || c1 > 191 ? -2 : c - 192 << 6 | c1 - 128;
        }
        if (c >= 224 && c <= 239) {
            int c1 = ++offset < endPos ? utf8[offset++] & 0xFF : -1;
            int c2 = offset < endPos ? utf8[offset] & 0xFF : -1;
            int lower = c == 224 ? 160 : 128;
            int upper = c == 237 ? 159 : 191;
            return c1 < lower || c1 > upper || c2 < 128 || c2 > 191 ? -2 : c - 224 << 12 | c1 - 128 << 6 | c2 - 128;
        }
        if (c >= 240 && c <= 244) {
            int upper;
            int c1 = ++offset < endPos ? utf8[offset++] & 0xFF : -1;
            int c2 = offset < endPos ? utf8[offset++] & 0xFF : -1;
            int c3 = offset < endPos ? utf8[offset] & 0xFF : -1;
            int lower = c == 240 ? 144 : 128;
            int n = upper = c == 244 ? 143 : 191;
            if (c1 < lower || c1 > upper || c2 < 128 || c2 > 191 || c3 < 128 || c3 > 191) {
                return -2;
            }
            return c - 240 << 18 | c1 - 128 << 12 | c2 - 128 << 6 | c3 - 128;
        }
        return -2;
    }

    public static int StringHashCode(String str) {
        int upos = 0;
        int code = 2128535065;
        while (upos != str.length()) {
            int sc = DataUtilities.CodePointAt(str, upos, 1);
            if (sc < 0) {
                return code;
            }
            code = code * 31 + sc;
            if (sc >= 65536) {
                upos += 2;
                continue;
            }
            ++upos;
        }
        return code;
    }

    public static int Utf8HashCode(byte[] utf8) {
        int upos = 0;
        int code = 2128535065;
        int sc;
        while ((sc = CBORUtilities.Utf8CodePointAt(utf8, upos)) != -1) {
            if (sc == -2) {
                return code;
            }
            code = code * 31 + sc;
            if (sc >= 65536) {
                upos += 4;
                continue;
            }
            if (sc >= 2048) {
                upos += 3;
                continue;
            }
            if (sc >= 128) {
                upos += 2;
                continue;
            }
            ++upos;
        }
        return code;
    }

    public static boolean CheckUtf16(String str) {
        int upos = 0;
        while (upos != str.length()) {
            int sc = DataUtilities.CodePointAt(str, upos, 1);
            if (sc < 0) {
                return false;
            }
            if (sc >= 65536) {
                upos += 2;
                continue;
            }
            ++upos;
        }
        return true;
    }

    public static boolean CheckUtf8(byte[] utf8) {
        int upos = 0;
        int sc;
        while ((sc = CBORUtilities.Utf8CodePointAt(utf8, upos)) != -1) {
            if (sc == -2) {
                return false;
            }
            if (sc >= 65536) {
                upos += 4;
                continue;
            }
            if (sc >= 2048) {
                upos += 3;
                continue;
            }
            if (sc >= 128) {
                upos += 2;
                continue;
            }
            ++upos;
        }
        return true;
    }

    public static boolean StringEqualsUtf8(String str, byte[] utf8) {
        if (str == null) {
            return utf8 == null;
        }
        if (utf8 == null) {
            return false;
        }
        long strAUpperBound = str.length() * 3;
        if (strAUpperBound < (long)utf8.length) {
            return false;
        }
        long strBUpperBound = utf8.length * 3;
        if (strBUpperBound < (long)str.length()) {
            return false;
        }
        int spos = 0;
        int upos = 0;
        while (true) {
            int sc = DataUtilities.CodePointAt(str, spos, 1);
            int uc = CBORUtilities.Utf8CodePointAt(utf8, upos);
            if (uc == -2) {
                throw new IllegalStateException("Invalid encoding");
            }
            if (sc == -1) {
                return uc == -1;
            }
            if (sc != uc) {
                return false;
            }
            if (sc >= 65536) {
                spos += 2;
                upos += 4;
                continue;
            }
            if (sc >= 2048) {
                ++spos;
                upos += 3;
                continue;
            }
            if (sc >= 128) {
                ++spos;
                upos += 2;
                continue;
            }
            ++spos;
            ++upos;
        }
    }

    public static boolean ByteArrayEquals(byte[] a, byte[] b) {
        if (a == null) {
            return b == null;
        }
        if (b == null) {
            return false;
        }
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    public static int ByteArrayHashCode(byte[] a) {
        if (a == null) {
            return 0;
        }
        int ret = 19;
        ret = ret * 31 + a.length;
        for (int i = 0; i < a.length; ++i) {
            ret = ret * 31 + a[i];
        }
        return ret;
    }

    public static int ByteArrayCompare(byte[] a, byte[] b) {
        if (a == null) {
            return b == null ? 0 : -1;
        }
        if (b == null) {
            return 1;
        }
        int c = Math.min(a.length, b.length);
        for (int i = 0; i < c; ++i) {
            if (a[i] == b[i]) continue;
            return a[i] < b[i] ? -1 : 1;
        }
        return a.length != b.length ? (a.length < b.length ? -1 : 1) : 0;
    }

    public static int ByteArrayCompareLengthFirst(byte[] a, byte[] b) {
        if (a == null) {
            return b == null ? 0 : -1;
        }
        if (b == null) {
            return 1;
        }
        if (a.length != b.length) {
            return a.length < b.length ? -1 : 1;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == b[i]) continue;
            return a[i] < b[i] ? -1 : 1;
        }
        return 0;
    }

    public static String TrimDotZero(String str) {
        return str.length() > 2 && str.charAt(str.length() - 1) == '0' && str.charAt(str.length() - 2) == '.' ? str.substring(0, str.length() - 2) : str;
    }

    public static long DoubleToInt64Bits(double dbl) {
        return Double.doubleToRawLongBits(dbl);
    }

    public static int SingleToInt32Bits(float flt) {
        return Float.floatToRawIntBits(flt);
    }

    public static double Int64BitsToDouble(long bits) {
        return Double.longBitsToDouble(bits);
    }

    public static float Int32BitsToSingle(int bits) {
        return Float.intBitsToFloat(bits);
    }

    @Deprecated
    public static String DoubleToString(double dbl) {
        return EFloat.FromDouble(dbl).ToShortestString(EContext.Binary64);
    }

    public static String DoubleBitsToString(long dblbits) {
        return EFloat.FromDoubleBits(dblbits).ToShortestString(EContext.Binary64);
    }

    @Deprecated
    public static String SingleToString(float sing) {
        return EFloat.FromSingle(sing).ToShortestString(EContext.Binary32);
    }

    public static String LongToString(long longValue) {
        char digit;
        long divValue;
        if (longValue == Long.MIN_VALUE) {
            return "-9223372036854775808";
        }
        if (longValue == 0L) {
            return "0";
        }
        if (longValue == Integer.MIN_VALUE) {
            return "-2147483648";
        }
        boolean neg = longValue < 0L;
        int count = 0;
        int intlongValue = (int)longValue;
        if ((long)intlongValue == longValue) {
            char digit2;
            int intdivValue;
            char[] chars = new char[12];
            count = 11;
            if (neg) {
                intlongValue = -intlongValue;
            }
            while (intlongValue > 43698) {
                intdivValue = intlongValue / 10;
                digit2 = HexAlphabet.charAt(intlongValue - intdivValue * 10);
                chars[count--] = digit2;
                intlongValue = intdivValue;
            }
            while (intlongValue > 9) {
                intdivValue = intlongValue * 26215 >> 18;
                digit2 = HexAlphabet.charAt(intlongValue - intdivValue * 10);
                chars[count--] = digit2;
                intlongValue = intdivValue;
            }
            if (intlongValue != 0) {
                chars[count--] = HexAlphabet.charAt(intlongValue);
            }
            if (neg) {
                chars[count] = 45;
            } else {
                ++count;
            }
            return new String(chars, count, 12 - count);
        }
        char[] chars = new char[24];
        count = 23;
        if (neg) {
            longValue = -longValue;
        }
        while (longValue > 43698L) {
            divValue = longValue / 10L;
            digit = HexAlphabet.charAt((int)(longValue - divValue * 10L));
            chars[count--] = digit;
            longValue = divValue;
        }
        while (longValue > 9L) {
            divValue = longValue * 26215L >> 18;
            digit = HexAlphabet.charAt((int)(longValue - divValue * 10L));
            chars[count--] = digit;
            longValue = divValue;
        }
        if (longValue != 0L) {
            chars[count--] = HexAlphabet.charAt((int)longValue);
        }
        if (neg) {
            chars[count] = 45;
        } else {
            ++count;
        }
        return new String(chars, count, 24 - count);
    }

    private static EInteger FloorDiv(EInteger a, EInteger n) {
        return a.signum() >= 0 ? a.Divide(n) : EInteger.FromInt32(-1).Subtract(EInteger.FromInt32(-1).Subtract(a).Divide(n));
    }

    private static EInteger FloorMod(EInteger a, EInteger n) {
        return a.Subtract(CBORUtilities.FloorDiv(a, n).Multiply(n));
    }

    public static void GetNormalizedPartProlepticGregorian(EInteger year, int month, EInteger day, EInteger[] dest) {
        EInteger count;
        int[] dayArray;
        if (month <= 0 || month > 12) {
            throw new IllegalArgumentException("month");
        }
        int[] nArray = dayArray = year.Remainder(4).signum() != 0 || year.Remainder(100).signum() == 0 && year.Remainder(400).signum() != 0 ? ValueNormalDays : ValueLeapDays;
        if (day.compareTo(100) > 0) {
            count = day.Divide(146097);
            day = day.Subtract(count.Multiply(146097));
            year = year.Add(count.Multiply(400));
        }
        if (day.compareTo(-101) < 0) {
            count = day.Abs().Divide(146097);
            day = day.Add(count.Multiply(146097));
            year = year.Subtract(count.Multiply(400));
        }
        while (true) {
            EInteger days = EInteger.FromInt32(dayArray[month]);
            if (day.signum() > 0 && day.compareTo(days) <= 0) break;
            if (day.compareTo(days) > 0) {
                day = day.Subtract(days);
                if (month == 12) {
                    month = 1;
                    dayArray = (year = year.Add(1)).Remainder(4).signum() != 0 || year.Remainder(100).signum() == 0 && year.Remainder(400).signum() != 0 ? ValueNormalDays : ValueLeapDays;
                } else {
                    ++month;
                }
            }
            if (day.signum() > 0) continue;
            if (--month <= 0) {
                year = year.Add(-1);
                month = 12;
            }
            dayArray = year.Remainder(4).signum() != 0 || year.Remainder(100).signum() == 0 && year.Remainder(400).signum() != 0 ? ValueNormalDays : ValueLeapDays;
            day = day.Add(dayArray[month]);
        }
        dest[0] = year;
        dest[1] = EInteger.FromInt32(month);
        dest[2] = day;
    }

    public static EInteger GetNumberOfDaysProlepticGregorian(EInteger year, int month, int mday) {
        if (month <= 0 || month > 12) {
            throw new IllegalArgumentException("month");
        }
        if (mday <= 0 || mday > 31) {
            throw new IllegalArgumentException("mday");
        }
        EInteger numDays = EInteger.FromInt32(0);
        int startYear = 1970;
        if (year.compareTo(startYear) < 0) {
            EInteger currentYear = EInteger.FromInt32(startYear - 1);
            EInteger diff = currentYear.Subtract(year);
            if (diff.compareTo(401) > 0) {
                EInteger blocks = diff.Subtract(401).Divide(400);
                numDays = numDays.Subtract(blocks.Multiply(146097));
                diff = diff.Subtract(blocks.Multiply(400));
                currentYear = currentYear.Subtract(blocks.Multiply(400));
            }
            numDays = numDays.Subtract(diff.Multiply(365));
            int decrement = 1;
            while (currentYear.compareTo(year) > 0) {
                if (decrement == 1 && currentYear.Remainder(4).signum() == 0) {
                    decrement = 4;
                }
                if (currentYear.Remainder(4).signum() == 0 && (currentYear.Remainder(100).signum() != 0 || currentYear.Remainder(400).signum() == 0)) {
                    numDays = numDays.Subtract(1);
                }
                currentYear = currentYear.Subtract(decrement);
            }
            numDays = year.Remainder(4).signum() != 0 || year.Remainder(100).signum() == 0 && year.Remainder(400).signum() != 0 ? numDays.Subtract(365 - ValueNormalToMonth[month]).Subtract(ValueNormalDays[month] - mday + 1) : numDays.Subtract(366 - ValueLeapToMonth[month]).Subtract(ValueLeapDays[month] - mday + 1);
        } else {
            boolean isNormalYear = year.Remainder(4).signum() != 0 || year.Remainder(100).signum() == 0 && year.Remainder(400).signum() != 0;
            EInteger currentYear = EInteger.FromInt32(startYear);
            if (currentYear.Add(401).compareTo(year) < 0) {
                EInteger y2 = year.Subtract(2);
                numDays = numDays.Add(y2.Subtract(startYear).Divide(400).Multiply(146097));
                currentYear = y2.Subtract(y2.Subtract(startYear).Remainder(400));
            }
            EInteger diff = year.Subtract(currentYear);
            numDays = numDays.Add(diff.Multiply(365));
            EInteger eileap = currentYear;
            if (currentYear.Remainder(4).signum() != 0) {
                eileap = eileap.Add(4 - eileap.Remainder(4).ToInt32Checked());
            }
            numDays = numDays.Add(year.Subtract(eileap).Add(3).Divide(4));
            if (currentYear.Remainder(100).signum() != 0) {
                currentYear = currentYear.Add(100 - currentYear.Remainder(100).ToInt32Checked());
            }
            while (currentYear.compareTo(year) < 0) {
                if (currentYear.Remainder(400).signum() != 0) {
                    numDays = numDays.Subtract(1);
                }
                currentYear = currentYear.Add(100);
            }
            int yearToMonth = isNormalYear ? ValueNormalToMonth[month - 1] : ValueLeapToMonth[month - 1];
            numDays = numDays.Add(yearToMonth).Add(mday - 1);
        }
        return numDays;
    }

    public static void BreakDownSecondsSinceEpoch(EDecimal edec, EInteger[] year, int[] lesserFields) {
        EInteger integerPart = edec.Quantize(0, ERounding.Floor).ToEInteger();
        EDecimal fractionalPart = edec.Abs().Subtract(EDecimal.FromEInteger(integerPart).Abs());
        int nanoseconds = fractionalPart.Multiply(1000000000).ToInt32Checked();
        EInteger[] normPart = new EInteger[3];
        EInteger days = CBORUtilities.FloorDiv(integerPart, EInteger.FromInt32(86400)).Add(1);
        int secondsInDay = CBORUtilities.FloorMod(integerPart, EInteger.FromInt32(86400)).ToInt32Checked();
        CBORUtilities.GetNormalizedPartProlepticGregorian(EInteger.FromInt32(1970), 1, days, normPart);
        lesserFields[0] = normPart[1].ToInt32Checked();
        lesserFields[1] = normPart[2].ToInt32Checked();
        lesserFields[2] = secondsInDay / 3600;
        lesserFields[3] = secondsInDay % 3600 / 60;
        lesserFields[4] = secondsInDay % 60;
        lesserFields[5] = nanoseconds / 100;
        lesserFields[6] = 0;
        year[0] = normPart[0];
    }

    public static boolean NameStartsWithWord(String name, String word) {
        int wl = word.length();
        return !(name.length() <= wl || !name.substring(0, wl).equals(word) || name.charAt(wl) >= 'a' && name.charAt(wl) <= 'z' || name.charAt(wl) >= '0' && name.charAt(wl) <= '9');
    }

    public static String FirstCharLower(String name) {
        if (name.length() > 0 && name.charAt(0) >= 'A' && name.charAt(0) <= 'Z') {
            StringBuilder sb = new StringBuilder();
            sb.append((char)(name.charAt(0) + 32));
            sb.append(name.substring(1));
            return sb.toString();
        }
        return name;
    }

    public static String FirstCharUpper(String name) {
        if (name.length() > 0 && name.charAt(0) >= 'a' && name.charAt(0) <= 'z') {
            StringBuilder sb = new StringBuilder();
            sb.append((char)(name.charAt(0) - 32));
            sb.append(name.substring(1));
            return sb.toString();
        }
        return name;
    }

    private static boolean IsValidDateTime(int[] dateTime) {
        if (dateTime == null || dateTime.length < 8) {
            return false;
        }
        if (dateTime[1] < 1 || dateTime[1] > 12 || dateTime[2] < 1) {
            return false;
        }
        boolean leap = CBORUtilities.IsLeapYear(dateTime[0]);
        if (dateTime[1] == 4 || dateTime[1] == 6 || dateTime[1] == 9 || dateTime[1] == 11 ? dateTime[2] > 30 : (dateTime[1] == 2 ? dateTime[2] > (leap ? 29 : 28) : dateTime[2] > 31)) {
            return false;
        }
        return dateTime[3] >= 0 && dateTime[4] >= 0 && dateTime[5] >= 0 && dateTime[3] < 24 && dateTime[4] < 60 && dateTime[5] < 61 && dateTime[6] >= 0 && dateTime[6] < 1000000000 && dateTime[7] > -1440 && dateTime[7] < 1440;
    }

    private static boolean IsLeapYear(int yr) {
        if ((yr %= 400) < 0) {
            yr += 400;
        }
        return yr % 4 == 0 && yr % 100 != 0 || yr % 400 == 0;
    }

    public static void ParseAtomDateTimeString(String str, EInteger[] bigYearArray, int[] lf) {
        int[] d = CBORUtilities.ParseAtomDateTimeString(str);
        bigYearArray[0] = EInteger.FromInt32(d[0]);
        System.arraycopy(d, 1, lf, 0, 7);
    }

    private static int[] ParseAtomDateTimeString(String str) {
        boolean bad = false;
        if (str.length() < 19) {
            throw new IllegalArgumentException("Invalid date/time");
        }
        for (int i = 0; i < 19 && !bad; ++i) {
            if (i == 4 || i == 7) {
                bad |= str.charAt(i) != '-';
                continue;
            }
            if (i == 13 || i == 16) {
                bad |= str.charAt(i) != ':';
                continue;
            }
            if (i == 10) {
                bad |= str.charAt(i) != 'T';
                continue;
            }
            bad |= str.charAt(i) < '0' || str.charAt(i) > '9';
        }
        if (bad) {
            throw new IllegalArgumentException("Invalid date/time");
        }
        int year = (str.charAt(0) - 48) * 1000 + (str.charAt(1) - 48) * 100 + (str.charAt(2) - 48) * 10 + (str.charAt(3) - 48);
        int month = (str.charAt(5) - 48) * 10 + (str.charAt(6) - 48);
        int day = (str.charAt(8) - 48) * 10 + (str.charAt(9) - 48);
        int hour = (str.charAt(11) - 48) * 10 + (str.charAt(12) - 48);
        int minute = (str.charAt(14) - 48) * 10 + (str.charAt(15) - 48);
        int second = (str.charAt(17) - 48) * 10 + (str.charAt(18) - 48);
        int index = 19;
        int nanoSeconds = 0;
        if (index <= str.length() && str.charAt(index) == '.') {
            int icount = 0;
            ++index;
            while (index < str.length() && str.charAt(index) >= '0' && str.charAt(index) <= '9') {
                if (icount < 9) {
                    nanoSeconds = nanoSeconds * 10 + (str.charAt(index) - 48);
                    ++icount;
                }
                ++index;
            }
            while (icount < 9) {
                nanoSeconds *= 10;
                ++icount;
            }
        }
        int utcToLocal = 0;
        if (index + 1 == str.length() && str.charAt(index) == 'Z') {
            utcToLocal = 0;
        } else if (index + 6 == str.length()) {
            bad = false;
            for (int i = 0; i < 6 && !bad; ++i) {
                if (i == 0) {
                    bad |= str.charAt(index + i) != '-' && str.charAt(index + i) != '+';
                    continue;
                }
                if (i == 3) {
                    bad |= str.charAt(index + i) != ':';
                    continue;
                }
                bad |= str.charAt(index + i) < '0' || str.charAt(index + i) > '9';
            }
            if (bad) {
                throw new IllegalArgumentException("Invalid date/time");
            }
            boolean neg = str.charAt(index) == '-';
            int tzhour = (str.charAt(index + 1) - 48) * 10 + (str.charAt(index + 2) - 48);
            int tzminute = (str.charAt(index + 4) - 48) * 10 + (str.charAt(index + 5) - 48);
            if (tzminute >= 60) {
                throw new IllegalArgumentException("Invalid date/time");
            }
            utcToLocal = (neg ? -1 : 1) * (tzhour * 60) + tzminute;
        } else {
            throw new IllegalArgumentException("Invalid date/time");
        }
        int[] dt = new int[]{year, month, day, hour, minute, second, nanoSeconds, utcToLocal};
        if (!CBORUtilities.IsValidDateTime(dt)) {
            throw new IllegalArgumentException("Invalid date/time");
        }
        return dt;
    }

    public static String ToAtomDateTimeString(EInteger bigYear, int[] lesserFields) {
        if (lesserFields[6] != 0) {
            throw new UnsupportedOperationException("Local time offsets not supported");
        }
        int smallYear = bigYear.ToInt32Checked();
        if (smallYear < 0) {
            throw new IllegalArgumentException("year(" + smallYear + ") is not greater or equal to 0");
        }
        if (smallYear > 9999) {
            throw new IllegalArgumentException("year(" + smallYear + ") is not less or equal to 9999");
        }
        int month = lesserFields[0];
        int day = lesserFields[1];
        int hour = lesserFields[2];
        int minute = lesserFields[3];
        int second = lesserFields[4];
        int fracSeconds = lesserFields[5];
        char[] charbuf = new char[32];
        charbuf[0] = (char)(48 + smallYear / 1000 % 10);
        charbuf[1] = (char)(48 + smallYear / 100 % 10);
        charbuf[2] = (char)(48 + smallYear / 10 % 10);
        charbuf[3] = (char)(48 + smallYear % 10);
        charbuf[4] = 45;
        charbuf[5] = (char)(48 + month / 10 % 10);
        charbuf[6] = (char)(48 + month % 10);
        charbuf[7] = 45;
        charbuf[8] = (char)(48 + day / 10 % 10);
        charbuf[9] = (char)(48 + day % 10);
        charbuf[10] = 84;
        charbuf[11] = (char)(48 + hour / 10 % 10);
        charbuf[12] = (char)(48 + hour % 10);
        charbuf[13] = 58;
        charbuf[14] = (char)(48 + minute / 10 % 10);
        charbuf[15] = (char)(48 + minute % 10);
        charbuf[16] = 58;
        charbuf[17] = (char)(48 + second / 10 % 10);
        charbuf[18] = (char)(48 + second % 10);
        int charbufLength = 19;
        if (fracSeconds > 0) {
            charbuf[19] = 46;
            ++charbufLength;
            int index = 20;
            for (int digitdiv = 100000000; digitdiv > 0 && fracSeconds != 0; digitdiv /= 10) {
                int digit = fracSeconds / digitdiv % 10;
                fracSeconds -= digit * digitdiv;
                charbuf[index++] = (char)(48 + digit);
                ++charbufLength;
            }
            charbuf[index] = 90;
            ++charbufLength;
        } else {
            charbuf[19] = 90;
            ++charbufLength;
        }
        return new String(charbuf, 0, charbufLength);
    }

    public static long IntegerToDoubleBits(int i) {
        if (i == Integer.MIN_VALUE) {
            return -4476578029606273024L;
        }
        long longmant = Math.abs(i);
        int expo = 0;
        while (longmant < 0x100000L) {
            longmant <<= 1;
            --expo;
        }
        longmant &= 0xFFFFFFFFFFFFFL;
        longmant |= (long)(expo + 1075) << 52;
        if (i < 0) {
            longmant |= Long.MIN_VALUE;
        }
        return longmant;
    }

    public static boolean IsBeyondSafeRange(long bits) {
        return (bits &= Long.MAX_VALUE) >= 0x7FF0000000000000L || bits > 0x433FFFFFFFFFFFFFL;
    }

    public static boolean IsIntegerValue(long bits) {
        if ((bits &= Long.MAX_VALUE) == 0L) {
            return true;
        }
        if (bits >= 0x7FF0000000000000L) {
            return false;
        }
        if (bits >> 52 >= 1075L) {
            return true;
        }
        if (bits >> 52 <= 1022L) {
            return false;
        }
        long mant = bits & 0xFFFFFFFFFFFFFL;
        int exp = (int)(bits >> 52);
        int shift = 52 - (exp - 1023);
        return mant >> shift << shift == mant;
    }

    public static long GetIntegerValue(long bits) {
        long sgn;
        long l = sgn = bits >> 63 != 0L ? -1L : 1L;
        if ((bits &= Long.MAX_VALUE) == 0L) {
            return 0L;
        }
        if (bits >= 0x7FF0000000000000L) {
            throw new UnsupportedOperationException();
        }
        if (bits >> 52 >= 1076L) {
            throw new UnsupportedOperationException();
        }
        if (bits >> 52 <= 1022L) {
            throw new UnsupportedOperationException();
        }
        int exp = (int)(bits >> 52);
        long mant = bits & 0xFFFFFFFFFFFFFL;
        int shift = 52 - (exp - 1023);
        return ((mant |= 0x10000000000000L) >> shift) * sgn;
    }

    @Deprecated
    public static EInteger EIntegerFromDouble(double dbl) {
        return CBORUtilities.EIntegerFromDoubleBits(Double.doubleToRawLongBits(dbl));
    }

    public static EInteger EIntegerFromDoubleBits(long lvalue) {
        boolean neg;
        int value0 = (int)(lvalue & 0xFFFFFFFFL);
        int value1 = (int)(lvalue >> 32 & 0xFFFFFFFFL);
        int floatExponent = value1 >> 20 & 0x7FF;
        boolean bl = neg = value1 >> 31 != 0;
        if (floatExponent == 2047) {
            throw new ArithmeticException("Value is infinity or NaN");
        }
        value1 &= 0xFFFFF;
        if (floatExponent == 0) {
            ++floatExponent;
        } else {
            value1 |= 0x100000;
        }
        if ((value1 | value0) != 0) {
            while ((value0 & 1) == 0) {
                value0 >>= 1;
                value0 &= Integer.MAX_VALUE;
                value0 |= value1 << 31;
                value1 >>= 1;
                ++floatExponent;
            }
        }
        byte[] bytes = new byte[]{(byte)(value0 & 0xFF), (byte)(value0 >> 8 & 0xFF), (byte)(value0 >> 16 & 0xFF), (byte)(value0 >> 24 & 0xFF), (byte)(value1 & 0xFF), (byte)(value1 >> 8 & 0xFF), (byte)(value1 >> 16 & 0xFF), (byte)(value1 >> 24 & 0xFF), 0};
        EInteger bigmantissa = EInteger.FromBytes(bytes, true);
        if ((floatExponent -= 1075) == 0) {
            if (neg) {
                bigmantissa = bigmantissa.Negate();
            }
            return bigmantissa;
        }
        if (floatExponent > 0) {
            bigmantissa = bigmantissa.ShiftLeft(floatExponent);
            if (neg) {
                bigmantissa = bigmantissa.Negate();
            }
            return bigmantissa;
        }
        int exp = -floatExponent;
        bigmantissa = bigmantissa.ShiftRight(exp);
        if (neg) {
            bigmantissa = bigmantissa.Negate();
        }
        return bigmantissa;
    }

    public static boolean DoubleBitsNaN(long bits) {
        return (bits &= Long.MAX_VALUE) > 0x7FF0000000000000L;
    }

    public static boolean DoubleBitsFinite(long bits) {
        return (bits &= Long.MAX_VALUE) < 0x7FF0000000000000L;
    }

    private static int RoundedShift(long mant, int shift) {
        long mask = (1L << shift) - 1L;
        long half = 1L << shift - 1;
        long shifted = mant >> shift;
        long masked = mant & mask;
        return masked > half || masked == half && (shifted & 1L) != 0L ? (int)shifted + 1 : (int)shifted;
    }

    private static int RoundedShift(int mant, int shift) {
        int mask = (1 << shift) - 1;
        int half = 1 << shift - 1;
        int shifted = mant >> shift;
        int masked = mant & mask;
        return masked > half || masked == half && (shifted & 1) != 0 ? shifted + 1 : shifted;
    }

    public static int DoubleToHalfPrecisionIfSameValue(long bits) {
        int exp = (int)(bits >> 52 & 0x7FFL);
        long mant = bits & 0xFFFFFFFFFFFFFL;
        int sign = (int)(bits >> 48) & 0x8000;
        int sexp = exp - 1008;
        if (exp == 2047) {
            int newmant = (int)(mant >> 42);
            return (mant & 0x3FFFFFFFFFFL) == 0L ? sign | 0x7C00 | newmant : -1;
        }
        if (sexp >= 31) {
            return -1;
        }
        if (sexp < -10) {
            return -1;
        }
        if (sexp > 0) {
            return (mant & 0x3FFFFFFFFFFL) == 0L ? sign | sexp << 10 | CBORUtilities.RoundedShift(mant, 42) : -1;
        }
        int rs = CBORUtilities.RoundedShift(mant | 0x10000000000000L, 42 - (sexp - 1));
        if (sexp == -10 && rs == 0) {
            return -1;
        }
        return (mant & (1L << 42 - (sexp - 1)) - 1L) == 0L ? sign | rs : -1;
    }

    public static boolean DoubleRetainsSameValueInSingle(long bits) {
        if ((bits & Long.MAX_VALUE) == 0L) {
            return true;
        }
        int exp = (int)(bits >> 52 & 0x7FFL);
        long mant = bits & 0xFFFFFFFFFFFFFL;
        int sexp = exp - 896;
        if (exp == 2047) {
            return (mant & 0x1FFFFFFFL) == 0L;
        }
        if (sexp < -23 || sexp >= 255) {
            return false;
        }
        if (sexp > 0) {
            return (mant & 0x1FFFFFFFL) == 0L;
        }
        if (sexp == -23) {
            return (mant & (1L << 29 - (sexp - 1)) - 1L) == 0L && CBORUtilities.RoundedShift(mant | 0x10000000000000L, 29 - (sexp - 1)) != 0;
        }
        return (mant & (1L << 29 - (sexp - 1)) - 1L) == 0L;
    }

    public static int SingleToRoundedHalfPrecision(int bits) {
        int exp = bits >> 23 & 0xFF;
        int mant = bits & 0x7FFFFF;
        int sign = bits >> 16 & 0x8000;
        int sexp = exp - 112;
        if (exp == 255) {
            int newmant = mant >> 13;
            return mant != 0 && newmant == 0 ? sign | 0x7C01 : sign | 0x7C00 | newmant;
        }
        if (sexp >= 31) {
            return sign | 0x7C00;
        }
        if (sexp < -10) {
            return sign;
        }
        if (sexp > 0) {
            return sign | sexp << 10 | CBORUtilities.RoundedShift(mant, 13);
        }
        return sign | CBORUtilities.RoundedShift(mant | 0x800000, 13 - (sexp - 1));
    }

    public static int DoubleToRoundedHalfPrecision(long bits) {
        int exp = (int)(bits >> 52 & 0x7FFL);
        long mant = bits & 0xFFFFFFFFFFFFFL;
        int sign = (int)(bits >> 48) & 0x8000;
        int sexp = exp - 1008;
        if (exp == 2047) {
            int newmant = (int)(mant >> 42);
            return mant != 0L && newmant == 0 ? sign | 0x7C01 : sign | 0x7C00 | newmant;
        }
        if (sexp >= 31) {
            return sign | 0x7C00;
        }
        if (sexp < -10) {
            return sign;
        }
        if (sexp > 0) {
            return sign | sexp << 10 | CBORUtilities.RoundedShift(mant, 42);
        }
        return sign | CBORUtilities.RoundedShift(mant | 0x10000000000000L, 42 - (sexp - 1));
    }

    public static int DoubleToRoundedSinglePrecision(long bits) {
        int exp = (int)(bits >> 52 & 0x7FFL);
        long mant = bits & 0xFFFFFFFFFFFFFL;
        int sign = (int)(bits >> 32) & Integer.MIN_VALUE;
        int sexp = exp - 896;
        if (exp == 2047) {
            int newmant = (int)(mant >> 29);
            return mant != 0L && newmant == 0 ? sign | 0x7F800001 : sign | 0x7F800000 | newmant;
        }
        if (sexp >= 255) {
            return sign | 0x7F800000;
        }
        if (sexp < -23) {
            return sign;
        }
        if (sexp > 0) {
            return sign | sexp << 23 | CBORUtilities.RoundedShift(mant, 29);
        }
        return sign | CBORUtilities.RoundedShift(mant | 0x10000000000000L, 29 - (sexp - 1));
    }

    public static int SingleToHalfPrecisionIfSameValue(float f) {
        int bits = Float.floatToRawIntBits(f);
        int exp = bits >> 23 & 0xFF;
        int mant = bits & 0x7FFFFF;
        int sign = bits >> 16 & 0x8000;
        if (exp == 255) {
            return (bits & 0x1FFF) == 0 ? sign + 31744 + (mant >> 13) : -1;
        }
        if (exp == 0) {
            return (bits & 0x1FFF) == 0 ? sign + (mant >> 13) : -1;
        }
        if (exp <= 102 || exp >= 143) {
            return -1;
        }
        if (exp <= 112) {
            int shift = 126 - exp;
            int rs = (1024 >> 145 - exp) + (mant >> shift);
            return mant != 0 && exp == 103 ? -1 : ((bits & (1 << shift) - 1) == 0 ? sign + rs : -1);
        }
        return (bits & 0x1FFF) == 0 ? sign + (exp - 112 << 10) + -(mant >> 13) : -1;
    }

    public static long SingleToDoublePrecision(int bits) {
        long negvalue = (long)(bits >> 31 & 1) << 63;
        int exp = bits >> 23 & 0xFF;
        int mant = bits & 0x7FFFFF;
        long value = 0L;
        if (exp == 255) {
            value = 0x7FF0000000000000L | (long)mant << 29 | negvalue;
        } else if (exp == 0) {
            if (mant == 0) {
                value = negvalue;
            } else {
                ++exp;
                while (mant < 0x800000) {
                    mant <<= 1;
                    --exp;
                }
                value = (long)(exp + 896) << 52 | (long)(mant & 0x7FFFFF) << 29 | negvalue;
            }
        } else {
            value = (long)(exp + 896) << 52 | (long)mant << 29 | negvalue;
        }
        return value;
    }

    public static long HalfToDoublePrecision(int bits) {
        long negvalue = (long)(bits & 0x8000) << 48;
        int exp = bits >> 10 & 0x1F;
        int mant = bits & 0x3FF;
        long value = 0L;
        if (exp == 31) {
            value = 0x7FF0000000000000L | (long)mant << 42 | negvalue;
        } else if (exp == 0) {
            if (mant == 0) {
                value = negvalue;
            } else {
                ++exp;
                while (mant < 1024) {
                    mant <<= 1;
                    --exp;
                }
                value = (long)(exp + 1008) << 52 | (long)(mant & 0x3FF) << 42 | negvalue;
            }
        } else {
            value = (long)(exp + 1008) << 52 | (long)mant << 42 | negvalue;
        }
        return value;
    }
}

