/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import org.eclipse.californium.scandium.config.DtlsConnectorConfig;
import org.eclipse.californium.scandium.dtls.AlertMessage;
import org.eclipse.californium.scandium.dtls.ChangeCipherSpecMessage;
import org.eclipse.californium.scandium.dtls.ClientHello;
import org.eclipse.californium.scandium.dtls.Connection;
import org.eclipse.californium.scandium.dtls.DTLSFlight;
import org.eclipse.californium.scandium.dtls.DTLSSession;
import org.eclipse.californium.scandium.dtls.Finished;
import org.eclipse.californium.scandium.dtls.HandshakeException;
import org.eclipse.californium.scandium.dtls.HandshakeMessage;
import org.eclipse.californium.scandium.dtls.HelloExtensions;
import org.eclipse.californium.scandium.dtls.Random;
import org.eclipse.californium.scandium.dtls.RecordLayer;
import org.eclipse.californium.scandium.dtls.ServerHandshaker;
import org.eclipse.californium.scandium.dtls.ServerHello;
import org.eclipse.californium.scandium.dtls.cipher.CipherSuite;

public class ResumingServerHandshaker
extends ServerHandshaker {
    private byte[] handshakeHash;

    public ResumingServerHandshaker(int sequenceNumber, DTLSSession session, RecordLayer recordLayer, Connection connection, DtlsConnectorConfig config, int maxTransmissionUnit) {
        super(sequenceNumber, session, recordLayer, connection, config, maxTransmissionUnit);
    }

    @Override
    protected void doProcessMessage(HandshakeMessage message) throws HandshakeException, GeneralSecurityException {
        switch (message.getMessageType()) {
            case CLIENT_HELLO: {
                this.receivedClientHello((ClientHello)message);
                this.expectChangeCipherSpecMessage();
                break;
            }
            case FINISHED: {
                this.receivedClientFinished((Finished)message);
                break;
            }
            default: {
                throw new HandshakeException(String.format("Received unexpected handshake message [%s] from peer %s", new Object[]{message.getMessageType(), message.getPeer()}), new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.UNEXPECTED_MESSAGE, message.getPeer()));
            }
        }
    }

    private void receivedClientHello(ClientHello clientHello) throws HandshakeException {
        MessageDigest mdWithServerFinished;
        this.handshakeStarted();
        if (!clientHello.getCipherSuites().contains((Object)this.session.getCipherSuite())) {
            throw new HandshakeException("Client wants to change cipher suite in resumed session", new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.ILLEGAL_PARAMETER, clientHello.getPeer()));
        }
        if (!clientHello.getCompressionMethods().contains((Object)this.session.getCompressionMethod())) {
            throw new HandshakeException("Client wants to change compression method in resumed session", new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.ILLEGAL_PARAMETER, clientHello.getPeer()));
        }
        this.clientRandom = clientHello.getRandom();
        this.serverRandom = new Random();
        CipherSuite cipherSuite = this.session.getCipherSuite();
        HelloExtensions serverHelloExtensions = new HelloExtensions();
        this.negotiateCipherSuite(clientHello, serverHelloExtensions);
        this.processHelloExtensions(clientHello, serverHelloExtensions);
        this.flightNumber += 2;
        DTLSFlight flight = new DTLSFlight(this.getSession(), this.flightNumber);
        ServerHello serverHello = new ServerHello(clientHello.getClientVersion(), this.serverRandom, this.session.getSessionIdentifier(), cipherSuite, this.session.getCompressionMethod(), serverHelloExtensions, clientHello.getPeer());
        this.wrapMessage(flight, serverHello);
        ChangeCipherSpecMessage changeCipherSpecMessage = new ChangeCipherSpecMessage(clientHello.getPeer());
        this.wrapMessage(flight, changeCipherSpecMessage);
        MessageDigest md = this.getHandshakeMessageDigest();
        try {
            mdWithServerFinished = (MessageDigest)md.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new HandshakeException("Cannot create FINISHED message hash", new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.INTERNAL_ERROR, clientHello.getPeer()));
        }
        this.masterSecret = this.session.getMasterSecret();
        this.calculateKeys(this.masterSecret);
        this.setCurrentWriteState();
        Finished finished = new Finished(this.session.getCipherSuite().getThreadLocalPseudoRandomFunctionMac(), this.masterSecret, false, md.digest(), clientHello.getPeer());
        this.wrapMessage(flight, finished);
        mdWithServerFinished.update(finished.toByteArray());
        this.handshakeHash = mdWithServerFinished.digest();
        this.sendFlight(flight);
        this.states = NO_CLIENT_CERTIFICATE;
        this.statesIndex = 0;
    }

    private void receivedClientFinished(Finished message) throws HandshakeException {
        message.verifyData(this.session.getCipherSuite().getThreadLocalPseudoRandomFunctionMac(), this.masterSecret, true, this.handshakeHash);
        this.sessionEstablished();
        this.handshakeCompleted();
    }
}

