/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network;

import java.net.InetSocketAddress;
import java.util.Random;
import org.eclipse.californium.core.network.GroupedMessageIdTracker;
import org.eclipse.californium.core.network.MapBasedMessageIdTracker;
import org.eclipse.californium.core.network.MessageIdProvider;
import org.eclipse.californium.core.network.MessageIdTracker;
import org.eclipse.californium.core.network.NullMessageIdTracker;
import org.eclipse.californium.core.network.config.NetworkConfig;
import org.eclipse.californium.elements.util.ClockUtil;
import org.eclipse.californium.elements.util.LeastRecentlyUsedCache;
import org.eclipse.californium.elements.util.NetworkInterfacesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryMessageIdProvider
implements MessageIdProvider {
    private static final Logger LOG = LoggerFactory.getLogger(InMemoryMessageIdProvider.class);
    private final LeastRecentlyUsedCache<InetSocketAddress, MessageIdTracker> trackers;
    private final MessageIdTracker multicastTracker;
    private final TrackerMode mode;
    private final Random random;
    private final NetworkConfig config;
    private final int multicastBaseMid;

    public InMemoryMessageIdProvider(NetworkConfig config) {
        if (config == null) {
            throw new NullPointerException("Config must not be null");
        }
        String textualMode = null;
        TrackerMode mode = TrackerMode.GROUPED;
        try {
            textualMode = config.getString("MID_TACKER");
            mode = TrackerMode.valueOf(textualMode);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Tracker mode '" + textualMode + "' not supported!");
        }
        catch (NullPointerException e) {
            throw new IllegalArgumentException("Tracker mode not provided/configured!");
        }
        this.mode = mode;
        this.config = config;
        this.random = config.getBoolean("USE_RANDOM_MID_START") ? new Random(ClockUtil.nanoRealtime()) : null;
        this.trackers = new LeastRecentlyUsedCache(config.getInt("MAX_ACTIVE_PEERS", 150000), config.getLong("MAX_PEER_INACTIVITY_PERIOD", 600L));
        this.trackers.setEvictingOnReadAccess(false);
        int multicastBaseMid = config.getInt("MULTICAST_BASE_MID");
        if (0 < multicastBaseMid) {
            this.multicastBaseMid = multicastBaseMid;
            int max = 65536;
            int mid = null == this.random ? multicastBaseMid : this.random.nextInt(max - multicastBaseMid) + multicastBaseMid;
            switch (mode) {
                case NULL: {
                    this.multicastTracker = new NullMessageIdTracker(mid, multicastBaseMid, max);
                    break;
                }
                case MAPBASED: {
                    this.multicastTracker = new MapBasedMessageIdTracker(mid, multicastBaseMid, max, config);
                    break;
                }
                default: {
                    this.multicastTracker = new GroupedMessageIdTracker(mid, multicastBaseMid, max, config);
                    break;
                }
            }
        } else {
            this.multicastBaseMid = 65536;
            this.multicastTracker = null;
        }
    }

    @Override
    public int getNextMessageId(InetSocketAddress destination) {
        MessageIdTracker tracker = this.getTracker(destination);
        if (tracker == null) {
            return -1;
        }
        return tracker.getNextMessageId();
    }

    private synchronized MessageIdTracker getTracker(InetSocketAddress destination) {
        if (NetworkInterfacesUtil.isMultiAddress(destination.getAddress())) {
            if (this.multicastTracker == null) {
                LOG.warn("Destination address {} is a multicast address, please configure NetworkConfig to support multicast messaging", (Object)destination);
            }
            return this.multicastTracker;
        }
        MessageIdTracker tracker = this.trackers.get(destination);
        if (tracker == null) {
            int mid = null == this.random ? 0 : this.random.nextInt(this.multicastBaseMid);
            switch (this.mode) {
                case NULL: {
                    tracker = new NullMessageIdTracker(mid, 0, this.multicastBaseMid);
                    break;
                }
                case MAPBASED: {
                    tracker = new MapBasedMessageIdTracker(mid, 0, this.multicastBaseMid, this.config);
                    break;
                }
                default: {
                    tracker = new GroupedMessageIdTracker(mid, 0, this.multicastBaseMid, this.config);
                }
            }
            if (this.trackers.put(destination, tracker)) {
                return tracker;
            }
            return null;
        }
        return tracker;
    }

    public static enum TrackerMode {
        NULL,
        GROUPED,
        MAPBASED;

    }
}

