/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network.config;

import org.eclipse.californium.core.network.config.NetworkConfig;

public class NetworkConfigDefaults {
    public static final int DEFAULT_MAX_ACTIVE_PEERS = 150000;
    public static final long DEFAULT_MAX_PEER_INACTIVITY_PERIOD = 600L;
    public static final int DEFAULT_MAX_RESOURCE_BODY_SIZE = 8192;
    public static final int DEFAULT_BLOCKWISE_STATUS_LIFETIME = 300000;
    public static final boolean DEFAULT_BLOCKWISE_STRICT_BLOCK2_OPTION = false;
    public static final int DEFAULT_PREFERRED_BLOCK_SIZE = 512;
    public static final int DEFAULT_MAX_MESSAGE_SIZE = 1024;
    public static final String DEFAULT_MID_TRACKER = "GROUPED";
    public static final int DEFAULT_MID_TRACKER_GROUPS = 16;
    public static final long DEFAULT_EXCHANGE_LIFETIME = 247000L;
    public static final String DEFAULT_DEDUPLICATOR = "DEDUPLICATOR_MARK_AND_SWEEP";
    public static final long DEFAULT_MARK_AND_SWEEP_INTERVAL = 10000L;
    public static final int DEFAULT_CROP_ROTATION_PERIOD = 247000;
    public static final boolean DEFAULT_DEDUPLICATOR_AUTO_REPLACE = true;
    public static final String DEFAULT_RESPONSE_MATCHING = "STRICT";
    public static final int DEFAULT_TCP_CONNECTION_IDLE_TIMEOUT = 10;
    public static final int DEFAULT_TCP_CONNECT_TIMEOUT = 10000;
    public static final int DEFAULT_TLS_HANDSHAKE_TIMEOUT = 10000;
    public static final int DEFAULT_SECURE_SESSION_TIMEOUT = 86400;
    public static final int DEFAULT_DTLS_AUTO_RESUME_TIMEOUT = 30000;
    public static final int DEFAULT_HEALTH_STATUS_INTERVAL = 0;
    public static final int DEFAULT_MULTICAST_BASE_MID = 65000;
    public static final String DEFAULT_DTLS_CONNECTION_ID_LENGTH = "";
    public static final String DEFAULT_DTLS_CONNECTION_ID_NODE_ID = "";

    public static void setDefaults(NetworkConfig config) {
        int CORES = Runtime.getRuntime().availableProcessors();
        String OS = System.getProperty("os.name");
        boolean WINDOWS = OS.startsWith("Windows");
        config.setInt("MAX_ACTIVE_PEERS", 150000);
        config.setLong("MAX_PEER_INACTIVITY_PERIOD", 600L);
        config.setInt("COAP_PORT", 5683);
        config.setInt("COAP_SECURE_PORT", 5684);
        config.setInt("ACK_TIMEOUT", 2000);
        config.setFloat("ACK_RANDOM_FACTOR", 1.5f);
        config.setFloat("ACK_TIMEOUT_SCALE", 2.0f);
        config.setInt("MAX_RETRANSMIT", 4);
        config.setLong("EXCHANGE_LIFETIME", 247000L);
        config.setLong("NON_LIFETIME", 145000L);
        config.setLong("MAX_TRANSMIT_WAIT", 93000L);
        config.setInt("NSTART", 1);
        config.setInt("LEISURE", 5000);
        config.setFloat("PROBING_RATE", 1.0f);
        config.setBoolean("USE_MESSAGE_OFFLOADING", false);
        config.setInt("MAX_LATENCY", 100000);
        config.setInt("MAX_SERVER_RESPONSE_DELAY", 250000);
        config.setBoolean("USE_RANDOM_MID_START", true);
        config.setString("MID_TACKER", DEFAULT_MID_TRACKER);
        config.setInt("MID_TRACKER_GROUPS", 16);
        config.setInt("TOKEN_SIZE_LIMIT", 8);
        config.setInt("PREFERRED_BLOCK_SIZE", 512);
        config.setInt("MAX_MESSAGE_SIZE", 1024);
        config.setInt("MAX_RESOURCE_BODY_SIZE", 8192);
        config.setInt("BLOCKWISE_STATUS_LIFETIME", 300000);
        config.setBoolean("BLOCKWISE_STRICT_BLOCK2_OPTION", false);
        config.setLong("NOTIFICATION_CHECK_INTERVAL", 86400000L);
        config.setInt("NOTIFICATION_CHECK_INTERVAL_COUNT", 100);
        config.setLong("NOTIFICATION_REREGISTRATION_BACKOFF", 2000L);
        config.setBoolean("USE_CONGESTION_CONTROL", false);
        config.setString("CONGESTION_CONTROL_ALGORITHM", "Cocoa");
        config.setInt("PROTOCOL_STAGE_THREAD_COUNT", CORES);
        config.setInt("NETWORK_STAGE_RECEIVER_THREAD_COUNT", WINDOWS ? CORES : 1);
        config.setInt("NETWORK_STAGE_SENDER_THREAD_COUNT", WINDOWS ? CORES : 1);
        config.setInt("UDP_CONNECTOR_DATAGRAM_SIZE", 2048);
        config.setInt("UDP_CONNECTOR_RECEIVE_BUFFER", 0);
        config.setInt("UDP_CONNECTOR_SEND_BUFFER", 0);
        config.setInt("UDP_CONNECTOR_OUT_CAPACITY", Integer.MAX_VALUE);
        config.setString("DEDUPLICATOR", DEFAULT_DEDUPLICATOR);
        config.setLong("MARK_AND_SWEEP_INTERVAL", 10000L);
        config.setInt("CROP_ROTATION_PERIOD", 247000);
        config.setBoolean("DEDUPLICATOR_AUTO_REPLACE", true);
        config.setString("RESPONSE_MATCHING", DEFAULT_RESPONSE_MATCHING);
        config.setInt("HTTP_PORT", 8080);
        config.setInt("HTTP_SERVER_SOCKET_TIMEOUT", 100000);
        config.setInt("HTTP_SERVER_SOCKET_BUFFER_SIZE", 8192);
        config.setInt("HTTP_CACHE_RESPONSE_MAX_AGE", 86400);
        config.setInt("HTTP_CACHE_SIZE", 32);
        config.setInt("HEALTH_STATUS_INTERVAL", 0);
        config.setInt("TCP_CONNECTION_IDLE_TIMEOUT", 10);
        config.setInt("TCP_WORKER_THREADS", 1);
        config.setInt("TCP_CONNECT_TIMEOUT", 10000);
        config.setInt("TLS_HANDSHAKE_TIMEOUT", 10000);
        config.setLong("SECURE_SESSION_TIMEOUT", 86400L);
        config.setLong("DTLS_AUTO_RESUME_TIMEOUT", 30000L);
        config.setString("DTLS_CONNECTION_ID_LENGTH", "");
        config.setString("DTLS_CONNECTION_ID_NODE_ID", "");
        config.setInt("MULTICAST_BASE_MID", 65000);
    }

    private NetworkConfigDefaults() {
    }
}

