/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core;

import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.californium.core.CoapResponse;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.InternalMessageObserver;
import org.eclipse.californium.core.coap.MessageObserver;
import org.eclipse.californium.core.coap.MessageObserverAdapter;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.network.Endpoint;
import org.eclipse.californium.core.observe.NotificationListener;
import org.eclipse.californium.core.observe.ObserveNotificationOrderer;
import org.eclipse.californium.elements.EndpointContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoapObserveRelation {
    private static final Logger LOGGER = LoggerFactory.getLogger(CoapObserveRelation.class);
    private final ScheduledThreadPoolExecutor scheduler;
    private final Endpoint endpoint;
    private final long reregistrationBackoff;
    private final AtomicBoolean requestPending = new AtomicBoolean(true);
    private final AtomicReference<ScheduledFuture<?>> reregistrationHandle = new AtomicReference();
    private volatile Request request;
    private volatile boolean canceled = false;
    private volatile boolean proactiveCancel = false;
    private volatile CoapResponse current = null;
    private volatile ObserveNotificationOrderer orderer;
    private volatile NotificationListener notificationListener;
    private final Runnable reregister = new Runnable(){

        @Override
        public void run() {
            CoapObserveRelation.this.reregister();
        }
    };
    private final MessageObserver pendingRequestObserver = new MessageObserverAdapter(){

        @Override
        public void onResponse(Response response) {
            this.next();
        }

        @Override
        public void onCancel() {
            this.next();
        }

        @Override
        protected void failed() {
            this.next();
        }

        private void next() {
            if (CoapObserveRelation.this.proactiveCancel) {
                CoapObserveRelation.this.sendCancelObserve();
            } else {
                CoapObserveRelation.this.requestPending.set(false);
            }
        }
    };

    protected CoapObserveRelation(Request request, Endpoint endpoint, ScheduledThreadPoolExecutor executor) {
        this.request = request;
        this.endpoint = endpoint;
        this.orderer = new ObserveNotificationOrderer();
        this.reregistrationBackoff = endpoint.getConfig().getLong("NOTIFICATION_REREGISTRATION_BACKOFF");
        this.scheduler = executor;
        this.request.addMessageObserver(this.pendingRequestObserver);
        this.request.setProtectFromOffload();
    }

    public boolean reregister() {
        Request request = this.request;
        if (request.isCanceled()) {
            throw new IllegalStateException("observe request already canceled! token " + request.getTokenString());
        }
        CoapResponse response = this.current;
        if (response != null && !response.getOptions().hasObserve()) {
            throw new IllegalStateException("observe not supported by CoAP server!");
        }
        if (this.isCanceled()) {
            throw new IllegalStateException("observe already canceled!");
        }
        if (this.requestPending.compareAndSet(false, true)) {
            Request refresh = Request.newGet();
            EndpointContext destinationContext = response != null ? response.advanced().getSourceContext() : request.getDestinationContext();
            refresh.setDestinationContext(destinationContext);
            refresh.setToken(request.getToken());
            refresh.setOptions(request.getOptions());
            for (MessageObserver observer : request.getMessageObservers()) {
                if (observer instanceof InternalMessageObserver && ((InternalMessageObserver)((Object)observer)).isInternal()) continue;
                request.removeMessageObserver(observer);
                refresh.addMessageObserver(observer);
            }
            this.request = refresh;
            this.orderer = new ObserveNotificationOrderer();
            this.endpoint.sendRequest(refresh);
            return true;
        }
        return false;
    }

    private void sendCancelObserve() {
        this.proactiveCancel = false;
        CoapResponse response = this.current;
        Request request = this.request;
        EndpointContext destinationContext = response != null ? response.advanced().getSourceContext() : request.getDestinationContext();
        Request cancel = Request.newGet();
        cancel.setDestinationContext(destinationContext);
        cancel.setToken(request.getToken());
        cancel.setOptions(request.getOptions());
        cancel.setObserveCancel();
        for (MessageObserver observer : request.getMessageObservers()) {
            if (observer instanceof InternalMessageObserver && ((InternalMessageObserver)((Object)observer)).isInternal()) continue;
            request.removeMessageObserver(observer);
            cancel.addMessageObserver(observer);
        }
        this.endpoint.sendRequest(cancel);
    }

    private void cancel() {
        this.endpoint.cancelObservation(this.request.getToken());
        this.setCanceled(true);
    }

    public void proactiveCancel() {
        this.cancel();
        this.proactiveCancel = true;
        if (this.requestPending.compareAndSet(false, true)) {
            this.sendCancelObserve();
        }
    }

    public void reactiveCancel() {
        Request request = this.request;
        if (CoAP.isTcpScheme(request.getScheme())) {
            LOGGER.info("change to cancel the observe {} proactive over TCP.", (Object)request.getTokenString());
            this.proactiveCancel();
        } else {
            request.cancel();
            this.cancel();
        }
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public CoapResponse getCurrent() {
        return this.current;
    }

    protected void setCanceled(boolean canceled) {
        this.canceled = canceled;
        if (this.canceled) {
            this.setReregistrationHandle(null);
            if (this.notificationListener != null) {
                this.endpoint.removeNotificationListener(this.notificationListener);
            }
        }
    }

    public void setNotificationListener(NotificationListener listener) {
        this.notificationListener = listener;
    }

    protected boolean onResponse(CoapResponse response) {
        boolean isNew = false;
        if (null != response) {
            Integer observe = response.getOptions().getObserve();
            boolean prepareNext = observe != null && !this.isCanceled();
            isNew = this.orderer.isNew(response.advanced());
            if (isNew) {
                this.current = response;
            } else if (prepareNext) {
                boolean bl = prepareNext = this.orderer.getCurrent() == observe.intValue();
            }
            if (prepareNext) {
                this.prepareReregistration(response);
            }
        }
        return isNew;
    }

    private void setReregistrationHandle(ScheduledFuture<?> reregistrationHandle) {
        ScheduledFuture<?> previousHandle = this.reregistrationHandle.getAndSet(reregistrationHandle);
        if (previousHandle != null) {
            if (previousHandle instanceof Runnable) {
                this.scheduler.remove((Runnable)((Object)previousHandle));
            } else {
                previousHandle.cancel(false);
            }
        }
    }

    private void prepareReregistration(CoapResponse response) {
        long timeout = response.getOptions().getMaxAge() * 1000L + this.reregistrationBackoff;
        ScheduledFuture<?> f = this.scheduler.schedule(this.reregister, timeout, TimeUnit.MILLISECONDS);
        this.setReregistrationHandle(f);
    }
}

