/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements.util;

import java.util.concurrent.atomic.AtomicLong;

public class SimpleCounterStatistic {
    private final String name;
    private final int align;
    private final AlignGroup group;
    private final AtomicLong currentCounter = new AtomicLong();
    private final AtomicLong overallCounter = new AtomicLong();

    public SimpleCounterStatistic(String name) {
        this.name = name;
        this.align = 0;
        this.group = null;
    }

    public SimpleCounterStatistic(String name, int align) {
        this.name = name;
        this.align = align;
        this.group = null;
    }

    public SimpleCounterStatistic(String name, AlignGroup group) {
        this.name = name;
        this.align = 0;
        this.group = group.add(this);
    }

    public String dump(int align) {
        long current = this.currentCounter.getAndSet(0L);
        long overall = this.overallCounter.addAndGet(current);
        return SimpleCounterStatistic.format(align, this.name, current) + String.format(" (%8d overall).", overall);
    }

    public String getName() {
        return this.name;
    }

    public long increment() {
        return this.currentCounter.incrementAndGet();
    }

    public long increment(int delta) {
        return this.currentCounter.addAndGet(delta);
    }

    public long reset() {
        long current = this.currentCounter.getAndSet(0L);
        this.overallCounter.addAndGet(current);
        return this.overallCounter.getAndSet(0L);
    }

    public boolean isUsed() {
        return this.currentCounter.get() > 0L || this.overallCounter.get() > 0L;
    }

    public String toString() {
        int align = this.group == null ? this.align : this.group.getAlign();
        return this.dump(align);
    }

    public static String format(int align, String name, long value) {
        if (align == 0) {
            return String.format("%s: %8d", name, value);
        }
        return String.format("%" + align + "s: %8d", name, value);
    }

    public static class AlignGroup {
        int align;

        public AlignGroup add(SimpleCounterStatistic statistic) {
            return this.add(statistic.getName());
        }

        public AlignGroup add(String name) {
            int align = name.length();
            if (align > this.align) {
                this.align = align;
            }
            return this;
        }

        public int getAlign() {
            return -(this.align + 1);
        }
    }
}

