/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network.stack;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.californium.core.network.Exchange;
import org.eclipse.californium.core.network.stack.CleanupMessageObserver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MulticastCleanupMessageObserver
extends CleanupMessageObserver {
    static final Logger LOGGER = LoggerFactory.getLogger(MulticastCleanupMessageObserver.class.getName());
    private final ScheduledExecutorService scheduledExecutor;
    private final long multicastLifetime;
    private volatile ScheduledFuture<?> cleanup;

    public MulticastCleanupMessageObserver(Exchange exchange, ScheduledExecutorService scheduledExecutor, long multicastLifetime) {
        super(exchange);
        this.scheduledExecutor = scheduledExecutor;
        this.multicastLifetime = multicastLifetime;
    }

    @Override
    public void onSent(boolean retransmission) {
        this.cleanup = this.scheduledExecutor.schedule(new Runnable(){

            @Override
            public void run() {
                MulticastCleanupMessageObserver.this.exchange.execute(new Runnable(){

                    @Override
                    public void run() {
                        if (MulticastCleanupMessageObserver.this.exchange.getResponse() == null) {
                            MulticastCleanupMessageObserver.this.exchange.getRequest().setCanceled(true);
                        } else {
                            MulticastCleanupMessageObserver.this.exchange.setComplete();
                            MulticastCleanupMessageObserver.this.exchange.getRequest().onComplete();
                        }
                    }
                });
            }
        }, this.multicastLifetime, TimeUnit.MILLISECONDS);
    }

    @Override
    protected void complete(String action) {
        ScheduledFuture<?> cleanup = this.cleanup;
        if (cleanup != null) {
            cleanup.cancel(false);
        }
        super.complete(action);
    }
}

