/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network.deduplication;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.californium.core.network.Exchange;
import org.eclipse.californium.core.network.KeyMID;
import org.eclipse.californium.core.network.config.NetworkConfig;
import org.eclipse.californium.core.network.deduplication.Deduplicator;
import org.eclipse.californium.elements.util.ClockUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SweepDeduplicator
implements Deduplicator {
    private static final Logger LOGGER = LoggerFactory.getLogger(SweepDeduplicator.class.getName());
    private final ConcurrentMap<KeyMID, DedupExchange> incomingMessages = new ConcurrentHashMap<KeyMID, DedupExchange>();
    private final SweepAlgorithm algorithm = new SweepAlgorithm();
    private final long sweepInterval;
    private final long exchangeLifetime;
    private final boolean replace;
    private volatile ScheduledFuture<?> jobStatus;
    private ScheduledExecutorService executor;

    public SweepDeduplicator(NetworkConfig config) {
        this.sweepInterval = config.getLong("MARK_AND_SWEEP_INTERVAL");
        this.exchangeLifetime = config.getLong("EXCHANGE_LIFETIME");
        this.replace = config.getBoolean("DEDUPLICATOR_AUTO_REPLACE");
    }

    @Override
    public synchronized void start() {
        if (this.jobStatus == null) {
            this.jobStatus = this.executor.scheduleAtFixedRate(this.algorithm, this.sweepInterval, this.sweepInterval, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public synchronized void stop() {
        if (this.jobStatus != null) {
            this.jobStatus.cancel(false);
            this.jobStatus = null;
            this.clear();
        }
    }

    @Override
    public synchronized void setExecutor(ScheduledExecutorService executor) {
        if (this.jobStatus != null) {
            throw new IllegalStateException("executor service can not be set on running Deduplicator");
        }
        this.executor = executor;
    }

    @Override
    public Exchange findPrevious(KeyMID key, Exchange exchange) {
        DedupExchange current = new DedupExchange(exchange);
        DedupExchange previous = this.incomingMessages.putIfAbsent(key, current);
        if (this.replace && previous != null && previous.exchange.getOrigin() != exchange.getOrigin()) {
            LOGGER.debug("replace exchange for {}", (Object)key);
            previous = this.incomingMessages.replace(key, previous, current) ? null : this.incomingMessages.putIfAbsent(key, current);
        }
        return null == previous ? null : previous.exchange;
    }

    @Override
    public boolean replacePrevious(KeyMID key, Exchange previous, Exchange exchange) {
        boolean result = true;
        DedupExchange prev = new DedupExchange(previous);
        DedupExchange current = new DedupExchange(exchange);
        if (!this.incomingMessages.replace(key, prev, current)) {
            result = this.incomingMessages.putIfAbsent(key, current) == null;
        }
        return result;
    }

    @Override
    public Exchange find(KeyMID key) {
        DedupExchange previous = (DedupExchange)this.incomingMessages.get(key);
        return null == previous ? null : previous.exchange;
    }

    @Override
    public void clear() {
        this.incomingMessages.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.incomingMessages.isEmpty();
    }

    @Override
    public int size() {
        return this.incomingMessages.size();
    }

    private class SweepAlgorithm
    implements Runnable {
        private SweepAlgorithm() {
        }

        @Override
        public void run() {
            try {
                LOGGER.trace("Start Mark-And-Sweep with {} entries", (Object)SweepDeduplicator.this.incomingMessages.size());
                this.sweep();
            }
            catch (Throwable t) {
                LOGGER.warn("Exception in Mark-and-Sweep algorithm", t);
            }
        }

        private void sweep() {
            if (!SweepDeduplicator.this.incomingMessages.isEmpty()) {
                long start = ClockUtil.nanoRealtime();
                long oldestAllowed = start - TimeUnit.MILLISECONDS.toNanos(SweepDeduplicator.this.exchangeLifetime);
                for (Map.Entry entry : SweepDeduplicator.this.incomingMessages.entrySet()) {
                    DedupExchange exchange = (DedupExchange)entry.getValue();
                    if (exchange.nanoTimestamp - oldestAllowed >= 0L) continue;
                    LOGGER.trace("Mark-And-Sweep removes {}", entry.getKey());
                    SweepDeduplicator.this.incomingMessages.remove(entry.getKey());
                }
                LOGGER.debug("Sweep run took {}ms", (Object)TimeUnit.NANOSECONDS.toMillis(ClockUtil.nanoRealtime() - start));
            }
        }
    }

    private static class DedupExchange {
        public final long nanoTimestamp;
        public final Exchange exchange;

        public DedupExchange(Exchange exchange) {
            this.exchange = exchange;
            this.nanoTimestamp = ClockUtil.nanoRealtime();
        }

        public int hashCode() {
            return this.exchange.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DedupExchange other = (DedupExchange)obj;
            return this.exchange.equals(other.exchange);
        }
    }
}

