/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network.deduplication;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.californium.core.network.Exchange;
import org.eclipse.californium.core.network.KeyMID;
import org.eclipse.californium.core.network.config.NetworkConfig;
import org.eclipse.californium.core.network.deduplication.Deduplicator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CropRotation
implements Deduplicator {
    private static final Logger LOGGER = LoggerFactory.getLogger(CropRotation.class.getCanonicalName());
    private volatile ScheduledFuture<?> jobStatus;
    private final ExchangeMap[] maps;
    private volatile int first;
    private volatile int second;
    private final long period;
    private final boolean replace;
    private final Rotation rotation = new Rotation();
    private ScheduledExecutorService executor;

    public CropRotation(NetworkConfig config) {
        this.maps = new ExchangeMap[3];
        this.maps[0] = new ExchangeMap();
        this.maps[1] = new ExchangeMap();
        this.maps[2] = new ExchangeMap();
        this.first = 0;
        this.second = 1;
        this.period = config.getLong("CROP_ROTATION_PERIOD");
        this.replace = config.getBoolean("DEDUPLICATOR_AUTO_REPLACE");
    }

    @Override
    public synchronized void start() {
        if (this.jobStatus == null) {
            this.jobStatus = this.executor.scheduleAtFixedRate(this.rotation, this.period, this.period, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public synchronized void stop() {
        if (this.jobStatus != null) {
            this.jobStatus.cancel(false);
            this.jobStatus = null;
            this.clear();
        }
    }

    @Override
    public synchronized void setExecutor(ScheduledExecutorService executor) {
        if (this.jobStatus != null) {
            throw new IllegalStateException("executor service can not be set on running Deduplicator");
        }
        this.executor = executor;
    }

    @Override
    public Exchange findPrevious(KeyMID key, Exchange exchange) {
        int f = this.first;
        int s = this.second;
        Exchange prev = this.maps[f].putIfAbsent(key, exchange);
        if (prev != null || f == s) {
            return prev;
        }
        prev = this.maps[s].putIfAbsent(key, exchange);
        if (this.replace && prev != null && prev.getOrigin() != exchange.getOrigin()) {
            LOGGER.debug("replace exchange for {}", (Object)key);
            prev = this.maps[s].replace(key, prev, exchange) ? null : this.maps[s].putIfAbsent(key, exchange);
        }
        return prev;
    }

    @Override
    public boolean replacePrevious(KeyMID key, Exchange previous, Exchange exchange) {
        int s = this.second;
        return this.maps[s].replace(key, previous, exchange) || this.maps[s].putIfAbsent(key, exchange) == null;
    }

    @Override
    public Exchange find(KeyMID key) {
        int f = this.first;
        int s = this.second;
        Exchange prev = (Exchange)this.maps[s].get(key);
        if (prev != null || f == s) {
            return prev;
        }
        prev = (Exchange)this.maps[f].get(key);
        return prev;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        ExchangeMap[] exchangeMapArray = this.maps;
        synchronized (this.maps) {
            this.maps[0].clear();
            this.maps[1].clear();
            this.maps[2].clear();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        ExchangeMap[] exchangeMapArray = this.maps;
        synchronized (this.maps) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.maps[0].size() + this.maps[1].size() + this.maps[2].size();
        }
    }

    @Override
    public boolean isEmpty() {
        for (ExchangeMap map : this.maps) {
            if (map.isEmpty()) continue;
            return false;
        }
        return true;
    }

    private static class ExchangeMap
    extends ConcurrentHashMap<KeyMID, Exchange> {
        private static final long serialVersionUID = 1504940670839294042L;

        private ExchangeMap() {
        }
    }

    private class Rotation
    implements Runnable {
        private Rotation() {
        }

        @Override
        public void run() {
            try {
                this.rotation();
            }
            catch (Throwable t) {
                LOGGER.warn("Exception in Crop-Rotation algorithm", t);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void rotation() {
            ExchangeMap[] exchangeMapArray = CropRotation.this.maps;
            synchronized (exchangeMapArray) {
                int third = CropRotation.this.first;
                CropRotation.this.first = CropRotation.this.second;
                CropRotation.this.second = (CropRotation.this.second + 1) % 3;
                CropRotation.this.maps[third].clear();
            }
        }
    }
}

