/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network;

import java.util.concurrent.Executor;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.EmptyMessage;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.coap.Token;
import org.eclipse.californium.core.network.BaseMatcher;
import org.eclipse.californium.core.network.EndpointReceiver;
import org.eclipse.californium.core.network.Exchange;
import org.eclipse.californium.core.network.KeyMID;
import org.eclipse.californium.core.network.KeyToken;
import org.eclipse.californium.core.network.MessageExchangeStore;
import org.eclipse.californium.core.network.RemoveHandler;
import org.eclipse.californium.core.network.TokenGenerator;
import org.eclipse.californium.core.network.config.NetworkConfig;
import org.eclipse.californium.core.observe.NotificationListener;
import org.eclipse.californium.core.observe.ObservationStore;
import org.eclipse.californium.elements.EndpointContext;
import org.eclipse.californium.elements.EndpointContextMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UdpMatcher
extends BaseMatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(UdpMatcher.class.getName());
    private final RemoveHandler exchangeRemoveHandler = new RemoveHandlerImpl();
    private final EndpointContextMatcher endpointContextMatcher;

    public UdpMatcher(NetworkConfig config, NotificationListener notificationListener, TokenGenerator tokenGenerator, ObservationStore observationStore, MessageExchangeStore exchangeStore, Executor executor, EndpointContextMatcher matchingStrategy) {
        super(config, notificationListener, tokenGenerator, observationStore, exchangeStore, executor);
        this.endpointContextMatcher = matchingStrategy;
    }

    @Override
    public void sendRequest(Exchange exchange) {
        Request request = exchange.getCurrentRequest();
        if (request.isObserve() && 0 == exchange.getFailedTransmissionCount()) {
            if (this.exchangeStore.assignMessageId(request) != -1) {
                this.registerObserve(request);
            } else {
                LOGGER.warn("message IDs exhausted, could not register outbound observe request for tracking");
                request.setSendError(new IllegalStateException("automatic message IDs exhausted"));
                return;
            }
        }
        try {
            if (this.exchangeStore.registerOutboundRequest(exchange)) {
                exchange.setRemoveHandler(this.exchangeRemoveHandler);
                LOGGER.debug("tracking open request [MID: {}, Token: {}]", (Object)request.getMID(), (Object)request.getToken());
            } else {
                LOGGER.warn("message IDs exhausted, could not register outbound request for tracking");
                request.setSendError(new IllegalStateException("automatic message IDs exhausted"));
            }
        }
        catch (IllegalArgumentException ex) {
            request.setSendError(ex);
        }
    }

    @Override
    public void sendResponse(Exchange exchange) {
        boolean ready = true;
        Response response = exchange.getCurrentResponse();
        response.ensureToken(exchange.getCurrentRequest().getToken());
        if (response.getType() == CoAP.Type.CON) {
            exchange.removeNotifications();
            this.exchangeStore.registerOutboundResponse(exchange);
            ready = false;
        } else if (response.getType() == CoAP.Type.NON) {
            if (response.isNotification()) {
                this.exchangeStore.registerOutboundResponse(exchange);
                ready = false;
            } else {
                this.exchangeStore.assignMessageId(response);
            }
        }
        if (ready) {
            exchange.setComplete();
        }
    }

    @Override
    public void sendEmptyMessage(Exchange exchange, EmptyMessage message) {
        message.setToken(Token.EMPTY);
        if (message.getType() == CoAP.Type.RST && exchange != null) {
            exchange.setComplete();
        }
    }

    @Override
    public void receiveRequest(final Request request, final EndpointReceiver receiver) {
        boolean duplicate;
        Exchange exchange;
        KeyMID idByMID = new KeyMID(request.getMID(), this.endpointContextMatcher.getEndpointIdentity(request.getSourceContext()));
        final Exchange previous = this.exchangeStore.findPrevious(idByMID, exchange = new Exchange(request, Exchange.Origin.REMOTE, this.executor));
        boolean bl = duplicate = previous != null;
        if (duplicate) {
            EndpointContext sourceContext = request.getSourceContext();
            Request previousRequest = previous.getCurrentRequest();
            EndpointContext previousSourceContext = previous.getOrigin() == Exchange.Origin.REMOTE ? previousRequest.getSourceContext() : previousRequest.getDestinationContext();
            duplicate = this.endpointContextMatcher.isToBeSent(previousSourceContext, sourceContext);
            if (!duplicate) {
                if (this.exchangeStore.replacePrevious(idByMID, previous, exchange)) {
                    LOGGER.debug("replaced request {} by new request {}!", (Object)previousRequest, (Object)request);
                } else {
                    LOGGER.warn("new request {} could not be registered! Deduplication disabled!", (Object)request);
                }
            }
        }
        if (duplicate) {
            LOGGER.trace("duplicate request: {}", (Object)request);
            request.setDuplicate(true);
            previous.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        receiver.receiveRequest(previous, request);
                    }
                    catch (RuntimeException ex) {
                        LOGGER.warn("error receiving request {} again!", (Object)request, (Object)ex);
                        receiver.reject(request);
                    }
                }
            });
        } else {
            exchange.setRemoveHandler(this.exchangeRemoveHandler);
            exchange.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        receiver.receiveRequest(exchange, request);
                    }
                    catch (RuntimeException ex) {
                        LOGGER.warn("error receiving request {}", (Object)request, (Object)ex);
                        receiver.reject(request);
                    }
                }
            });
        }
    }

    @Override
    public void receiveResponse(final Response response, final EndpointReceiver receiver) {
        final Object peer = this.endpointContextMatcher.getEndpointIdentity(response.getSourceContext());
        final KeyToken idByToken = this.tokenGenerator.getKeyToken(response.getToken(), peer);
        LOGGER.trace("received response {}", (Object)response);
        Exchange tempExchange = this.exchangeStore.get(idByToken);
        if (tempExchange == null) {
            tempExchange = this.matchNotifyResponse(response);
        }
        if (tempExchange == null) {
            if (response.getType() != CoAP.Type.ACK) {
                KeyMID idByMID = new KeyMID(response.getMID(), peer);
                final Exchange prev = this.exchangeStore.find(idByMID);
                if (prev != null) {
                    prev.execute(new Runnable(){

                        @Override
                        public void run() {
                            if (prev.getCurrentRequest().isMulticast()) {
                                LOGGER.debug("Ignore delayed response {} to multicast request {}", (Object)response, (Object)prev.getCurrentRequest().getDestinationContext().getPeerAddress());
                                return;
                            }
                            try {
                                if (UdpMatcher.this.endpointContextMatcher.isResponseRelatedToRequest(prev.getEndpointContext(), response.getSourceContext())) {
                                    LOGGER.trace("received response for already completed {}: {}", (Object)prev, (Object)response);
                                    response.setDuplicate(true);
                                    receiver.receiveResponse(prev, response);
                                    return;
                                }
                            }
                            catch (RuntimeException ex) {
                                LOGGER.warn("error receiving response {} for {}", response, prev, ex);
                            }
                            UdpMatcher.this.reject(response, receiver);
                        }
                    });
                } else {
                    this.reject(response, receiver);
                }
            } else {
                LOGGER.trace("discarding unmatchable piggy-backed response from [{}]: {}", (Object)response.getSourceContext(), (Object)response);
            }
            return;
        }
        final Exchange exchange = tempExchange;
        exchange.execute(new Runnable(){

            @Override
            public void run() {
                boolean checkResponseToken;
                boolean bl = checkResponseToken = !exchange.isNotification() || exchange.getRequest() != exchange.getCurrentRequest();
                if (checkResponseToken && UdpMatcher.this.exchangeStore.get(idByToken) != exchange) {
                    if (UdpMatcher.this.running) {
                        LOGGER.debug("ignoring response {}, exchange not longer matching!", (Object)response);
                    }
                    return;
                }
                EndpointContext context = exchange.getEndpointContext();
                if (context == null) {
                    LOGGER.debug("ignoring response {}, request pending to sent!", (Object)response);
                    return;
                }
                try {
                    if (UdpMatcher.this.endpointContextMatcher.isResponseRelatedToRequest(context, response.getSourceContext())) {
                        KeyMID idByMID;
                        CoAP.Type type = response.getType();
                        Request currentRequest = exchange.getCurrentRequest();
                        int requestMid = currentRequest.getMID();
                        if (currentRequest.isMulticast()) {
                            if (type != CoAP.Type.NON) {
                                LOGGER.debug("ignoring response of type {} for multicast request with token [{}], from {}", new Object[]{response.getType(), response.getTokenString(), response.getSourceContext().getPeerAddress()});
                                return;
                            }
                        } else if (type == CoAP.Type.ACK && requestMid != response.getMID()) {
                            LOGGER.debug("ignoring ACK, possible MID reuse before lifetime end for token {}, expected MID {} but received {}", response.getTokenString(), requestMid, response.getMID());
                            return;
                        }
                        if (type != CoAP.Type.ACK && !exchange.isNotification() && !currentRequest.isMulticast() && response.isNotification() && currentRequest.isObserveCancel()) {
                            LOGGER.debug("ignoring notify for pending cancel {}!", (Object)response);
                            return;
                        }
                        if ((type == CoAP.Type.CON || type == CoAP.Type.NON) && UdpMatcher.this.exchangeStore.findPrevious(idByMID = new KeyMID(response.getMID(), peer), exchange) != null) {
                            LOGGER.trace("received duplicate response for open {}: {}", (Object)exchange, (Object)response);
                            response.setDuplicate(true);
                        }
                        receiver.receiveResponse(exchange, response);
                        return;
                    }
                    LOGGER.debug("ignoring potentially forged response for token {} with non-matching endpoint context", (Object)idByToken);
                }
                catch (RuntimeException ex) {
                    LOGGER.warn("error receiving response {} for {}", response, exchange, ex);
                }
                UdpMatcher.this.reject(response, receiver);
            }
        });
    }

    @Override
    public void receiveEmptyMessage(final EmptyMessage message, final EndpointReceiver receiver) {
        final KeyMID idByMID = new KeyMID(message.getMID(), this.endpointContextMatcher.getEndpointIdentity(message.getSourceContext()));
        final Exchange exchange = this.exchangeStore.get(idByMID);
        if (exchange == null) {
            LOGGER.debug("ignoring unmatchable empty message from {}: {}", (Object)message.getSourceContext(), (Object)message);
            return;
        }
        exchange.execute(new Runnable(){

            @Override
            public void run() {
                if (exchange.getCurrentRequest().isMulticast()) {
                    LOGGER.debug("ignoring {} message for multicast request {}", (Object)message.getType(), (Object)idByMID);
                    return;
                }
                if (UdpMatcher.this.exchangeStore.get(idByMID) != exchange) {
                    if (UdpMatcher.this.running) {
                        LOGGER.debug("ignoring ack/rst {}, not longer matching!", (Object)message);
                    }
                    return;
                }
                try {
                    if (UdpMatcher.this.endpointContextMatcher.isResponseRelatedToRequest(exchange.getEndpointContext(), message.getSourceContext())) {
                        UdpMatcher.this.exchangeStore.remove(idByMID, exchange);
                        LOGGER.debug("received expected reply for message {}", (Object)idByMID);
                        receiver.receiveEmptyMessage(exchange, message);
                    } else {
                        LOGGER.debug("ignoring potentially forged reply for message {} with non-matching endpoint context", (Object)idByMID);
                    }
                }
                catch (RuntimeException ex) {
                    LOGGER.warn("error receiving empty message {} for {}", message, exchange, ex);
                }
            }
        });
    }

    private void reject(Response response, EndpointReceiver receiver) {
        if (response.getType() != CoAP.Type.ACK && response.hasMID()) {
            LOGGER.debug("rejecting response from {}", (Object)response.getSourceContext());
            receiver.reject(response);
        }
    }

    private class RemoveHandlerImpl
    implements RemoveHandler {
        private RemoveHandlerImpl() {
        }

        @Override
        public void remove(Exchange exchange, KeyToken keyToken, KeyMID keyMID) {
            if (keyToken != null) {
                UdpMatcher.this.exchangeStore.remove(keyToken, exchange);
            }
            if (keyMID != null) {
                UdpMatcher.this.exchangeStore.remove(keyMID, exchange);
            }
        }
    }
}

