/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements.tcp;

import io.netty.channel.Channel;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.CancellationException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.eclipse.californium.elements.EndpointContext;
import org.eclipse.californium.elements.EndpointContextMatcher;
import org.eclipse.californium.elements.RawData;
import org.eclipse.californium.elements.tcp.TcpClientConnector;
import org.eclipse.californium.elements.tcp.TlsContextUtil;

public class TlsClientConnector
extends TcpClientConnector {
    private static final int DEFAULT_HANDSHAKE_TIMEOUT_MILLIS = 10000;
    private final SSLContext sslContext;
    private final int handshakeTimeoutMillis;

    public TlsClientConnector(SSLContext sslContext, int numberOfThreads, int connectTimeoutMillis, int idleTimeout) {
        this(sslContext, numberOfThreads, connectTimeoutMillis, 10000, idleTimeout);
    }

    public TlsClientConnector(SSLContext sslContext, int numberOfThreads, int connectTimeoutMillis, int handshakeTimeoutMillis, int idleTimeout) {
        super(numberOfThreads, connectTimeoutMillis, idleTimeout, new TlsContextUtil(true));
        this.sslContext = sslContext;
        this.handshakeTimeoutMillis = handshakeTimeoutMillis;
    }

    @Override
    protected void send(final Channel channel, final EndpointContextMatcher endpointMatcher, final RawData msg) {
        SslHandler sslHandler = channel.pipeline().get(SslHandler.class);
        if (sslHandler == null) {
            msg.onError(new IllegalStateException("Missing SslHandler"));
        } else {
            Future<Channel> handshakeFuture = sslHandler.handshakeFuture();
            handshakeFuture.addListener(new GenericFutureListener<Future<Channel>>(){

                @Override
                public void operationComplete(Future<Channel> future) throws Exception {
                    if (future.isSuccess()) {
                        EndpointContext context = TlsClientConnector.this.contextUtil.buildEndpointContext(channel);
                        if (context == null || context.get("TLS_SESSION_ID") == null) {
                            msg.onError(new IllegalStateException("Missing TlsEndpointContext " + context));
                            return;
                        }
                        TlsClientConnector.super.send(future.getNow(), endpointMatcher, msg);
                    } else if (future.isCancelled()) {
                        msg.onError(new CancellationException());
                    } else {
                        msg.onError(future.cause());
                    }
                }
            });
        }
    }

    @Override
    protected void onNewChannelCreated(SocketAddress remote, Channel ch) {
        SSLEngine sslEngine = this.createSllEngine(remote);
        sslEngine.setUseClientMode(true);
        SslHandler sslHandler = new SslHandler(sslEngine);
        sslHandler.setHandshakeTimeoutMillis(this.handshakeTimeoutMillis);
        ch.pipeline().addFirst(sslHandler);
    }

    @Override
    public String getProtocol() {
        return "TLS";
    }

    private SSLEngine createSllEngine(SocketAddress remoteAddress) {
        if (remoteAddress instanceof InetSocketAddress) {
            InetSocketAddress remote = (InetSocketAddress)remoteAddress;
            this.LOGGER.info("Connection to inet {}", (Object)remote);
            return this.sslContext.createSSLEngine(remote.getAddress().getHostAddress(), remote.getPort());
        }
        this.LOGGER.info("Connection to {}", (Object)remoteAddress);
        return this.sslContext.createSSLEngine();
    }
}

