/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.net.InetSocketAddress;
import java.security.MessageDigest;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import org.eclipse.californium.elements.util.DatagramReader;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.scandium.dtls.AlertMessage;
import org.eclipse.californium.scandium.dtls.HandshakeException;
import org.eclipse.californium.scandium.dtls.HandshakeMessage;
import org.eclipse.californium.scandium.dtls.HandshakeType;
import org.eclipse.californium.scandium.dtls.cipher.PseudoRandomFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Finished
extends HandshakeMessage {
    private static final Logger LOG = LoggerFactory.getLogger(Finished.class.getName());
    private final byte[] verifyData;

    public Finished(Mac hmac, SecretKey masterSecret, boolean isClient, byte[] handshakeHash, InetSocketAddress peerAddress) {
        super(peerAddress);
        this.verifyData = this.generateVerifyData(hmac, masterSecret, isClient, handshakeHash);
    }

    private Finished(DatagramReader reader, InetSocketAddress peerAddress) {
        super(peerAddress);
        this.verifyData = reader.readBytesLeft();
    }

    public void verifyData(Mac hmac, SecretKey masterSecret, boolean isClient, byte[] handshakeHash) throws HandshakeException {
        byte[] myVerifyData = this.generateVerifyData(hmac, masterSecret, isClient, handshakeHash);
        if (!MessageDigest.isEqual(myVerifyData, this.verifyData)) {
            StringBuilder msg = new StringBuilder("Verification of peer's [").append(this.getPeer()).append("] FINISHED message failed");
            if (LOG.isTraceEnabled()) {
                msg.append(StringUtil.lineSeparator()).append("Expected: ").append(StringUtil.byteArray2HexString(myVerifyData));
                msg.append(StringUtil.lineSeparator()).append("Received: ").append(StringUtil.byteArray2HexString(this.verifyData));
            }
            LOG.debug(msg.toString());
            AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.HANDSHAKE_FAILURE, this.getPeer());
            throw new HandshakeException("Verification of FINISHED message failed", alert);
        }
    }

    private byte[] generateVerifyData(Mac hmac, SecretKey masterSecret, boolean isClient, byte[] handshakeHash) {
        if (isClient) {
            return PseudoRandomFunction.doPRF(hmac, masterSecret, PseudoRandomFunction.Label.CLIENT_FINISHED_LABEL, handshakeHash);
        }
        return PseudoRandomFunction.doPRF(hmac, masterSecret, PseudoRandomFunction.Label.SERVER_FINISHED_LABEL, handshakeHash);
    }

    @Override
    public HandshakeType getMessageType() {
        return HandshakeType.FINISHED;
    }

    @Override
    public int getMessageLength() {
        return this.verifyData.length;
    }

    @Override
    public String toString() {
        return super.toString() + "\t\tVerify Data: " + StringUtil.byteArray2HexString(this.verifyData) + StringUtil.lineSeparator();
    }

    @Override
    public byte[] fragmentToByteArray() {
        return this.verifyData;
    }

    public static HandshakeMessage fromReader(DatagramReader reader, InetSocketAddress peerAddress) {
        return new Finished(reader, peerAddress);
    }
}

