/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements.util;

import java.io.ByteArrayInputStream;
import java.util.Arrays;

public final class DatagramReader {
    private final ByteArrayInputStream byteStream;
    private byte currentByte;
    private int currentBitIndex;
    private byte markByte;
    private int markBitIndex;

    public DatagramReader(byte[] byteArray) {
        this(byteArray, true);
    }

    public DatagramReader(byte[] byteArray, boolean copy) {
        this.byteStream = new RangeInputStream(copy ? Arrays.copyOf(byteArray, byteArray.length) : byteArray);
        this.currentByte = 0;
        this.currentBitIndex = -1;
        this.markByte = this.currentByte;
        this.markBitIndex = this.currentBitIndex;
    }

    public DatagramReader(ByteArrayInputStream byteStream) {
        if (byteStream == null) {
            throw new NullPointerException("byte stream must not be null!");
        }
        this.byteStream = byteStream;
        this.currentByte = 0;
        this.currentBitIndex = -1;
        this.markByte = this.currentByte;
        this.markBitIndex = this.currentBitIndex;
    }

    public void mark() {
        this.markByte = this.currentByte;
        this.markBitIndex = this.currentBitIndex;
        this.byteStream.mark(0);
    }

    public void reset() {
        this.byteStream.reset();
        this.currentByte = this.markByte;
        this.currentBitIndex = this.markBitIndex;
    }

    public void close() {
        this.byteStream.skip(this.byteStream.available());
        this.currentByte = 0;
        this.currentBitIndex = -1;
    }

    public long readLong(int numBits) {
        long bits = 0L;
        for (int i = numBits - 1; i >= 0; --i) {
            boolean bit;
            if (this.currentBitIndex < 0) {
                this.readCurrentByte();
            }
            boolean bl = bit = (this.currentByte >> this.currentBitIndex & 1) != 0;
            if (bit) {
                bits |= 1L << i;
            }
            --this.currentBitIndex;
        }
        return bits;
    }

    public int read(int numBits) {
        int bits = 0;
        for (int i = numBits - 1; i >= 0; --i) {
            boolean bit;
            if (this.currentBitIndex < 0) {
                this.readCurrentByte();
            }
            boolean bl = bit = (this.currentByte >> this.currentBitIndex & 1) != 0;
            if (bit) {
                bits |= 1 << i;
            }
            --this.currentBitIndex;
        }
        return bits;
    }

    public byte[] readBytes(int count) {
        int available = this.byteStream.available();
        int bytesToRead = count;
        if (bytesToRead < 0) {
            bytesToRead = available;
        } else if (bytesToRead > available) {
            throw new IllegalArgumentException("requested " + count + " bytes exceeds available " + available + " bytes.");
        }
        byte[] bytes = new byte[bytesToRead];
        if (this.currentBitIndex >= 0) {
            for (int i = 0; i < bytesToRead; ++i) {
                bytes[i] = (byte)this.read(8);
            }
        } else {
            this.byteStream.read(bytes, 0, bytes.length);
        }
        return bytes;
    }

    public byte readNextByte() {
        byte[] bytes = this.readBytes(1);
        return bytes[0];
    }

    public byte[] readBytesLeft() {
        return this.readBytes(-1);
    }

    public boolean bytesAvailable() {
        return this.byteStream.available() > 0;
    }

    public boolean bytesAvailable(int expectedBytes) {
        int bytesLeft = this.byteStream.available();
        return bytesLeft >= expectedBytes;
    }

    public int bitsLeft() {
        return this.byteStream.available() * 8 + (this.currentBitIndex + 1);
    }

    public DatagramReader createRangeReader(int count) {
        return new DatagramReader(this.createRangeInputStream(count));
    }

    public ByteArrayInputStream createRangeInputStream(int count) {
        if (this.currentBitIndex > 0) {
            throw new IllegalStateException(this.currentBitIndex + " bits unread!");
        }
        int available = this.byteStream.available();
        if (available < count) {
            throw new IllegalArgumentException("requested " + count + " bytes exceeds available " + available + " bytes.");
        }
        if (this.byteStream instanceof RangeInputStream) {
            RangeInputStream range = (RangeInputStream)this.byteStream;
            return range.range(count);
        }
        byte[] range = new byte[count];
        this.byteStream.read(range, 0, count);
        return new RangeInputStream(range);
    }

    private void readCurrentByte() {
        int val = this.byteStream.read();
        if (val < 0) {
            throw new IllegalArgumentException("requested byte exceeds available bytes!");
        }
        this.currentByte = (byte)val;
        this.currentBitIndex = 7;
    }

    private static class RangeInputStream
    extends ByteArrayInputStream {
        private RangeInputStream(byte[] buffer) {
            super(buffer);
        }

        private RangeInputStream(byte[] buffer, int offset, int length) {
            super(buffer, offset, length);
        }

        private RangeInputStream range(int count) {
            int offset = this.pos;
            long available = this.skip(count);
            if (available < (long)count) {
                throw new IllegalArgumentException("requested " + count + " bytes exceeds available " + available + " bytes.");
            }
            return new RangeInputStream(this.buf, offset, count);
        }
    }
}

