/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import org.eclipse.californium.elements.UDPConnector;

public class UdpMulticastConnector
extends UDPConnector {
    private InetAddress intfAddress;
    private InetAddress[] multicastGroups;

    public UdpMulticastConnector(InetAddress intfAddress, InetSocketAddress localAddress, InetAddress ... multicastGroups) {
        super(localAddress);
        this.intfAddress = intfAddress;
        this.multicastGroups = multicastGroups;
    }

    public UdpMulticastConnector(InetSocketAddress localAddress, InetAddress ... multicastGroups) {
        this(null, localAddress, multicastGroups);
    }

    @Override
    public synchronized void start() throws IOException {
        if (this.running) {
            return;
        }
        MulticastSocket socket = new MulticastSocket(this.localAddr);
        if (this.intfAddress != null && !this.intfAddress.isAnyLocalAddress()) {
            socket.setInterface(this.intfAddress);
        }
        for (InetAddress group : this.multicastGroups) {
            socket.joinGroup(group);
        }
        this.init(socket);
    }
}

