/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls.cipher;

import java.security.GeneralSecurityException;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import org.eclipse.californium.elements.util.NotForAndroid;
import org.eclipse.californium.scandium.dtls.cipher.CCMBlockCipher;
import org.eclipse.californium.scandium.dtls.cipher.CipherSuite;

public class AeadBlockCipher {
    public static final String AES_CCM = "AES/CCM";

    public static final boolean isSupported(String transformation, int keyLength) {
        try {
            Cipher cipher = AES_CCM.equals(transformation) ? (Cipher)CCMBlockCipher.CIPHER.current() : Cipher.getInstance(transformation);
            if (cipher != null) {
                int maxAllowedKeyLengthBits = Cipher.getMaxAllowedKeyLength(cipher.getAlgorithm());
                return keyLength * 8 <= maxAllowedKeyLengthBits;
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            // empty catch block
        }
        return false;
    }

    public static final byte[] decrypt(CipherSuite suite, SecretKey key, byte[] nonce, byte[] a, byte[] c) throws GeneralSecurityException {
        if (AES_CCM.equals(suite.getTransformation())) {
            return CCMBlockCipher.decrypt(key, nonce, a, c, suite.getMacLength());
        }
        return AeadBlockCipher.jreDecrypt(suite, key, nonce, a, c);
    }

    public static final byte[] encrypt(CipherSuite suite, SecretKey key, byte[] nonce, byte[] a, byte[] m) throws GeneralSecurityException {
        if (AES_CCM.equals(suite.getTransformation())) {
            return CCMBlockCipher.encrypt(key, nonce, a, m, suite.getMacLength());
        }
        return AeadBlockCipher.jreEncrypt(suite, key, nonce, a, m);
    }

    @NotForAndroid
    private static final byte[] jreDecrypt(CipherSuite suite, SecretKey key, byte[] nonce, byte[] a, byte[] c) throws GeneralSecurityException {
        Cipher cipher = suite.getThreadLocalCipher();
        GCMParameterSpec parameterSpec = new GCMParameterSpec(suite.getMacLength() * 8, nonce);
        cipher.init(2, (Key)key, parameterSpec);
        cipher.updateAAD(a);
        return cipher.doFinal(c);
    }

    @NotForAndroid
    private static final byte[] jreEncrypt(CipherSuite suite, SecretKey key, byte[] nonce, byte[] a, byte[] m) throws GeneralSecurityException {
        Cipher cipher = suite.getThreadLocalCipher();
        GCMParameterSpec parameterSpec = new GCMParameterSpec(suite.getMacLength() * 8, nonce);
        cipher.init(1, (Key)key, parameterSpec);
        cipher.updateAAD(a);
        return cipher.doFinal(m);
    }
}

