/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements;

import java.net.InetSocketAddress;
import java.util.Set;
import org.eclipse.californium.elements.DtlsEndpointContext;
import org.eclipse.californium.elements.EndpointContext;
import org.eclipse.californium.elements.EndpointContextUtil;
import org.eclipse.californium.elements.KeySetEndpointContextMatcher;
import org.eclipse.californium.elements.MapBasedEndpointContext;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class EndpointContextUtilTest {
    private static final InetSocketAddress ADDRESS = new InetSocketAddress(0);
    private EndpointContext connectorContext;
    private EndpointContext relaxedMessageContext;
    private EndpointContext strictMessageContext;
    private EndpointContext differentMessageContext;
    private EndpointContext unsecureMessageContext;
    private EndpointContext unsecureMessageContext2;

    @Before
    public void setup() {
        this.connectorContext = new DtlsEndpointContext(ADDRESS, null, "session", "1", "CIPHER", "100");
        this.relaxedMessageContext = new DtlsEndpointContext(ADDRESS, null, "session", "2", "CIPHER", "200");
        this.strictMessageContext = new DtlsEndpointContext(ADDRESS, null, "session", "1", "CIPHER", "100");
        this.differentMessageContext = new DtlsEndpointContext(ADDRESS, null, "new session", "1", "CIPHER", "100");
        MapBasedEndpointContext mapBasedContext = new MapBasedEndpointContext(ADDRESS, null, "ID", "session", "UNKNOWN", "secret");
        this.unsecureMessageContext = mapBasedContext;
        mapBasedContext = new MapBasedEndpointContext(ADDRESS, null, "ID", "session", "UNKNOWN", "topsecret");
        this.unsecureMessageContext2 = mapBasedContext;
    }

    @Test
    public void testEndpointContextUtil() {
        Set<String> keys = KeySetEndpointContextMatcher.createKeySet("DTLS_SESSION_ID", "DTLS_CIPHER");
        Assert.assertThat((Object)EndpointContextUtil.match("test-1", keys, this.strictMessageContext, this.connectorContext), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)EndpointContextUtil.match("test-2", keys, this.relaxedMessageContext, this.connectorContext), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)EndpointContextUtil.match("test-3", keys, this.differentMessageContext, this.connectorContext), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)EndpointContextUtil.match("test-4", keys, this.differentMessageContext, this.unsecureMessageContext), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)EndpointContextUtil.match("test-5", keys, this.unsecureMessageContext, this.unsecureMessageContext2), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testEndpointContextUtilWithAdditionalKey() {
        Set<String> keys = KeySetEndpointContextMatcher.createKeySet("DTLS_SESSION_ID", "DTLS_CIPHER", "UNKNOWN");
        Assert.assertThat((Object)EndpointContextUtil.match("test-1", keys, this.strictMessageContext, this.connectorContext), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)EndpointContextUtil.match("test-2", keys, this.relaxedMessageContext, this.connectorContext), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)EndpointContextUtil.match("test-3", keys, this.differentMessageContext, this.connectorContext), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)EndpointContextUtil.match("test-4", keys, this.differentMessageContext, this.unsecureMessageContext), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)EndpointContextUtil.match("test-5", keys, this.unsecureMessageContext, this.unsecureMessageContext2), (Matcher)CoreMatchers.is((Object)false));
    }
}

