/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.observe;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.elements.util.ClockUtil;

public class ObserveNotificationOrderer {
    private final AtomicInteger number = new AtomicInteger();
    private long nanoTimestamp;

    public ObserveNotificationOrderer() {
    }

    public ObserveNotificationOrderer(Integer observe) {
        if (observe == null) {
            throw new NullPointerException("observe option must not be null!");
        }
        this.number.set(observe);
        this.nanoTimestamp = ClockUtil.nanoRealtime();
    }

    public int getNextObserveNumber() {
        int next = this.number.incrementAndGet();
        while (next >= 0x1000000) {
            this.number.compareAndSet(next, 0);
            next = this.number.incrementAndGet();
        }
        return next;
    }

    public int getCurrent() {
        return this.number.get();
    }

    public synchronized boolean isNew(Response response) {
        Integer observe = response.getOptions().getObserve();
        if (observe == null) {
            return true;
        }
        long T1 = this.nanoTimestamp;
        int V1 = this.number.get();
        long T2 = ClockUtil.nanoRealtime();
        int V2 = observe;
        if (V1 < V2 && (long)(V2 - V1) < 0x800000L || V1 > V2 && (long)(V1 - V2) > 0x800000L || T2 > T1 + TimeUnit.SECONDS.toNanos(128L)) {
            this.nanoTimestamp = T2;
            this.number.set(V2);
            return true;
        }
        return false;
    }
}

