/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls.cipher;

import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.SecretKeySpec;
import org.eclipse.californium.elements.util.StandardCharsets;

public final class PseudoRandomFunction {
    public static final boolean isSupported(String macName, String hashName) {
        try {
            Mac.getInstance(macName);
        }
        catch (NoSuchAlgorithmException e) {
            return false;
        }
        try {
            MessageDigest.getInstance(hashName);
        }
        catch (NoSuchAlgorithmException e) {
            return false;
        }
        return true;
    }

    private PseudoRandomFunction() {
    }

    static byte[] doPRF(String algorithmMac, byte[] secret, byte[] label, byte[] seed, int length) {
        try {
            Mac hmac = Mac.getInstance(algorithmMac);
            hmac.init(new SecretKeySpec(secret, "MAC"));
            return PseudoRandomFunction.doExpansion(hmac, label, seed, length);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(String.format("MAC algorithm %s is not available on JVM", algorithmMac), e);
        }
        catch (InvalidKeyException e) {
            throw new IllegalArgumentException("Cannot run Pseudo Random Function with invalid key", e);
        }
    }

    public static final byte[] doPRF(String algorithmMac, byte[] secret, Label label, byte[] seed) {
        return PseudoRandomFunction.doPRF(algorithmMac, secret, label.getBytes(), seed, label.length());
    }

    public static final byte[] doPRF(String algorithmMac, byte[] secret, Label label, byte[] seed, int length) {
        return PseudoRandomFunction.doPRF(algorithmMac, secret, label.getBytes(), seed, length);
    }

    public static final byte[] doExpansion(Mac hmac, byte[] label, byte[] seed, int length) {
        int offset = 0;
        int macLength = hmac.getMacLength();
        byte[] aAndSeed = new byte[macLength + label.length + seed.length];
        byte[] expansion = new byte[length];
        try {
            System.arraycopy(label, 0, aAndSeed, macLength, label.length);
            System.arraycopy(seed, 0, aAndSeed, macLength + label.length, seed.length);
            hmac.update(label);
            hmac.update(seed);
            while (true) {
                hmac.doFinal(aAndSeed, 0);
                hmac.update(aAndSeed);
                int nextOffset = offset + macLength;
                if (nextOffset > length) {
                    hmac.doFinal(aAndSeed, 0);
                    System.arraycopy(aAndSeed, 0, expansion, offset, length - offset);
                } else {
                    hmac.doFinal(expansion, offset);
                    if (nextOffset != length) {
                        offset = nextOffset;
                        hmac.update(aAndSeed, 0, macLength);
                        continue;
                    }
                }
                break;
            }
        }
        catch (ShortBufferException e) {
            e.printStackTrace();
        }
        return expansion;
    }

    public static enum Label {
        MASTER_SECRET_LABEL("master secret", 48),
        KEY_EXPANSION_LABEL("key expansion", 128),
        CLIENT_FINISHED_LABEL("client finished", 12),
        SERVER_FINISHED_LABEL("server finished", 12);

        private final String value;
        private final byte[] bytesValue;
        private final int length;

        private Label(String value, int length) {
            this.value = value;
            this.bytesValue = value.getBytes(StandardCharsets.UTF_8);
            this.length = length;
        }

        public String value() {
            return this.value;
        }

        public byte[] getBytes() {
            return this.bytesValue;
        }

        public int length() {
            return this.length;
        }
    }
}

