/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.PublicKey;
import java.security.cert.CertPath;
import java.util.Arrays;
import java.util.List;
import org.eclipse.californium.elements.auth.PreSharedKeyIdentity;
import org.eclipse.californium.elements.auth.RawPublicKeyIdentity;
import org.eclipse.californium.elements.auth.X509CertPath;
import org.eclipse.californium.elements.util.DatagramWriter;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.scandium.config.DtlsConnectorConfig;
import org.eclipse.californium.scandium.dtls.AlertMessage;
import org.eclipse.californium.scandium.dtls.CertificateMessage;
import org.eclipse.californium.scandium.dtls.CertificateRequest;
import org.eclipse.californium.scandium.dtls.CertificateType;
import org.eclipse.californium.scandium.dtls.CertificateTypeExtension;
import org.eclipse.californium.scandium.dtls.CertificateVerify;
import org.eclipse.californium.scandium.dtls.ChangeCipherSpecMessage;
import org.eclipse.californium.scandium.dtls.ClientCertificateTypeExtension;
import org.eclipse.californium.scandium.dtls.ClientHello;
import org.eclipse.californium.scandium.dtls.ClientKeyExchange;
import org.eclipse.californium.scandium.dtls.CompressionMethod;
import org.eclipse.californium.scandium.dtls.Connection;
import org.eclipse.californium.scandium.dtls.ConnectionId;
import org.eclipse.californium.scandium.dtls.ConnectionIdExtension;
import org.eclipse.californium.scandium.dtls.DTLSFlight;
import org.eclipse.californium.scandium.dtls.DTLSMessage;
import org.eclipse.californium.scandium.dtls.DTLSSession;
import org.eclipse.californium.scandium.dtls.ECDHClientKeyExchange;
import org.eclipse.californium.scandium.dtls.ECDHServerKeyExchange;
import org.eclipse.californium.scandium.dtls.EcdhPskClientKeyExchange;
import org.eclipse.californium.scandium.dtls.EcdhPskServerKeyExchange;
import org.eclipse.californium.scandium.dtls.Finished;
import org.eclipse.californium.scandium.dtls.HandshakeException;
import org.eclipse.californium.scandium.dtls.HandshakeMessage;
import org.eclipse.californium.scandium.dtls.HandshakeType;
import org.eclipse.californium.scandium.dtls.Handshaker;
import org.eclipse.californium.scandium.dtls.HelloExtensions;
import org.eclipse.californium.scandium.dtls.MaxFragmentLengthExtension;
import org.eclipse.californium.scandium.dtls.NULLClientKeyExchange;
import org.eclipse.californium.scandium.dtls.PSKClientKeyExchange;
import org.eclipse.californium.scandium.dtls.ProtocolVersion;
import org.eclipse.californium.scandium.dtls.PskPublicInformation;
import org.eclipse.californium.scandium.dtls.Random;
import org.eclipse.californium.scandium.dtls.RecordLayer;
import org.eclipse.californium.scandium.dtls.ServerCertificateTypeExtension;
import org.eclipse.californium.scandium.dtls.ServerHello;
import org.eclipse.californium.scandium.dtls.ServerHelloDone;
import org.eclipse.californium.scandium.dtls.ServerNameExtension;
import org.eclipse.californium.scandium.dtls.SessionId;
import org.eclipse.californium.scandium.dtls.SignatureAndHashAlgorithm;
import org.eclipse.californium.scandium.dtls.SupportedEllipticCurvesExtension;
import org.eclipse.californium.scandium.dtls.SupportedPointFormatsExtension;
import org.eclipse.californium.scandium.dtls.cipher.CipherSuite;
import org.eclipse.californium.scandium.dtls.cipher.ECDHECryptography;
import org.eclipse.californium.scandium.dtls.pskstore.PskStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerHandshaker
extends Handshaker {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerHandshaker.class.getName());
    private DTLSFlight lastFlight;
    private boolean useNoSessionId = false;
    private boolean clientAuthenticationWanted = false;
    private boolean clientAuthenticationRequired = false;
    private PublicKey clientPublicKey;
    private List<CipherSuite> supportedCipherSuites;
    private final List<CertificateType> supportedClientCertificateTypes;
    private final List<CertificateType> supportedServerCertificateTypes;
    private CertificateType negotiatedClientCertificateType;
    private CertificateType negotiatedServerCertificateType;
    private ECDHECryptography.SupportedGroup negotiatedSupportedGroup;
    private SignatureAndHashAlgorithm signatureAndHashAlgorithm;
    protected DatagramWriter handshakeMessages;
    protected CertificateMessage clientCertificate = null;
    protected ClientKeyExchange clientKeyExchange;
    protected CertificateVerify certificateVerify = null;
    protected final PskStore pskStore;
    private PskPublicInformation preSharedKeyIdentity;

    public ServerHandshaker(int initialMessageSequenceNo, DTLSSession session, RecordLayer recordLayer, Connection connection, DtlsConnectorConfig config, int maxTransmissionUnit) {
        super(false, initialMessageSequenceNo, session, recordLayer, connection, config, maxTransmissionUnit);
        this.supportedCipherSuites = config.getSupportedCipherSuites();
        this.pskStore = config.getPskStore();
        this.privateKey = config.getPrivateKey();
        this.certificateChain = config.getCertificateChain();
        this.publicKey = config.getPublicKey();
        this.sniEnabled = config.isSniEnabled();
        this.clientAuthenticationWanted = config.isClientAuthenticationWanted();
        this.clientAuthenticationRequired = config.isClientAuthenticationRequired();
        this.useNoSessionId = config.useNoServerSessionId();
        this.supportedClientCertificateTypes = config.getTrustCertificateTypes();
        this.supportedServerCertificateTypes = config.getIdentityCertificateTypes();
    }

    public PskPublicInformation getPreSharedKeyIdentity() {
        return this.preSharedKeyIdentity;
    }

    @Override
    protected void doProcessMessage(DTLSMessage message) throws HandshakeException, GeneralSecurityException {
        if (this.lastFlight != null) {
            LOGGER.debug("Received client's ({}) FINISHED message again, retransmitting last flight...", (Object)this.getPeerAddress());
            this.lastFlight.incrementTries();
            this.lastFlight.setNewSequenceNumbers();
            this.sendFlight(this.lastFlight);
            return;
        }
        if (LOGGER.isDebugEnabled()) {
            StringBuilder msg = new StringBuilder();
            msg.append("Processing {} message from peer [{}]");
            if (LOGGER.isTraceEnabled()) {
                msg.append(":").append(StringUtil.lineSeparator()).append(message);
            }
            LOGGER.debug(msg.toString(), (Object)message.getContentType(), (Object)message.getPeer());
        }
        switch (message.getContentType()) {
            case CHANGE_CIPHER_SPEC: {
                this.setCurrentReadState();
                LOGGER.debug("Processed {} message from peer [{}]", (Object)message.getContentType(), (Object)message.getPeer());
                break;
            }
            case HANDSHAKE: {
                HandshakeMessage handshakeMsg = (HandshakeMessage)message;
                switch (handshakeMsg.getMessageType()) {
                    case CLIENT_HELLO: {
                        this.receivedClientHello((ClientHello)handshakeMsg);
                        break;
                    }
                    case CERTIFICATE: {
                        this.receivedClientCertificate((CertificateMessage)handshakeMsg);
                        break;
                    }
                    case CLIENT_KEY_EXCHANGE: {
                        switch (this.getKeyExchangeAlgorithm()) {
                            case PSK: {
                                byte[] premasterSecret = this.receivedClientKeyExchange((PSKClientKeyExchange)handshakeMsg);
                                this.generateKeys(premasterSecret);
                                break;
                            }
                            case ECDHE_PSK: {
                                byte[] premasterSecret = this.receivedClientKeyExchange((EcdhPskClientKeyExchange)handshakeMsg);
                                this.generateKeys(premasterSecret);
                                break;
                            }
                            case EC_DIFFIE_HELLMAN: {
                                byte[] premasterSecret = this.receivedClientKeyExchange((ECDHClientKeyExchange)handshakeMsg);
                                this.generateKeys(premasterSecret);
                                break;
                            }
                            case NULL: {
                                byte[] premasterSecret = this.receivedClientKeyExchange((NULLClientKeyExchange)handshakeMsg);
                                this.generateKeys(premasterSecret);
                                break;
                            }
                            default: {
                                throw new HandshakeException(String.format("Unsupported key exchange algorithm %s", this.getKeyExchangeAlgorithm().name()), new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.HANDSHAKE_FAILURE, handshakeMsg.getPeer()));
                            }
                        }
                        this.handshakeMessages.writeBytes(this.clientKeyExchange.getRawMessage());
                        if (this.clientAuthenticationRequired && this.getKeyExchangeAlgorithm() == CipherSuite.KeyExchangeAlgorithm.EC_DIFFIE_HELLMAN) break;
                        this.expectChangeCipherSpecMessage();
                        break;
                    }
                    case CERTIFICATE_VERIFY: {
                        this.receivedCertificateVerify((CertificateVerify)handshakeMsg);
                        this.expectChangeCipherSpecMessage();
                        break;
                    }
                    case FINISHED: {
                        this.receivedClientFinished((Finished)handshakeMsg);
                        break;
                    }
                    default: {
                        throw new HandshakeException(String.format("Received unexpected %s message from peer %s", new Object[]{handshakeMsg.getMessageType(), handshakeMsg.getPeer()}), new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.UNEXPECTED_MESSAGE, handshakeMsg.getPeer()));
                    }
                }
                if (this.lastFlight == null) {
                    this.incrementNextReceiveSeq();
                }
                LOGGER.debug("Processed {} message with message sequence no [{}] from peer [{}]", new Object[]{handshakeMsg.getMessageType(), handshakeMsg.getMessageSeq(), message.getPeer()});
                break;
            }
            default: {
                throw new HandshakeException(String.format("Received unexpected %s message from peer %s", new Object[]{message.getContentType(), message.getPeer()}), new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.HANDSHAKE_FAILURE, message.getPeer()));
            }
        }
    }

    private void receivedClientCertificate(CertificateMessage message) throws HandshakeException {
        if (this.clientCertificate != null && this.clientCertificate.getMessageSeq() == message.getMessageSeq()) {
            return;
        }
        this.clientCertificate = message;
        if (this.clientAuthenticationRequired && this.clientCertificate.getCertificateChain() != null && this.clientCertificate.getPublicKey() == null) {
            LOGGER.debug("Client authentication failed: missing certificate!");
            AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.HANDSHAKE_FAILURE, this.session.getPeer());
            throw new HandshakeException("Client Certificate required!", alert);
        }
        this.verifyCertificate(this.clientCertificate);
        this.clientPublicKey = this.clientCertificate.getPublicKey();
        this.handshakeMessages.writeBytes(this.clientCertificate.getRawMessage());
    }

    private void receivedCertificateVerify(CertificateVerify message) throws HandshakeException {
        this.certificateVerify = message;
        message.verifySignature(this.clientPublicKey, this.handshakeMessages.toByteArray());
        CertPath peerCertPath = this.clientCertificate.getCertificateChain();
        if (peerCertPath != null) {
            this.session.setPeerIdentity(new X509CertPath(peerCertPath));
        } else {
            this.session.setPeerIdentity(new RawPublicKeyIdentity(this.clientPublicKey));
        }
    }

    private void receivedClientFinished(Finished message) throws HandshakeException {
        if (this.lastFlight != null) {
            return;
        }
        if (CipherSuite.KeyExchangeAlgorithm.EC_DIFFIE_HELLMAN.equals((Object)this.getKeyExchangeAlgorithm()) && this.clientAuthenticationRequired && (this.clientCertificate == null || this.certificateVerify == null)) {
            AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.HANDSHAKE_FAILURE, this.session.getPeer());
            throw new HandshakeException("Client did not send required authentication messages.", alert);
        }
        this.flightNumber += 2;
        DTLSFlight flight = new DTLSFlight(this.getSession(), this.flightNumber);
        if (this.clientCertificate != null) {
            this.md.update(this.clientCertificate.getRawMessage());
        }
        this.md.update(this.clientKeyExchange.getRawMessage());
        if (this.certificateVerify != null) {
            this.md.update(this.certificateVerify.getRawMessage());
        }
        MessageDigest mdWithClientFinished = null;
        try {
            mdWithClientFinished = (MessageDigest)this.md.clone();
            mdWithClientFinished.update(message.toByteArray());
        }
        catch (CloneNotSupportedException e) {
            LOGGER.error("Cannot compute digest for server's Finish handshake message", e);
        }
        byte[] handshakeHash = this.md.digest();
        String prfMacName = this.session.getCipherSuite().getPseudoRandomFunctionMacName();
        message.verifyData(prfMacName, this.session.getMasterSecret(), true, handshakeHash);
        ChangeCipherSpecMessage changeCipherSpecMessage = new ChangeCipherSpecMessage(this.session.getPeer());
        this.wrapMessage(flight, changeCipherSpecMessage);
        this.setCurrentWriteState();
        handshakeHash = mdWithClientFinished.digest();
        Finished finished = new Finished(prfMacName, this.session.getMasterSecret(), this.isClient, handshakeHash, this.session.getPeer());
        this.wrapMessage(flight, finished);
        this.state = HandshakeType.FINISHED.getCode();
        flight.setRetransmissionNeeded(false);
        this.lastFlight = flight;
        this.sendFlight(flight);
        this.sessionEstablished();
    }

    private void receivedClientHello(ClientHello clientHello) throws HandshakeException {
        this.handshakeStarted();
        byte[] cookie = clientHello.getCookie();
        this.flightNumber = cookie != null && cookie.length > 0 ? 4 : 2;
        this.handshakeMessages = new DatagramWriter(2048);
        DTLSFlight flight = new DTLSFlight(this.getSession(), this.flightNumber);
        this.createServerHello(clientHello, flight);
        this.createCertificateMessage(clientHello, flight);
        this.createServerKeyExchange(clientHello, flight);
        this.createCertificateRequest(clientHello, flight);
        ServerHelloDone serverHelloDone = new ServerHelloDone(this.session.getPeer());
        this.wrapMessage(flight, serverHelloDone);
        this.md.update(serverHelloDone.toByteArray());
        this.handshakeMessages.writeBytes(serverHelloDone.toByteArray());
        this.sendFlight(flight);
    }

    private void createServerHello(ClientHello clientHello, DTLSFlight flight) throws HandshakeException {
        ProtocolVersion serverVersion = this.negotiateProtocolVersion(clientHello.getClientVersion());
        this.clientRandom = clientHello.getRandom();
        this.serverRandom = new Random();
        SessionId sessionId = this.useNoSessionId ? SessionId.emptySessionId() : new SessionId();
        this.session.setSessionIdentifier(sessionId);
        if (!clientHello.getCompressionMethods().contains((Object)CompressionMethod.NULL)) {
            throw new HandshakeException("Client does not support NULL compression method", new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.HANDSHAKE_FAILURE, clientHello.getPeer()));
        }
        this.session.setCompressionMethod(CompressionMethod.NULL);
        HelloExtensions serverHelloExtensions = new HelloExtensions();
        this.negotiateCipherSuite(clientHello, serverHelloExtensions);
        this.processHelloExtensions(clientHello, serverHelloExtensions);
        ServerHello serverHello = new ServerHello(serverVersion, this.serverRandom, sessionId, this.session.getCipherSuite(), this.session.getCompressionMethod(), serverHelloExtensions, this.session.getPeer());
        this.wrapMessage(flight, serverHello);
        this.initMessageDigest();
        this.md.update(clientHello.getRawMessage());
        this.handshakeMessages.writeBytes(clientHello.getRawMessage());
        this.md.update(serverHello.toByteArray());
        this.handshakeMessages.writeBytes(serverHello.toByteArray());
    }

    private void createCertificateMessage(ClientHello clientHello, DTLSFlight flight) throws HandshakeException {
        CertificateMessage certificateMessage = null;
        if (this.session.getCipherSuite().requiresServerCertificateMessage()) {
            if (CertificateType.RAW_PUBLIC_KEY == this.session.sendCertificateType()) {
                certificateMessage = new CertificateMessage(this.publicKey.getEncoded(), this.session.getPeer());
            } else if (CertificateType.X_509 == this.session.sendCertificateType()) {
                certificateMessage = new CertificateMessage(this.certificateChain, this.session.getPeer());
            } else {
                throw new IllegalArgumentException("Certificate type " + (Object)((Object)this.session.sendCertificateType()) + " not supported!");
            }
            this.wrapMessage(flight, certificateMessage);
            this.md.update(certificateMessage.toByteArray());
            this.handshakeMessages.writeBytes(certificateMessage.toByteArray());
        }
    }

    private void createServerKeyExchange(ClientHello clientHello, DTLSFlight flight) throws HandshakeException {
        HandshakeMessage serverKeyExchange = null;
        switch (this.getKeyExchangeAlgorithm()) {
            case EC_DIFFIE_HELLMAN: {
                this.signatureAndHashAlgorithm = new SignatureAndHashAlgorithm(SignatureAndHashAlgorithm.HashAlgorithm.SHA256, SignatureAndHashAlgorithm.SignatureAlgorithm.ECDSA);
                try {
                    this.ecdhe = new ECDHECryptography(this.negotiatedSupportedGroup.getEcParams());
                    serverKeyExchange = new ECDHServerKeyExchange(this.signatureAndHashAlgorithm, this.ecdhe, this.privateKey, this.clientRandom, this.serverRandom, this.negotiatedSupportedGroup.getId(), this.session.getPeer());
                    break;
                }
                catch (GeneralSecurityException e) {
                    throw new HandshakeException(String.format("Error performing EC Diffie Hellman key exchange: %s", e.getMessage()), new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.INTERNAL_ERROR, this.getPeerAddress()));
                }
            }
            case PSK: {
                break;
            }
            case ECDHE_PSK: {
                try {
                    this.ecdhe = new ECDHECryptography(this.negotiatedSupportedGroup.getEcParams());
                    serverKeyExchange = new EcdhPskServerKeyExchange(PskPublicInformation.EMPTY, this.ecdhe, this.clientRandom, this.serverRandom, this.negotiatedSupportedGroup.getId(), this.session.getPeer());
                    break;
                }
                catch (GeneralSecurityException e) {
                    throw new HandshakeException(String.format("Error performing EC Diffie Hellman key exchange: %s", e.getMessage()), new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.INTERNAL_ERROR, this.getPeerAddress()));
                }
            }
        }
        if (serverKeyExchange != null) {
            this.wrapMessage(flight, serverKeyExchange);
            this.md.update(serverKeyExchange.toByteArray());
            this.handshakeMessages.writeBytes(serverKeyExchange.toByteArray());
        }
    }

    private void createCertificateRequest(ClientHello clientHello, DTLSFlight flight) throws HandshakeException {
        if ((this.clientAuthenticationWanted || this.clientAuthenticationRequired) && this.signatureAndHashAlgorithm != null) {
            CertificateRequest certificateRequest = new CertificateRequest(this.session.getPeer());
            certificateRequest.addCertificateType(CertificateRequest.ClientCertificateType.ECDSA_SIGN);
            certificateRequest.addSignatureAlgorithm(new SignatureAndHashAlgorithm(this.signatureAndHashAlgorithm.getHash(), this.signatureAndHashAlgorithm.getSignature()));
            if (this.certificateVerifier != null) {
                certificateRequest.addCertificateAuthorities(this.certificateVerifier.getAcceptedIssuers());
            }
            this.wrapMessage(flight, certificateRequest);
            this.md.update(certificateRequest.toByteArray());
            this.handshakeMessages.writeBytes(certificateRequest.toByteArray());
        }
    }

    private byte[] receivedClientKeyExchange(ECDHClientKeyExchange message) {
        this.clientKeyExchange = message;
        byte[] premasterSecret = this.ecdhe.getSecret(message.getEncodedPoint()).getEncoded();
        return premasterSecret;
    }

    private byte[] receivedClientKeyExchange(PSKClientKeyExchange message) throws HandshakeException {
        this.clientKeyExchange = message;
        this.preSharedKeyIdentity = message.getIdentity();
        byte[] psk = this.pskStore.getKey(this.session.getServerNames(), this.preSharedKeyIdentity);
        return this.configurePskCredentials(this.preSharedKeyIdentity, psk, null);
    }

    private byte[] receivedClientKeyExchange(EcdhPskClientKeyExchange message) throws HandshakeException {
        this.clientKeyExchange = message;
        this.preSharedKeyIdentity = message.getIdentity();
        byte[] psk = this.pskStore.getKey(this.session.getServerNames(), this.preSharedKeyIdentity);
        byte[] otherSecret = this.ecdhe.getSecret(message.getEncodedPoint()).getEncoded();
        return this.configurePskCredentials(this.preSharedKeyIdentity, psk, otherSecret);
    }

    private byte[] receivedClientKeyExchange(NULLClientKeyExchange message) {
        this.clientKeyExchange = message;
        return new byte[0];
    }

    protected void processHelloExtensions(ClientHello clientHello, HelloExtensions serverHelloExtensions) {
        ConnectionIdExtension connectionIdExtension;
        ServerNameExtension serverNameExt;
        MaxFragmentLengthExtension maxFragmentLengthExt = clientHello.getMaxFragmentLengthExtension();
        if (maxFragmentLengthExt != null) {
            this.session.setMaxFragmentLength(maxFragmentLengthExt.getFragmentLength().length());
            serverHelloExtensions.addExtension(maxFragmentLengthExt);
            LOGGER.debug("Negotiated max. fragment length [{} bytes] with peer [{}]", (Object)maxFragmentLengthExt.getFragmentLength().length(), (Object)clientHello.getPeer());
        }
        if ((serverNameExt = clientHello.getServerNameExtension()) != null) {
            if (this.sniEnabled) {
                this.session.setServerNames(serverNameExt.getServerNames());
                serverHelloExtensions.addExtension(ServerNameExtension.emptyServerNameIndication());
                this.session.setSniSupported(true);
                LOGGER.debug("using server name indication received from peer [{}]", (Object)clientHello.getPeer());
            } else {
                LOGGER.debug("client [{}] included SNI in HELLO but SNI support is disabled", (Object)clientHello.getPeer());
            }
        }
        if (this.connectionIdGenerator != null && (connectionIdExtension = clientHello.getConnectionIdExtension()) != null) {
            this.session.setWriteConnectionId(connectionIdExtension.getConnectionId());
            ConnectionId connectionId = this.connectionIdGenerator.useConnectionId() ? this.getConnection().getConnectionId() : ConnectionId.EMPTY;
            ConnectionIdExtension extension = ConnectionIdExtension.fromConnectionId(connectionId);
            serverHelloExtensions.addExtension(extension);
        }
    }

    @Override
    public void startHandshake() throws HandshakeException {
        throw new HandshakeException("starting an handshake is not supported for server handshaker!", null);
    }

    private ProtocolVersion negotiateProtocolVersion(ProtocolVersion clientVersion) throws HandshakeException {
        ProtocolVersion version = new ProtocolVersion();
        if (clientVersion.compareTo(version) >= 0) {
            return new ProtocolVersion();
        }
        AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.PROTOCOL_VERSION, this.session.getPeer());
        throw new HandshakeException("The server only supports DTLS v1.2", alert);
    }

    private void negotiateCipherSuite(ClientHello clientHello, HelloExtensions serverHelloExtensions) throws HandshakeException {
        CertificateType supportedServerCertType = this.getSupportedServerCertificateType(clientHello);
        CertificateType supportedClientCertType = this.getSupportedClientCertificateType(clientHello);
        ECDHECryptography.SupportedGroup group = ServerHandshaker.negotiateNamedCurve(clientHello);
        for (CipherSuite cipherSuite : clientHello.getCipherSuites()) {
            if (cipherSuite == CipherSuite.TLS_NULL_WITH_NULL_NULL || !this.supportedCipherSuites.contains((Object)cipherSuite) || !this.isEligible(cipherSuite, supportedServerCertType, supportedClientCertType, group)) continue;
            this.negotiatedServerCertificateType = supportedServerCertType;
            this.negotiatedClientCertificateType = supportedClientCertType;
            this.negotiatedSupportedGroup = group;
            this.session.setCipherSuite(cipherSuite);
            this.addServerHelloExtensions(cipherSuite, clientHello, serverHelloExtensions);
            this.session.setParameterAvailable();
            LOGGER.debug("Negotiated cipher suite [{}] with peer [{}]", (Object)cipherSuite.name(), (Object)this.getPeerAddress());
            return;
        }
        AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.HANDSHAKE_FAILURE, this.session.getPeer());
        throw new HandshakeException("Client proposed unsupported cipher suites only", alert);
    }

    private boolean isEligible(CipherSuite cipher, CertificateType supportedServerCertType, CertificateType supportedClientCertType, ECDHECryptography.SupportedGroup group) {
        boolean result = true;
        if (cipher.isEccBased()) {
            result &= group != null;
        }
        if (cipher.requiresServerCertificateMessage()) {
            result &= supportedServerCertType != null;
            if (this.clientAuthenticationRequired || this.clientAuthenticationWanted) {
                result &= supportedClientCertType != null;
            }
        }
        return result;
    }

    private void addServerHelloExtensions(CipherSuite negotiatedCipherSuite, ClientHello clientHello, HelloExtensions extensions) {
        CertificateTypeExtension ext;
        if (this.negotiatedClientCertificateType != null) {
            this.session.setReceiveCertificateType(this.negotiatedClientCertificateType);
            if (clientHello.getClientCertificateTypeExtension() != null) {
                ext = new ClientCertificateTypeExtension(this.negotiatedClientCertificateType);
                extensions.addExtension(ext);
            }
        }
        if (this.negotiatedServerCertificateType != null) {
            this.session.setSendCertificateType(this.negotiatedServerCertificateType);
            if (clientHello.getServerCertificateTypeExtension() != null) {
                ext = new ServerCertificateTypeExtension(this.negotiatedServerCertificateType);
                extensions.addExtension(ext);
            }
        }
        if (negotiatedCipherSuite.isEccBased() && clientHello.getSupportedPointFormatsExtension() != null) {
            List<SupportedPointFormatsExtension.ECPointFormat> formats = Arrays.asList(SupportedPointFormatsExtension.ECPointFormat.UNCOMPRESSED);
            extensions.addExtension(new SupportedPointFormatsExtension(formats));
        }
    }

    private static ECDHECryptography.SupportedGroup negotiateNamedCurve(ClientHello clientHello) {
        ECDHECryptography.SupportedGroup result;
        block2: {
            SupportedEllipticCurvesExtension extension;
            List<ECDHECryptography.SupportedGroup> preferredGroups;
            block1: {
                result = null;
                preferredGroups = ECDHECryptography.SupportedGroup.getPreferredGroups();
                extension = clientHello.getSupportedEllipticCurvesExtension();
                if (extension != null) break block1;
                if (preferredGroups.isEmpty()) break block2;
                result = preferredGroups.get(0);
                break block2;
            }
            for (Integer preferredGroupId : extension.getSupportedGroupIds()) {
                ECDHECryptography.SupportedGroup group = ECDHECryptography.SupportedGroup.fromId(preferredGroupId);
                if (group == null || !group.isUsable() || !preferredGroups.contains((Object)group)) continue;
                result = group;
                break;
            }
        }
        return result;
    }

    private CertificateType getSupportedClientCertificateType(ClientHello clientHello) {
        return ServerHandshaker.getSupportedCertificateType(clientHello.getClientCertificateTypeExtension(), this.supportedClientCertificateTypes);
    }

    private CertificateType getSupportedServerCertificateType(ClientHello clientHello) {
        return ServerHandshaker.getSupportedCertificateType(clientHello.getServerCertificateTypeExtension(), this.supportedServerCertificateTypes);
    }

    private static CertificateType getSupportedCertificateType(CertificateTypeExtension certTypeExt, List<CertificateType> supportedCertificateTypes) {
        if (supportedCertificateTypes != null) {
            if (certTypeExt != null) {
                for (CertificateType certType : certTypeExt.getCertificateTypes()) {
                    if (!supportedCertificateTypes.contains((Object)certType)) continue;
                    return certType;
                }
            } else if (supportedCertificateTypes.contains((Object)CertificateType.X_509)) {
                return CertificateType.X_509;
            }
        }
        return null;
    }

    final CertificateType getNegotiatedClientCertificateType() {
        return this.negotiatedClientCertificateType;
    }

    final CertificateType getNegotiatedServerCertificateType() {
        return this.negotiatedServerCertificateType;
    }

    final ECDHECryptography.SupportedGroup getNegotiatedSupportedGroup() {
        return this.negotiatedSupportedGroup;
    }

    private byte[] configurePskCredentials(PskPublicInformation identity, byte[] psk, byte[] otherSecret) throws HandshakeException {
        String virtualHost = this.session.getVirtualHost();
        if (virtualHost == null) {
            LOGGER.debug("client [{}] uses PSK identity [{}]", (Object)this.getPeerAddress(), (Object)identity);
        } else {
            LOGGER.debug("client [{}] uses PSK identity [{}] for server [{}]", this.getPeerAddress(), identity, virtualHost);
        }
        if (psk == null) {
            throw new HandshakeException(String.format("cannot authenticate client, identity [%s] is unknown for server [%s]", identity, virtualHost), new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.UNKNOWN_PSK_IDENTITY, this.session.getPeer()));
        }
        if (this.sniEnabled) {
            this.session.setPeerIdentity(new PreSharedKeyIdentity(virtualHost, identity.getPublicInfoAsString()));
        } else {
            this.session.setPeerIdentity(new PreSharedKeyIdentity(identity.getPublicInfoAsString()));
        }
        return this.generatePremasterSecretFromPSK(psk, otherSecret);
    }
}

