/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements.auth;

import org.eclipse.californium.elements.auth.PreSharedKeyIdentity;
import org.junit.Assert;
import org.junit.Test;

public class PreSharedKeyIdentityTest {
    @Test(expected=IllegalArgumentException.class)
    public void testConstructorRejectsIllegalHostName() {
        new PreSharedKeyIdentity("illegal.host:name", "acme");
    }

    @Test
    public void testEqualsDetectsNonMatchingVirtualHost() {
        PreSharedKeyIdentity idOne = new PreSharedKeyIdentity("iot.eclipse.org", "device-1");
        PreSharedKeyIdentity idTwo = new PreSharedKeyIdentity("coap.eclipse.org", "device-1");
        Assert.assertFalse((boolean)idOne.equals(idTwo));
        Assert.assertTrue((boolean)idOne.isScopedIdentity());
    }

    @Test
    public void testEqualsSucceeds() {
        PreSharedKeyIdentity idOne = new PreSharedKeyIdentity("iot.eclipse.org", "device-1");
        PreSharedKeyIdentity idTwo = new PreSharedKeyIdentity("iot.eclipse.org", "device-1");
        Assert.assertTrue((boolean)idOne.equals(idTwo));
        Assert.assertTrue((boolean)idOne.isScopedIdentity());
    }

    @Test
    public void testEqualsFails() {
        PreSharedKeyIdentity idOne = new PreSharedKeyIdentity("device-1");
        PreSharedKeyIdentity idTwo = new PreSharedKeyIdentity(null, "device-1");
        Assert.assertFalse((boolean)idOne.equals(idTwo));
        Assert.assertFalse((boolean)idOne.isScopedIdentity());
        Assert.assertTrue((boolean)idTwo.isScopedIdentity());
    }
}

