/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements;

import java.net.InetSocketAddress;
import org.eclipse.californium.elements.AddressEndpointContext;
import org.eclipse.californium.elements.DtlsEndpointContext;
import org.eclipse.californium.elements.EndpointContext;
import org.eclipse.californium.elements.EndpointContextMatcher;
import org.eclipse.californium.elements.UdpEndpointContext;
import org.eclipse.californium.elements.UdpEndpointContextMatcher;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class UdpEndpointContextMatcherTest {
    private static final InetSocketAddress ADDRESS = new InetSocketAddress(5683);
    private static final InetSocketAddress CHANGED_ADDRESS = new InetSocketAddress(5684);
    private static final InetSocketAddress MULTICAST_ADDRESS = new InetSocketAddress("224.0.1.187", 5683);
    private EndpointContext connectorContext;
    private EndpointContext addressContext;
    private EndpointContext messageContext;
    private EndpointContext multicastContext;
    private EndpointContext changedAddressContext;
    private EndpointContext secureMessageContext;
    private EndpointContextMatcher matcher;

    @Before
    public void setup() {
        this.connectorContext = new UdpEndpointContext(ADDRESS);
        this.addressContext = new AddressEndpointContext(ADDRESS);
        this.messageContext = new UdpEndpointContext(ADDRESS);
        this.multicastContext = new UdpEndpointContext(MULTICAST_ADDRESS);
        this.changedAddressContext = new UdpEndpointContext(CHANGED_ADDRESS);
        this.secureMessageContext = new DtlsEndpointContext(ADDRESS, null, "session", "1", "CIPHER", "100");
        this.matcher = new UdpEndpointContextMatcher(true);
    }

    @Test
    public void testSending() {
        Assert.assertThat((Object)this.matcher.isToBeSent(this.addressContext, this.connectorContext), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)this.matcher.isToBeSent(this.messageContext, this.connectorContext), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)this.matcher.isToBeSent(this.secureMessageContext, this.connectorContext), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)this.matcher.isToBeSent(this.multicastContext, this.connectorContext), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testResponse() {
        Assert.assertThat((Object)this.matcher.isResponseRelatedToRequest(this.messageContext, this.messageContext), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)this.matcher.isResponseRelatedToRequest(this.messageContext, this.secureMessageContext), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)this.matcher.isResponseRelatedToRequest(this.secureMessageContext, this.messageContext), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)this.matcher.isResponseRelatedToRequest(this.addressContext, this.messageContext), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)this.matcher.isResponseRelatedToRequest(this.messageContext, this.addressContext), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)this.matcher.isResponseRelatedToRequest(this.messageContext, this.changedAddressContext), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)this.matcher.isResponseRelatedToRequest(this.changedAddressContext, this.messageContext), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)this.matcher.isResponseRelatedToRequest(this.multicastContext, this.messageContext), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)this.matcher.isResponseRelatedToRequest(this.multicastContext, this.changedAddressContext), (Matcher)CoreMatchers.is((Object)false));
    }
}

