/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements;

import java.net.InetSocketAddress;
import java.security.Principal;
import org.eclipse.californium.elements.TcpEndpointContext;
import org.eclipse.californium.elements.util.StringUtil;

public class TlsEndpointContext
extends TcpEndpointContext {
    public static final String KEY_SESSION_ID = "DTLS_SESSION_ID";
    public static final String KEY_CIPHER = "CIPHER";

    public TlsEndpointContext(InetSocketAddress peerAddress, Principal peerIdentity, String connectionId, String sessionId, String cipher) {
        super(peerAddress, peerIdentity, "CONNECTION_ID", connectionId, KEY_SESSION_ID, sessionId, KEY_CIPHER, cipher);
    }

    public String getSessionId() {
        return this.get(KEY_SESSION_ID);
    }

    public String getCipher() {
        return this.get(KEY_CIPHER);
    }

    @Override
    public String toString() {
        return String.format("TLS(%s,%s,%s,%s)", this.getPeerAddressAsString(), StringUtil.trunc(this.getConnectionId(), 6), StringUtil.trunc(this.getSessionId(), 6), this.getCipher());
    }
}

