/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network;

import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Iterator;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.californium.core.Utils;
import org.eclipse.californium.core.coap.BlockOption;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.EmptyMessage;
import org.eclipse.californium.core.coap.Message;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.coap.Token;
import org.eclipse.californium.core.network.Endpoint;
import org.eclipse.californium.core.network.ExchangeCompleteException;
import org.eclipse.californium.core.network.RemoveHandler;
import org.eclipse.californium.core.observe.ObserveRelation;
import org.eclipse.californium.elements.EndpointContext;
import org.eclipse.californium.elements.util.ClockUtil;
import org.eclipse.californium.elements.util.SerialExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Exchange {
    private static final Logger LOGGER = LoggerFactory.getLogger(Exchange.class.getName());
    static final boolean DEBUG = LOGGER.isTraceEnabled();
    private static final int MAX_OBSERVE_NO = 0xFFFFFF;
    private static final AtomicInteger INSTANCE_COUNTER = new AtomicInteger();
    private final int id;
    private final SerialExecutor executor;
    private Throwable caller;
    private volatile Endpoint endpoint;
    private volatile RemoveHandler removeHandler;
    private final AtomicBoolean complete = new AtomicBoolean();
    private final long nanoTimestamp;
    private final boolean keepRequestInStore;
    private final boolean notification;
    private volatile Request request;
    private volatile Request currentRequest;
    private volatile Response response;
    private volatile Response currentResponse;
    private final Origin origin;
    private volatile boolean timedOut;
    private volatile int currentTimeout;
    private volatile int failedTransmissionCount = 0;
    private ScheduledFuture<?> retransmissionHandle;
    private volatile BlockOption block1ToAck;
    private volatile Integer notificationNumber;
    private volatile ObserveRelation relation;
    private final AtomicReference<EndpointContext> endpointContext = new AtomicReference();
    private byte[] cryptoContextId;

    public Exchange(Request request, Origin origin, Executor executor) {
        this(request, origin, executor, null, request != null && request.isObserve(), false);
    }

    public Exchange(Request request, Origin origin, Executor executor, EndpointContext ctx, boolean notification) {
        this(request, origin, executor, ctx, request != null && request.isObserve() && !notification, notification);
    }

    private Exchange(Request request, Origin origin, Executor executor, EndpointContext ctx, boolean keepRequestInStore, boolean notification) {
        if (request == null) {
            throw new NullPointerException("request must not be null!");
        }
        this.id = INSTANCE_COUNTER.incrementAndGet();
        this.executor = SerialExecutor.create(executor);
        this.currentRequest = request;
        this.request = request;
        this.origin = origin;
        this.endpointContext.set(ctx);
        this.keepRequestInStore = keepRequestInStore;
        this.notification = notification;
        this.nanoTimestamp = ClockUtil.nanoRealtime();
    }

    public String toString() {
        char originMarker;
        char c = originMarker = this.origin == Origin.LOCAL ? (char)'L' : 'R';
        if (this.complete.get()) {
            return "Exchange[" + originMarker + this.id + ", complete]";
        }
        return "Exchange[" + originMarker + this.id + "]";
    }

    public void sendAccept() {
        assert (this.origin == Origin.REMOTE);
        Request current = this.currentRequest;
        if (current.getType() == CoAP.Type.CON && current.hasMID() && !current.isAcknowledged()) {
            current.setAcknowledged(true);
            EmptyMessage ack = EmptyMessage.newACK(current);
            this.endpoint.sendEmptyMessage(this, ack);
        }
    }

    public void sendReject() {
        assert (this.origin == Origin.REMOTE);
        Request current = this.currentRequest;
        if (current.hasMID() && !current.isRejected()) {
            current.setRejected(true);
            EmptyMessage rst = EmptyMessage.newRST(current);
            this.endpoint.sendEmptyMessage(this, rst);
        }
    }

    public void sendResponse(Response response) {
        Request current = this.currentRequest;
        response.setDestinationContext(current.getSourceContext());
        this.endpoint.sendResponse(this, response);
    }

    public Origin getOrigin() {
        return this.origin;
    }

    public boolean isOfLocalOrigin() {
        return this.origin == Origin.LOCAL;
    }

    public boolean keepsRequestInStore() {
        return this.keepRequestInStore;
    }

    public boolean isNotification() {
        return this.notification;
    }

    public Request getRequest() {
        return this.request;
    }

    public void setRequest(Request newRequest) {
        this.assertOwner();
        if (this.request != newRequest) {
            Token token;
            if (this.keepRequestInStore && (token = this.request.getToken()) != null && !token.equals(newRequest.getToken())) {
                throw new IllegalArgumentException(this + " token missmatch (" + token + "!=" + newRequest.getToken() + ")!");
            }
            this.request = newRequest;
        }
    }

    public Request getCurrentRequest() {
        return this.currentRequest;
    }

    public void setCurrentRequest(Request newCurrentRequest) {
        this.assertOwner();
        if (this.currentRequest != newCurrentRequest) {
            this.setRetransmissionHandle(null);
            this.failedTransmissionCount = 0;
            Token token = this.currentRequest.getToken();
            if (token != null) {
                if (token.equals(newCurrentRequest.getToken())) {
                    token = null;
                } else if (this.keepRequestInStore && token.equals(this.request.getToken())) {
                    token = null;
                }
            }
            KeyMID key = null;
            if (this.currentRequest.hasMID() && this.currentRequest.getMID() != newCurrentRequest.getMID()) {
                key = KeyMID.fromOutboundMessage(this.currentRequest);
            }
            if (token != null || key != null) {
                LOGGER.debug("{} replace {} by {}", this, this.currentRequest, newCurrentRequest);
                RemoveHandler obs = this.removeHandler;
                if (obs != null) {
                    obs.remove(this, token, key);
                }
            }
            this.currentRequest = newCurrentRequest;
        }
    }

    public Response getResponse() {
        return this.response;
    }

    public void setResponse(Response response) {
        this.assertOwner();
        this.response = response;
    }

    public Response getCurrentResponse() {
        return this.currentResponse;
    }

    public void setCurrentResponse(Response newCurrentResponse) {
        this.assertOwner();
        if (this.currentResponse != newCurrentResponse) {
            RemoveHandler handler;
            if (this.currentResponse != null && this.currentResponse.getType() == CoAP.Type.CON && this.currentResponse.hasMID() && (handler = this.removeHandler) != null) {
                KeyMID key = KeyMID.fromOutboundMessage(this.currentResponse);
                handler.remove(this, null, key);
            }
            this.currentResponse = newCurrentResponse;
        }
    }

    public BlockOption getBlock1ToAck() {
        return this.block1ToAck;
    }

    public void setBlock1ToAck(BlockOption block1ToAck) {
        this.block1ToAck = block1ToAck;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    public boolean isTimedOut() {
        return this.timedOut;
    }

    public void setTimedOut(Message message) {
        this.assertOwner();
        LOGGER.debug("{} timed out {}!", (Object)this, (Object)message);
        if (!this.isComplete()) {
            this.setComplete();
            this.timedOut = true;
            message.setTimedOut(true);
            if (this.request != null && this.request != message && this.currentRequest == message) {
                this.request.setTimedOut(true);
            }
        }
    }

    public int getFailedTransmissionCount() {
        return this.failedTransmissionCount;
    }

    public void setFailedTransmissionCount(int failedTransmissionCount) {
        this.failedTransmissionCount = failedTransmissionCount;
    }

    public int getCurrentTimeout() {
        return this.currentTimeout;
    }

    public void setCurrentTimeout(int currentTimeout) {
        this.currentTimeout = currentTimeout;
    }

    public ScheduledFuture<?> getRetransmissionHandle() {
        return this.retransmissionHandle;
    }

    public void setRetransmissionHandle(ScheduledFuture<?> newRetransmissionHandle) {
        this.assertOwner();
        if (!this.complete.get() || newRetransmissionHandle == null) {
            ScheduledFuture<?> previous = this.retransmissionHandle;
            this.retransmissionHandle = newRetransmissionHandle;
            if (previous != null) {
                previous.cancel(false);
            }
        }
    }

    public void retransmitResponse() {
        this.assertOwner();
        if (this.origin != Origin.REMOTE) {
            throw new IllegalStateException(this + " retransmit on local exchange not allowed!");
        }
        this.caller = null;
        this.complete.set(false);
    }

    public void setNotificationNumber(int notificationNo) {
        if (notificationNo < 0 || notificationNo > 0xFFFFFF) {
            throw new IllegalArgumentException(this + " illegal observe number");
        }
        this.notificationNumber = notificationNo;
    }

    public Integer getNotificationNumber() {
        return this.notificationNumber;
    }

    public void setRemoveHandler(RemoveHandler removeHandler) {
        this.removeHandler = removeHandler;
    }

    public boolean hasRemoveHandler() {
        return this.removeHandler != null;
    }

    public boolean isComplete() {
        return this.complete.get();
    }

    public Throwable getCaller() {
        return this.caller;
    }

    public boolean setComplete() {
        this.assertOwner();
        if (this.complete.compareAndSet(false, true)) {
            if (DEBUG) {
                this.caller = new Throwable(this.toString());
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("{}!", (Object)this, (Object)this.caller);
                } else {
                    LOGGER.debug("{}!", (Object)this);
                }
            } else {
                LOGGER.debug("{}!", (Object)this);
            }
            this.setRetransmissionHandle(null);
            RemoveHandler handler = this.removeHandler;
            if (handler != null) {
                if (this.origin == Origin.LOCAL) {
                    KeyMID key;
                    Request currrentRequest = this.getCurrentRequest();
                    Token token = currrentRequest.getToken();
                    KeyMID keyMID = key = currrentRequest.hasMID() ? KeyMID.fromOutboundMessage(currrentRequest) : null;
                    if (token != null || key != null) {
                        handler.remove(this, token, key);
                    }
                    Request request = this.getRequest();
                    if (this.keepRequestInStore && request != currrentRequest) {
                        token = request.getToken();
                        KeyMID keyMID2 = key = request.hasMID() ? KeyMID.fromOutboundMessage(request) : null;
                        if (token != null || key != null) {
                            handler.remove(this, token, key);
                        }
                    }
                    if (request == currrentRequest) {
                        LOGGER.debug("local {} completed {}!", (Object)this, (Object)request);
                    } else {
                        LOGGER.debug("local {} completed {} -/- {}!", this, request, currrentRequest);
                    }
                } else {
                    Response currentResponse = this.getCurrentResponse();
                    if (currentResponse == null) {
                        LOGGER.debug("remote {} rejected (without response)!", (Object)this);
                    } else {
                        if (currentResponse.getType() == CoAP.Type.CON && currentResponse.hasMID()) {
                            KeyMID key = KeyMID.fromOutboundMessage(currentResponse);
                            handler.remove(this, null, key);
                        }
                        this.removeNotifications();
                        Response response = this.getResponse();
                        if (response == currentResponse || response == null) {
                            LOGGER.debug("Remote {} completed {}!", (Object)this, (Object)currentResponse);
                        } else {
                            LOGGER.debug("Remote {} completed {} -/- {}!", this, response, currentResponse);
                        }
                    }
                }
            }
            return true;
        }
        throw new ExchangeCompleteException(this + " already complete!", this.caller);
    }

    public boolean executeComplete() {
        if (this.complete.get()) {
            return false;
        }
        if (this.executor == null || this.checkOwner()) {
            this.setComplete();
        } else {
            this.execute(new Runnable(){

                @Override
                public void run() {
                    if (!Exchange.this.complete.get()) {
                        Exchange.this.setComplete();
                    }
                }
            });
        }
        return true;
    }

    public long getNanoTimestamp() {
        return this.nanoTimestamp;
    }

    public long calculateRTT() {
        return TimeUnit.NANOSECONDS.toMillis(ClockUtil.nanoRealtime() - this.nanoTimestamp);
    }

    public ObserveRelation getRelation() {
        return this.relation;
    }

    public void setRelation(ObserveRelation relation) {
        this.relation = relation;
    }

    public void removeNotifications() {
        this.assertOwner();
        ObserveRelation relation = this.relation;
        RemoveHandler handler = this.removeHandler;
        if (relation != null) {
            boolean removed = false;
            Iterator<Response> iterator = relation.getNotificationIterator();
            while (iterator.hasNext()) {
                Response previous = iterator.next();
                LOGGER.debug("{} removing NON notification: {}", (Object)this, (Object)previous);
                if (previous.hasMID()) {
                    if (handler != null) {
                        KeyMID key = KeyMID.fromOutboundMessage(previous);
                        handler.remove(this, null, key);
                    }
                } else {
                    previous.cancel();
                }
                iterator.remove();
                removed = true;
            }
            if (removed) {
                LOGGER.debug("{} removing all remaining NON-notifications of observe relation with {}", (Object)this, (Object)relation.getSource());
            }
        }
    }

    public void setEndpointContext(EndpointContext ctx) {
        if (this.endpointContext.compareAndSet(null, ctx)) {
            this.getCurrentRequest().onContextEstablished(ctx);
        } else {
            this.endpointContext.set(ctx);
        }
    }

    public EndpointContext getEndpointContext() {
        return this.endpointContext.get();
    }

    public void execute(Runnable command) {
        try {
            if (this.executor == null || this.checkOwner()) {
                command.run();
            } else {
                this.executor.execute(command);
            }
        }
        catch (RejectedExecutionException e) {
            LOGGER.debug("{} execute:", (Object)this, (Object)e);
        }
        catch (Throwable t) {
            LOGGER.error("{} execute:", (Object)this, (Object)t);
        }
    }

    public void assertIncomplete(Object message) {
        this.assertOwner();
        if (this.complete.get()) {
            throw new ExchangeCompleteException(this + " is already complete! " + message, this.caller);
        }
    }

    private void assertOwner() {
        if (this.executor != null) {
            this.executor.assertOwner();
        }
    }

    public boolean checkOwner() {
        if (this.executor != null) {
            return this.executor.checkOwner();
        }
        return true;
    }

    public void setCryptographicContextID(byte[] cryptoContextId) {
        this.cryptoContextId = cryptoContextId;
    }

    public byte[] getCryptographicContextID() {
        return this.cryptoContextId;
    }

    public static final class KeyMID {
        private static final int MAX_PORT_NO = 65535;
        private final int MID;
        private final byte[] address;
        private final int port;
        private final int hash;

        private KeyMID(int mid, byte[] address, int port) {
            if (mid < 0 || mid > 65535) {
                throw new IllegalArgumentException("MID must be a 16 bit unsigned int: " + mid);
            }
            if (address == null) {
                throw new NullPointerException("address must not be null");
            }
            if (port < 0 || port > 65535) {
                throw new IllegalArgumentException("Port must be a 16 bit unsigned int");
            }
            this.MID = mid;
            this.address = address;
            this.port = port;
            this.hash = this.createHashCode();
        }

        public int hashCode() {
            return this.hash;
        }

        private int createHashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.MID;
            result = 31 * result + Arrays.hashCode(this.address);
            result = 31 * result + this.port;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            KeyMID other = (KeyMID)obj;
            if (this.MID != other.MID) {
                return false;
            }
            if (!Arrays.equals(this.address, other.address)) {
                return false;
            }
            return this.port == other.port;
        }

        public String toString() {
            return "KeyMID[" + this.MID + ", " + Utils.toHexString(this.address) + ":" + this.port + "]";
        }

        public static KeyMID fromInboundMessage(Message message) {
            InetSocketAddress address = message.getSourceContext().getPeerAddress();
            return new KeyMID(message.getMID(), address.getAddress().getAddress(), address.getPort());
        }

        public static KeyMID fromOutboundMessage(Message message) {
            InetSocketAddress address = message.getDestinationContext().getPeerAddress();
            return new KeyMID(message.getMID(), address.getAddress().getAddress(), address.getPort());
        }
    }

    public static enum Origin {
        LOCAL,
        REMOTE;

    }
}

