/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls.pskstore;

import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.californium.elements.util.Bytes;
import org.eclipse.californium.scandium.dtls.PskPublicInformation;
import org.eclipse.californium.scandium.dtls.pskstore.PskStore;
import org.eclipse.californium.scandium.util.ServerName;
import org.eclipse.californium.scandium.util.ServerNames;

public class InMemoryPskStore
implements PskStore {
    private static final ServerName GLOBAL_SCOPE = ServerName.from(ServerName.NameType.UNDEFINED, Bytes.EMPTY);
    private final Map<ServerName, Map<PskPublicInformation, Psk>> scopedKeys = new ConcurrentHashMap<ServerName, Map<PskPublicInformation, Psk>>();
    private final Map<InetSocketAddress, Map<ServerName, PskPublicInformation>> scopedIdentities = new ConcurrentHashMap<InetSocketAddress, Map<ServerName, PskPublicInformation>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getKey(PskPublicInformation identity) {
        if (identity == null) {
            throw new NullPointerException("identity must not be null");
        }
        Map<ServerName, Map<PskPublicInformation, Psk>> map = this.scopedKeys;
        synchronized (map) {
            return InMemoryPskStore.getKeyFromMapAndNormalizeIdentity(identity, this.scopedKeys.get(GLOBAL_SCOPE));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getKey(ServerNames serverNames, PskPublicInformation identity) {
        if (serverNames == null) {
            return this.getKey(identity);
        }
        if (identity == null) {
            throw new NullPointerException("identity must not be null");
        }
        Map<ServerName, Map<PskPublicInformation, Psk>> map = this.scopedKeys;
        synchronized (map) {
            Iterator<ServerName> i$ = serverNames.iterator();
            if (i$.hasNext()) {
                ServerName serverName = i$.next();
                return InMemoryPskStore.getKeyFromMapAndNormalizeIdentity(identity, this.scopedKeys.get(serverName));
            }
            return null;
        }
    }

    private static byte[] getKeyFromMapAndNormalizeIdentity(PskPublicInformation identity, Map<PskPublicInformation, Psk> keyMap) {
        Psk psk;
        if (keyMap != null && (psk = keyMap.get(identity)) != null) {
            if (!psk.identity.isCompliantEncoding()) {
                identity.normalize(psk.identity.getPublicInfoAsString());
            }
            return psk.getKey();
        }
        return null;
    }

    public void setKey(String identity, byte[] key) {
        this.setKey(new PskPublicInformation(identity), key, GLOBAL_SCOPE);
    }

    public void setKey(PskPublicInformation identity, byte[] key) {
        this.setKey(identity, key, GLOBAL_SCOPE);
    }

    public void setKey(String identity, byte[] key, String virtualHost) {
        this.setKey(new PskPublicInformation(identity), key, ServerName.fromHostName(virtualHost));
    }

    public void setKey(PskPublicInformation identity, byte[] key, String virtualHost) {
        this.setKey(identity, key, ServerName.fromHostName(virtualHost));
    }

    public void setKey(String identity, byte[] key, ServerName virtualHost) {
        this.setKey(new PskPublicInformation(identity), key, virtualHost);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setKey(PskPublicInformation identity, byte[] key, ServerName virtualHost) {
        if (identity == null) {
            throw new NullPointerException("identity must not be null");
        }
        if (key == null) {
            throw new NullPointerException("key must not be null");
        }
        if (virtualHost == null) {
            throw new NullPointerException("serverName must not be null");
        }
        Map<ServerName, Map<PskPublicInformation, Psk>> map = this.scopedKeys;
        synchronized (map) {
            Map<PskPublicInformation, Psk> keysForServerName = this.scopedKeys.get(virtualHost);
            if (keysForServerName == null) {
                keysForServerName = new ConcurrentHashMap<PskPublicInformation, Psk>();
                this.scopedKeys.put(virtualHost, keysForServerName);
            }
            keysForServerName.put(identity, new Psk(identity, key));
        }
    }

    public void addKnownPeer(InetSocketAddress peerAddress, String identity, byte[] key) {
        this.addKnownPeer(peerAddress, GLOBAL_SCOPE, new PskPublicInformation(identity), key);
    }

    public void addKnownPeer(InetSocketAddress peerAddress, PskPublicInformation identity, byte[] key) {
        this.addKnownPeer(peerAddress, GLOBAL_SCOPE, identity, key);
    }

    public void addKnownPeer(InetSocketAddress peerAddress, String virtualHost, String identity, byte[] key) {
        this.addKnownPeer(peerAddress, ServerName.fromHostName(virtualHost), new PskPublicInformation(identity), key);
    }

    public void addKnownPeer(InetSocketAddress peerAddress, String virtualHost, PskPublicInformation identity, byte[] key) {
        this.addKnownPeer(peerAddress, ServerName.fromHostName(virtualHost), identity, key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addKnownPeer(InetSocketAddress peerAddress, ServerName virtualHost, PskPublicInformation identity, byte[] key) {
        if (peerAddress == null) {
            throw new NullPointerException("peer address must not be null");
        }
        if (virtualHost == null) {
            throw new NullPointerException("virtual host must not be null");
        }
        if (identity == null) {
            throw new NullPointerException("identity must not be null");
        }
        if (key == null) {
            throw new NullPointerException("key must not be null");
        }
        Map<ServerName, Map<PskPublicInformation, Psk>> map = this.scopedKeys;
        synchronized (map) {
            Map<ServerName, PskPublicInformation> identities = this.scopedIdentities.get(peerAddress);
            if (identities == null) {
                identities = new ConcurrentHashMap<ServerName, PskPublicInformation>();
                this.scopedIdentities.put(peerAddress, identities);
            }
            identities.put(virtualHost, identity);
            this.setKey(identity, key, virtualHost);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PskPublicInformation getIdentity(InetSocketAddress peerAddress) {
        if (peerAddress == null) {
            throw new NullPointerException("address must not be null");
        }
        Map<ServerName, Map<PskPublicInformation, Psk>> map = this.scopedKeys;
        synchronized (map) {
            return InMemoryPskStore.getIdentityFromMap(GLOBAL_SCOPE, this.scopedIdentities.get(peerAddress));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PskPublicInformation getIdentity(InetSocketAddress peerAddress, ServerNames virtualHost) {
        if (virtualHost == null) {
            return this.getIdentity(peerAddress);
        }
        if (peerAddress == null) {
            throw new NullPointerException("address must not be null");
        }
        Map<ServerName, Map<PskPublicInformation, Psk>> map = this.scopedKeys;
        synchronized (map) {
            for (ServerName serverName : virtualHost) {
                PskPublicInformation identity = InMemoryPskStore.getIdentityFromMap(serverName, this.scopedIdentities.get(peerAddress));
                if (identity == null) continue;
                return identity;
            }
            return null;
        }
    }

    private static PskPublicInformation getIdentityFromMap(ServerName virtualHost, Map<ServerName, PskPublicInformation> identities) {
        if (identities != null) {
            return identities.get(virtualHost);
        }
        return null;
    }

    private static class Psk {
        private final PskPublicInformation identity;
        private final byte[] key;

        private Psk(PskPublicInformation identity, byte[] key) {
            this.identity = identity;
            this.key = Arrays.copyOf(key, key.length);
        }

        private byte[] getKey() {
            return Arrays.copyOf(this.key, this.key.length);
        }
    }
}

