/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls.cipher;

import java.util.ArrayList;
import java.util.List;
import javax.crypto.Cipher;
import org.eclipse.californium.elements.util.DatagramReader;
import org.eclipse.californium.elements.util.DatagramWriter;
import org.eclipse.californium.scandium.dtls.cipher.AeadBlockCipher;
import org.eclipse.californium.scandium.dtls.cipher.PseudoRandomFunction;
import org.eclipse.californium.scandium.dtls.cipher.ThreadLocalCipher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum CipherSuite {
    TLS_PSK_WITH_AES_128_GCM_SHA256(168, CertificateKeyAlgorithm.NONE, KeyExchangeAlgorithm.PSK, CipherSpec.AES_128_GCM, MACAlgorithm.NULL),
    TLS_PSK_WITH_AES_128_CCM_8(49320, CertificateKeyAlgorithm.NONE, KeyExchangeAlgorithm.PSK, CipherSpec.AES_128_CCM_8, MACAlgorithm.NULL),
    TLS_PSK_WITH_AES_256_CCM_8(49321, CertificateKeyAlgorithm.NONE, KeyExchangeAlgorithm.PSK, CipherSpec.AES_256_CCM_8, MACAlgorithm.NULL),
    TLS_PSK_WITH_AES_128_CCM(49316, CertificateKeyAlgorithm.NONE, KeyExchangeAlgorithm.PSK, CipherSpec.AES_128_CCM, MACAlgorithm.NULL),
    TLS_PSK_WITH_AES_256_CCM(49317, CertificateKeyAlgorithm.NONE, KeyExchangeAlgorithm.PSK, CipherSpec.AES_256_CCM, MACAlgorithm.NULL),
    TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA256(49207, CertificateKeyAlgorithm.NONE, KeyExchangeAlgorithm.ECDHE_PSK, CipherSpec.AES_128_CBC, MACAlgorithm.HMAC_SHA256),
    TLS_PSK_WITH_AES_128_CBC_SHA256(174, CertificateKeyAlgorithm.NONE, KeyExchangeAlgorithm.PSK, CipherSpec.AES_128_CBC, MACAlgorithm.HMAC_SHA256),
    TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256(49195, CertificateKeyAlgorithm.EC, KeyExchangeAlgorithm.EC_DIFFIE_HELLMAN, CipherSpec.AES_128_GCM, MACAlgorithm.NULL),
    TLS_ECDHE_ECDSA_WITH_AES_128_CCM_8(49326, CertificateKeyAlgorithm.EC, KeyExchangeAlgorithm.EC_DIFFIE_HELLMAN, CipherSpec.AES_128_CCM_8, MACAlgorithm.NULL),
    TLS_ECDHE_ECDSA_WITH_AES_256_CCM_8(49327, CertificateKeyAlgorithm.EC, KeyExchangeAlgorithm.EC_DIFFIE_HELLMAN, CipherSpec.AES_256_CCM_8, MACAlgorithm.NULL),
    TLS_ECDHE_ECDSA_WITH_AES_128_CCM(49324, CertificateKeyAlgorithm.EC, KeyExchangeAlgorithm.EC_DIFFIE_HELLMAN, CipherSpec.AES_128_CCM, MACAlgorithm.NULL),
    TLS_ECDHE_ECDSA_WITH_AES_256_CCM(49325, CertificateKeyAlgorithm.EC, KeyExchangeAlgorithm.EC_DIFFIE_HELLMAN, CipherSpec.AES_256_CCM, MACAlgorithm.NULL),
    TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA(49162, CertificateKeyAlgorithm.EC, KeyExchangeAlgorithm.EC_DIFFIE_HELLMAN, CipherSpec.AES_256_CBC, MACAlgorithm.HMAC_SHA1),
    TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256(49187, CertificateKeyAlgorithm.EC, KeyExchangeAlgorithm.EC_DIFFIE_HELLMAN, CipherSpec.AES_128_CBC, MACAlgorithm.HMAC_SHA256),
    TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384(49188, CertificateKeyAlgorithm.EC, KeyExchangeAlgorithm.EC_DIFFIE_HELLMAN, CipherSpec.AES_256_CBC, MACAlgorithm.HMAC_SHA384, PRFAlgorithm.TLS_PRF_SHA384),
    TLS_NULL_WITH_NULL_NULL(0, CertificateKeyAlgorithm.NONE, KeyExchangeAlgorithm.NULL, CipherSpec.NULL, MACAlgorithm.NULL);

    public static final int CIPHER_SUITE_BITS = 16;
    private static final Logger LOGGER;
    private static int overallMaxCipherTextExpansion;
    private final int code;
    private final CertificateKeyAlgorithm certificateKeyAlgorithm;
    private final KeyExchangeAlgorithm keyExchange;
    private final CipherSpec cipher;
    private final MACAlgorithm macAlgorithm;
    private final PRFAlgorithm pseudoRandomFunction;
    private final int maxCipherTextExpansion;

    private CipherSuite(int code, CertificateKeyAlgorithm certificate, KeyExchangeAlgorithm keyExchange, CipherSpec cipher, MACAlgorithm macAlgorithm) {
        this(code, certificate, keyExchange, cipher, macAlgorithm, PRFAlgorithm.TLS_PRF_SHA256);
    }

    private CipherSuite(int code, CertificateKeyAlgorithm certificate, KeyExchangeAlgorithm keyExchange, CipherSpec cipher, MACAlgorithm macAlgorithm, PRFAlgorithm prf) {
        this.code = code;
        this.certificateKeyAlgorithm = certificate;
        this.keyExchange = keyExchange;
        this.cipher = cipher;
        this.macAlgorithm = macAlgorithm;
        this.pseudoRandomFunction = prf;
        switch (this.cipher.getType()) {
            case BLOCK: {
                this.maxCipherTextExpansion = cipher.getRecordIvLength() + macAlgorithm.getOutputLength() + cipher.getRecordIvLength() + 1;
                break;
            }
            case AEAD: {
                this.maxCipherTextExpansion = cipher.getRecordIvLength() + cipher.getMacLength();
                break;
            }
            default: {
                this.maxCipherTextExpansion = 0;
            }
        }
    }

    public int getMaxCiphertextExpansion() {
        return this.maxCipherTextExpansion;
    }

    public String getTransformation() {
        return this.cipher.getTransformation();
    }

    public Cipher getCipher() {
        return this.cipher.getCipher();
    }

    public int getCode() {
        return this.code;
    }

    public CertificateKeyAlgorithm getCertificateKeyAlgorithm() {
        return this.certificateKeyAlgorithm;
    }

    public KeyExchangeAlgorithm getKeyExchange() {
        return this.keyExchange;
    }

    public boolean requiresServerCertificateMessage() {
        return !CertificateKeyAlgorithm.NONE.equals((Object)this.certificateKeyAlgorithm);
    }

    public boolean isPskBased() {
        return KeyExchangeAlgorithm.PSK.equals((Object)this.keyExchange) || KeyExchangeAlgorithm.ECDHE_PSK.equals((Object)this.keyExchange);
    }

    public boolean isEccBased() {
        return CertificateKeyAlgorithm.EC.equals((Object)this.certificateKeyAlgorithm) || KeyExchangeAlgorithm.ECDHE_PSK.equals((Object)this.keyExchange) || KeyExchangeAlgorithm.EC_DIFFIE_HELLMAN.equals((Object)this.keyExchange);
    }

    public boolean isSupported() {
        return this.pseudoRandomFunction.getMacAlgorithm().isSupported() && this.macAlgorithm.isSupported() && this.cipher.isSupported();
    }

    public int getMacLength() {
        if (this.macAlgorithm == MACAlgorithm.NULL) {
            return this.cipher.getMacLength();
        }
        return this.macAlgorithm.getOutputLength();
    }

    public int getMacKeyLength() {
        return this.macAlgorithm.getKeyLength();
    }

    public String getMacName() {
        return this.macAlgorithm.getName();
    }

    public int getRecordIvLength() {
        return this.cipher.getRecordIvLength();
    }

    public int getFixedIvLength() {
        return this.cipher.getFixedIvLength();
    }

    public String getPseudoRandomFunctionMacName() {
        return this.pseudoRandomFunction.getMacAlgorithm().getName();
    }

    public String getPseudoRandomFunctionHashName() {
        return this.pseudoRandomFunction.getMacAlgorithm().getHashName();
    }

    public CipherType getCipherType() {
        return this.cipher.getType();
    }

    public int getEncKeyLength() {
        return this.cipher.getKeyLength();
    }

    public static int getOverallMaxCiphertextExpansion() {
        if (overallMaxCipherTextExpansion == 0) {
            int overall = 0;
            for (CipherSuite suite : CipherSuite.values()) {
                if (!suite.isSupported()) continue;
                overall = Math.max(overall, suite.getMaxCiphertextExpansion());
            }
            overallMaxCipherTextExpansion = overall;
        }
        return overallMaxCipherTextExpansion;
    }

    public static List<CipherSuite> getPskCipherSuites(boolean ecdhePsk) {
        ArrayList<CipherSuite> list = new ArrayList<CipherSuite>();
        for (CipherSuite suite : CipherSuite.values()) {
            if (!suite.isSupported() || !KeyExchangeAlgorithm.PSK.equals((Object)suite.keyExchange) && (!ecdhePsk || !KeyExchangeAlgorithm.ECDHE_PSK.equals((Object)suite.keyExchange))) continue;
            list.add(suite);
        }
        return list;
    }

    public static List<CipherSuite> getEcdsaCipherSuites() {
        return CipherSuite.getCertificateCipherSuites(CertificateKeyAlgorithm.EC.name());
    }

    public static List<CipherSuite> getCertificateCipherSuites(String keyAlgorithm) {
        ArrayList<CipherSuite> list = new ArrayList<CipherSuite>();
        for (CipherSuite suite : CipherSuite.values()) {
            if (!suite.isSupported() || !suite.certificateKeyAlgorithm.name().equals(keyAlgorithm)) continue;
            list.add(suite);
        }
        return list;
    }

    public static CipherSuite getTypeByCode(int code) {
        for (CipherSuite suite : CipherSuite.values()) {
            if (suite.code != code) continue;
            return suite;
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Cannot resolve cipher suite code [{}]", (Object)Integer.toHexString(code));
        }
        return null;
    }

    public static CipherSuite getTypeByName(String name) {
        for (CipherSuite suite : CipherSuite.values()) {
            if (!suite.name().equals(name)) continue;
            return suite;
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Cannot resolve cipher suite code [{}]", (Object)name);
        }
        return null;
    }

    public static boolean containsEccBasedCipherSuite(List<CipherSuite> cipherSuites) {
        if (cipherSuites != null) {
            for (CipherSuite cipherSuite : cipherSuites) {
                if (!cipherSuite.isEccBased()) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsCipherSuiteRequiringCertExchange(List<CipherSuite> cipherSuites) {
        if (cipherSuites != null) {
            for (CipherSuite cipherSuite : cipherSuites) {
                if (!cipherSuite.requiresServerCertificateMessage()) continue;
                return true;
            }
        }
        return false;
    }

    public static byte[] listToByteArray(List<CipherSuite> cipherSuites) {
        DatagramWriter writer = new DatagramWriter();
        for (CipherSuite cipherSuite : cipherSuites) {
            writer.write(cipherSuite.getCode(), 16);
        }
        return writer.toByteArray();
    }

    public static List<CipherSuite> listFromByteArray(byte[] byteArray, int numElements) {
        ArrayList<CipherSuite> cipherSuites = new ArrayList<CipherSuite>();
        DatagramReader reader = new DatagramReader(byteArray);
        for (int i = 0; i < numElements; ++i) {
            int code = reader.read(16);
            CipherSuite cipher = CipherSuite.getTypeByCode(code);
            if (cipher == null) continue;
            cipherSuites.add(cipher);
        }
        return cipherSuites;
    }

    static {
        LOGGER = LoggerFactory.getLogger(CipherSuite.class.getCanonicalName());
        overallMaxCipherTextExpansion = 0;
    }

    public static enum CertificateKeyAlgorithm {
        NONE,
        DSA,
        RSA,
        EC;

    }

    public static enum CipherType {
        NULL,
        STREAM,
        BLOCK,
        AEAD;

    }

    private static enum PRFAlgorithm {
        TLS_PRF_SHA256(MACAlgorithm.HMAC_SHA256),
        TLS_PRF_SHA384(MACAlgorithm.HMAC_SHA384);

        private final MACAlgorithm mac;

        private PRFAlgorithm(MACAlgorithm mac) {
            this.mac = mac;
        }

        public MACAlgorithm getMacAlgorithm() {
            return this.mac;
        }
    }

    public static enum KeyExchangeAlgorithm {
        NULL,
        DHE_DSS,
        DHE_RSA,
        DH_ANON,
        RSA,
        DH_DSS,
        DH_RSA,
        PSK,
        ECDHE_PSK,
        EC_DIFFIE_HELLMAN;

    }

    private static enum CipherSpec {
        NULL("NULL", CipherType.NULL, 0, 0, 0),
        B_3DES_EDE_CBC("DESede/CBC/NoPadding", CipherType.BLOCK, 24, 4, 8),
        AES_128_CBC("AES/CBC/NoPadding", CipherType.BLOCK, 16, 4, 16),
        AES_256_CBC("AES/CBC/NoPadding", CipherType.BLOCK, 32, 4, 16),
        AES_128_CCM_8("AES/CCM", CipherType.AEAD, 16, 4, 8, 8),
        AES_256_CCM_8("AES/CCM", CipherType.AEAD, 32, 4, 8, 8),
        AES_128_CCM("AES/CCM", CipherType.AEAD, 16, 4, 8, 16),
        AES_256_CCM("AES/CCM", CipherType.AEAD, 32, 4, 8, 16),
        AES_128_GCM("AES/GCM/NoPadding", CipherType.AEAD, 16, 4, 8, 16);

        private final String transformation;
        private final CipherType type;
        private final int keyLength;
        private final int fixedIvLength;
        private final int recordIvLength;
        private final int macLength;
        private final boolean supported;
        private final ThreadLocalCipher cipher;

        private CipherSpec(String transformation, CipherType type, int keyLength, int fixedIvLength, int recordIvLength) {
            this(transformation, type, keyLength, fixedIvLength, recordIvLength, 0);
        }

        private CipherSpec(String transformation, CipherType type, int keyLength, int fixedIvLength, int recordIvLength, int macLength) {
            this.transformation = transformation;
            this.type = type;
            this.keyLength = keyLength;
            this.fixedIvLength = fixedIvLength;
            this.recordIvLength = recordIvLength;
            this.macLength = macLength;
            boolean supported = true;
            if (type == CipherType.AEAD || type == CipherType.BLOCK) {
                supported = AeadBlockCipher.isSupported(transformation, keyLength);
            }
            if ("AES/CCM".equals(transformation)) {
                this.cipher = null;
                this.supported = supported;
            } else {
                this.cipher = supported ? new ThreadLocalCipher(transformation) : null;
                this.supported = this.cipher == null ? false : this.cipher.isSupported();
            }
        }

        private String getTransformation() {
            return this.transformation;
        }

        private CipherType getType() {
            return this.type;
        }

        private int getKeyLength() {
            return this.keyLength;
        }

        private int getFixedIvLength() {
            return this.fixedIvLength;
        }

        private int getRecordIvLength() {
            return this.recordIvLength;
        }

        private int getMacLength() {
            return this.macLength;
        }

        private boolean isSupported() {
            return this.supported;
        }

        private Cipher getCipher() {
            return this.cipher.current();
        }
    }

    private static enum MACAlgorithm {
        NULL(null, null, 0),
        HMAC_MD5("HmacMD5", "MD5", 16),
        HMAC_SHA1("HmacSHA1", "SHA-1", 20),
        HMAC_SHA256("HmacSHA256", "SHA-256", 32),
        HMAC_SHA384("HmacSHA384", "SHA-384", 48),
        HMAC_SHA512("HmacSHA512", "SHA-512", 64);

        private final String name;
        private final String hashName;
        private final int outputLength;
        private final boolean supported;

        private MACAlgorithm(String name, String hashName, int outputLength) {
            this.name = name;
            this.hashName = hashName;
            this.outputLength = outputLength;
            this.supported = name == null && hashName == null ? true : PseudoRandomFunction.isSupported(name, hashName);
        }

        public String getName() {
            return this.name;
        }

        public String getHashName() {
            return this.hashName;
        }

        public int getOutputLength() {
            return this.outputLength;
        }

        public int getKeyLength() {
            return this.outputLength;
        }

        public boolean isSupported() {
            return this.supported;
        }
    }
}

