/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.californium.elements.util.DatagramReader;
import org.eclipse.californium.elements.util.DatagramWriter;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.scandium.dtls.AlertMessage;
import org.eclipse.californium.scandium.dtls.HandshakeException;
import org.eclipse.californium.scandium.dtls.HelloExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HelloExtensions {
    private static final Logger LOGGER = LoggerFactory.getLogger(HelloExtensions.class.getCanonicalName());
    public static final int LENGTH_BITS = 16;
    private final List<HelloExtension> extensions = new ArrayList<HelloExtension>();

    public HelloExtensions() {
    }

    public HelloExtensions(List<HelloExtension> extensions) {
        this.extensions.addAll(extensions);
    }

    boolean isEmpty() {
        return this.extensions.isEmpty();
    }

    public int getLength() {
        int length = 0;
        for (HelloExtension extension : this.extensions) {
            length += extension.getLength();
        }
        return length;
    }

    public void addExtension(HelloExtension extension) {
        if (extension != null) {
            this.extensions.add(extension);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\t\tExtensions Length: ").append(this.getLength());
        for (HelloExtension ext : this.extensions) {
            sb.append(StringUtil.lineSeparator()).append(ext);
        }
        return sb.toString();
    }

    public byte[] toByteArray() {
        if (this.extensions.isEmpty()) {
            return new byte[0];
        }
        DatagramWriter writer = new DatagramWriter();
        writer.write(this.getLength(), 16);
        for (HelloExtension extension : this.extensions) {
            writer.writeBytes(extension.toByteArray());
        }
        return writer.toByteArray();
    }

    public static HelloExtensions fromByteArray(byte[] byteArray, InetSocketAddress peerAddress) throws HandshakeException {
        int length;
        int extensionLength;
        DatagramReader reader = new DatagramReader(byteArray);
        ArrayList<HelloExtension> extensions = new ArrayList<HelloExtension>();
        for (length = reader.read(16); length > 0; length -= 4 + extensionLength) {
            byte[] extensionBytes;
            int typeId = reader.read(16);
            HelloExtension extension = HelloExtension.fromByteArray(typeId, extensionBytes = reader.readBytes(extensionLength = reader.read(16)), peerAddress);
            if (extension != null) {
                extensions.add(extension);
                continue;
            }
            LOGGER.debug("Peer included an unknown extension type code [{}] in its Hello message", (Object)typeId);
        }
        if (length < 0) {
            throw new HandshakeException("Hello message contained malformed extensions", new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.DECODE_ERROR, peerAddress));
        }
        return new HelloExtensions(extensions);
    }

    final HelloExtension getExtension(HelloExtension.ExtensionType type) {
        if (type != null) {
            for (HelloExtension ext : this.extensions) {
                if (!type.equals((Object)ext.getType())) continue;
                return ext;
            }
        }
        return null;
    }

    public List<HelloExtension> getExtensions() {
        return Collections.unmodifiableList(this.extensions);
    }
}

