/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.net.InetSocketAddress;
import org.eclipse.californium.elements.util.DatagramWriter;
import org.eclipse.californium.scandium.dtls.AlertMessage;
import org.eclipse.californium.scandium.dtls.ConnectionId;
import org.eclipse.californium.scandium.dtls.HandshakeException;
import org.eclipse.californium.scandium.dtls.HelloExtension;

public final class ConnectionIdExtension
extends HelloExtension {
    private static final int CID_FIELD_LENGTH_BITS = 8;
    private ConnectionId id;

    private ConnectionIdExtension(ConnectionId id) {
        super(HelloExtension.ExtensionType.CONNECTION_ID);
        this.id = id;
    }

    public ConnectionId getConnectionId() {
        return this.id;
    }

    @Override
    public int getLength() {
        return 5 + this.id.length();
    }

    @Override
    protected void addExtensionData(DatagramWriter writer) {
        int length = this.id.length();
        writer.write(1 + length, 16);
        writer.write(length, 8);
        writer.writeBytes(this.id.getBytes());
    }

    public static ConnectionIdExtension fromConnectionId(ConnectionId cid) {
        if (cid == null) {
            throw new NullPointerException("cid must not be null!");
        }
        return new ConnectionIdExtension(cid);
    }

    public static ConnectionIdExtension fromExtensionData(byte[] extensionData, InetSocketAddress peerAddress) throws HandshakeException {
        if (extensionData == null) {
            throw new NullPointerException("cid must not be null!");
        }
        if (extensionData.length == 0) {
            throw new HandshakeException("Connection id length must be provided!", new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.ILLEGAL_PARAMETER, peerAddress));
        }
        if (extensionData.length > 256) {
            throw new HandshakeException("Connection id length too large! 255 max, but has " + (extensionData.length - 1), new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.ILLEGAL_PARAMETER, peerAddress));
        }
        byte len = extensionData[0];
        if (len != extensionData.length - 1) {
            throw new HandshakeException("Connection id length " + len + " doesn't match " + (extensionData.length - 1) + "!", new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.ILLEGAL_PARAMETER, peerAddress));
        }
        if (len == 0) {
            return new ConnectionIdExtension(ConnectionId.EMPTY);
        }
        byte[] cid = new byte[len];
        System.arraycopy(extensionData, 1, cid, 0, len);
        return new ConnectionIdExtension(new ConnectionId(cid));
    }
}

