/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements;

import java.net.InetSocketAddress;
import org.eclipse.californium.elements.EndpointContext;
import org.eclipse.californium.elements.EndpointContextMatcher;
import org.eclipse.californium.elements.TlsEndpointContext;
import org.eclipse.californium.elements.TlsEndpointContextMatcher;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TlsEndpointContextMatcherTest {
    private static final InetSocketAddress ADDRESS = new InetSocketAddress(0);
    private EndpointContext connectorContext;
    private EndpointContext messageContext;
    private EndpointContext differentMessageContext;
    private EndpointContextMatcher matcher;

    @Before
    public void setup() {
        this.connectorContext = new TlsEndpointContext(ADDRESS, null, "ID1", "S1", "C1");
        this.messageContext = new TlsEndpointContext(ADDRESS, null, "ID1", "S1", "C1");
        this.differentMessageContext = new TlsEndpointContext(ADDRESS, null, "ID2", "S2", "C1");
        this.matcher = new TlsEndpointContextMatcher();
    }

    @Test
    public void testWithConnectorEndpointContext() {
        Assert.assertThat((Object)this.matcher.isToBeSent(this.messageContext, this.connectorContext), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)this.matcher.isToBeSent(this.differentMessageContext, this.connectorContext), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testWithoutConnectorEndpointContext() {
        Assert.assertThat((Object)this.matcher.isToBeSent(this.messageContext, null), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)this.matcher.isToBeSent(this.differentMessageContext, null), (Matcher)CoreMatchers.is((Object)false));
    }
}

