/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements;

import java.security.Principal;
import org.eclipse.californium.elements.EndpointContext;
import org.eclipse.californium.elements.EndpointContextMatcher;

public class PrincipalEndpointContextMatcher
implements EndpointContextMatcher {
    @Override
    public String getName() {
        return "principal correlation";
    }

    @Override
    public boolean isResponseRelatedToRequest(EndpointContext requestContext, EndpointContext responseContext) {
        return this.internalMatch(requestContext, responseContext);
    }

    @Override
    public boolean isToBeSent(EndpointContext messageContext, EndpointContext connectorContext) {
        if (null == connectorContext) {
            return true;
        }
        return this.internalMatch(messageContext, connectorContext);
    }

    private final boolean internalMatch(EndpointContext requestedContext, EndpointContext availableContext) {
        String cipher;
        if (requestedContext.getPeerIdentity() != null) {
            if (availableContext.getPeerIdentity() == null) {
                return false;
            }
            if (!this.matchPrincipals(requestedContext.getPeerIdentity(), availableContext.getPeerIdentity())) {
                return false;
            }
        }
        return (cipher = requestedContext.get("DTLS_CIPHER")) == null || cipher.equals(availableContext.get("DTLS_CIPHER"));
    }

    protected boolean matchPrincipals(Principal requestedPrincipal, Principal availablePrincipal) {
        return requestedPrincipal.equals(availablePrincipal);
    }
}

