/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements;

import java.net.InetSocketAddress;
import java.security.Principal;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.californium.elements.AddressEndpointContext;
import org.eclipse.californium.elements.EndpointContext;

public class MapBasedEndpointContext
extends AddressEndpointContext {
    public static final String KEY_PREFIX_NONE_CRITICAL = "*";
    private final boolean hasCriticalEntries;
    private final Map<String, String> entries;

    public MapBasedEndpointContext(InetSocketAddress peerAddress, Principal peerIdentity, String ... attributes) {
        this(peerAddress, null, peerIdentity, attributes);
    }

    public MapBasedEndpointContext(InetSocketAddress peerAddress, String virtualHost, Principal peerIdentity, String ... attributes) {
        this(peerAddress, virtualHost, peerIdentity, MapBasedEndpointContext.createMap(attributes));
    }

    public MapBasedEndpointContext(InetSocketAddress peerAddress, Principal peerIdentity, Map<String, String> attributes) {
        this(peerAddress, null, peerIdentity, attributes);
    }

    public MapBasedEndpointContext(InetSocketAddress peerAddress, String virtualHost, Principal peerIdentity, Map<String, String> attributes) {
        super(peerAddress, virtualHost, peerIdentity);
        if (attributes == null) {
            throw new NullPointerException("missing attributes map, must not be null!");
        }
        this.entries = Collections.unmodifiableMap(new HashMap<String, String>(attributes));
        this.hasCriticalEntries = MapBasedEndpointContext.findCriticalEntries(this.entries);
    }

    private static final Map<String, String> createMap(String ... attributes) {
        if (attributes == null) {
            throw new NullPointerException("attributes must not null!");
        }
        if ((attributes.length & 1) != 0) {
            throw new IllegalArgumentException("number of attributes must be even, not " + attributes.length + "!");
        }
        HashMap<String, String> entries = new HashMap<String, String>();
        for (int index = 0; index < attributes.length; ++index) {
            String key = attributes[index];
            String value = attributes[++index];
            if (null == key) {
                throw new NullPointerException(index / 2 + ". key is null");
            }
            if (key.isEmpty()) {
                throw new IllegalArgumentException(index / 2 + ". key is empty");
            }
            if (null == value) {
                throw new NullPointerException(index / 2 + ". value is null");
            }
            String old = entries.put(key, value);
            if (null == old) continue;
            throw new IllegalArgumentException(index / 2 + ". key '" + key + "' is provided twice");
        }
        return entries;
    }

    private static final boolean findCriticalEntries(Map<String, String> attributes) {
        for (String key : attributes.keySet()) {
            if (key.startsWith(KEY_PREFIX_NONE_CRITICAL)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String get(String key) {
        return this.entries.get(key);
    }

    @Override
    public Map<String, String> entries() {
        return this.entries;
    }

    @Override
    public boolean hasCriticalEntries() {
        return this.hasCriticalEntries;
    }

    @Override
    public String toString() {
        return String.format("MAP(%s)", this.getPeerAddressAsString());
    }

    public static MapBasedEndpointContext addEntries(EndpointContext context, String ... attributes) {
        Map<String, String> additionalAttributes = MapBasedEndpointContext.createMap(attributes);
        HashMap<String, String> entries = new HashMap<String, String>(context.entries());
        entries.putAll(additionalAttributes);
        return new MapBasedEndpointContext(context.getPeerAddress(), context.getVirtualHost(), context.getPeerIdentity(), entries);
    }
}

