/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network.stack;

import org.eclipse.californium.core.network.Outbox;
import org.eclipse.californium.core.network.config.NetworkConfig;
import org.eclipse.californium.core.network.stack.BaseCoapStack;
import org.eclipse.californium.core.network.stack.BlockwiseLayer;
import org.eclipse.californium.core.network.stack.CoapStack;
import org.eclipse.californium.core.network.stack.CongestionControlLayer;
import org.eclipse.californium.core.network.stack.ExchangeCleanupLayer;
import org.eclipse.californium.core.network.stack.Layer;
import org.eclipse.californium.core.network.stack.ObserveLayer;
import org.eclipse.californium.core.network.stack.ReliabilityLayer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoapUdpStack
extends BaseCoapStack {
    private static final Logger LOGGER = LoggerFactory.getLogger(CoapStack.class.getCanonicalName());

    public CoapUdpStack(NetworkConfig config, Outbox outbox) {
        super(outbox);
        Layer[] layers = new Layer[]{this.createExchangeCleanupLayer(config), this.createObserveLayer(config), this.createBlockwiseLayer(config), this.createReliabilityLayer(config)};
        this.setLayers(layers);
    }

    protected Layer createExchangeCleanupLayer(NetworkConfig config) {
        return new ExchangeCleanupLayer(config);
    }

    protected Layer createObserveLayer(NetworkConfig config) {
        return new ObserveLayer(config);
    }

    protected Layer createBlockwiseLayer(NetworkConfig config) {
        return new BlockwiseLayer(config);
    }

    protected Layer createReliabilityLayer(NetworkConfig config) {
        ReliabilityLayer reliabilityLayer;
        if (config.getBoolean("USE_CONGESTION_CONTROL")) {
            reliabilityLayer = CongestionControlLayer.newImplementation(config);
            LOGGER.info("Enabling congestion control: {}", (Object)reliabilityLayer.getClass().getSimpleName());
        } else {
            reliabilityLayer = new ReliabilityLayer(config);
        }
        return reliabilityLayer;
    }
}

