/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.plugtests.resources;

import java.nio.ByteBuffer;
import org.eclipse.californium.core.CoapResource;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.server.resources.CoapExchange;

public class Validate
extends CoapResource {
    private byte[] data = null;
    private int dataCf = 0;
    private byte[] etag = new byte[]{0, 0, 0, 0};

    public Validate() {
        super("validate");
        this.getAttributes().setTitle("Resource which varies");
    }

    @Override
    public void handleGET(CoapExchange exchange) {
        Response response;
        Request request = exchange.advanced().getRequest();
        if (exchange.getRequestOptions().containsETag(this.etag)) {
            response = new Response(CoAP.ResponseCode.VALID);
            response.getOptions().addETag((byte[])this.etag.clone());
            this.storeData(null, -1);
        } else {
            response = new Response(CoAP.ResponseCode.CONTENT);
            if (this.data == null) {
                this.etag = ByteBuffer.allocate(2).putShort((short)(Math.random() * 65536.0)).array();
                StringBuilder payload = new StringBuilder();
                payload.append(String.format("Type: %d (%s)\nCode: %d (%s)\nMID: %d", new Object[]{request.getType().value, request.getType(), request.getCode().value, request.getCode(), request.getMID()}));
                if (request.getToken().length > 0) {
                    payload.append("\nToken: ");
                    payload.append(request.getTokenString());
                }
                if (payload.length() > 64) {
                    payload.delete(63, payload.length());
                    payload.append('\u00bb');
                }
                response.setPayload(payload.toString());
                response.getOptions().setContentFormat(0);
            } else {
                response.setPayload(this.data);
                response.getOptions().setContentFormat(this.dataCf);
            }
            response.getOptions().addETag((byte[])this.etag.clone());
        }
        exchange.respond(response);
    }

    @Override
    public void handlePUT(CoapExchange exchange) {
        if (exchange.getRequestOptions().isIfMatch(this.etag)) {
            if (exchange.getRequestOptions().hasContentFormat()) {
                this.storeData(exchange.getRequestPayload(), exchange.getRequestOptions().getContentFormat());
                exchange.setETag((byte[])this.etag.clone());
                exchange.respond(CoAP.ResponseCode.CHANGED);
            } else {
                exchange.respond(CoAP.ResponseCode.BAD_REQUEST, "Content-Format not set");
            }
        } else if (exchange.getRequestOptions().hasIfNoneMatch() && this.data == null) {
            this.storeData(exchange.getRequestPayload(), exchange.getRequestOptions().getContentFormat());
            exchange.respond(CoAP.ResponseCode.CREATED);
        } else {
            exchange.respond(CoAP.ResponseCode.PRECONDITION_FAILED);
            this.storeData(null, -1);
        }
    }

    @Override
    public void handleDELETE(CoapExchange exchange) {
        this.storeData(null, -1);
        exchange.respond(CoAP.ResponseCode.DELETED);
    }

    private synchronized void storeData(byte[] payload, int cf) {
        if (payload != null) {
            this.data = payload;
            this.dataCf = cf;
            this.etag = ByteBuffer.allocate(4).putInt(this.data.hashCode()).array();
            this.getAttributes().clearContentType();
            this.getAttributes().addContentType(this.dataCf);
            this.getAttributes().setMaximumSizeEstimate(this.data.length);
        } else {
            this.data = null;
            this.etag = ByteBuffer.allocate(2).putShort((short)(Math.random() * 65536.0)).array();
        }
        this.changed();
    }
}

