/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.plugtests.resources;

import org.eclipse.californium.core.CoapResource;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.MediaTypeRegistry;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.server.resources.CoapExchange;

public class MultiFormat
extends CoapResource {
    public MultiFormat() {
        super("multi-format");
        this.getAttributes().setTitle("Resource that exists in different content formats (text/plain utf8 and application/xml)");
        this.getAttributes().addContentType(0);
        this.getAttributes().addContentType(41);
    }

    @Override
    public void handleGET(CoapExchange exchange) {
        Request request = exchange.advanced().getRequest();
        Response response = new Response(CoAP.ResponseCode.CONTENT);
        String format = "";
        switch (exchange.getRequestOptions().getAccept()) {
            case -1: 
            case 0: {
                response.getOptions().setContentFormat(0);
                format = "Status type: \"%s\"\nCode: \"%s\"\nMID: \"%s\"\nAccept: \"%s\"";
                break;
            }
            case 41: {
                response.getOptions().setContentFormat(41);
                format = "<msg type=\"%s\" code=\"%s\" mid=%s accept=\"%s\"/>";
                break;
            }
            default: {
                response = new Response(CoAP.ResponseCode.NOT_ACCEPTABLE);
                format = "text/plain or application/xml only";
            }
        }
        response.setPayload(String.format(format, new Object[]{request.getType(), request.getCode(), request.getMID(), MediaTypeRegistry.toString(request.getOptions().getAccept())}));
        exchange.respond(response);
    }
}

