/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.plugtests.resources;

import org.eclipse.californium.core.CoapResource;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.MediaTypeRegistry;
import org.eclipse.californium.core.server.resources.CoapExchange;

public class LargeUpdate
extends CoapResource {
    private byte[] data = null;
    private int dataCf = 0;

    public LargeUpdate() {
        this("large-update");
        StringBuilder builder = new StringBuilder();
        builder.append("/-------------------------------------------------------------\\\n");
        builder.append("|                 RESOURCE BLOCK NO. 1 OF 5                   |\n");
        builder.append("|               [each line contains 64 bytes]                 |\n");
        builder.append("\\-------------------------------------------------------------/\n");
        builder.append("/-------------------------------------------------------------\\\n");
        builder.append("|                 RESOURCE BLOCK NO. 2 OF 5                   |\n");
        builder.append("|               [each line contains 64 bytes]                 |\n");
        builder.append("\\-------------------------------------------------------------/\n");
        builder.append("/-------------------------------------------------------------\\\n");
        builder.append("|                 RESOURCE BLOCK NO. 3 OF 5                   |\n");
        builder.append("|               [each line contains 64 bytes]                 |\n");
        builder.append("\\-------------------------------------------------------------/\n");
        builder.append("/-------------------------------------------------------------\\\n");
        builder.append("|                 RESOURCE BLOCK NO. 4 OF 5                   |\n");
        builder.append("|               [each line contains 64 bytes]                 |\n");
        builder.append("\\-------------------------------------------------------------/\n");
        builder.append("/-------------------------------------------------------------\\\n");
        builder.append("|                 RESOURCE BLOCK NO. 5 OF 5                   |\n");
        builder.append("|               [each line contains 64 bytes]                 |\n");
        builder.append("\\-------------------------------------------------------------/\n");
        this.data = builder.toString().getBytes();
    }

    public LargeUpdate(String resourceIdentifier) {
        super(resourceIdentifier);
        this.getAttributes().setTitle("Large resource that can be updated using PUT method");
        this.getAttributes().addResourceType("block");
        this.getAttributes().setMaximumSizeEstimate(1280);
    }

    @Override
    public void handleGET(CoapExchange exchange) {
        if (exchange.getRequestOptions().hasAccept() && exchange.getRequestOptions().getAccept() != this.dataCf) {
            exchange.respond(CoAP.ResponseCode.NOT_ACCEPTABLE, MediaTypeRegistry.toString(this.dataCf) + " only");
        } else {
            exchange.respond(CoAP.ResponseCode.CONTENT, this.data, this.dataCf);
        }
    }

    @Override
    public void handlePUT(CoapExchange exchange) {
        if (exchange.getRequestOptions().hasContentFormat()) {
            this.storeData(exchange.getRequestPayload(), exchange.getRequestOptions().getContentFormat());
            exchange.respond(CoAP.ResponseCode.CHANGED);
        } else {
            exchange.respond(CoAP.ResponseCode.BAD_REQUEST, "Content-Format not set");
        }
    }

    private synchronized void storeData(byte[] payload, int cf) {
        this.data = payload;
        this.dataCf = cf;
        this.getAttributes().clearContentType();
        this.getAttributes().addContentType(this.dataCf);
        this.getAttributes().setMaximumSizeEstimate(this.data.length);
        this.changed();
    }
}

