/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network.stack;

import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.californium.core.coap.EmptyMessage;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.network.Exchange;
import org.eclipse.californium.core.network.config.NetworkConfig;
import org.eclipse.californium.core.network.stack.AbstractLayer;

public class TokenLayer
extends AbstractLayer {
    private AtomicInteger counter;

    public TokenLayer(NetworkConfig config) {
        this.counter = config.getBoolean("USE_RANDOM_TOKEN_START") ? new AtomicInteger(new Random().nextInt()) : new AtomicInteger(0);
    }

    @Override
    public void sendRequest(Exchange exchange, Request request) {
        if (request.getToken() == null) {
            request.setToken(this.createNewToken());
        }
        super.sendRequest(exchange, request);
    }

    @Override
    public void sendResponse(Exchange exchange, Response response) {
        if (response.getToken() == null) {
            response.setToken(exchange.getCurrentRequest().getToken());
        }
        super.sendResponse(exchange, response);
    }

    @Override
    public void sendEmptyMessage(Exchange exchange, EmptyMessage message) {
        super.sendEmptyMessage(exchange, message);
    }

    @Override
    public void receiveRequest(Exchange exchange, Request request) {
        if (exchange.getCurrentRequest().getToken() == null) {
            throw new NullPointerException("Received requests's token cannot be null, use byte[0] for empty tokens");
        }
        super.receiveRequest(exchange, request);
    }

    @Override
    public void receiveResponse(Exchange exchange, Response response) {
        if (response.getToken() == null) {
            throw new NullPointerException("Received response's token cannot be null, use byte[0] for empty tokens");
        }
        super.receiveResponse(exchange, response);
    }

    @Override
    public void receiveEmptyMessage(Exchange exchange, EmptyMessage message) {
        super.receiveEmptyMessage(exchange, message);
    }

    private byte[] createNewToken() {
        int token = this.counter.incrementAndGet();
        return new byte[]{(byte)(token >>> 24), (byte)(token >>> 16), (byte)(token >>> 8), (byte)token};
    }
}

