/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network;

import org.eclipse.californium.core.config.CoapConfig;
import org.eclipse.californium.elements.Connector;
import org.eclipse.californium.elements.EndpointContextMatcher;
import org.eclipse.californium.elements.PrincipalAndAnonymousEndpointContextMatcher;
import org.eclipse.californium.elements.PrincipalEndpointContextMatcher;
import org.eclipse.californium.elements.RelaxedDtlsEndpointContextMatcher;
import org.eclipse.californium.elements.StrictDtlsEndpointContextMatcher;
import org.eclipse.californium.elements.TcpEndpointContextMatcher;
import org.eclipse.californium.elements.TlsEndpointContextMatcher;
import org.eclipse.californium.elements.UdpEndpointContextMatcher;
import org.eclipse.californium.elements.config.Configuration;

public class EndpointContextMatcherFactory {
    public static EndpointContextMatcher create(Connector connector, Configuration config) {
        if (connector == null) {
            throw new NullPointerException("Connector must not be null!");
        }
        return EndpointContextMatcherFactory.create(connector.getProtocol(), false, config);
    }

    public static EndpointContextMatcher create(String protocol, boolean anonymous, Configuration config) {
        if (protocol == null) {
            throw new NullPointerException("Protocol must not be null!");
        }
        if (config == null) {
            throw new NullPointerException("Configuration must not be null!");
        }
        if ("TCP".equalsIgnoreCase(protocol)) {
            return new TcpEndpointContextMatcher();
        }
        if ("TLS".equalsIgnoreCase(protocol)) {
            return new TlsEndpointContextMatcher();
        }
        CoapConfig.MatcherMode mode = config.get(CoapConfig.RESPONSE_MATCHING);
        if ("UDP".equalsIgnoreCase(protocol)) {
            switch (mode) {
                case RELAXED: {
                    return new UdpEndpointContextMatcher(false);
                }
            }
            return new UdpEndpointContextMatcher(true);
        }
        if ("DTLS".equalsIgnoreCase(protocol)) {
            switch (mode) {
                case RELAXED: {
                    return new RelaxedDtlsEndpointContextMatcher();
                }
                case PRINCIPAL: {
                    return new PrincipalEndpointContextMatcher();
                }
                case PRINCIPAL_IDENTITY: {
                    if (anonymous) {
                        return new PrincipalAndAnonymousEndpointContextMatcher();
                    }
                    return new PrincipalEndpointContextMatcher(true);
                }
            }
            return new StrictDtlsEndpointContextMatcher();
        }
        throw new IllegalArgumentException("Protocol " + protocol + " is not supported!");
    }
}

