/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements.util;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.concurrent.ThreadFactory;
import org.eclipse.californium.elements.util.NamedThreadFactory;

public class SocketThreadFactory {
    public static ThreadFactory create(String prefix, int count, ThreadGroup group) {
        if (count == 0) {
            return null;
        }
        Long start = null;
        NamedThreadFactory.Type type = NamedThreadFactory.Type.VIRTUAL;
        if (count > 0) {
            type = NamedThreadFactory.Type.DAEMON;
            if (count > 1) {
                start = 0L;
            }
        }
        return NamedThreadFactory.create(prefix, start, group, type);
    }

    public static String toName(InetSocketAddress localAddress) {
        StringBuilder builder = new StringBuilder();
        builder.append('-');
        InetAddress address = localAddress.getAddress();
        boolean bracket = address instanceof Inet6Address;
        if (bracket) {
            builder.append('[');
        }
        builder.append(address.getHostAddress());
        if (bracket) {
            builder.append(']');
        }
        builder.append(':').append(localAddress.getPort());
        return builder.toString();
    }
}

